define([], function() {
    "use strict";
    var ctrl = ["$scope", "message", "constsService", "appUtils", "model", "statusEnumService", "restService", "utilService",
        "communicationService", "mask", "exception",
        function($scope, message, Consts, appUtils, Model, Status, Rest, utilService, communicationService, mask, exception) {

            var avaliableTableFixer = appUtils.tableFixer("avaliableVmsTable", "uuid");
            var selectedTabelFixer = appUtils.tableFixer("selectedVmsTable", "uuid");

            var selectedVms = [];
            var avaliableVms = [];

            var selectedVmsQuery = "";
            var avaliableVmsQuery = "";
            var data = $("#" + Consts.ADD_PROTECT_VMS.winId).widget().option("data"),
                mappingId = data.mappingId,
                vrgSn = data.vrgSn;
            var filterName = "name";
            var filterValue = "";
            var extFilter = {
                filterName: filterName,
                filterValue: filterValue
            };

            $scope.text = {
                avaliableVms: appUtils.getString("resMapping.term.availableVM.tab"),
                selectedVms: appUtils.getString("resMapping.term.selectVM.tab")
            };
            $scope.start = Consts.start;
            $scope.pageSize = Consts.pageSize;
            $scope.orderBy = Consts.orderBy;
            $scope.orderType = Consts.orderType;
            $scope.Consts = Consts;

            $scope.model = {
                dualSelectBox: {
                    "id": "dualSelectBox",
                    "left-values": [{
                        "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftTitle.html",
                        "title-type": "url",
                        "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftContent.html",
                        "content-type": "url"
                    }],
                    "right-values": [{
                        "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightTitle.html",
                        "title-type": "url",
                        "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightContent.html",
                        "content-type": "url",
                        "add": {
                            id: "addBtn",
                            click: function() {
                                var checkedItems = avaliableTableFixer.getSelectedRow();
                                appUtils.union(selectedVms, checkedItems, "uuid");
                                _updateSelectedVms(selectedVms);
                                updateDisableRow();
                            }
                        },
                        "remove": {
                            id: "removeBtn",
                            click: function() {
                                var removeItems = selectedTabelFixer.getSelectedRow();
                                appUtils.removeFromArray(selectedVms, removeItems, "uuid");

                                selectedTabelFixer.remove(removeItems, "uuid");
                                avaliableTableFixer.remove(removeItems, "uuid");

                                _updateSelectedVms(selectedVms);
                                updateDisableRow();
                                avaliableTableFixer.selectRow();
                            }
                        }
                    }],
                    "setting": {
                        "left-width": "400px",
                        "height": "400px",
                        "right-width": "440px"
                    }
                },

                avaliableVms: {
                    id: "avaliableVmsTable",
                    displayLength: Consts.TABLE_COUNT_PER_PAGE,
                    tableFixer: avaliableTableFixer,
                    data: [],
                    checkbox: true,
                    currPage: {
                        "pageIndex": 1
                    },
                    columns: [{
                        "bVisible": false,
                        "mData": "uuid"
                    }, {
                        "sTitle": appUtils.getString("current_alarm_term_name_column"),
                        "mData": "name"
                    }, {
                        "sTitle": "ID",
                        "mData": "vmId"
                    }, {
                        "sTitle": appUtils.getString("common_term_system_label"),
                        "mData": "osType"
                    }],
                    tHeadCheckboxFn: function() {
                        avaliableTableFixer.click();
                    },
                    click: function(event, cell) {
                        updateDisableRow();
                        avaliableTableFixer.click();
                    },
                    callback: function(oPage) {

                        avaliableTableFixer.pageQuery = true;
                        $scope.start = oPage.currentPage - 1;
                        pageQuery();
                    },
                    sortCallback: function(nNode, sortArr) {
                        $scope.start = 0;
                        $scope.orderBy = $scope.model.avaliableVms.columns[sortArr[0][0] - 1].mData;
                        avaliableTableFixer.pageQuery = true;
                        $scope.orderType = sortArr[0][1];
                        pageQuery();
                    },
                    drawCallback: function() {
                        avaliableTableFixer.selectRow();
                        updateDisableRow();
                    }
                },

                selectedVms: {
                    id: "selectedVmsTable",
                    displayLength: Consts.TABLE_COUNT_PER_PAGE,
                    enablePagination: true,
                    tableFixer: selectedTabelFixer,
                    data: [],
                    checkbox: true,
                    columns: [{
                        "bVisible": false,
                        "mData": "uuid"
                    }, {
                        "sTitle": appUtils.getString("current_alarm_term_name_column"),
                        "mData": "name"
                    }, {
                        "sTitle": "ID",
                        "mData": "vmId"
                    }, {
                        "sTitle": appUtils.getString("common_term_system_label"),
                        "mData": "osType"
                    }],
                    tHeadCheckboxFn: function() {
                        selectedTabelFixer.click();
                    },
                    click: function(event, cell) {
                        selectedTabelFixer.click();
                    },
                    drawCallback: function() {
                        selectedTabelFixer.selectRow();
                    }
                },

                leftSearchSelect: {
                    id: "leftSearchSelect",
                    values: [{
                        selectId: "name",
                        label: appUtils.getString("current_alarm_term_name_column")
                    }, {
                        selectId: "vmId",
                        label: "ID"
                    }, {
                        selectId: "osType",
                        label: appUtils.getString("common_term_system_label")
                    }],
                    defaultSelectid: "name"
                },

                rightSearchSelect: {
                    id: "rightSearchSelect",
                    values: [{
                        selectId: "name",
                        label: appUtils.getString("current_alarm_term_name_column")
                    }, {
                        selectId: "vmId",
                        label: "ID"
                    }, {
                        selectId: "osType",
                        label: appUtils.getString("common_term_system_label")
                    }],
                    defaultSelectid: "name"
                },

                leftSearch: {
                    id: "leftSearchBox",
                    searchFn: function(query) {
                        avaliableVmsQuery = $.encoder.encodeForURL(query);
                        updateAvaliableVms();
                    }
                },

                rightSearch: {
                    id: "rightSearchBox",
                    searchFn: function(query) {
                        selectedVmsQuery = $.encoder.encodeForURL(query);
                        _updateSelectedVms(selectedVms);
                    }
                }
            };

            function updateAvaliableVms() {
                filterName = $("#leftSearchSelect").widget().getSelectedId();
                filterValue = avaliableVmsQuery;
                $scope.start = 0;
                $scope.model.avaliableVms.curPage = {
                    "pageIndex": 1
                };
                pageQuery();
            }


            var _updateSelectedVms = function(data) {
                data = angular.copy(data);
                if (!_.isEmpty(selectedVmsQuery) && angular.isArray(data)) {
                    var key = $("#rightSearchSelect").widget().getSelectedId(),
                        delCnt = 0;
                    selectedVmsQuery = selectedVmsQuery.toLowerCase();
                    for (var i = 0, len = data.length; i < len; i++) {
                        var item = data[i - delCnt];
                        item.name = item.name.toLowerCase();
                        item.osType = item.osType.toLowerCase();
                        item.vmId = item.vmId.toLowerCase();
                        if (item[key].indexOf(selectedVmsQuery) == -1) {
                            data.splice(i - delCnt++, 1);
                        }
                    }
                }

                $scope.model.selectedVms.totalRecords = data.length;
                $scope.model.selectedVms.data = data;
                $scope.model.selectedVms.enablePagination = data.length > 10;
                $scope.model.selectedVms.curPage = {
                    "pageIndex": 1
                };
                $scope.$apply();
            }


            function updateDisableRow() {
                var tbWidget = $("#avaliableVmsTable").widget();
                if (!tbWidget) return;

                var tbData = tbWidget.getTableData();
                var selectedData = appUtils.intersection(selectedVms, tbData, "uuid");

                appUtils.enableAllRow("avaliableVmsTable", tbData.length);
                selectedData.forEach(function(item) {
                    tbWidget.setSelectedRow("uuid", item["uuid"]);
                    var index = appUtils.getIndexFromArray(tbData, "uuid", item["uuid"]);
                    appUtils.disableRow("avaliableVmsTable", index);
                });
            }



            function pageQuery() {
                var url = utilService.getResouceUrl("/vrg/" + vrgSn + "/action/getVMsUnprotected?mappingId=" + mappingId + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&orderBy=" + $scope.orderBy + "&startPage=" + $scope.start);
                mask.show();
                communicationService.get(url + "&extFilter.filterName=" + filterName + "&extFilter.filterValue=" + filterValue).promise().always(_updateUI);

            }

            function _updateUI(result) {
                if (exception.check(result)) {
                    var arr = [];
                    appUtils.encodeForHTML(result);
                    _.each(result.records, function(d) {
                        arr.push(_.pick(d, "uuid", "name", "osType", "vmId"));
                    });
                    $scope.model.avaliableVms.data = arr;
                    $scope.model.avaliableVms.totalRecords = result["totalCount"];
                    if ($scope.model.avaliableVms.totalRecords > Consts.TABLE_COUNT_PER_PAGE) {
                        $scope.model.avaliableVms.enablePagination = true;
                    } else {
                        $scope.model.avaliableVms.enablePagination = false;
                    }
                    if ($scope.model.avaliableVms.totalRecords == 0) {
                        $scope.ngShow = false;
                    } else {
                        $scope.ngShow = true;
                    }
                    $scope.model.selectedVms.enablePagination = false;
                    avaliableVms = arr;
                    $scope.model.selectedVms.enablePagination = $("#selectedVmsTable").widget().getTableData().length > 10;
                    $scope.$apply();
                }
                mask.hide();
            };
            (function init() {
                pageQuery();
            }());

            setTimeout(function() {
                $("div.tiny-dualSelectBox-content-div").css({
                    "width": "380px"
                });
            }, 0);
        }
    ];

    var module = angular.module("recoverydirector.site.config");
    module.tinyController("addProtectVmsCtrl", ctrl);
    return module;
});
