define([],
	function() {
	"use strict";
	var ctrler = [
			"$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
			function($scope, $state,$compile,$stateParams, $timeout, exception, message,
					communicationService, utilService, mask ,constsService,appUtils,statusEnumService) {
				var defaulDisplay = "--";
				//获取到Window传递的参数
				var params = $("#" + constsService.MOVE_FM_FC_TO.winId).widget().option("data");
				var transferParam = params.transferParams;
				$scope.start = constsService.start;
				constsService.pageSize = 8;
				$scope.pageSize = constsService.pageSize;
				$scope.orderBy = "productVRGName";
                $scope.orderType = "desc";
				function _init() {
					var url = utilService.getResouceUrl("/vrg/action/getAvailableVRGMapping?mappingId=" + transferParam.mappingId + "&orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&startPage=" + $scope.start);
                    mask.show();
                    communicationService.get(url, null, null, 3600000).promise().always(_updateUI);
				};

				function _updateUI(result) {
	                  if (exception.check(result)) {
	                        var arr = [];
	                        appUtils.encodeForHTML(result);
	                        _.each(result.records, function (d) {
	                            var tmo = {
	                            	mappingId: d.mappingId,
	                            	productVRGName: d.productVRGName,
	                            	productVRGIP: d.productVRGIP,
	                            	recoveryVRGName: d.recoveryVRGName,
	                            	recoveryVRGIP: d.recoveryVRGIP
	                            };
	                            arr.push(tmo);
	                        });
	                        $scope.moveVmsToVrg.data = arr;
	                        $scope.moveVmsToVrg.totalRecords = result["totalCount"];
	                        constsService.TABLE_COUNT_PER_PAGE = 8;
	                        if ($scope.moveVmsToVrg.totalRecords > constsService.TABLE_COUNT_PER_PAGE) {
	                            $scope.moveVmsToVrg.enablePagination = true;
	                        } else {
	                            $scope.moveVmsToVrg.enablePagination = false;
	                        }
	                        if ($scope.moveVmsToVrg.totalRecords == 0) {
	                            $scope.ngShow = false;
	                        } else {
	                            $scope.ngShow = true;
	                        }
	                        $scope.$apply();
	                    }
	                    mask.hide();
	                };

				$scope.moveRvgInfo = {
					id : "moveRvgInfo",
					"values" : [
					        {
					        	value : transferParam.mappingId
					        },
					        {
					        	value : transferParam.productSiteName
					        },
					        {
					        	value : transferParam.productResourceProviderName
					        },
					        {
					        	value : transferParam.recoverySiteName
					        },
					        {
					        	value : transferParam.recoveryResourceProviderName
					        }
			      ]
				};
				$scope.vrgtitle = {
					id : "vrgtitle",
					"titles" :[
					         {
					        	 value : appUtils.getString("rvg_vms_product_site_title") + ":"
					         },
					         {
					        	 value : appUtils.getString("rvg_vms_dr_site_title") + ":"
					         },
					         {
					        	 value : appUtils.getString("rvg_vms_cloud_site_title") + ":"
					         },
					         {
					        	 value : appUtils.getString("rvg_vms_pair_title")
					         },
					         {
					        	 value : appUtils.getString("rvg_vms_enforce_move_title")
					         },
					         {
					        	 value : appUtils.getString("rvg_vms_help_title")
					         }

					 ]
				};
				//获取
				$scope.moveVmsToVrg = {
					id: "moveVmsToVrg",
					"enablePagination": false,
	                "columns": [
	                        {
	                        	"mData" : "mappingId",
	                        	"bVisible": false
	                        },
							{
								"sTitle": appUtils.getString("rvg_move_vms_product_name_title"),
	                            "mData": "productVRGName"
							},
							{
								"sTitle": appUtils.getString("rvg_move_vms_product_ip_name_title"),
	                            "mData": "productVRGIP"
	                        },
	                        {
								"sTitle": appUtils.getString("rvg_move_vms_dr_name_title"),
	                            "mData": "recoveryVRGName"
	                        },
	                        {
								"sTitle": appUtils.getString("rvg_move_vms_dr_ip_name_title"),
	                            "mData": "recoveryVRGIP"
	                        }
	                    ],
	                    callback: function (evtObj) {
	                        $scope.start = evtObj.currentPage - 1;
	                        var url = utilService.getResouceUrl("/vrg/action/getAvailableVRGMapping?mappingId=" + transferParam.mappingId + "&orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&startPage=" + $scope.start);
	                        mask.show();
	                        communicationService.get(url, null, null, 3600000).promise().always(_updateUI);
	                    },
	                    sortCallback: function (nNode, sortArr) {
	                    	//不算上mappingId 所以需要-1
	                        $scope.orderBy = $scope.moveVmsToVrg.columns[sortArr[0][0] -1].mData;
	                        $scope.orderType = sortArr[0][1];
	                        $scope.start = 0;
	                        var url = utilService.getResouceUrl("/vrg/action/getAvailableVRGMapping?mappingId=" + transferParam.mappingId + "&orderBy=" + $scope.orderBy + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&startPage=" + $scope.start);
	                        mask.show();
	                        communicationService.get(url, null, null, 3600000).promise().always(_updateUI);
	                    }
				};

				_init();
			}];

		var moveVmsToVrgApp = angular.module("recoverydirector.site.config");
		moveVmsToVrgApp.tinyController("app.mapping.resource.move.vms.ctrl", ctrler);
	    return moveVmsToVrgApp;
	});