define(["tiny-widgets/Window"],
    function(Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            function($scope, $state, $compile, $stateParams, $timeout, exception, message,
                communicationService, utilService, mask, constsService, appUtils, statusEnumService) {

                var transferParam = [];
                var flag = true;
                var getProtectVmsTable;
                var getcheckVmsLength;
                var configing = appUtils.getString("conmon_ter_vrg_configing_value");
                var removing = appUtils.getString("conmon_ter_vrg_removing_value");
                var moving = appUtils.getString("conmon_ter_vrg_moving_value");
                var operation = appUtils.getString("ism.drm.vrg.operation.success");
                var vrgObj = $scope.$parent.getData();
                var pairObj = {
                    isPair: false
                };
                $scope.start = constsService.start;
                $scope.pageSize = constsService.pageSize;
                $scope.orderBy = constsService.orderBy;
                $scope.orderType = constsService.orderType;
                $scope.transdata;
                var firstMappingId = "";

                var checkIsDisable = function(status) {
                    if (status != 6 && status != 5) {
                        return false;
                    }

                    $("#btnVMsAdd").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                    $("#btnVMsAddSpan").addClass("disabledbtn");
                    $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                    $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                    if (_.contains(["5", "6"], $.trim(status))) {
                        $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                        $("#btnVMsDeleteSpan").removeClass("disabledbtn");
                        $("#btnVMsMove").removeClass("iconbutton-move-disabled").addClass("iconbutton-move");
                        $("#btnVMsMoveSpan").removeClass("disabledbtn");
                    }
                    return true;
                }

                function _init(data) {

                    transferParam = data;
                    $scope.transdata = data;
                    var mappingId = transferParam.mappingId;
                    var url = utilService.getResouceUrl("/vrg/"+vrgObj.deviceSn+"/action/getVMsProtected?mappingId=" + mappingId + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&orderBy=" + $scope.orderBy + "&startPage=" + $scope.start);
                    communicationService.get(url).promise().always(_updateUI);
                };

                function _updateUI(result) {
                    if (_.contains(["5", "6"], String($scope.transdata.status))) {
                        $("#btnVMsAdd").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                        $("#btnVMsAddSpan").addClass("disabledbtn");
                    } else {
                        $("#btnVMsAdd").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                        $("#btnVMsAddSpan").removeClass("disabledbtn");
                    }
                    if (exception.check(result)) {
                        var arr = [];
                        appUtils.encodeForHTML(result);
                        _.each(result.records, function(d) {

                            var configStatu;
                            var errorCode = "";
                            var cloudErrorCode = "";
                            var isMoveFailed = false;
                            var isException = false;
                            if (utilService.isNotEmpty(d.errorCode) && d.errorCode != 0) {
                                errorCode = appUtils.getString("lego.err." + d.errorCode);
                            }
                            // 规避问题：如果错误码使用fusionsphere开头不能找到，则使用lego开头，如果都不能找到，则显示fusionsphere.error.xxxx
                            if (utilService.isNotEmpty(d.cloudErrorCode)) {
	                        	var fsErrorCode;
	                        	if (d.cloudErrorCode.indexOf("fusionsphere.error") != -1) {
	                        		fsErrorCode = d.cloudErrorCode;
	                        	} else {
									fsErrorCode = "fusionsphere.error." + d.cloudErrorCode;
	                        	}
                                var legoCode = "lego.err." + d.cloudErrorCode;
                                var i18nCode = appUtils.getString(fsErrorCode);
                                if (i18nCode === fsErrorCode) {
                                    i18nCode = appUtils.getString(legoCode);
                                }
                                if (i18nCode === legoCode) {
                                    errorCode = appUtils.getString(errorCode, d.cloudErrorCode);
                                    i18nCode = "--";
                                }
                                cloudErrorCode = appUtils.getStringWithColon("ism.drm.vrg.failed.cause") + i18nCode;
                            }
                            switch (d.configStatus) {
                                case 1:
                                    configStatu = appUtils.getString("common_ter_vrg_config_value");
                                    break;
                                case 2:
                                    configStatu = appUtils.getString("common_ter_vrg_config_failed_value") + "(" + errorCode + cloudErrorCode + ")";
                                    break;
                                case 3:
                                    configStatu = appUtils.getString("conmon_ter_vrg_configing_value");
                                    break;
                                case 4:
                                    configStatu = appUtils.getString("conmon_ter_vrg_removing_value");
                                    break;
                                case 5:
                                    configStatu = appUtils.getString("conmon_ter_vrg_remove_failed_value") + "(" + errorCode + cloudErrorCode + ")";
                                    isMoveFailed = true;
                                    break;
                                case 6:
                                    configStatu = appUtils.getString("conmon_ter_vrg_moving_value");
                                    break;
                                case 7:
                                    configStatu = appUtils.getString("conmon_ter_vrg_exception_value") + "(" + errorCode + cloudErrorCode + ")";
                                    isException = true;
                                    break;
                                case 8:
                                    configStatu = appUtils.getString("common_ter_vrg_reset_configing_value");
                                    break;
                                case 9:
                                    configStatu = appUtils.getString("common_ter_vrg_invalid_configing_value");
                                    break;
                            }

                            var tmo = {
                                uuid: d.uuid,
                                mappingId: d.mappingId,
                                name: d.name,
                                osType: d.osType,
                                providerName: d.providerName,
                                errorCode: errorCode,
                                cloudErrorCode: cloudErrorCode,
                                configStatus: configStatu,
                                isMoveFailed: isMoveFailed,
                                isException: isException

                            };
                            arr.push(tmo);
                        });
                        $scope.protectVMSTable.data = arr;
                        $scope.protectVMSTable.totalRecords = result["totalCount"];
                        if ($scope.protectVMSTable.totalRecords > constsService.TABLE_COUNT_PER_PAGE) {
                            $scope.protectVMSTable.enablePagination = true;
                        } else {
                            $scope.protectVMSTable.enablePagination = false;
                        }
                        if ($scope.protectVMSTable.totalRecords == 0) {
                            $scope.ngShow = false;
                        } else {
                            $scope.ngShow = true;
                        }
                        $scope.$apply();
                    }
                };
                $scope.openWindow = function(id, title, param, width, height, url, buttons) {
                    var options = {
                        "winId": id,
                        "title": title,
                        "data": param,
                        "height": height,
                        "width": width,
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "content": url,
                        "minimizable": false,
                        "maximizable": false,
                        "buttons": buttons,
                        "close": function() {
                            _init($scope.vmsdata);
                        }
                    };
                    var win = new Window(options);
                    win.show();
                };
                var getTable = function() {
                    getcheckVmsLength = $('#protectVMSTable').widget().getTableCheckedNums();
                    getProtectVmsTable = $('#protectVMSTable').widget().getTableCheckedItems();
                };
                $scope.btnVMsAdd = {
                    id: "btnVMsAdd",
                    text: appUtils.getString("common_term_add_button"),
                    disabled: true,
                    click: function() {
                        if (_.isEmpty(pairObj)) {
                            return;
                        }
                        if (!_.contains(["5", "6"], String($scope.transdata.status))) {
                            var data = {
                                mappingId: transferParam.mappingId,
                                vrgSn: vrgObj.deviceSn
                            };
                            var editButtons = [{
                                key: "ok",
                                label: appUtils.getString("common_term_confirm_button"),
                                handler: function(event) {

                                    var uuids = [];
                                    var selectVms = $("#selectedVmsTable").widget().dataTableConfig.aaData;
                                    _.each(selectVms, function(d) {
                                        uuids.push(d.uuid);
                                    });

                                    if (selectVms.length < 1) {
                                        message.error(appUtils.getString("common_term_select_data_least_label"));
                                    } else {
                                        mask.show();
                                        var url = utilService.getResouceUrl("/vrg/action/addVMsToVRG?mappingId=" + data.mappingId + "&isReconfig=false");
                                        communicationService.put(url, uuids).promise().always(function(response) {
                                            if (exception.check(response)) {
                                                if (utilService.isNotEmpty(response.failCount) && selectVms.length > 1) {
                                                    mask.hide();
                                                    batchOperation(response);
                                                } else {
                                                    mask.hide();
                                                    message.prompt({
                                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                                        ok: function() {
                                                            _init($scope.vmsdata);
                                                        }
                                                    });
                                                }
                                            }
                                            mask.hide();

                                        });
                                        $("#" + constsService.ADD_PROTECT_VMS.winId).widget().destroy();
                                    }
                                }
                            }, {
                                key: "cancel",
                                label: appUtils.getString("common_term_cancel_button"),
                                handler: function(event) {
                                    $("#" + constsService.ADD_PROTECT_VMS.winId).widget().destroy();
                                }
                            }];
                            $scope.openWindow(constsService.ADD_PROTECT_VMS.winId, appUtils.getString(constsService.ADD_PROTECT_VMS.title), data, constsService.ADD_PROTECT_VMS.width, constsService.ADD_PROTECT_VMS.height,
                                constsService.ADD_PROTECT_VMS.url, editButtons);
                        }
                    }
                };
                $scope.btnVMsDelete = {
                    id: "btnVMsDelete",
                    text: appUtils.getString("common_term_delete_button"),
                    disabled: true,
                    click: function() {
                        getTable();
                        var length = getcheckVmsLength;
                        var checkboxObj = getProtectVmsTable;
                        if (length > 0) {
                            var flag = true;
                            _.each(checkboxObj, function(d) {
                                if (d.configStatus == configing || d.configStatus == removing || d.configStatus == moving || d.configStatus == appUtils.getString("common_ter_vrg_reset_configing_value")) {
                                    flag = false;
                                }
                            });
                            if (flag) {
                                $scope.btnDelAction();
                            }
                        }

                    }
                };
                $scope.btnVMsReconfigure = {
                    id: "btnVMsRestReconfigure",
                    text: appUtils.getString("common_term_rvg_config_label"),
                    disabled: false,
                    click: function() {
                        if (!_.contains(["5", "6", "8", "9"], String($scope.transdata.status))) {
                            getTable();
                            var length = getcheckVmsLength;
                            var checkboxObj = getProtectVmsTable;
                            var config_failed = "";
                            if (length > 0) {
                                var flag = true;
                                _.each(checkboxObj, function(d) {
                                    if (((utilService.isNotEmpty(d.errorCode) && d.errorCode != operation) || utilService.isNotEmpty(d.cloudErrorCode)) && !d.isMoveFailed) {
                                        var errorCode = appUtils.getString(d.errorCode);
                                        var cloudErrorCode = appUtils.getString(d.cloudErrorCode);
                                        config_failed = appUtils.getString("common_ter_vrg_config_failed_value") + "(" + errorCode + cloudErrorCode + ")";
                                    }
                                    if (d.configStatus != config_failed && d.isException != true) {
                                        flag = false;
                                    }
                                });
                                if (flag) {
                                    $scope.ReconfigureAction();
                                }
                            }
                        }
                    }
                };
                $scope.btnVMsMove = {
                    id: "btnVMsMove",
                    text: appUtils.getString("common_term_rvg_move_label"),
                    disabled: false,
                    click: function() {
                        getTable();
                        var length = getcheckVmsLength;
                        var checkboxObj = getProtectVmsTable;
                        if (length > 0) {
                            var flag = true;
                            _.each(checkboxObj, function(d) {
                                if (d.configStatus == configing || d.configStatus == removing || d.configStatus == moving
                                        || d.configStatus == appUtils.getString("common_ter_vrg_reset_configing_value")
                                        || d.configStatus == appUtils.getString("common_ter_vrg_invalid_configing_value")) {
                                    flag = false;
                                }
                            });
                            if (flag) {
                                $scope.MoveVMsToVrgAction();
                            }
                        }
                    }
                };

                $scope.protectVMSTable = {
                    id: "protectVMSTable",
                    paginationStyle:"full_numbers",
                    isDraggedRemember: false,
                    "totalRecords": 0,
                    "enablePagination": false,
                    "checkbox": true,
                    "currPage": {
                        "pageIndex": 1
                    },
                    "columns": [{
                        "mData": "uuid",
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("common_rvg_protect_vms_name_title"),
                        "mData": "name"
                    }, {
                        "sTitle": appUtils.getString("common_rvg_protect_vms_ostype_title"),
                        "mData": "osType"
                    }, {
                        "sTitle": appUtils.getString("common_rvg_protect_vms_providername_title"),
                        "mData": "providerName"
                    }, {
                        "sTitle": appUtils.getString("common_rvg_protect_vms_host_title"),
                        "mData": "configStatus"
                    }],
                    "tHeadCheckboxFn": function() {
                        getTable();
                        //得到所有选中的对象
                        var checkboxObj = getProtectVmsTable;
                        var length = getcheckVmsLength;
                        var flaging = true;
                        _.each(checkboxObj, function(d) {
                            if (d.configStatus == removing || d.configStatus == moving || d.configStatus == configing) {
                                flaging = false;
                            }
                        });

                        if ($scope.transdata.status == 6 || $scope.transdata.status == 5) {
                            if (!_.isEmpty(checkboxObj)) {
                                $("#btnVMsAdd").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                                $("#btnVMsAddSpan").addClass("disabledbtn");
                                $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#btnVMsDeleteSpan").removeClass("disabledbtn");

                                $("#btnVMsMove").removeClass("iconbutton-move-disabled").addClass("iconbutton-move");
                                $("#btnVMsMoveSpan").removeClass("disabledbtn");

                                $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                                return;
                            }
                            $("#btnVMsAdd").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                            $("#btnVMsAddSpan").addClass("disabledbtn");
                            $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                            $("#btnVMsDeleteSpan").addClass("disabledbtn");

                            $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                            $("#btnVMsMoveSpan").addClass("disabledbtn");

                            $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                            $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                            return;
                        }

                        if (!flaging || length < 1) {
                            $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                            $("#btnVMsDeleteSpan").addClass("disabledbtn");

                            $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                            $("#btnVMsMoveSpan").addClass("disabledbtn");

                            $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                            $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                        } else {
                            changeCss(checkboxObj);
                        }

                        if (_.isEmpty(checkboxObj)) {
                            return;
                        }
                        var isConfig = true,configured = appUtils.getString("common_ter_vrg_config_value");
                        _.each(checkboxObj, function(d) {
                            (d.configStatus == configured || d.isMoveFailed || d.configStatus == configing || d.configStatus == removing || d.configStatus == moving) && (isConfig = false)

                        });

                        if (isConfig) {
                            $("#btnVMsReconfigure").removeClass("iconbutton-config-disabled").addClass("iconbutton-config");
                            $("#btnVMsReconfigureSpan").removeClass("disabledbtn");
                        } else {

                            $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                            $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                        }

                    },
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    callback: function(evtObj) {
                        $scope.start = evtObj.currentPage - 1;
                        $scope.pageSize = evtObj.displayLength;
                        transferParam = $scope.transdata;
                        var mappingId = transferParam.mappingId;
                        var url = utilService.getResouceUrl("/vrg/" + vrgObj.deviceSn + "/action/getVMsProtected?mappingId=" + mappingId + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&orderBy=" + $scope.orderBy + "&startPage=" + $scope.start);
                        communicationService.get(url).promise().always(_updateUI);
                    },
                    sortCallback: function(nNode, sortArr) {
                        //不算上uuid，所以需要-1
                        $scope.orderBy = $scope.protectVMSTable.columns[sortArr[0][0] - 1].mData;
                        $scope.orderType = sortArr[0][1];
                        transferParam = $scope.transdata;
                        $scope.start = 0;
                        var mappingId = transferParam.mappingId;
                        var url = utilService.getResouceUrl("/vrg/" + vrgObj.deviceSn + "/action/getVMsProtected?mappingId=" + mappingId + "&orderType=" + $scope.orderType + "&pageSize=" + $scope.pageSize + "&orderBy=" + $scope.orderBy + "&startPage=" + $scope.start);
                        communicationService.get(url).promise().always(_updateUI);
                    },
                    "renderRow": function(nRow, aData, iDataIndex) {

                    },
                    //行的点击事件
                    cellClickActive: function(e, param) {
                        if (_.isEmpty($('#protectVMSTable').widget().getTableCheckedItems())) {
                            $("#btnVMsAdd").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                            $("#btnVMsAddSpan").addClass("disabledbtn");
                            $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                            $("#btnVMsDeleteSpan").addClass("disabledbtn");

                            $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                            $("#btnVMsMoveSpan").addClass("disabledbtn");

                            $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                            $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                            if (!checkIsDisable(pairObj.status)) {
                                $("#btnVMsAdd").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                                $("#btnVMsAddSpan").removeClass("disabledbtn");
                            }
                            return;
                        }
                        if (!checkIsDisable(pairObj.status)) {
                            $("#btnVMsAdd").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                            $("#btnVMsAddSpan").removeClass("disabledbtn");
                            $("#btnVMsReconfigure").removeClass("iconbutton-config-disabled").addClass("iconbutton-config");
                            $("#btnVMsReconfigureSpan").removeClass("disabledbtn");
                            $("#btnVMsMove").removeClass("iconbutton-move-disabled").addClass("iconbutton-move");
                            $("#btnVMsMoveSpan").removeClass("disabledbtn");
                            $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                            $("#btnVMsDeleteSpan").removeClass("disabledbtn");
                        };

                        if ($scope.transdata.status == 6 || $scope.transdata.status == 5) {
                            return;
                        }

                        var configStatus = param.configStatus;
                        getTable();
                        var length = getcheckVmsLength;
                        if (length != 0) {
                            var checkboxObj = getProtectVmsTable;
                            var errorCode = "";
                            var cloudErrorCode = "";
                            if (utilService.isNotEmpty(checkboxObj[0].errorCode) && checkboxObj[0].errorCode != operation) {
                                errorCode = appUtils.getString(checkboxObj[0].errorCode);
                            }
                            if (utilService.isNotEmpty(checkboxObj[0].cloudErrorCode)) {
                                cloudErrorCode = appUtils.getString(checkboxObj[0].cloudErrorCode);
                            }
                            var configured = appUtils.getString("common_ter_vrg_config_value");
                            var configurField = appUtils.getString("common_ter_vrg_config_failed_value") + "(" + errorCode + cloudErrorCode + ")";
                            var moveField = appUtils.getString("conmon_ter_vrg_remove_failed_value") + "(" + errorCode + cloudErrorCode + ")";
                        }
                        if (length == 1) {
                            configStatus = checkboxObj[0].configStatus;
                            var isExceptionValue = checkboxObj[0].isException;
                            if (moveField == configStatus || configured == configStatus) {
                                $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#btnVMsDeleteSpan").removeClass("disabledbtn");

                                $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                            } else if (configurField == configStatus || isExceptionValue == true) {
                                $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#btnVMsDeleteSpan").removeClass("disabledbtn");

                            } else if(configStatus == appUtils.getString("common_ter_vrg_reset_configing_value")) {
                                $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                $("#btnVMsDeleteSpan").addClass("disabledbtn");
                                $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                                $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                                $("#btnVMsMoveSpan").addClass("disabledbtn");

                            } else if(configStatus == appUtils.getString('common_ter_vrg_invalid_configing_value')) {
                                $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#btnVMsDeleteSpan").removeClass("disabledbtn");
                                $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                                $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                                $("#btnVMsMoveSpan").addClass("disabledbtn");
                            }
                            else {
                                $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                $("#btnVMsDeleteSpan").addClass("disabledbtn");

                                if (configing == configStatus || removing == configStatus) {
                                    $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                    $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                                    $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                                    $("#btnVMsMoveSpan").addClass("disabledbtn");
                                }
                            }

                        } else if (length > 1) {
                            var flag = false;
                            var failedStatu = true;
                            _.each(checkboxObj, function(d) {
                                if (d.configStatus != configing && d.configStatus != removing && d.configStatus != moving) {
                                    if ((!utilService.isNotEmpty(d.cloudErrorCode) && !(utilService.isNotEmpty(d.errorCode) && d.errorCode != operation)) || d.isMoveFailed) {
                                        failedStatu = false;
                                    }
                                } else {
                                    flag = true;
                                }
                            });
                            if (flag) {
                                $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                                $("#btnVMsDeleteSpan").addClass("disabledbtn");

                                $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                                $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                                $("#btnVMsMoveSpan").addClass("disabledbtn");
                            } else {
                                $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                                $("#btnVMsDeleteSpan").removeClass("disabledbtn");

                                var isConfig = true;
                                _.each(checkboxObj, function(d) {
                                    (d.configStatus == configured || d.isMoveFailed) && (isConfig = false)
                                });

                                if (isConfig) {
                                    $("#btnVMsReconfigure").removeClass("iconbutton-config-disabled").addClass("iconbutton-config");
                                    $("#btnVMsReconfigureSpan").removeClass("disabledbtn");
                                } else {

                                    $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                                    $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                                }
                            }
                        } else {
                            $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                            $("#btnVMsDeleteSpan").addClass("disabledbtn");

                            $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                            $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                            $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                            $("#btnVMsMoveSpan").addClass("disabledbtn");
                        }

                    }
                };

                var changeCss = function(checkboxObj) {
                    //如果全部有错误码
                    var flag = true;
                    _.each(checkboxObj, function(d) {
                        if ((!utilService.isNotEmpty(d.cloudErrorCode) && !(utilService.isNotEmpty(d.errorCode) && d.errorCode != operation)) || d.isMoveFailed) {
                            flag = false;
                        }
                    });
                    if (flag) {
                        $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                        $("#btnVMsDeleteSpan").removeClass("disabledbtn");
                        $("#btnVMsReconfigure").removeClass("iconbutton-config-disabled").addClass("iconbutton-config");
                        $("#btnVMsReconfigureSpan").removeClass("disabledbtn");
                        $("#btnVMsMove").removeClass("iconbutton-move-disabled").addClass("iconbutton-move");
                        $("#btnVMsMoveSpan").removeClass("disabledbtn");
                    } else {
                        $("#btnVMsDelete").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                        $("#btnVMsDeleteSpan").removeClass("disabledbtn");
                        $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                        $("#btnVMsReconfigureSpan").addClass("disabledbtn");
                        $("#btnVMsMove").removeClass("iconbutton-move-disabled").addClass("iconbutton-move");
                        $("#btnVMsMoveSpan").removeClass("disabledbtn");
                    }
                };

                var getUuids = function(checkboxObj, uuids) {
                    _.each(checkboxObj, function(d) {
                        uuids.push(d.uuid);
                    });
                };

                $scope.MoveVMsToVrgAction = function() {
                    var editButtons = [];
                    var uuid = [];
                    getTable();
                    uuid = getProtectVmsTable;
                    var data = {
                        uuids: uuid,
                        transferParams: transferParam
                    };
                    var editButtons = [{
                            key: "ok",
                            label: appUtils.getString("common_term_confirm_button"),
                            focused: true,
                            handler: function(event) {
                                var targetobj = $('#moveVmsToVrg').widget().getTableCheckedItems();
                                if (targetobj.length < 1) {
                                    message.error(appUtils.getString("common_term_select_data_least_label"));
                                } else {
                                    var params = $("#" + constsService.MOVE_FM_FC_TO.winId).widget().option("data");
                                    var uuids = [];
                                    var checkboxObj = params.uuids;
                                    getUuids(checkboxObj, uuids);
                                    var forcedMove = $('#forcedMove').is(':checked');
                                    var transferParam = params.transferParams;
                                    var url = utilService.getResouceUrl("/vrg/action/moveVMs?isForcedMove=" + forcedMove + "&sourceMappingId=" + transferParam.mappingId + "&targetMappingId=" + targetobj[0].mappingId);
                                    mask.show();
                                    communicationService.put(url, uuids).promise().always(function(response) {
                                        if (exception.check(response)) {
                                            if (utilService.isNotEmpty(response.failCount) && checkboxObj.length > 1) {
                                                mask.hide();
                                                batchOperation(response);
                                            } else {
                                                mask.hide();
                                                message.prompt({
                                                    content: appUtils.getString("common_term_operationsyn_success_label"),
                                                    ok: function() {
                                                        $scope.start = constsService.start;
                                                        $("#protectVMSTable").widget().option("cur-page", {
                                                            "pageIndex": 1
                                                        });
                                                        _init($scope.vmsdata);
                                                    }
                                                });
                                            }
                                            disableBtns();
                                        }
                                        mask.hide();
                                    });

                                    $("#" + constsService.MOVE_FM_FC_TO.winId).widget().destroy();
                                }
                            }
                        }, {
                            key: "cancel",
                            label: appUtils.getString("common_term_cancel_button"),
                            handler: function(event) {
                                $("#" + constsService.MOVE_FM_FC_TO.winId).widget().destroy();
                            }
                        }

                    ];

                    $scope.openWindow(constsService.MOVE_FM_FC_TO.winId, appUtils.getString(constsService.MOVE_FM_FC_TO.title), data, constsService.MOVE_FM_FC_TO.width, constsService.MOVE_FM_FC_TO.height,
                        constsService.MOVE_FM_FC_TO.url, editButtons);
                };
                var batchOperation = function(response) {
                    var editButtons = [{
                        key: "cancel",
                        focused: true,
                        label: appUtils.getString("common_term_close_button"),
                        handler: function(event) {
                            $("#alarmClearFailWin").widget().destroy();
                            $("#protectVMSTable").widget().option("cur-page", {
                                "pageIndex": 1
                            });
                            _init($scope.vmsdata);
                        }
                    }];
                    $scope.openWindow("alarmClearFailWin", appUtils.getString(constsService.ALARM_CLEAR_ERROR_TITLE),
                        response, "500px", "550px", constsService.COURRENT_BATCH_RESULT_URL, editButtons);
                };
                //重新配置
                $scope.ReconfigureAction = function() {
                    var uuid = [];
                    getTable();
                    var items = getProtectVmsTable;
                    _.each(items, function(d) {
                        uuid.push(d.uuid);
                    });
                    var mappingId = transferParam.mappingId;
                    message.prompt({
                        content: appUtils.getString('mapping_resource_rvg_reconfigure_warn_tips'),
                        ok: function() {
                            mask.show();
                            var url = utilService.getResouceUrl("/vrg/action/addVMsToVRG?mappingId=" + mappingId + "&isReconfig=true");
                            communicationService.put(url, uuid).promise().always(function(response) {
                                if (exception.check(response)) {
                                    if (utilService.isNotEmpty(response.failCount) && items.length > 1) {
                                        mask.hide();
                                        batchOperation(response);
                                    } else {
                                        mask.hide();
                                        message.prompt({
                                            content: appUtils.getString("common_term_operationsyn_success_label"),
                                            ok: function() {
                                                _init($scope.vmsdata);
                                            }
                                        });
                                    }
                                    disableBtns();
                                }
                                mask.hide();
                            });
                        }
                    });
                };
                $scope.btnDelAction = function() {
                    var uuid = [];
                    getTable();
                    var items = getProtectVmsTable;
                    _.each(items, function(d) {
                        uuid.push(d.uuid);
                    });


                    var editButtons = [{
                        key: "ok",
                        label: appUtils.getString("common_term_confirm_button"),
                        handler: function(event) {
                            var forcedDelete = $('#forcedDelete').is(':checked');
                            $("#" + constsService.DELETE_FM_FC.winId).widget().destroy();
                            mask.show();
                            communicationService.put(utilService.getResouceUrl("/vrg/action/removeVMsFromVRG?mappingId=" + transferParam.mappingId + "&forcedDel=" + forcedDelete), uuid).promise().always(function(response) {
                                if (exception.check(response)) {
                                    if (utilService.isNotEmpty(response.failCount) && items.length > 1) {
                                        mask.hide();
                                        batchOperation(response);
                                    } else {
                                        mask.hide();
                                        message.prompt({
                                            content: appUtils.getString("common_term_operationsyn_success_label"),
                                            ok: function() {
                                                $scope.start = constsService.start;
                                                $("#protectVMSTable").widget().option("cur-page", {
                                                    "pageIndex": 1
                                                });
                                                _init($scope.vmsdata);
                                            }
                                        });
                                    }
                                    disableBtns();
                                }
                                mask.hide();
                            });
                        }
                    }, {
                        key: "cancel",
                        label: appUtils.getString("common_term_cancel_button"),
                        focused: true,
                        handler: function(event) {
                            $("#" + constsService.DELETE_FM_FC.winId).widget().destroy();
                        }
                    }];
                                        $scope.openWindow(constsService.DELETE_FM_FC.winId,appUtils.getString(constsService.DELETE_FM_FC.title),constsService.DELETE_FM_FC.data,constsService.DELETE_FM_FC.width,constsService.DELETE_FM_FC.height,
                            constsService.DELETE_FM_FC.url,editButtons);
                };

                var tabNotify = function(evt, rowData) {
                    if(2 !== constsService.FUSIONSPHERE_ENUM[rowData.cloudType])
                    {
                        return;
                    }

                    vrgObj = rowData;
                    queryPairInfo();
                };
                //灰化表格上方三个button
                var disableBtns = function (){
                    $("#btnVMsDelete").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                    $("#btnVMsDeleteSpan").addClass("disabledbtn");

                    $("#btnVMsReconfigure").removeClass("iconbutton-config").addClass("iconbutton-config-disabled");
                    $("#btnVMsReconfigureSpan").addClass("disabledbtn");

                    $("#btnVMsMove").removeClass("iconbutton-move").addClass("iconbutton-move-disabled");
                    $("#btnVMsMoveSpan").addClass("disabledbtn");
                }
                var queryPairInfo = function() {
                    var paramObj = {
                        filterName: "resourceId",
                        filterValue : vrgObj.deviceSn,
                        resourceType : 5,
                        startPage: 0,
                        pageSize: 10
                    };
                    var url = appUtils.fillUrl(constsService.RM_URL.mappingURL, paramObj);

                    communicationService.get(url, null, null, 3600000).promise().always(function(result) {

                        if (!exception.check(result) || _.isEmpty(result.records)) {
                            pairObj = {};
                            transferParam = {};
                            $scope.transdata = {};

                            $("#btnVMsAdd").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                            $("#btnVMsAddSpan").addClass("disabledbtn");
                            $scope.protectVMSTable.data = [];
                            $scope.protectVMSTable.totalRecords = 0;
                            $scope.protectVMSTable.currPage = {"pageIndex":1};
                            $scope.protectVMSTable.enablePagination = false;
                            $scope.$apply();
                            return;
                        }

                        pairObj = result.records[0];
                        pairObj.isPair = true;

                        $scope.vmsdata = pairObj;
                        if ("" == firstMappingId){
                            firstMappingId = pairObj.mappingId;
                        }else if(firstMappingId != pairObj.mappingId){
                            $scope.start = constsService.start;
                            $("#protectVMSTable").widget().option("cur-page",{"pageIndex":1});
                            firstMappingId = pairObj.mappingId;
                        }

                        _init(pairObj);
                    });
                };

                $scope.$on(constsService.TOPIC.SITE_CLOUD_TAB, tabNotify);


                $scope.refreshData = function() {
                    !_.isEmpty(vrgObj) && (tabNotify(null, vrgObj));
                }

                !_.isEmpty(vrgObj) && (tabNotify(null, vrgObj));
            }
        ];
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.vrg.relationVM.ctrl', ctrler);
        return module;
    });
