define(["tiny-widgets/Window", "tiny-common/UnifyValid", "tiny-extra-lib/jquery.base64"],
		function(Window, UnifyValid) {
			"use strict";
			var ctrler = [
					"$scope",
					"$state",
					"$stateParams",
					"exception",
					"message",
					"communicationService",
					"utilService",
					"mask",
					"constsService",
					"appUtils",
					"statusEnumService",
					function($scope, $state, $stateParams,exception, message,
							communicationService, utilService, mask,
							constsService, appUtils,statusEnumService) {
						var siteId = $stateParams.siteId;
						$scope.deviceType = "ism.drm.deviceType.vrg.mainType";
						$scope.btnVrgPair = {
							id : "btnVrgPair",
							text : appUtils.getString("site.term,vrgPair.label"),
							click : function() {
								$state.go("site.addRMWizard",{type:"vrg"});
						   }
						};


						 $scope.operationVrgArray = [{
								id : "iconBtnDevRefresh",
		                    	authKey: "ism.drm.resource.mgt.refresh.operateID",
								template : "<div class='iconbutton-pg-refresh' title='"+appUtils.getString("common_term_refresh_button")+"'></div>",
								clickActive : function() {
							      	_refreshDevAction();
								}
							}, {
								id : "iconBtnEdit",
		                    	authKey: "ism.drm.resource.mgt.modify.operateID",
								template : "<div class='iconbutton-edit' title='"+appUtils.getString("common_term_edit_button")+"'></div>",
								clickActive : function() {
							      _editDevAction();
							  	}
							},
							{
								id : "iconBtnDel",
		                        authKey: "ism.drm.resource.mgt.delete.operateID",
								template : "<div class='iconbutton-delete' title='"+appUtils.getString("common_term_delete_button")+"'></div>",
								clickActive : function() {
								   _deleteDevAction();
							}
					    }];

						$scope.refreshVrgPage = function(){
							mask.show()
							_init();
						};

						$scope.datasVrgTable = {
								id : "datasVrgTable",
								columns : [
										{
											"sTitle" : appUtils.getString("common_term_status_column"),
											"mData" : "status"
										},
										{
											"sTitle" : appUtils.getString("common_term_name_label"),
											"mData" : "<nam></nam>e"
										},
										{
											"sTitle" : appUtils.getString("common_term_ip_column"),
											"mData" : "ipAddress"
										},
										{
											"sTitle" : appUtils.getString("common_term_port_label"),
											"mData" : "port",
											"bSortable":false,
											"bVisible" : false
										},
										{
											"sTitle" : appUtils.getString("site_term_cache_column"),
											"mData" : "totalCapacity",
											"bSortable":false
										},
										{
											"sTitle" : appUtils.getString("site_term_leftedCache_column"),
											"mData" : "availableCapacity",
											"bSortable":false
										},
										{
											"sTitle" : appUtils.getString("site.vrg.term.isPair.cloumn"),
											"mData" : "isPair",
											"bSortable":false
										}],
								callback : function(evtObj) {
								    var start = evtObj.currentPage - 1;
					                var pageSize = evtObj.displayLength;
					                var url = "";
					                communicationService.get(utilService.getResouceUrl(url+"&startPage="+start)).promise().always(_updateUI);
								},
	                            paging:true,
								renderRow : function(nRow, aData, iDataIndex) {
									$("td:eq(0)", nRow).html(statusEnumService.getStatus("RVG_RESOURCE_MAPPING_STATUS", aData['status']));
								},
								data : [],
								opAreaConfig : $scope.operationVrgArray,
								cellClickActive : function(e, param) {
									$scope.$broadcast(constsService.TOPIC.SITE_VRG_TAB, param);
								},
								hoverActive : function(e, param) {
								}
							};

						$scope.plugins = [
		                    {
		                        "openState": "site.vrg.pairInfo",
		                        "id": "pairInfo",
		                        "name": appUtils.getString("site.term.pairInfo.column")
		                    },
		                    {
		                        "openState": "site.vrg.relationVM",
		                        "id": "relation",
		                        "name": appUtils.getString("site.term.relateVM.column")
		                    }
		                ];

				        var _editDevAction = function() {
                              var id =_getOpID();
                              var data = {};
                              communicationService.get(utilService.getResouceUrl("/resources/"+id)).promise().always(function(response){
	                            if(exception.check(response)){
	                              data.sn = response.sn ;
		                            if (Object.prototype.toString.call(response.moName) === "[object Null]") {
		                              data.name = "null";
		                            } else {
		                              data.name = response.moName;
		                            }
		                            data.deviceType = $scope.deviceType;
		                            data.isStorage = false;
					            	var options = {
				            			"winId": "modifyVrgHostDevAliasWinId",
				                        "data":data,
				                        "title": appUtils.getString("res_term_modifyalias_label"),
				                        "width" : "zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language") ? "920px" : "1050px",
				                        "height" : "600px",
				                        "content-type": "url",
				                        "content":constsService.RES_VRG_HOST_EDIT_URL,
				                        "minimizable": false,
				                        "maximizable": false,
				                        "buttons": [{
				                        	key : "ok",
				                        	label : appUtils.getString('common_term_confirm_button'),
				                        	focused : true,
				                        	handler : function(event) {
					                        	if (!UnifyValid.FormValid($("#container"), {focusInvalid: true})) {
						                            return;
						                        }

					                        	var manageInfoSwitchFlag = $("#manageInfo").widget().option("selected") == "on" ? true:false;
					                        	var alarmInfoSwitchFlag = $("#alarmInfo").widget().option("selected") == "on" ? true:false;
					                        	var param = {};
						                        var id = $("#modifyVrgHostDevAliasWinId").widget().option("data").sn;
						                        param.moName = $.trim($("#name").widget().getValue());
						                        param.deviceType = $scope.deviceType;
						                        var url = utilService.getResouceUrl("/resources/"+id);
						                        mask.show();
						                        communicationService.put(url, param).promise().always(function(result) {
						                        	 mask.hide();
						                        	if (exception.check(result)) {
							                        	//只修改名称
						                        		if(!manageInfoSwitchFlag && !alarmInfoSwitchFlag) {
			                                                mask.hide();
						                        			message.success({content:appUtils.getString("common_term_operation_success_label"), ok:function(){
							                        			$("#modifyVrgHostDevAliasWinId").widget().destroy();
							                        		}});
						                        			return;
						                        		}

						                        		var editParam = {}, extendParams = {};
			                                            editParam.isModifyPwd = false;
			                                            if (manageInfoSwitchFlag) {
			                                                editParam.isModifyPwd = true;
			                                                editParam.networkUserName = $("#protocolUsername").widget().getValue();
			                                                if(infoTransferredService.get("protocalPwdModule", "protocalPwd")) {
			                                                    editParam.networkPassword=  $("#protocalPwd").widget().getValue();
			                                                }
			                                                editParam.networkIpAddress = $("#ip").widget().option("value");
			                                                extendParams.port = $("#protocalPort").widget().option("value");
			                                            }

						                            	if("ism.drm.deviceType.vrg.mainType" == $scope.deviceType) {
						                            		extendParams.netMask = $("#mask").widget().option("value");
							                            	extendParams.netGetWay = $("#gateway").widget().option("value");
						                            	}
						                            	if (alarmInfoSwitchFlag) {
						                            		extendParams.snmpVersion = "SNMPv3";
							                            	extendParams.snmpRetries = $("#count").widget().option("value");
							                            	extendParams.snmpTimeout = $("#timeout").widget().option("value");
							                            	extendParams.snmpPort = $("#alarmPort").widget().option("value");
							                            	extendParams.snmpSecurityName = $("#alarmUsername").widget().getValue();
							                            	extendParams.snmpContextName = $("#env").widget().getValue();
							                            	extendParams.snmpContextEngineId =  $("#engineId").widget().getValue();
							                            	var authId = $("#authProtocol").widget().getSelectedId();
							                            	var encryptId = $("#encryptProtocol").widget().getSelectedId();
							                            	extendParams.snmpAuthProtocol = authId;
							                            	if ("" != authId) {
							                            		if(infoTransferredService.get("authPwdModule", "authPwd")) {
							                            			extendParams.snmpAuthPwd = $("#authPwd").widget().getValue();
							                            		}
							                            		extendParams.snmpEncryptProtocol = encryptId;
							                            		if ("" != encryptId) {
							                            			if(infoTransferredService.get("encryptPwdModule", "encryptPwd")) {
							                            				extendParams.snmpEncryptPwd = $("#encryptPwd").widget().getValue();
							                            			}
							                            		}
							                            	}
						                            	}

						                            	editParam.extendParams = extendParams;
			                                            mask.show();
							                        	communicationService.put(utilService.getResouceUrl("/resources/"+$.base64.encode(data.sn)+"/action/modifyMgrProtocol"),editParam).promise().always(function(response){
			                                                mask.hide();
						            				    	if(exception.check(response)){
						            			    			message.success({content: appUtils.getString("common_term_operation_success_label"), ok: function(){
						            			    				$("#modifyVrgHostDevAliasWinId").widget().destroy();
						            					    	}});
						            				    	  }
						            				     });
			                                        } else {
			                                            mask.hide();
			                                        }
						                        });



				                        	}
				                        }, {
				                        	key : "cancel",
				                          	label : appUtils.getString('common_term_cancel_button'),
				                          	focused : false,
				                          	handler : function(event) {
				                        		$("#modifyVrgHostDevAliasWinId").widget().destroy();
				                        	}
				                        }
				                        ],
										"close":function(){
											_refreshData();
										}
					            	}

					            	var win = new Window(options);
				                    win.show();
	    	                      }
	                       });
                        };

                        var _deleteDevAction = function(){
						    var  deviceSn = _getOpID();
							var arr = [];
							arr.push(deviceSn)
							var url = "/sites/"+ siteId +"/action/unregisterRes?resType=ism.drm.deviceType.vrg.mainType";
							 message.warn({"content":appUtils.getString("site_term_vrg_delete_message","siteName" ,_getOpName()),"ok":function(){
								 mask.show();
								 communicationService.put(utilService.getResouceUrl(url),arr).promise().always(function(result){
									    mask.hide();
										if(exception.check(result)){
			                        		  message.success({content:appUtils.getString("common_term_operation_success_label"),ok:function(){
			                        			  _init();
			                        		}});
			                        	}
									})
							 }})
					  };


					  var _refreshDevAction = function(){
						     var deviceSn = _getOpSn();
					    	 deviceSn = $.base64.encode(deviceSn)
						     mask.show();
							 communicationService.put(utilService.getResouceUrl("/fusionsphere/"+deviceSn+"/action/refresh")).promise().always(function(result){
								 mask.hide();
								 if(exception.check(result)){
									 message.prompt({content:appUtils.getString("site_term_refresh_message"),ok:function(){}});
								 }
							});
					  };

						var _updateUI = function(result) {
							mask.hide();
							if (exception.check(result)) {
								var arr = [];
				                _.each(result, function(d) {
				                    var tmo =_.pick(d, "deviceSn", "status", "name","ipAddress","port","totalCapacity","availableCapacity");
				                    arr.push(tmo);
				                });
				                $scope.datasVrgTable.data = appUtils.encodeForHTML(arr);
				                $scope.$apply();
							}
						};

						var _getOpID = function(){
					    	    var opID = $("#datasVRGTable").widget().getHoverData()[0].deviceSn;
					            return opID;
					    };

					    var _getOpName = function(){
                            return $("#datasVRGTable").widget().getHoverData()[0].name;
				        };

					    var _init = function(){
							 var regestedVrg = "/vrg?siteId="+siteId;
							communicationService.get(utilService.getResouceUrl(regestedVrg)).promise().always(_updateUI);
						}

					  _init();
				}]
			var module = angular.module('recoverydirector.site.config');
			module.tinyController('site.vrg.ctrl', ctrler);
			return module;
})
