define(["tiny-common/UnifyValid"], function(UnifyValid) {
	"use strict";
	var ctrl = [
			"$scope",
			"$state",
			"$stateParams",
			"exception",
			"message",
			"communicationService",
			"utilService",
			"mask",
			"constsService","appUtils","restService",
			function($scope, $state, $stateParams, exception, message, communicationService, utilService, mask, constsService ,appUtils,restService) {

				var data = $("#edit").widget().option("data");
				_.isEmpty(data) && (data = {isLocal : false,isModify : false});
				var isLocal = data.isLocal,
					isModify = data.isModify,
					verifyModel = {
						ip: {
			                	id:"ip",
			                    width:constsService.W3,
			                    value:data.ip,
			                    disabled : false,
			                    require : true,
			                    isShow : true,
								extendFunction: ["checkIP"],
                        		validate: "checkIP : extend function;"
			                },
							port:{
			                	id:"port",
			                	width:constsService.W2,
			                	disabled : false,
			                    require : true,
			                    isShow : true,
			                	value: +data.port > 0 ? data.port : "9443",
			                	min:"1",
			                	max:"65535",
			                	change:function(){
			                	  var val = $("#port").widget().options.value;
			                	  if($.trim(val) == ""){
			                		  $("#port").widget().option("value",data.port);
			                	  }
			                   },
			                   validate:[{
	                                validFn: "required"
	                            }, {
	                                validFn: "rangeValue",
	                                params: [1, 65535],
	                                errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 65535)
	                            }, {
	                                validFn: "integer"
	                            }],
			                   tip: appUtils.getString("common_term_addRemoteServer_port_tip")
			                },
			                password: {
			                    id: "password",
			                    width:constsService.W3,
			                    disabled:false,
			                    require:true,
			                    type:"password",
			                    isShow : true,
			                    validate: constsService.VALID.AUTH_PWD_64
			                },
			                username: {
			                    id: "username",
			                    disabled:true,
			                    require:true,
			                    isShow : true,
			                    values: "",
			                    width:constsService.W3,
			                    validate: constsService.VALID.AUTH_NAME
			               }
			           };
			        var isModifyName = !isLocal && isModify && data.user != "SyncAdmin";
			        $scope.isAddRemoteserver = (!isLocal && !isModify) ? true : false;
				$scope.model = {
							labels: {
								message : appUtils.getString(isLocal ? "site.localserver.task.modify.des.label" : isModify ? "site.remotelserver.task.modify.des.label" : "site.manageServer.task.add.des.label"),
			                    name: appUtils.getStringWithColon("common_term_name_label"),
			                    port:appUtils.getStringWithColon("common_term_port_label"),
			                    username: appUtils.getStringWithColon("common_term_username_label"),
			                    ip: appUtils.getStringWithColon("common_term_ip_column"),
			                    authinfo:appUtils.getStringWithColon("res_term_modifyauth_label"),
			                    password: appUtils.getStringWithColon("common_term_password_label"),
			                    devAlias: appUtils.getStringWithColon("common_term_alias_label"),
			                    instructions: appUtils.getString("common_term_wizardInstructions_label"),
			                    modifyUsername: appUtils.getStringWithColon("common_term_username_label")
		                   },
		                   name: {
			                    id: "name",
			                    width:constsService.W3,
			                    value: null === data.name ? "null" : data.name,
			                    disabled:false,
			                    validate: constsService.VALID.NAME_REQUIRED
			                },
			                devAlias: {
			                    id: "devAlias",
			                    width:constsService.W3,
			                    value:data.devAlias,
			                    disabled:false,
			                    isShow : true,
			                    description : appUtils.getString("site_managementServer_task_add_para_alias_des_label"),
			                    validate: constsService.VALID.NAME_DEVALIAS
			                },
			                authinfo:{
			                	id : "authinfo",
			     				items : [{label : appUtils.getString("common_term_enable_label"), value : "on"},
			     				         {label : appUtils.getString("common_term_disable_label"), value : "off"}],
			     				standard : true,
			     				selected:"off",
			     				isShow : false,
			     				change : function() {
				                	 var selected  = $("#authinfo").widget().option("selected");
				                	 var isOn = selected == "on";
				                	 _.each(verifyModel,function(v,k){
				                	 	v.disabled = isOn;
				                	 	v.require = !isOn;
				                	 });
				                	 if(isModifyName){
				                	 	$scope.model.modifyUsername.disable = isOn;
				                	 	$scope.model.modifyUsername.require = !isOn;
				                	 };

			     				}
			                },
			                modifyUsername:{
			                	id: "modifyUsername",
			                	values: [],
			                	width: constsService.W3,
			                	disable: true,
			                	isShow: false,
			                	require: true
			                }

			      };

		      	_.each(verifyModel,function(v,k){
		      			if(isLocal)
		      			{
		      				v.disabled = true;
		      				v.isShow = false;
		      			}else{
		      				if(isModify)
		      				{
		      					v.disabled = true;
			      				v.isShow = true;
			      				if(isModifyName && v.id == "username"){
			      					v.isShow = false;
			      				}
		      				}else{
		      					v.disabled = false;
			      				v.isShow = true;
		      				}
		      			}
			    });

		      	$scope.model.authinfo.isShow = !isLocal && isModify;
		      	$scope.model.modifyUsername.isShow = isModifyName;
		      	if(isModifyName){
		      		$scope.model.modifyUsername.values = [{
		      			"selectId": data.user,
		      			"label": data.user
		      		},{
		      			"selectId": "SyncAdmin",
		      			"label": "SyncAdmin"
		      		}];
		      		$scope.model.modifyUsername.defaultSelectid = data.user;
		      		$scope.$apply();
		      	};

		      	$scope.model.name.isShow = isLocal;
		      	$scope.model.devAlias.isShow = !isLocal;
		      	_.extend($scope.model,verifyModel);

		      	(function init() {
		      		if (!isLocal && isModify) {
		      			$scope.model.username.values = data.user;
		      			$scope.$apply();
		      		}
		      		else {
		      			$scope.model.username.values = "SyncAdmin";
		      			$scope.$apply();
		      		}
		      	})();

		      	UnifyValid.checkIP = function() {
	                var val = $.trim($("#ip").widget().getValue());
	                if (_.isEmpty(val)) {
	                    return appUtils.getString("common_term_empty_label");
	                };
	                if (!appUtils.validIPv4OrIPv6Address(val)) {
	                    return appUtils.getString("validate_ipv4_ipv6_label");
	                }
	                return "";
	            };

	            $scope.$on('$destroy', function() {
	                delete UnifyValid.checkIP;
	            });

			} ];

	var module = angular.module("recoverydirector.site.config");
	module.tinyController("server.serverRemoteEditCtrl", ctrl);
	return module;
})
