define([],
    function() {
        "use strict";
        var ctrler = [
            "$rootScope",
            "$scope",
            "$state",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            "infoTransferredService",
            function($rootScope, $scope, $state, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model, infoTransferredService) {

                $scope.site = {
                    resourceOptAuth: "9328"
                };

                function _addCloseIcon() {
                    _.each($(".button.level0.switch"), function(outIcon) {
                        var childrenElem = $(outIcon).parent('.level0').children('ul');

                        function serverClick(){
                            var childrenElem = $(outIcon).parent('.level0').children('ul');
                            if(childrenElem.length == 0) {
                                $(this).parent('.level0').children('a').click();
                            }
                        };
                        $(outIcon).bind('click', serverClick);

                        //不处于打开状态的服务器节点才添加＋符号
                        if($(outIcon).attr('class').indexOf('_open') < 0) {
                            if ($(outIcon).hasClass('center_docu')) {
                                $(outIcon).removeClass('center_docu').addClass('center_close');
                            } else if ($(outIcon).hasClass('bottom_docu')) {
                                $(outIcon).removeClass('bottom_docu').addClass('bottom_close');
                            } else if ($(outIcon).hasClass('roots_docu')) {
                                $(outIcon).removeClass('roots_docu').addClass('roots_close');
                            }
                        } else {
                            _.each(childrenElem.children('li').children('span'), function(insideIcon) {
                                if (!$(insideIcon).hasClass('center_close') && !$(insideIcon).hasClass('center_open') && $(insideIcon).hasClass('center_docu')) {
                                    $(insideIcon).removeClass('center_docu').addClass('center_close');
                                } else if (!$(insideIcon).hasClass('bottom_close') && !$(insideIcon).hasClass('bottom_open') && $(insideIcon).hasClass('bottom_docu')) {
                                    $(insideIcon).removeClass('bottom_docu').addClass('bottom_close');
                                };

                                //当站点节点从未展开过时,才在click事件上绑定加载其下设备节点的函数
                                function siteClick(){
                                    if($(insideIcon).parent('.level1').children('ul').length == 0) {
                                        $(this).parent('.level1').children('a').click();
                                    }
                                };
                                $(insideIcon).one('click', siteClick);
                            })
                        }
                    })
                };

                infoTransferredService.remove("resource", "addCloseIcon");
                infoTransferredService.put("resource", "addCloseIcon", _addCloseIcon);
                var SERVER_STATUS = {
                        0: {
                            label: appUtils.getString("site_term_status_on_label"),
                            class: "serverOnline"
                        },
                        1: {
                            label: appUtils.getString("site_term_status_network_fault_label"),
                            class: "serverOffline"
                        },
                        2: {
                            label: appUtils.getString("site_term_status_verify_label"),
                            class: "serverFailed"
                        },
                        3: {
                            label: appUtils.getString("common_term_currentStatus_value_upgrading_label"),
                            class: "serverUpgrading"
                        }
                    },
                    opts = {
                        add: {
                            name: appUtils.getString("common_term_add_button"),
                            authKey: "ism.drm.servers.auth.add",
                            isActive: true,
                            class: "iconbutton-add",
                            clickActive: function(treeNode) {
                                !_.isEmpty(treeNode) && _.isFunction(treeNode.add) && (treeNode.add(this.callback));
                            },
                            callback: function(selectNode) {
                                //添加刷新父节点
                                var parentNode = selectNode.getParentNode();
                                var treeObj = $("#tree").widget().getZTreeObj();
                                if (_.isEmpty(parentNode)) {
                                    _init();
                                    return;
                                };

                                var allSites,
                                    siteIds = [];
                                if (!_.isEmpty(infoTransferredService.get("resource", "sitesAttachServer"))) {
                                    allSites = infoTransferredService.get("resource", "sitesAttachServer");

                                    $.each(allSites, function(index, node) {
                                        node.open = false;
                                        siteIds.push(node.siteId);
                                    });
                                }
                                infoTransferredService.remove("resource", "sitesAttachServer");
                                parentNode.onLoad(openNewSite);

                                function openNewSite() {
                                    //选中并打开新建的站点节点
                                    _.each(parentNode.children, function(val) {
                                        if (_.indexOf(siteIds, val.siteId) < 0) {
                                            treeObj.selectNode(val);
                                            val.onClick();
                                            val.onLoad();
                                        }
                                    });
                                    //关闭其它服务器节点和移除下面的站点节点
                                    _.each(treeObj.getNodes(), function(server) {
                                        if (server.uuid != parentNode.uuid) {
                                            $("#tree").widget().getZTreeObj().removeChildNodes(server);
                                        }
                                    });
                                    _addCloseIcon();
                                };
                            }
                        },
                        modify: {
                            name: appUtils.getString("common_term_edit_button"),
                            authKey: "ism.drm.servers.auth.modify",
                            isActive: true,
                            class: "iconbutton-edit",
                            clickActive: function(treeNode) {
                                !_.isEmpty(treeNode) && _.isFunction(treeNode.modify) && (treeNode.modify(this.callback));
                            },
                            callback: function(selectNode) {

                                //修改刷新父节点
                                var parentNode = selectNode.getParentNode()
                                if (_.isEmpty(parentNode)) {
                                    _init();
                                    return;
                                }
                                parentNode.onLoad(_addCloseIcon);
                            }
                        },
                        delete: {
                            name: appUtils.getString("common_term_delete_button"),
                            authKey: "ism.drm.servers.auth.delete",
                            isActive: true,
                            class: "iconbutton-delete",
                            clickActive: function(treeNode) {
                                !_.isEmpty(treeNode) && _.isFunction(treeNode.delete) && (treeNode.delete(this.callback));
                            },
                            callback: function(selectNode) {
                                // delete node
                                var treeObj = $("#tree").widget().getZTreeObj(),
                                    nextNode = selectNode.getNextNode();

                                if (_.isEmpty(nextNode)) {
                                    nextNode = selectNode.getPreNode();
                                    _.isEmpty(nextNode) && (nextNode = selectNode.getParentNode());
                                    _.isEmpty(nextNode) && (nextNode = treeObj.getNodes()[0]);

                                }

                                treeObj.removeNode(selectNode);

                                treeObj.selectNode(nextNode);
                                infoTransferredService.put("resource", "currentNode", nextNode);

                                opts.notifyHover();
                                nextNode.onClick();
                                nextNode.onLoad(_addCloseIcon);
                            }
                        },
                        refresh: {
                            name: appUtils.getString("common_term_refresh_button"),
                            authKey: "ism.drm.servers.auth.refresh",
                            isActive: true,
                            class: "iconbutton-pg-refresh",
                            clickActive: function(treeNode) {
                                !_.isEmpty(treeNode) && _.isFunction(treeNode.refresh) && (treeNode.refresh(this.callback));
                            },
                            callback: function(selectNode) {
                                selectNode.onLoad();
                            }
                        }
                    },
                    siteTree = {
                        "id": "tree",
                        "width": "150px",
                        "height": "375px",
                        "setting": {
                            view: {
                                selectedMulti: false //true时，按住ctrl可多选
                            },
                            data: {
                                simpleData: {
                                    enable: true
                                }
                            },
                            callback: {
                                onClick: function(event, id, node) {
                                    //记录当前选中节点，在操作后刷新节点时使用
                                    infoTransferredService.put("resource", "currentNode", node);

                                    opts.notifyHover();
                                    node.onClick();
                                    _.isFunction(node.onLoad) && (node.onLoad(_addCloseIcon));
                                    $scope.$apply();
                                }
                            }
                        },
                        values: [],
                        init: function() {
                            mask.show();
                            communicationService.get(utilService.getResouceUrl("/drmservers"), null, null, 3600000).promise().always(function(result) {
                                mask.hide();

                                if (!exception.check(result)) {
                                    return;
                                }

                                var nodes = [],
                                    sleectNode;

                                _.each(result, function(server) {
                                    var nodeObj, node = {
                                        type: server.serverType,
                                        id: server.uuid,
                                        pId: "-1",
                                        name: server.name,
                                        iconSkin: SERVER_STATUS[server.status].class,
                                        isOpen: true,
                                        isSelected: false,
                                        isDisable: false
                                    };
                                    _.extend(node, server);

                                    var nodeModelName = constsService.RESOURCE_TREE_MODEL["server" + node.type],
                                        nodeObj = new Model[nodeModelName](node);

                                    _.extend(nodeObj, node);
                                    nodes.push(nodeObj);

                                    _.isEmpty(sleectNode) && (sleectNode = nodeObj, sleectNode.selected = true);
                                });

                                $scope.siteTree.values = nodes;
                                $scope.$apply();

                                var serverNodes = $("#tree").widget().getZTreeObj().getNodes(),
                                    serverIds = [];
                                if (!_.isEmpty(infoTransferredService.get("resource", "allServerNodes"))) {
                                    $.each(infoTransferredService.get("resource", "allServerNodes"), function(index, server) {
                                        serverIds.push(server.uuid);
                                    });
                                };
                                infoTransferredService.remove("resource", "allServerNodes");

                                if (_.isEmpty(serverIds)) {
                                    sleectNode = serverNodes[0];
                                } else {
                                    $.each(serverNodes, function(index, node) {
                                        if (_.indexOf(serverIds, node.uuid) < 0) {
                                            sleectNode = node;
                                        }
                                    });
                                }
                                !_.isEmpty(sleectNode) && (opts.notifyHover(), sleectNode.onClick(), sleectNode.onLoad(addTitle), infoTransferredService.put("resource", "currentNode", sleectNode));

                                function addTitle() {
                                    var treeDom = $("#" + $scope.siteTree.id);
                                    _.each(SERVER_STATUS, function(v, k) {
                                        $("." + v.class + "_ico_open", treeDom).attr("title", v.label);
                                        $("." + v.class + "_ico_close", treeDom).attr("title", v.label);
                                        $("." + v.class + "_ico_docu", treeDom).attr("title", v.label);
                                    });
                                    _addCloseIcon();
                                    $(".curSelectedNode").click();
                                };
                                $scope.$apply();
                            });
                        }
                    };

                (function(optObj) {
                    _.each(optObj, function(v, k) {
                        var tempVal = v.clickActive;


                        v.clickActive = function(component) {
                            var nodeObj = $("#tree").widget().getZTreeObj().getSelectedNodes()[0];
                            tempVal.call(component, nodeObj);
                        }

                        v.hover = function() {
                            var nodeObj = $("#tree").widget().getZTreeObj().getSelectedNodes()[0];
                            v.isActive = !_.isUndefined(nodeObj[k]);
                            if (!window.isUltraVR && k == "add" && _.contains([0], +nodeObj.type)) {
                                v.isActive = false;
                            };

                        }
                    })

                    optObj.notifyHover = function() {
                        //改变上面按钮的状态
                        _.each(this, function(v, k) {
                            if (_.isFunction(v)) {
                                return;
                            }
                            v.hover();
                        });
                    }
                })(opts);

                var _init = function() {
                    siteTree.init();
                }
                _init();

                $scope.opts = [opts.add, opts.modify, opts.delete, opts.refresh];
                $scope.siteTree = siteTree;

                $scope.$on("$stateChangeSuccess", function(event, toState, toParams, fromState, fromParams) {
                    if (!("site" == toState.name && 0 == fromState.name.indexOf("site."))) {
                        return;
                    }
                    _init();
                });
            }

        ]

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.ctrl', ctrler);
        return module;
    })
