define(["tiny-common/UnifyValid"],
    function(UnifyValid) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$log",
            "$compile",
            "$stateParams",
            "$timeout",
            "exception",
            "message",
            "communicationService",
            "utilService",
            "mask",
            "constsService",
            "appUtils",
            "statusEnumService",
            "cookieService",
            "model",
            "infoTransferredService",
            "restService",
            function($scope, $state, $log, $compile, $stateParams, $timeout, exception, message, communicationService, utilService, mask, constsService, appUtils, statusEnumService, cookieService, Model, infoTransferredService, restService) {

                var currentSite = infoTransferredService.get("site", "currentSite");
                if (!currentSite) {
                    return;
                }
                var fusionsphereContents = [];
                if ("true" != "false") {
                    fusionsphereContents.push({
                        title: "OpenStack",
                        click: function() {
                            $state.go("site.discovery", {
                                siteId: currentSite.siteId,
                                type: 'homeopenStack'
                            });
                        }
                    });
                }

                var resources = {
                    "ism.drm.deviceType.fusionsphere.mainType": {
                        index: 2,
                        type: "vsphere",
                        nodeClass: "fusionsphere",
                        name: appUtils.getString("res.term.FusionShpere.label"),
                        class: "/theme/recoverydirector/images/home/ic_fusionsphere.png",
                        size: 0,
                        desc: appUtils.getString("site.res.task.addFusionShpere.des.label"),
                        btn: [{
                            id: "menubtnvsphere",
                            dropbtn: true,
                            click: function(e){
                                if( _.isUndefined(e) || $(e.target).prop("class") === "tiny-menubutton-main-a") {
                                    return;
                                }
                                $("#menubtnvsphere").widget()._popMenu();
                            },
                            content: fusionsphereContents,
                            text: appUtils.getString("site.term.addFusionShpere.label"),
                        }]
                    },
                    "ism.deviceType.cloudVault.mainType": {
                        index: 4,
                        type: "backuprespo",
                        nodeClass: "backupRespo",
                        name: appUtils.getString("ism.deviceType.cloudVault.mainType"),
                        class: "/theme/recoverydirector/images/home/ic_cloudvault.png",
                        size: 0,
                        desc: appUtils.getString("site_backuprespo_maintypedesc_label"),
                        btn: [{
                            id: "menubtnbackuprespo",
                            dropbtn: false,
                            content: [],
                            text: appUtils.getString("site_backuprespo_buy_label"),
                            click: function() {
                                window.open(constsService.HUAWEI_CLOUD_WEBSITE, "_blank");
                            }
                        }]
                    },
                    "ism.deviceType.cloudServer.mainType": {
                        index: 5,
                        type: "cloudserver",
                        nodeClass: "cloudServer",
                        name: appUtils.getString("ism.deviceType.cloudServer.mainType"),
                        class: "/theme/recoverydirector/images/home/ic_cloudserver.png",
                        size: 0,
                        desc: appUtils.getString("site_cloudserver_maintypedesc_label"),
                        btn: [{
                            id: "menubtnecsserver",
                            dropbtn: false,
                            content: [],
                            text: appUtils.getString("site_ecsserver_buy_label"),
                            click: function(e) {
                                window.open(constsService.HUAWEI_CLOUD_WEBSITE, "_blank");
                            }
                        }]
                    }
                };
                $scope.labels = {
                    basicInfo: appUtils.getString("common.term.basicInfo.title.label"),
                    statics: appUtils.getString("site_term_statics_res_label"),
                    pgList: appUtils.getString("ism.drm.protect.group.list"),
                    RPO_TITLE: appUtils.getString("home.term.RPOmet.tab"),
                    LOADING: appUtils.getString("home.term.loadding.label")
                };

                $scope.siteInfo = {
                    name: {
                        label: appUtils.getStringWithColon("group_count_term_site_name"),
                        value: currentSite.name
                    },
                    desc: {
                        label: appUtils.getStringWithColon("term_site_desc"),
                        value: currentSite.description
                    }
                }
                $scope.summery = [];
                $scope.summery.onLink = function(device) {
                    var currentSite = infoTransferredService.get("site", "currentSite"),
                        currentSiteNode = currentSite.getTree().getNodeByParam("id",currentSite.id),
                        selectNode = _.findWhere(currentSiteNode.children, {
                            iconSkin: device.nodeClass
                        });
                    if (!_.isEmpty(selectNode)) {
                        currentSiteNode.getTree().selectNode(selectNode);
                        $scope.$parent.siteTree.setting.callback.onClick(null, null, selectNode);
                    }

                }

                $scope.pgTable = {
                    id: "pgTable",
                    'isDraggedRemember': true,
                    displayLength: 5,
                    totalRecords: 0,
                    enablePagination: true,
                    callback: function(evtObj) {
                        $scope.pgTable.currPage.pageIndex = evtObj.currentPage;

                        $scope.pgTable.load();
                    },
                    sortCallback: function(nNode, sortArr) {
                        $scope.pgTable.currPage.pageIndex = 1;
                        $scope.pgTable.orderBy = $scope.pgTable.columns[sortArr[0][0]].mData;
                        $scope.pgTable.orderType = sortArr[0][1];
                        $scope.pgTable.load();
                    },
                    currPage: {
                        "pageIndex": 1
                    },
                    columns: [

                        {
                            "sTitle": appUtils.getString("common_term_status_label"),
                            "mData": "status",
                            "bSortable": false
                        }, {
                            "sTitle": appUtils.getString("common_term_name_label"),
                            "mData": "name"
                        }, {
                            "sTitle": appUtils.getString("site.term.applicationType.column"),
                            "mData": "poType"
                        }, {
                            "sTitle": appUtils.getString("ism.drm.protect.group.template"),
                            "mData": "template.name",
                            "bSortable": false
                        }, {
                            "sTitle": appUtils.getString("group_count_term_configured_RPO_column"),
                            "mData": "",
                            "bSortable": false
                        }, {
                            "sTitle": appUtils.getString("group_count_term_current_RPO_column"),
                            "mData": "",
                            "bSortable": false
                        }, {
                            "sTitle": appUtils.getString("ism.drm.protect.group.lastExcuteTime"),
                            "mData": "lastExecTime",
                            "bSortable": false
                        }
                    ],
                    renderRow: function(nRow, aData, iDataIndex) {
                        statusEnumService.setRenderRowStatus(arguments, {
                            0: ["PROTECTGROUP_STATUS", "status"],
                            1: ["I18N", aData.name],
                            3: ["I18N", appUtils.getPtFullName(aData.template.name)]
                        });
                        //正在执行添加查看详情链接 see updatePgTable
                        if( aData.status == 5 ) {
                            var html = "<span style='margin-right:5px;width:16px;height:16px;float:left;' class='iconbutton-loading'></span><font>" + appUtils.getString("ism.drm.drp.execute.result.now.run") + "</font>";
                            $('td:eq("0")', nRow).html(html);
                        }

                        var rpo = aData["RPO_ITEM_KEY"];

                        var configRpo = "--";
                        var actualRpo = "--";
                        if (angular.isArray(rpo) && rpo.length != 0) {
                            configRpo = "";
                            actualRpo = "";

                            rpo.forEach(function(rpoItem) {
                                configRpo += appUtils.maxMsTimeUnit(rpoItem.configuredRPO) + " , ";
                                actualRpo += appUtils.maxMsTimeUnit(rpoItem.actualRPO) + " , ";
                            });

                            configRpo = configRpo.replace(/ , $/, "");
                            actualRpo = actualRpo.replace(/ , $/, "");
                        }

                        var rto = aData["RTO_ITEM_KEY"];
                        var estimateRto = "--";
                        if (angular.isArray(rto) && rto.length != 0) {
                            estimateRto = "";

                            rto.forEach(function(rtoItem) {
                                estimateRto += appUtils.maxMsTimeUnit(rtoItem.estimateRTO) + " , ";
                            });

                            estimateRto = estimateRto.replace(/ , $/, "");
                        }

                        $("td:eq(2)", nRow).html(statusEnumService.getStatus("PROTECT_OBJECT_TYPE", aData['poType']));

                        $('td:eq("4")', nRow).text(configRpo);
                        $('td:eq("5")', nRow).text(actualRpo);
                    },
                    url: "/protectgroups",
                    orderBy: "name",
                    orderType: "desc",
                    load: function(callback) {
                        !callback && (callback = $scope.pgTable.updateUI);

                        var params = {
                                siteId : currentSite.id,
                                pageSize: $scope.pgTable.displayLength,
                                startPage: $scope.pgTable.currPage.pageIndex - 1,
                                orderBy: $scope.pgTable.orderBy,
                                orderType: $scope.pgTable.orderType
                            },
                            url = appUtils.fillUrl(this.url, params);
                        communicationService.get(url).promise().always(callback);
                    },
                    updateUI: function(result) {
                        if (!exception.check(result)) {
                            return;
                        }

                        $scope.pgTable.data = appUtils.encodeForHTML(result.records);

                        $scope.pgTable.totalRecords = result.totalCount;
                        $scope.pgTable.enablePagination = result.totalCount > $scope.pgTable.displayLength;
                        $scope.$apply();
                    }
                };

                var resourceStatisticInfo = function() {
                    $scope.mask = $.Deferred();
                    communicationService.get(utilService.getResouceUrl("/sites/" + currentSite.siteId + "/action/sumResource")).promise().always(function(response) {
                        $scope.mask.resolve();
                        var excep = exception.check(response, false);
                        if (angular.isString(excep)) {
                            $log.error("query sumResource failed >>>>>>");
                            response = {
                                result: {
                                    "ism.deviceType.cloudVault.mainType": 0,
                                    "ism.deviceType.cloudServer.mainType": 0
                                }
                            }
                        };

                        _.each(response.result, function(v, k, obj) {
                            var resObject = resources[k]
                            resObject && (
                                resObject.size = v,
                                this.push(resObject)
                            )
                        }, $scope.summery);

                        $scope.summery.sort(function(a, b) {
                            return parseInt(a.index, 10) - parseInt(b.index, 10);
                        })
                        $scope.$apply();
                    });
                };

                $scope.isEn = appUtils.isEn();
                $scope.isPgAuth = appUtils.checkRight("9006") && !currentSite.isCloudSite;

                var _init = function() {
                    resourceStatisticInfo();
                    $scope.isPgAuth && $scope.pgTable.load();
                    $scope.$apply();
                }();
            }
        ];
        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.home.ctrl', ctrler);
        return module;
    })
