+define(["tiny-common/UnifyValid", "tiny-widgets/Window"],
    function(UnifyValid, Window) {
        "use strict";
        var ctrler = [
            "$scope",
            "$state",
            "$stateParams",
            "$sce",
            "exception",
            "message",
            "restService",
            "communicationService", "utilService", "mask", "constsService", "appUtils", "statusEnumService","infoTransferredService",
            function($scope, $state, $stateParams, $sce, exception, message, restService,
                communicationService, utilService, mask, constsService, appUtils, statusEnumService, infoTransferredService) {
                var addSiteText = appUtils.isEn() ? "create a site" : appUtils.getString("home.term.addSite.label"),
                    linkHtml = "<a class='link'>" + addSiteText + "</a>",
                    serverUuid = $stateParams.serverUuid;
                var _addCloseIcon = infoTransferredService.get("resource","addCloseIcon");
                var _validCloudSitesCfg = function(isCreateSite) {
                    var regionId = $("#area").widget().getSelectedId();
                    if (regionId == "-1") {
                        message.error(appUtils.getString("validate_select_value_label", appUtils.getString("site_create_area_label")));
                        return false;
                    }
                    if (isCreateSite) {
                        var projectId = $("#project").widget().getValue();
                        if (projectId == "-1") {
                            message.error(appUtils.getString("validate_select_value_label", appUtils.getString("site_create_project_label")));
                            return false;
                        }
                    }

                    return true;
                };

                //当前点击的站点的类型boolean
                $scope.queryByName = true;
                $scope.configformTitle = appUtils.getString("user_term_userlist_title");
                $scope.btnCreate = {
                    id: "btnCreate",
                    text: appUtils.getString("home.term.addSite.label"),
                    toolTip: {
                        position: "right",
                        width: "340px",
                        content: appUtils.getString("site_create_tooltip_label"),
                    },
                    linkHtml: $sce.trustAsHtml(appUtils.getString("site.nosite.task.addSite.des.value").replace(addSiteText, linkHtml)),
                    click: function () {
                        var data = {};
                        data.isCreateSite = true;
                        var siteAddWin = angular.copy(constsService.SITE_ADD_EDIT);
                        siteAddWin.data = data;
                        siteAddWin.title = appUtils.getString("home.term.addSite.label");
                        appUtils.showWindow(siteAddWin, function() {
                            var options = this.options;
                            var isCloudSite = !_.isEmpty($("#siteType").attr('checked'));
                            if (!UnifyValid.FormValid($("#" + options.verifyId), {focusInvalid: true})) {
                                return;
                            }

                            if (isCloudSite && !_validCloudSitesCfg(true)) {
                                return;
                            }
                            var param = {};
                            param.serverUuid = serverUuid;
                            param.isCloudSite = isCloudSite;
                            param.name = $.trim($("#name").widget().getValue());
                            param.description = $.trim($("#description").widget().getValue());
                            if (isCloudSite) {
                                param.cloudServiceProvider = "HuaweiCloud";
                                param.ak = $("#ak").widget().getValue();
                                param.sk = $("#sk").widget().getValue();
                                param.regionId = $("#area").widget().getSelectedId();
                                param.projectId = $("#project").widget().getValue();
                                param.proxyId = $("#proxy").widget().getSelectedId() == "-1" ? "" : $("#proxy").widget().getSelectedId();
                            };
                            mask.show();
                            communicationService.post(utilService.getResouceUrl("/sites"), param, undefined, undefined, 10 * 60 * 1E3).promise().always(function(result) {
                                mask.hide();
                                if (exception.check(result)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            $("#" + options.winId).widget().destroy();
                                            _refreshData();
                                            $("#tree").widget().getZTreeObj().getSelectedNodes()[0].onLoad(openNewSite);

                                            var allSites,
                                                siteIds = [];
                                            if(!_.isEmpty(infoTransferredService.get("resource", "sitesAttachServer"))){
                                                allSites = infoTransferredService.get("resource", "sitesAttachServer");

                                                $.each(allSites, function(index, node){
                                                    node.open = false;
                                                    siteIds.push(node.siteId);
                                                });
                                            } else {
                                                allSites = $("#tree").widget().getZTreeObj().getSelectedNodes()[0].children;

                                                $.each(allSites, function(index, node){
                                                    node.open = false;
                                                    siteIds.push(node.siteId);
                                                });
                                            }
                                            infoTransferredService.remove("resource", "sitesAttachServer");
                                            function openNewSite(){
                                                //选中并打开新建的站点节点
                                                var serverNode = $("#tree").widget().getZTreeObj().getSelectedNodes()[0];
                                                _.each(serverNode.children, function(val){
                                                   if(_.indexOf(siteIds, val.siteId) < 0) {
                                                        $("#tree").widget().getZTreeObj().selectNode(val);
                                                        val.onClick();
                                                        val.onLoad();
                                                        $(".curSelectedNode").click();
                                                   }
                                                });
                                                //关闭其它服务器节点和移除下面的站点节点
                                                _.each($("#tree").widget().getZTreeObj().getNodes(), function(server){
                                                    if(server.uuid != serverNode.uuid) {
                                                        $("#tree").widget().getZTreeObj().removeChildNodes(server);
                                                    }
                                                });
                                                _addCloseIcon();
                                            };
                                        }
                                    });
                                }
                            });
                        })
                    }
                };

                $scope.openWin = function(winId, winTitle, paramObj, winWidth, winHeight, url) {
                    var options = {
                        "winId": winId,
                        "title": winTitle,
                        "data": paramObj,
                        "height": winHeight,
                        "width": winWidth,
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "content": url,
                        "minimizable": false,
                        "maximizable": false,
                        "buttons": [{
                            key: "close",
                            label: appUtils.getString("common_term_close_button"),
                            focused: true,
                            handler: function(event) {
                                $("#" + winId).widget().destroy();
                            }
                        }]
                    }
                    var win = new Window(options);
                    win.show();
                };


                $scope.model = {
                    status: {
                        id: "choise",
                        width: constsService.W2,
                        values: [{
                            selectId: "0",
                            label: appUtils.getString("common_term_name_label")
                        }, {
                            selectId: "1",
                            label: appUtils.getString("common_term_type_label")
                        }],
                        defaultSelectid: "0",
                        change: function() {
                            var s = $("#choise").widget().getSelectedId();
                            if (s == "0") {
                                $scope.queryByName = true;
                            } else {
                                $scope.queryByName = false;
                            }
                        },
                        disabled: false
                    },
                    text: {
                        id: "choiseText",
                        width: constsService.W2
                    },
                    choiseType: {
                        id: "choiseType",
                        width: constsService.W2,
                        values: [{
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }, {
                            selectId: "0",
                            label: appUtils.getString("site_term_local_label")
                        }, {
                            selectId: "1",
                            label: appUtils.getString("site_term_remote_label")
                        }],
                        defaultSelectid: "-1",
                        disabled: false
                    }
                };
                $scope.datasTable = {
                    id: "datasTable",
                    paging: "auto",
                    paginationStyle:"full_numbers",
                    columns: [
                        {
                            "sTitle": appUtils.getString("common_term_name_label"),
                            "mData": "name"
                        }, {
                            "sTitle": appUtils.getString("common_term_description_column"),
                            "mData": "description",
                            "bSortable": false
                        }, {
                            "sTitle": appUtils.getString("site_create_brand_label"),
                            "bSortable": false,
                            "bVisible": !window.isUltraVR
                        }, {
                            "sTitle": appUtils.getString("site_create_area_label"),
                            "mData": "regionId",
                            "bSortable": false,
                            "bVisible": !window.isUltraVR
                        }
                    ],
                    operateButtonCount: 3,
                    buttonContainerPosition: "right",
                    displayLength: constsService.TABLE_COUNT_PER_PAGE_BIG,
                    lengthMenu: constsService.TABLE_LENGTH_AUTO_MENU,
                    totalRecords: 0,
                    callback: function(evtObj) {},
                    currentPage: 0,
                    renderRow: function(nRow, aData, iDataIndex) {
                        var isCloudSite = aData['isCloudSite'];
                        var siteType = aData['isCloudSite'] ? appUtils.getString("yesBtnTitile") : appUtils.getString("noBtnTitile");
                        var cloudBrand = !isCloudSite ? "" : statusEnumService.getStatus("CLOUD_BRAND_ENUM", aData['cloudServiceProvider']);
                        isCloudSite && restService.queryRegion(aData['regionId'], function(result) {
                            $("td[tdtitle='" + appUtils.getString("site_create_area_label") + "']", nRow).html(appUtils.getString(_.isUndefined(result) ? "--" : result.name));
                        });
                        $("td[tdtitle='" + appUtils.getString("site_type_cloud_label") + "']", nRow).html(siteType);
                        $("td[tdtitle='" + appUtils.getString("site_create_brand_label") + "']", nRow).html(cloudBrand);
                    },
                    data: [],
                    opAreaConfig: appUtils.flilterOperRight([{
                        id: "iconBtnRefresh",
                        authKey: "9327",
                        template: "<div class='iconbutton-pg-refresh' title='" + appUtils.getString("common_term_refresh_button") + "'></div>",
                        clickActive: function() {
                            if (!$scope.isHoverLocalSite || $scope.current.isCloudSite) {
                                _refreshSiteAction();
                            }
                        }
                    }, {
                        id: "iconBtnEdit",
                        authKey: "9325",
                        template: "<div class='iconbutton-edit' title='" + appUtils.getString("common_term_edit_button") + "'></div>",
                        clickActive: function() {
                            _editSiteAction();
                        }
                    }, {
                        id: "iconBtnDel",
                        authKey: "9326",
                        template: "<div class='iconbutton-delete'  title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                        clickActive: function() {
                            if ($scope.isHoverLocalSite) {
                                _deleteSiteAction();
                            }
                        }
                    }]),
                    hoverActive: function(e, param) {
                        if (param) {
                            $scope.current = param;
                        }
                        //当前浮动的站点的类型boolean
                        if (param.siteType == "0") {
                            $scope.isHoverLocalSite = true;
                        } else {
                            $scope.isHoverLocalSite = false;
                        }
                        if ($scope.isHoverLocalSite) {
                            $("#iconBtnDel div").removeClass("iconbutton-delete-disabled").addClass("iconbutton-delete");
                            if (param.isCloudSite) {
                                $("#iconBtnRefresh div").removeClass("iconbutton-pg-refresh-disabled").addClass("iconbutton-pg-refresh");
                            } else {
                                $("#iconBtnRefresh div").removeClass("iconbutton-pg-refresh").addClass("iconbutton-pg-refresh-disabled");
                            }
                        } else {
                            $("#iconBtnRefresh div").removeClass("iconbutton-pg-refresh-disabled").addClass("iconbutton-pg-refresh");
                            $("#iconBtnDel div").removeClass("iconbutton-delete").addClass("iconbutton-delete-disabled");
                        }
                    },
                    cellClickActive: function(e, param) {}
                };


                var _editSiteAction = function() {
                    var id = _getOpID();
                    var data = {};
                    communicationService.get(utilService.getResouceUrl("/sites/" + id)).promise().always(function(response) {
                        if (exception.check(response)) {
                            var data = {};
                            data.isCreateSite = false;
                            data.proxyId = response.proxyId;
                            data.siteId = response.siteId;
                            data.regionId = response.regionId;
                            data.siteType = +response.siteType;
                            data.isCloudSite = response.isCloudSite;
                            data.ak = appUtils.encodeForHTML(response.ak);
                            data.name = appUtils.encodeForHTML(response.name);
                            data.description = appUtils.encodeForHTML(response.description);

                            var win = angular.copy(constsService.SITE_ADD_EDIT);
                            if (!response.isCloudSite) {
                                win.width = constsService.WIN_SIZE.S3[0];
                                win.height = constsService.MODIFY_SITE_WIN.height;
                            } else {
                                win.width = appUtils.isEn() ? constsService.WIN_SIZE.S4[0] : constsService.WIN_SIZE.S3[0];
                                win.height = constsService.WIN_SIZE.S4[1];
                            }
                            win.data = data;
                            win.helpId = "modifySite";

                            appUtils.showWindow(win, function() {
                                var options = this.options;
                                if (!UnifyValid.FormValid($("#" + options.verifyId), {focusInvalid: true})) {
                                    return;
                                }

                                if (data.isCloudSite && !_validCloudSitesCfg(false)) {
                                    return;
                                }

                                var param = {};
                                param.name = $.trim($("#name").widget().getValue());
                                param.description = $.trim($("#description").widget().getValue());
                                param.siteType = 0;
                                if (data.isCloudSite) {
                                    param.regionId = $("#area").widget().getSelectedId();
                                    param.ak = !infoTransferredService.get("akModule", "protocalName") ? "" : $.trim($("#ak").widget().getValue());
                                    param.proxyId = $("#proxy").widget().getSelectedId() == "-1" ? "" : $("#proxy").widget().getSelectedId();
                                    param.sk = !infoTransferredService.get("skPwdModule", "protocalPwd") ? "" : $.trim($("#sk").widget().getValue());
                                }
                                mask.show();
                                communicationService.put(utilService.getResouceUrl("/sites/" + options.data.siteId), param, undefined, undefined, 10 * 60 * 1E3).promise().always(function(result) {
                                    mask.hide();
                                    if (exception.check(result)) {
                                        message.success({
                                            content: appUtils.getString("common_term_operation_success_label"),
                                            ok: function() {
                                                $("#" + options.winId).widget().destroy();
                                                _refreshData();
                                                $("#tree").widget().getZTreeObj().getSelectedNodes()[0].onLoad(_addCloseIcon);
                                            }
                                        });
                                    }

                                });
                            })

                        }
                    });
                };

                var _deleteSiteAction = function() {
                    var id = _getOpID();
                    var name = _getOpName();
                    message.warn({
                        content: appUtils.getString("site_term_site_delete_message", name),
                        ok: function() {
                            mask.show();
                            communicationService.remove(utilService.getResouceUrl("/sites/" + id)).promise().always(function(response) {
                                mask.hide();
                                if (exception.check(response)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            _refreshData();
                                            $("#tree").widget().getZTreeObj().getSelectedNodes()[0].onLoad(_addCloseIcon);
                                        }
                                    });
                                }
                            });
                        }
                    });
                };

                var _refreshSiteAction = function() {
                    var id = _getOpID();
                    mask.show();
                    communicationService.put(utilService.getResouceUrl("/sites/" + id + "/action/refreshRemoteSite"), null, null, null, 3600 * 1E3).promise().always(function(response) {
                        mask.hide();
                        if (exception.check(response)) {
                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {
                                    _refreshData();
                                }
                            });
                        }
                    });
                };

                $scope.refreshPage = function() {
                    $scope.datasTable.currPage = {
                        "pageIndex": 0
                    };
                    _refreshData();
                };


                var _getOpID = function() {
                    var opID = $("#datasTable").widget().getHoverData()[0].siteId;
                    return opID;
                };
                var _getOpName = function() {
                    return $.trim($("#datasTable").widget().getHoverData()[0].name);
                };
                var _updateUI = function(result) {
                    mask.hide();
                    if (exception.check(result)) {
                        _.each(result, function(site){
                            _.isEmpty(site.name) && (site.name = "null")
                        });
                        $scope.datasTable.data = appUtils.encodeForHTML(result);
                        $scope.datasTable.totalRecords = result.length;
                        $scope.$apply();
                    }
                };

                var _refreshData = function() {
                    var url = utilService.getResouceUrl("/sites?serverUuid=" + serverUuid);
                    mask.show();
                    var promise = communicationService.get(url).promise();
                    promise.always(_updateUI);

                    $scope.promise = promise;

                };
                $scope.userRight = {};

                var _initRight = function() {
                    $scope.userRight.siteAdd = "9324";
                    $scope.datasTable.opAreaConfig = appUtils.flilterOperRight($scope.datasTable.opAreaConfig);
                };

                var _init = function() {
                    _refreshData();
                    _initRight();
                };

                _init();

            }
        ]

        var module = angular.module('recoverydirector.site.config');
        module.tinyController('site.siteList.ctrl', ctrler);
        return module;
    })
