define(function() {
    "use strict";
    var service = function() {
        var appUtils = angular.element(document).injector().get("appUtils");
        this.getOsType = function(type) {
            switch ($.trim(type)) {
                case "1":
                    return "Windows";
                case "2":
                    return "Red Hat";
                case "3":
                    return "HP-UX";
                case "4":
                    return "Solaris";
                case "5":
                    return "AIX";
                case "6":
                    return "SUSE";
                case "7":
                    return appUtils.getString("common_term_rocky_label");
                case "8":
                    return "Oracle Linux";
                case "9":
                    return "iSoft";
                default:
                    return "--";
            };

        };

        this.getClustorType = function(type) {
            switch ($.trim(type)) {
                case "1":
                    return "Oracle RAC";
                case "2":
                    return "VCS";
                case "3":
                    return "WSFC";
                case "4":
                    return "PowerHA";
                case "5":
                    return "ServiceGuard";
                case "6":
                    return "RHCS";
                case "7":
                    return "Sun Cluster";
                case "8":
                    return "Exchange DAG";
                case "9":
                    return "SAP HANA"
                default:
                    return "--";
            };
        };

    };
    return service;
});
