define(["tiny-widgets/Window"], function(Window) {
    "use strict";
    var ctrl = ["$scope","$state","$compile","exception", "message", "communicationService", "utilService" ,"constsService","appUtils","mask", "infoTransferredService", "cookieService",
            function ($scope, $state,$compile,exception ,message, communicationService , utilService ,constsService,appUtils,mask, infoTransferredService, cookieService) {
    	$scope.TEST_STATUS_IN_LAST_THREEMONTH = appUtils.getString("home.term.testStatusInLastThreeMonth.tab");
    	$scope.LOADING = appUtils.getString("home.term.loadding.label");
    	$scope.TOP5_TEST_TIME = appUtils.getString("home.term.RPOmet.tab");
    	$scope.BOTTOM_TEST_TIME = appUtils.getString("home.term.planTestTimeStatic.tab");
    	$scope.PROTECTION_COUNT_LBAEL = appUtils.getString("home.term.protectedCount_label");
    	$scope.TOP5_ALARM = appUtils.getString("home.term.top5alarm.tab");
    	$scope.TOP5_ALARM_VIEWALL = appUtils.getString("home.term.top5alarm.viewall");
    	$scope.PROTECTED_STATICS =  appUtils.getString("common.term.protectedStatistics.tab");
    	$scope.TEST_SUCCEED_LABEL = appUtils.getString("home.term.testStatusInLastThreeMonth.value.success.label");
    	$scope.TEST_FAILED_LABEL  = appUtils.getString("home.term.testStatusInLastThreeMonth.value.fail.label");
    	$scope.TEST_NOTESTED_LABEL  = appUtils.getString("home.term.testStatusInLastThreeMonth.value.notTested.label");
    	$scope.NO_LABEL = appUtils.getString("home_term_RPOmet_no_tab");
    	$scope.YES_LABEL  = appUtils.getString("home_term_RPOmet_yes_tab");
    	$scope.UNKNOWN_LABEL  = appUtils.getString("home_term_RPOmet_unknown_tab");
    	$scope.LEVEL_1 = appUtils.getString("home_term_planStatic_lv1_tab");
    	$scope.LEVEL_2 = appUtils.getString("home_term_planStatic_lv2_tab");
    	$scope.LEVEL_3 = appUtils.getString("home_term_planStatic_lv3_tab");
    	$scope.LEVEL_4 = appUtils.getString("home_term_planStatic_lv4_tab");
    	$scope.LEVEL_5 = appUtils.getString("home_term_planStatic_lv5_tab");
        $scope.NO_DATA = appUtils.getString("common_term_nodata_label");

    	var EMPTY_ERS = [{
				value :  100,
				name : appUtils.getString("common_term_nodata_label"),
				tooltip : appUtils.getString("common_term_nodata_label"),
				linearGradient : {
					startColor : constsService.COLOR_THIN_GREY,
					endColor : constsService.COLOR_THIN_GREY,
					angle : 100
				}
		}];
    	$scope.createTestStatusChart = function(){
    		var url = "/reports/action/testStatusStatistic";
    		communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result){
    		   if(exception.check(result)){
    			   var chartDatas = [];
				   if(result[0].successCount == "0" && result[1].failCount == "0" && result[2].unTestCount == "0"){
					   $scope.createDonutChart("testStatusContainer", EMPTY_ERS , 400, 200);
					   $("#testStatusLoadDiv").hide();
					   $("#donaChartDiv").show();
					   $("#donaChartDiv .succeed").eq(0).text(0);
					   $("#donaChartDiv .failed").eq(0).text(0);
					   $("#donaChartDiv .untested").eq(0).text(0);
					   return;
				   }
				   var s = parseInt(result[0].successCount,10);
				   var f = parseInt(result[1].failCount,10);
				   var u = parseInt(result[2].unTestCount,10);
				   var total = s + f+ u;
                   var s_tooltip = appUtils.getString("common_term_succeed_label") + ":" + s + appUtils.getString("common_label_single_label"),
                       f_tooltip = appUtils.getString("common_term_failed_label") + ":" + f + appUtils.getString("common_label_single_label"),
                       u_tooltip = appUtils.getString("common_term_untest_label") + ":" + u + appUtils.getString("common_label_single_label");

                    if (appUtils.isEn()) {
                       s_tooltip = appUtils.getString("common_term_succeed_label") + ":" + s + " " + appUtils.getString("common_label_single_label");
                       f_tooltip = appUtils.getString("common_term_failed_label") + ":" + f + " " + appUtils.getString("common_label_single_label");
                       u_tooltip = appUtils.getString("common_term_untest_label") + ":" + u + " " + appUtils.getString("common_label_single_label");
                    }

				   chartDatas.push(
				   {
						value : s*100/total,
						name : appUtils.getString("common_term_succeed_label"),
						tooltip : s_tooltip,
						linearGradient : {
							startColor : constsService.COLOR_GREEN,
							endColor : constsService.COLOR_GREEN,
							angle : 100
						}
				   });
				   chartDatas.push({
						value :  f*100/total,
						name : appUtils.getString("common_term_failed_label"),
						tooltip : f_tooltip,
						linearGradient : {
							startColor : constsService.COLOR_RED,
							endColor : constsService.COLOR_RED,
							angle : 100
						}
					});
				   chartDatas.push({
						value :  u*100/total,
						name : appUtils.getString("common_term_untest_label"),
						tooltip : u_tooltip,
						linearGradient : {
							startColor : constsService.COLOR_GREY,
							endColor : constsService.COLOR_GREY,
							angle : 100
						}
					});
				   $scope.createDonutChart("testStatusContainer", chartDatas , 400, 200);
				   $("#testStatusLoadDiv").hide();
				   $("#donaChartDiv").show();
				   $("#donaChartDiv .succeed").eq(0).text(s);
				   $("#donaChartDiv .failed").eq(0).text(f);
				   $("#donaChartDiv .untested").eq(0).text(u);
				   $("#donaChartDiv").show();
    		   }
    		})
    	}


    	$scope.refreshTestStatus= function(chartId){
    		$("#testStatusLoadDiv").css("display","none");
    		$("#testStatusContainer").empty();
    		$("#testStatusLoadDiv").show();
    		$scope.createTestStatusChart();
    	}

    	$scope.createRPOMeetChart = function() {
    		var url = "/reports/action/getRpoMetStatisticInfo";
        		communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result){
        		   if(exception.check(result)){
        			   var chartDatas = [];
    				   if(result.meetCount == "0" && result.notmeetCount == "0" && result.unknownCount == "0"){
    					    $scope.createDonutChart("rpoContainer", EMPTY_ERS, 400, 200);
        				    $("#rpoLoadDiv").hide();
        				    $("#rpoChartDiv .succeed").eq(0).text("0");
       				        $("#rpoChartDiv .failed").eq(0).text("0");
       				        $("#rpoChartDiv .untested").eq(0).text("0");
       				        $("#rpoChartDiv").show();
    					   return ;
    				   }
    				   var s = result.meetCount;
    				   var f = result.notmeetCount;
    				   var d = result.unknownCount;
    				   var total = s + f +d;
                       var s_tooltip = appUtils.getString("home_term_RPOmet_yes_tab") + ":" + s + appUtils.getString("common_label_single_label"),
                           f_tooltip = appUtils.getString("home_term_RPOmet_no_tab") + ":" + f + appUtils.getString("common_label_single_label"),
                           d_tooltip = appUtils.getString("home_term_RPOmet_unknown_tab") + ":" + d + appUtils.getString("common_label_single_label");

                       if (appUtils.isEn()) {
                           s_tooltip = appUtils.getString("home_term_RPOmet_yes_tab") + ":" + s + " " + appUtils.getString("common_label_single_label");
                           f_tooltip = appUtils.getString("home_term_RPOmet_no_tab") + ":" + f + " " + appUtils.getString("common_label_single_label");
                           d_tooltip = appUtils.getString("home_term_RPOmet_unknown_tab") + ":" + d + " " + appUtils.getString("common_label_single_label");
                       }
    				   chartDatas.push(
    				   {
    						value : s*100/total,
    						name : appUtils.getString("home_term_RPOmet_yes_tab"),
    						tooltip : s_tooltip,
    						linearGradient : {
    							startColor : constsService.COLOR_GREEN,
    							endColor : constsService.COLOR_GREEN,
    							angle : 100
    						}
    				   });
    				   chartDatas.push({
    						value :  f*100/total,
    						name : appUtils.getString("home_term_RPOmet_no_tab"),
    						tooltip :f_tooltip,
    						linearGradient : {
    							startColor : constsService.COLOR_RED,
    							endColor : constsService.COLOR_RED,
    							angle : 100
    						}
    					});
    				   chartDatas.push({
   						value :  d*100/total,
   						name : appUtils.getString("home_term_RPOmet_unknow_tab"),
   						tooltip : d_tooltip,
   						linearGradient : {
   							startColor : constsService.COLOR_GREY,
   							endColor : constsService.COLOR_GREY,
   							angle : 100
   						}
   					   });
        			    $scope.createDonutChart("rpoContainer", chartDatas, 400, 200);
     				    $("#rpoChartDiv .succeed").eq(0).text(s);
    				    $("#rpoChartDiv .failed").eq(0).text(f);
    				    $("#rpoChartDiv .untested").eq(0).text(d);
    				    $("#rpoLoadDiv").hide();
    				    $("#rpoChartDiv").show();
        		       }
        		   })
    	}


    	$scope.refreshTestTimeTop5 = function(){
    		$("#rpoChartDiv").css("display","none");
    		$("#rpoContainer").empty();
    		$("#rpoLoadDiv").show();
    		$scope.createRPOMeetChart();
    	}

    	$scope.createPlanStaticChart = function(){
    		var url = "/reports/action/getRpTestTimeStatisticInfo";
    		communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result){
    		   if(exception.check(result)){
    			   var chartDatas = result;
    			   var chartDatas = [];
				   if(result.level1 == "0" && result.level2 == "0" && result.level3 == "0" && result.level4 == "0"){
					    $scope.createDonutChart("planStaticContainer", EMPTY_ERS, 400, 200);
	    			    $("#planStaticLoadDiv").hide();
	 				    $("#planStatictDiv .succeed").eq(0).text("0");
					    $("#planStatictDiv .snormal").eq(0).text("0");
					    $("#planStatictDiv .failed").eq(0).text("0");
					    $("#planStatictDiv .untested").eq(0).text("0");
					    $("#planStatictDiv").show();
					   return;
				   }
				   var s = result.level1 ;
				   var f = result.level2 ;
				   var d = result.level3 ;
				   var k = result.level4 ;
				   var total = s + f + d +  k;
                   var s_tooltip = appUtils.getString("home_term_planStatic_lv1_tab") + ":" + s + appUtils.getString("common_label_single_label"),
                       f_tooltip = appUtils.getString("home_term_planStatic_lv2_tab") + ":" + f + appUtils.getString("common_label_single_label"),
                       d_tooltip = appUtils.getString("home_term_planStatic_lv3_tab") + ":" + d + appUtils.getString("common_label_single_label"),
                       k_tooltip = appUtils.getString("home_term_planStatic_lv4_tab") + ":" + k + appUtils.getString("common_label_single_label");

                   if (appUtils.isEn()) {
                       s_tooltip = appUtils.getString("home_term_planStatic_lv1_tab") + ":" + s + " " + appUtils.getString("common_label_single_label");
                       f_tooltip = appUtils.getString("home_term_planStatic_lv2_tab") + ":" + f + " " + appUtils.getString("common_label_single_label");
                       d_tooltip = appUtils.getString("home_term_planStatic_lv3_tab") + ":" + d + " " + appUtils.getString("common_label_single_label");
                       k_tooltip = appUtils.getString("home_term_planStatic_lv4_tab") + ":" + k + " " + appUtils.getString("common_label_single_label");
                   }

				   chartDatas.push(
				   {
						value : s*100/total,
						name : appUtils.getString("home_term_planStatic_lv1_tab"),
						tooltip : s_tooltip,
						linearGradient : {
							startColor : constsService.COLOR_GREEN,
							endColor : constsService.COLOR_GREEN,
							angle : 100
						}
				   });
				   chartDatas.push({
						value :  f*100/total,
						name : appUtils.getString("home_term_planStatic_lv2_tab"),
						tooltip :f_tooltip,
						linearGradient : {
							startColor : constsService.CLOLOR_ORANGE,
							endColor : constsService.CLOLOR_ORANGE,
							angle : 100
						}
					});
				   chartDatas.push({
						value :  d*100/total,
						name : appUtils.getString("home_term_planStatic_lv3_tab"),
						tooltip :d_tooltip,
						linearGradient : {
							startColor : constsService.COLOR_RED,
							endColor : constsService.COLOR_RED,
							angle : 100
						}
					});
				   chartDatas.push({
						value :  k*100/total,
						name : appUtils.getString("home_term_planStatic_lv4_tab"),
						tooltip :k_tooltip,
						linearGradient : {
							startColor : constsService.COLOR_GREY,
							endColor : constsService.COLOR_GREY,
							angle : 100
						}
					});
    			    $scope.createDonutChart("planStaticContainer", chartDatas, 400, 200);
 				    $("#planStatictDiv .succeed").eq(0).text(s);
				    $("#planStatictDiv .snormal").eq(0).text(f);
				    $("#planStatictDiv .failed").eq(0).text(d);
				    $("#planStatictDiv .untested").eq(0).text(k);
				    $("#planStaticLoadDiv").hide();
				    $("#planStatictDiv").show();
    		       }
    		   })
    	};

    	$scope.refreshTestTimeBottom5 = function(){
    		$("#planStatictDiv").css("display","none");
    		$("#planStaticContainer").empty();
    		$("#planStaticLoadDiv").show();
    		$scope.createPlanStaticChart();
    	};

    	$scope.queryProtectedStatistcs = function(){
    		$("#protectedStatisticsDiv").children("#protectedStatisticsInfo").empty();
    		$("#protectedStatisticsDiv").children("#protectedStatisticsLoadDiv").show();
    		var HEAD = '<table>';
    		var SUMMARY_LEFT = '<tr><td colspan="2" style="text-align:center;padding-left:20px;padding-bottom:10px"><div style="text-align:left;line-height:40px;display:inline-block;"><span class="imgcon ';
    		var SUMMARY_MIDDLE_L = '"></span><span class="textcon ';
    		var SUMMARY_MIDDLE_R = '">';
    		var SUMMARY_RIGHT = '</span></div></td></tr>';
    		var ITEM_LEFT = '<tr><td class="protected-info-key">';
    		var ITEM_MIDDLE = '</td><td class="protected-info-value">';
    		var ITEM_RIGHT = '</td></tr>';
    		var TAIL = '</table>';
    		var url = "/reports/action/protectStatistic";
    		communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result){
    		   if(exception.check(result)){
				   var chartDatas = result.details;
				   var legend = "";
				   var textclassName = "";
				   var imgclassName = "";
				   if(result.totalAppCount == "0"){
					   legend += appUtils.getString("home.app.nodata");
					   imgclassName = "no-protected-img";
					   textclassName = "no-protected-text";
				   }else if(result.totalNoProtectedAppCount == "0"){
					   legend += appUtils.getString("home.app.allprotect");
					   imgclassName = "all-protected-img";
					   textclassName = "all-protected-text all-space";
				   }else{
					   legend += result.totalNoProtectedAppCount;
					   if(appUtils.isEn()) {
					   		legend += " " + appUtils.getString("home.app.notprotect");
					   		imgclassName = "incompled-protected-img";
					   		textclassName = "incompled-protected-text";
					   } else {
					   		legend += appUtils.getString("home.app.notprotect");
					   		imgclassName = "incompled-protected-img";
					   		textclassName = "incompled-protected-text";
					   }
				   }
				   var resultHtml = HEAD + SUMMARY_LEFT + imgclassName + SUMMARY_MIDDLE_L + textclassName + SUMMARY_MIDDLE_R + legend + SUMMARY_RIGHT;
				   chartDatas.sort(function(a,b){
           			return parseInt(a.appType,10) -  parseInt(b.appType,10);
           		   })
				   for (var i= 0;i<chartDatas.length;i++){
					   var singleAppTotal = parseInt($.encoder.encodeForHTML(chartDatas[i].protectedAppCount),10)+ parseInt($.encoder.encodeForHTML(chartDatas[i].noProtectedAppCount),10)
					   var value = $.encoder.encodeForHTML(chartDatas[i].protectedAppCount)+"/"+singleAppTotal;
					   if(i == 0){
						   value = value +" "+ appUtils.getString("home.term.protectedCount_label");
					   }
					   var typeI18n = ""
						if(chartDatas[i].appType == "1"){
							typeI18n = appUtils.getStringWithColon("protection.term.Oracle.label");
						}
					    if(chartDatas[i].appType == "2"){
					    	typeI18n = appUtils.getStringWithColon("protection.term.SQL.label");
					    }
						if(chartDatas[i].appType == "3"){
							typeI18n = appUtils.getStringWithColon("protection.term.DB2.label");
						}
						if(chartDatas[i].appType == "8" || chartDatas[i].appType == "13"){
							typeI18n = appUtils.getStringWithColon("protection.term.Exchange.label");
						}
						if(chartDatas[i].appType == "9"){
							typeI18n = appUtils.getStringWithColon("protection.term.localFS.label");
						}
						if(chartDatas[i].appType == "10"){
							typeI18n = appUtils.getStringWithColon("protection.term.VMwareVM.label");
						}
						if(chartDatas[i].appType == "11"){
							typeI18n = appUtils.getStringWithColon("protection.term.LUN.label");
						}
						if(chartDatas[i].appType == "12"){
							typeI18n = appUtils.getStringWithColon("protection.term.HWVM.label");
						}
						if(chartDatas[i].appType == "14"){
							typeI18n = appUtils.getStringWithColon("protection.term.NAS.label");
                        }
                        if(chartDatas[i].appType == "15"){
            				typeI18n = "InterSystems Caché:";
                        }
                        if(chartDatas[i].appType == "16"){
                        	typeI18n = "SAP HANA:";
                        }

					   resultHtml = resultHtml + ITEM_LEFT + typeI18n + ITEM_MIDDLE + value + ITEM_RIGHT;
				   }
				   resultHtml = resultHtml + TAIL;
				   $("#protectedStatisticsDiv").children("#protectedStatisticsLoadDiv").hide();
				   $("#protectedStatisticsDiv").children("#protectedStatisticsInfo").html(resultHtml);
				   $("#protectedStatisticsDiv").children("#protectedStatisticsInfo").show();
    		    }
 		     })
    	};

    	/**chartId: 图的Id 需要唯一
    	 * container: 画图的容器的Id
    	 * chartDatas: 数据
    	 * width: 宽
    	 * height: 高
    	 */
    	 $scope.createDonutChart = function(container, chartDatas, width, height) {

    		var options = {
    			id : container,
				r : 65,
				height : height,
				width : width,
				strokeWidth : 12,
				showShadow : true,
				showLegend : false,
				showClickEvent : true,
    			data : chartDatas

    		};
    		var testStatusChart  = new tinyWidget.Cirquechart(options);
    		return testStatusChart;
    	};

		$scope.datasTable = {
				"id" : "alarmDatasTable",
				"columns" : [{
					"sTitle" : appUtils.getString("current_alarm_term_level_column"),
					"mData" : "severity",
					"bSortable":false
				}, {
					"sTitle" : appUtils.getString("current_alarm_term_name_column"),
					"mData" : "alarmName",
					"bSortable":false
				}, {
					"sTitle" : appUtils.getString("current_alarm_term_last_time_column"),
					"mData" : "alarmTimeStr",
					"bSortable":false
					},
					{
					"sTitle" : "entity",
					"mData" : "entity",
					"bVisible":false

					},{"mData":"params",bVisible:false}
				],
				"displayLength":constsService.TABLE_COUNT_PER_PAGE,
				"renderRow" : function(nRow, aData, iDataIndex) {
	            	var level = $.encoder.encodeForHTML(aData["severity"]);
	            	var des   = $.encoder.encodeForHTML(aData["alarmName"]);
	            	var param = aData["params"];
	            	var escapedParam = [];
	            	if(param){
	            	  for(var i = 0 ; i < param.length; i++){
	            	    escapedParam.push($.encoder.encodeForHTML(param[i]));
	            	  }
	            	}

	            	$('td:eq(0)', nRow).html("<span class='emergency'></span>&nbsp;"+appUtils.getString("alarm_term_critical_label"));
	                var optColumn = "<a href='javascript:void(0)' class='btn-link' ng-click='toAlarmDetail()'>" + appUtils.getString(des, escapedParam) + "</a> ";
                    var optLink = $compile($(optColumn));
                    var optScope = $scope.$new();
                    optScope.data = aData;
                    optScope.toAlarmDetail = function () {
                        var options = {
                             "winId": "currentAlarmDetailWin",
                             "title": appUtils.getString(constsService.COURRENT_ALARM_DETAIL_TITLE),
                             "data": {entity: aData['entity'], isFirstViewGo: true},
                             "height": "600px",
                             "width": "900px",
                             "modal": true,
                             "content-type": "url",
                             "draggable": true,
                             "content":  constsService.COURRENT_ALARM_DETAIL_URL,
                             "minimizable": false,
                             "maximizable": false,
                             "buttons": [
                                 {
                                     key: "close",
                                     label: appUtils.getString('common_term_close_button'),
                                     focused: true,
                                     handler: function (event) {
                                         $("#currentAlarmDetailWin").widget().destroy();
                                     }
                                 }
                             ],
                             "close": function () {
                             }
                         }
                         var win = new Window(options);
                         win.show();
                    };
                    var optNode = optLink(optScope);
                    $("td:eq(1)", nRow).html(optNode);
				},
				"data" : []
			};

        //新增时间轴
        $scope.groups = [];
        $scope.timelime = {
            url: "/reports/protectgrouplogs?startPage=0&pageSize=6",
            type: 0,
            search: {
                id: "execution-record-search",
                text: "<span class='x-panel-header-text'>" + appUtils.getString("home_term_pgExecutionRecord_listbox") + "</span>",
                content: []
            },
            refreshPage: function() {
            	$("#logNoDataDiv").hide();
            	$("#totalRecords").hide();
            	$("#logFrameInfo").hide();
            	$("#logLoadDiv").show();
                $scope.timelime.type == 0 ? $scope.NO_LOG_DATA = appUtils.getString("home_protectedGroup_task_display_value_nodata_label")
                    : $scope.NO_LOG_DATA = appUtils.getString("home_recoveryPlan_task_display_value_nodata_label");
                communicationService.get(utilService.getResouceUrl($scope.timelime.url)).promise().always(function(result){
                    var productModel = function (obj) {
                        return {
                            executeId: obj.executeId,
                            logId: obj.logId,
                            logStatus: obj.logStatus,
                            logStatusResult: obj.logStatusResult,
                            startTime: obj.startTime,
                            logName: obj.logName,
                            nameTitle : obj.logName,
                            nameLabel: obj.nameLabel,
                            deviceType: obj.deviceType,
                            processHide: obj.isprocessHide,
                            process: {
                                "id": "progress_" + obj.logId,
                                "value": obj.proValue,
                                "position": "right",
                                "width": "80px",
                                "height": "10px",
                                "color": obj.procColor
                            },
                            openLogDetail: function () {
                                var winConfig = angular.copy(obj.winConfig);
                                winConfig.title = appUtils.getString(obj.winConfig.title);
                                winConfig.buttons = [{
                                    label: appUtils.getString("common_term_close_button"),
                                    handler: function () {
                                        $("#" + obj.winConfig.winId).widget().destroy();
                                    }
                                }];
                                appUtils.openWin(winConfig, winConfig.params);
                            }
                        }
                    };

                    var getRecoveryLogStatusResult = function(data, statusRes) {
                        if ("zh" === cookieService.get("language") || "zh_CN" === cookieService.get("language")) {
                            return appUtils.getString(constsService.staticRecLogType[data.logType]) + statusRes;
                        }
                        return appUtils.getString(constsService.staticRecLogType[data.logType]) + " " + angular.lowercase(statusRes);
                    }

                    if (exception.check(result)) {
                        var _arary = [];
                        var _type = $scope.timelime.type;
                        _.each(result.records, function (data) {
                            var _logStatus = _type == 0 ? constsService.covertPgStatus[data.result] : data.logStatus;
                            data.executeId = _type == 0 ? data.pgId : data.planId;
                            data.logStatus = _logStatus;
                            var statusRes = appUtils.getString(constsService.staticLogStatus[_logStatus]);
                            data.logStatusResult = _type == 0 ?  statusRes: getRecoveryLogStatusResult(data, statusRes);
                            data.logName = _type == 0 ? data.pgName : data.planName;
                            data.nameLabel = _type == 0 ? appUtils.getString("home_pgExecuteRecord_task_para_protectedGroupName_label")
                                : appUtils.getString("home_pgExecuteRecord_task_para_recoveryPlanname_label");
                            data.isprocessHide = _logStatus == 3;
                            data.proValue = data.isprocessHide ? data.planProgress : 0;
                            data.procColor = _.contains(["1", "2"], $.trim(_logStatus)) ? constsService.COLOR_RED : constsService.COLOR_GREEN;
                            if (_type == 0) {
                                var winConfig = angular.copy(constsService.PG_EXEC_DETAIL);
                                winConfig.title = appUtils.getString("task_term_exec_detail_label");
                                winConfig.params = {pgId: data.pgId, logId: data.logId};
                                data.winConfig = winConfig;
                            }
                            else {
                                var winConfig = angular.copy(constsService.RECOVERY_HISTORY_LOG);
                                winConfig.title = appUtils.getString("task_term_exec_detail_label");
                                winConfig.params = {planId: data.planId, logId: data.logId};
                                data.winConfig = winConfig;
                            }
                            _arary.push(productModel(data));
                        });
                        $scope.groups = _arary;
                        $scope.timelime.recentlyInfo = appUtils.getString("home_term_latestRecords_label", _arary.length);
                    }

                    $("#logLoadDiv").hide();
                    if (_.isEmpty($scope.groups)) {
                    	$("#logNoDataDiv").show();
                    	$("#logFrameInfo").hide();
                    	$("#totalRecords").hide();
                    } else {
                    	$("#logNoDataDiv").hide();
                    	$("#logFrameInfo").show();
                    	$("#totalRecords").show();
                    };
                    $scope.$apply();
                });
            }
        }

    	$scope.refreshAlarmList = function(){
    		$("#alarmFrameDiv").children("#alarmFrameInfo").hide();
    		$("#alarmFrameDiv").children("#alarmFrameLoadDiv").show();
    		var url = "/alarms?startPage=0&pageSize=10&severity=4";
    		communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result){
    		   if (exception.check(result)) {
	                var arr = [];
	                _.each(result.records, function(d) {
	                	d.severity = $.encoder.encodeForHTML(d.severity);
	                	d.alarmTimeStr = $.encoder.encodeForHTML(d.alarmTimeStr);
	                	d.entity = $.encoder.encodeForHTML(d.entity);
	                    var tmo =_.pick(d, "severity", "alarmName" ,"alarmTimeStr", "entity","params");
	                    arr.push(tmo);
	                });
	                $scope.datasTable.data = arr;
	                $("#alarmFrameDiv").children("#alarmFrameLoadDiv").hide();
	                $("#alarmFrameDiv").children("#alarmFrameInfo").show();
	                $scope.$apply();
	              }
    		   })
    	};


    	$scope.userRight = {};
    	$scope.userRight.hasProtectReportRight = false;
    	$scope.userRight.hasRecoveryReportRight = false;
    	$scope.userRight.hasAlarmRight = false;
    	$scope.userRight.hasProtectRight = false;
        $scope.userRight.hasLogRight = false;
		 var _initRight = function(){

    	   $scope.createRPOMeetChart();
    	   $scope.createTestStatusChart();
	       $scope.createPlanStaticChart();
    	   $scope.queryProtectedStatistcs();
    	   var hasAlarmRight = appUtils.checkRight("lego.evtMgr.curtAlarm.scan");
    	   if(hasAlarmRight){
    		   $scope.userRight.hasAlarmRight = true;

    		   $scope.refreshAlarmList();
    	    	setTimeout(function(){
    	    		if($("#alarmFrameDiv")[0] && $("#protectedStatisticsDiv")[0]){
                        $("#alarmFrameDiv").height($("#protectedStatisticsDiv").height());
    	        	}
    	    	},200);
    	   }else{
    		   $scope.userRight.hasAlarmRight = false;
    	   }

          $scope.timelime.search.content = [];
          appUtils.checkRight("ism.drm.protection.menuname") && (
                $scope.timelime.search.content.push(
                    {
                        title: appUtils.getString("home_term_pgExecutionRecord_listbox"),
                        id: "execution-pg",
                        click: function () {
                            $scope.timelime.type = 0;
                            $scope.timelime.url = "/reports/protectgrouplogs?startPage=0&pageSize=6";
                            $scope.timelime.search.text = "<span class='x-panel-header-text'>" + appUtils.getString("home_term_pgExecutionRecord_listbox") + "</span>";
                            $scope.$apply();
                            $scope.timelime.refreshPage();
                        }
                    }
                )
          )
          if (_.isEmpty($scope.timelime.search.content)) {
                $scope.timelime.type = 1;
                $scope.timelime.url = "/reports/recoverylogs?startPage=0&pageSize=6";
                $scope.timelime.search.text = "<span class='x-panel-header-text'>" + appUtils.getString("home_term_recoveryPlanExecutionRecord_listbox") + "</span>";
          }
          appUtils.checkRight("ism.drm.disaster.recovery.menuname") && (
               $scope.timelime.search.content.push(
                    {
                        title: appUtils.getString("home_term_recoveryPlanExecutionRecord_listbox"),
                        id: "execution-recovery",
                        click: function () {
                            $scope.timelime.type = 1;
                            $scope.timelime.url = "/reports/recoverylogs?startPage=0&pageSize=6";
                            $scope.timelime.search.text = "<span class='x-panel-header-text'>" + appUtils.getString("home_term_recoveryPlanExecutionRecord_listbox") + "</span>";
                            $scope.$apply();
                            $scope.timelime.refreshPage();
                        }
                    }
                )
           )

          if(!_.isEmpty($scope.timelime.search.content)){
          		$("#leftContainer").css("width", "78%");
                $scope.userRight.hasLogRight = true;
                $scope.timelime.refreshPage();
          } else {
          		$("#leftContainer").css("width", "100%");
                $scope.userRight.hasLogRight = false;
          }
       };
       _initRight();

  }];

  var module = angular.module('home.config');
  module.tinyController('home.staticView.ctrl', ctrl);
  return module;

});
