/**
 * 导航菜单Controller
 *
 */
define(["app/framework/base/services/systemResService", "tiny-widgets/Window", "tiny-extra-lib/jquery.base64"],
    function(SystemResService, Window) {
        "use strict";
        var ctrl = function($rootScope, $scope, $compile, $state, $timeout, utilService, appUtils, communicationService, cookieService, message, exception,
            constsService, securityService, statusEnumService, mask, infoTransferredService, servicesPlugin, restService) {
            $scope.CRITICAL = appUtils.getString("alarm_term_critical_label");
            $scope.MAJOR = appUtils.getString("alarm_term_major_label");
            $scope.WARNING = appUtils.getString("alarm_term_warning_label");
            $scope.INFO = appUtils.getString("alarm_term_info_label");
            $scope.HELP = appUtils.getString("common_term_help_label");
            $scope.CURRENT_USER = appUtils.getString("common_term_currentuser_label");
            $scope.TASK = appUtils.getString("common_term_job_menu");
            $scope.SOUND_TIPS = "";
            $scope.SOUND_DISABLED = appUtils.getString("alarm_term_sound_disabled_label");
            $scope.SOUND_ENABLED = appUtils.getString("alarm_term_sound_enabled_label");
            $scope.SOUND = appUtils.getString("alarm_term_sound_label");
            $scope.LOADING = appUtils.getString("home.term.loadding.label");
            $scope.checkRight = appUtils.checkRight;
            $rootScope.isUltraVR = window.isUltraVR;
            $scope.isEn = appUtils.isEn();
            var localStorage = window.localStorage;
            var domainIp = window.location.hostname;
            var storage = window.sessionStorage;
            var currentUser = cookieService.get("userName");
            var resource = appUtils.resource();
            var loginInfo;

            $scope.about = {
                title: appUtils.getString("common_term_about_label"),
                click: function() {
                    var options = {
                        "winId": "aboutWin",
                        "width": "500px",
                        "height": "411px",
                        "minimizable": false,
                        "maximizable": false,
                        "content-type": "url",
                        "content": constsService.ABOUT_URL,
                        "buttons": null
                    };
                    var createWindow = new Window(options);
                    createWindow.show();
                }

            };
            $scope.helpIconClick = function() {
                if (window.isPrivateConsole) {
                    return;
                };
                _doGblHelp($state.$current.name, $state.$current.stateParamsKey);
            };
            $scope.menuEvent = function(_this) {
                if (window.isUltraVR && _this && _this.indexOf("home") > -1) {
                    $rootScope.enabledSwitch = true;
                    $("#service-nav").removeClass("sub_breadcrumbs").addClass("main_breadcrumbs");
                    if (_this.indexOf("home.topoVew") > -1) {
                        $rootScope.model.viewSwitch.selected = 1;
                    } else {
                        $rootScope.model.viewSwitch.selected = 0;
                    }
                } else {
                    $rootScope.enabledSwitch = false;
                    $("#service-nav").addClass("sub_breadcrumbs").removeClass("main_breadcrumbs");
                }

                if (_.isUndefined(_this) || _this.indexOf("recovery") == -1) {
                    var h1 = $("#tiny-menu .recovery").closest("h1");
                    h1.hasClass("menu_active") && h1.removeClass("menu_active");
                }
            };
            var index = 0, normalState = true;
            $scope.info = {
                text: cookieService.get("rd_language") == 'en' ? '简体中文' : 'English',
                switch : function() {
                    if (this.text == 'English') {
                        cookieService.put("rd_language", "en");
                        cookieService.put("tiny_language", "en");
                    } else {
                        cookieService.put("rd_language", "zh");
                        cookieService.put("tiny_language", "zh");
                    }
                    location.reload();
                },
                alarm: {
                    id: "framework-menus-alarm",
                    text: "<span id='alarm-total' style='color:#333 !important;' class='menu-item-btn'></span>",
                    expand: function() {
                        //下拉菜单初始化
                        if (index === 0) {
                            for (index; index < 4; index++) {
                                var dom = $('.alert-options:eq(' + index + ')').html('');
                                $('#ToBeMove>span:eq(0)').appendTo(dom);
                            }
                            $('#ToBeMove').remove();
                            $('.main_container').nextAll('ul.tiny-menubutton-dropdown').attr('id', 'alarm-ul');
                            //按UCD要求,减少宽度
                            $('#alarm-ul>li>a').css('padding', '0px 16px');
                        }

                        //确保展开菜单与上方对齐
                        var $ul = $('#alarm-ul');
                        if (normalState) {
                            $ul.css('margin-left') === '8px' || $ul.css('margin-left', '8px');
                        } else {
                            $ul.css('margin-left') === '1px' || $ul.css('margin-left', '1px');
                        }
                    },
                    "content": [{
                            //div里的text是占位用，不然第一次打开的位置和之后不一样
                            title: '<div class="alert-options">6666</div>',
                            click: function() {
                                $state.go("monitor.currentalarmjump", {
                                    alarmType: '4'
                                });
                            }
                        }, {
                            title: '<div class="alert-options">6666</div>',
                            click: function() {
                                $state.go("monitor.currentalarmjump", {
                                    alarmType: '3'
                                });
                            }
                        }, {
                            title: '<div class="alert-options">6666</div>',
                            click: function() {
                                $state.go("monitor.currentalarmjump", {
                                    alarmType: '2'
                                });
                            }
                        }, {
                            title: '<div class="alert-options">6666</div>',
                            click: function() {
                                $state.go("monitor.currentalarmjump", {
                                    alarmType: '1'
                                });
                            }
                        },


                    ]
                },
                user: {
                    id: "framework-menus-user",
                    text: "<span class='menu-item-btn'></span>",
                    "content": [{
                        title: "<div class='menu-item-btn'>" + appUtils.getString("user_term_userpassword_title") + "</div>",
                        id: "framework-menus-user-seting",
                        click: function() {
                            var options = {
                                "winId": "modifyPwdWin",
                                "data": {
                                    userId: '',
                                    userName: $scope.user.name
                                },
                                "minimizable": false,
                                "maximizable": false,
                                "title": appUtils.getString("user_term_userpassword_title"),
                                "width": !appUtils.isEn() ? constsService.MODIFY_PWD_WIN.width : constsService.MODIFY_PWD_WIN.width_en,
                                "height": !appUtils.isEn() ? constsService.MODIFY_PWD_WIN.height : constsService.MODIFY_PWD_WIN.height_en,
                                "content-type": "url",
                                "content": constsService.PASSWORD_EDIT_URL,
                                "buttons": null,
                                "close": function() {}
                            };

                            var win = new Window(options);
                            win.show();

                        }
                    }, {
                        title: "<div class='menu-item-btn'>" + appUtils.getString("common_term_loginout_button") + "</div>",
                        id: "framework-menus-user-destroy",
                        click: function() {
                            var content = appUtils.getString("user_term_logout_message");
                            var msg = new tinyWidget.Message({
                                "type": "confirm",
                                "content": content,
                                "height": "150px",
                                "width": "350px",
                                "buttons": [{
                                    "label": appUtils.getString("common_term_confirm_button"),
                                    "accessKey": "2",
                                    "key": "okBtn",
                                    "focused": false
                                }, {
                                    "label": appUtils.getString("common_term_cancel_button"),
                                    "accessKey": "3",
                                    "key": "cancelBtn",
                                    "focused": true
                                }],
                                "close": function() {

                                }
                            });
                            msg.setButton("okBtn", function() {
                                var requestUrl = "/ws/auth/logout";
                                var rootPath = utilService.getRootPath();
                                var url = utilService.getResouceUrl("/auth/logout");
                                storage.removeItem("failedNum");
                                storage.removeItem("loginInCount");
                                var isUserquickStart = JSON.parse(localStorage.getItem($.base64.encode(''+[currentUser, domainIp]+'')));
                                if(isUserquickStart) {
                                    localStorage.removeItem($.base64.encode(''+[currentUser, domainIp]+''));
                                }

                                communicationService.post(url,{timeOut:false}).promise().always(function(response, textStatus, request) {
                                    if (exception.check(response)) {
                                        var ssoUrl = request.getResponseHeader("redirect");
                                        if ( "sso" == cookieService.get("user.login.mode") && !_.isEmpty(ssoUrl)) {
                                            cookieService.removeToken();
                                            window.location.href = ssoUrl;
                                        }else{
                                            cookieService.removeToken();
                                            window.location.href = rootPath + constsService.LOGIN_URL;
                                        }
                                    }
                                });

                            });
                            msg.setButton("cancelBtn", function() {
                                msg.destroy()
                            });
                            msg.show();
                            $("#"+msg.dialogId).find(".ti-info-circle").removeClass('tiny-img-confirm').addClass('message_win_picture');
                            $("#"+msg.dialogId).css("min-height","40px").css("height","auto");
                            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(appUtils.getString("common_message_win_question_title"));
                            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("font-size","14px").css("color","#333");
                        }
                    }],
                    TimeLabel: appUtils.getString("common_term_lastLoginTime_label"),
                    StatusLabel: appUtils.getString("common_term_loginStatus_label"),
                    sucessTerminalLabel: appUtils.getString("common_term_lastLoginIP_label"),
                    sucessStatusValue: appUtils.getString("common_loginSucessed_value"),
                    failedStatusValue: appUtils.getString("common_loginFailed_value"),
                    checkDetailsLink: appUtils.getString("common_term_loginDetails_link_label"),
                    mouseclick: function(event) {
                        var loginInfoDivExist = $("#loginInfoDiv").css("display");
                        loginInfoDivExist == "block" ? $("#loginInfoDiv").hide() : (loginInfo.isFirstLogin == 0 && $("#loginInfoDiv").show());
                    },
                    checkDetails: function() {
                        $("#loginInfoDiv").hide();
                        var filter = {
                            startPage : constsService.start,
                            pageSize: constsService.TABLE_COUNT_PER_PAGE_BIG,
                            orderBy: "date",
                            orderType: "desc",
                            dateTo:  loginInfo.endTime,
                            dateFrom: loginInfo.startTime,
                            admin: currentUser,
                            result: constsService.covertPgStatus[1]
                        };
                        $state.go("settings.sysOperLog");
                        infoTransferredService.put("sysLog", "loadLoginFailed", true);
                        infoTransferredService.put("sysLog", "loadLoginFilter", filter);
                    }
                },
                help: {
                    id: "framework-menus-help",
                    text: "<span class='menu-item-btn'></span>",
                    "content": [{
                        title: "<div class='menu-item-btn'>" + appUtils.getString("common_term_help_label") + "</div>",
                        id: "framework-menus-help-helps",
                        click: function() {
                            _doGblHelp($state.$current.name, $state.$current.stateParamsKey);
                        }
                    }, {
                        title: "<div class='menu-item-btn'>" + appUtils.getString("common_term_quickstart_label") + "</div>",
                        id: "framework-menus-help-quick-start",
                        click: function() {
                            $scope.quickStart.click();
                        }
                    }, {
                        title: "<div class='menu-item-btn'>" + appUtils.getString("common_term_support_label") + "</div>",
                        id: "framework-menus-help-support",
                        click: function() {
                            window.open("https://support.huawei.com/enterprise/" + (cookieService.get("language") || "en") + "/cloud-storage/oceanstor-bcmanager-pid-21597093", "_blank");
                        }
                    }, {
                        title: "<div class='menu-item-btn'>" + appUtils.getString("common_term_about_label") + "</div>",
                        id: "framework-menus-help-about",
                        click: function() {
                            $scope.about.click();
                        }
                    }]
                },
                system: {
                    time: {
                        label: appUtils.getStringWithColon("common_term_system_time_label"),
                    },
                    timeZone: {
                        label: appUtils.getStringWithColon("common_term_system_timeZone_label"),
                    },
                    mouseleave: function(event) {
                        this.popShow = !this.popShow;
                        this.loadingShow = false;
                        this.contentShow = false;
                    },
                    mouseenter: function(event) {
                        var self = this;
                        var loginInfoDivExist = $("#loginInfoDiv").css("display");
                        if(loginInfoDivExist == "block") {
                            $("#loginInfoDiv").hide();
                        };
                        self.popShow = !self.popShow;
                        restService.getSystemTime([], {
                            mask: false,
                            success: function(result) {
                                self.time.value = result.time;
                                self.timeZone.value = result.displayName;
                                self.loadingShow = true;
                                self.contentShow = true;
                                $scope.$apply();
                            }
                        })
                    }
                }
            };
            "sso" == cookieService.get("user.login.mode") && $scope.info.user.content.shift();
            window.isPrivateConsole && $scope.info.help.content.splice(0, 2);
            var helpWin = null;
            var _doGblHelp = function(key, keyParam) {
                restService.getSoftwareInfo([], {
                    mask: false,
                    success: function(result) {
                        var url = window.isEn ? "/help/en/en-us_bookmap_0229729142.htm" : "/help/zh/zh-cn_bookmap_0229728260.htm";
                        if (window.isUltraVR) {
                            url = window.isEn ? "/help_fs/en/en-us_bookmap_0229730378.htm" : "/help_fs/zh/zh-cn_bookmap_0229730378.htm";
                        }
                        openHelpLink(url);
                    }
                })

                function openHelpLink(url) {
                    var currKey = _.isUndefined(key) ? "" : key;
                    var currentPath = "";
                    if (_.isUndefined(keyParam)) {
                        currentPath = currKey;
                    } else {
                        var currParamValue = $state.params[keyParam];
                        if ($.trim(currParamValue).length !== 0) {
                            currentPath = currKey + "?" + keyParam + "=" + currParamValue;
                        } else {
                            currentPath = currKey;
                        }
                    }

                    if (currentPath.indexOf("settings.userEdit") >= 0) {
                        if (currentPath.indexOf("?") > 0) {
                            currentPath = "settings.userEdit";
                        } else {
                            currentPath = "settings.userAdd";
                        }
                    }

                    if (currentPath.indexOf("settings.roleAdd") >= 0) {
                        if (currentPath.indexOf("?") > 0) {
                            currentPath = "settings.roleEdit";
                        } else {
                            currentPath = "settings.roleAdd";
                        }
                    }

                    if (!currentPath || !_.has(constsService.HELP_MAP, currentPath)) {
                        return;
                    }

                    url += "#" + constsService.HELP_MAP[currentPath];
                    if (helpWin && !helpWin.closed) {
                        var curUrl = helpWin.location.href;
                        if (curUrl.indexOf(url) > 0) {
                            return;
                        }
                        helpWin.location.href = url;
                        helpWin.location.replace(url);
                    } else {
                        helpWin = window.open(url, "online_help");
                    }
                }

            };

            var timeoutName = setTimeout(function() {
                var usrName = $.encoder.encodeForHTML(appUtils.getCurrentUser().userName);
                $("#framework-menus-user .menu-item-btn").text(usrName);
                clearTimeout(timeoutName);
            }, 500);
            var ngdom = $("<div></div>");
            var ngdom2 = $("<div></div>");

            $scope.model = {
                btn: {
                    text: appUtils.getString('common_term_delete_button'),
                    label: '',
                    click: function() {
                        batchDelTask();
                    }
                },
                status: {
                    id: "taskStatus",
                    width: constsService.W2,
                    values: [{
                        selectId: "0",
                        label: appUtils.getString("common_term_status_column")
                    }],
                    defaultSelectid: "0",
                    disabled: false
                },
                text: {
                    id: "taskStatusText",
                    width: constsService.W2,
                    defaultSelectid: "2",
                    values: [{
                        selectId: '2',
                        label: appUtils.getString('common_term_all_label')
                    }, {
                        selectId: '0',
                        label: appUtils.getString('common_term_succeed_label')
                    }, {
                        selectId: '1',
                        label: appUtils.getString('common_term_failed_label')
                    }, {
                        selectId: '-1',
                        label: appUtils.getString('common_term_running_label')
                    }],
                    disabled: false,
                    change: function() {
                        var seId = $("#taskStatusText").widget().getSelectedId();
                        $scope.taskQueryType = seId;
                        typeId = parseInt(seId, 10);
                    }
                },
                advanceSearchPop: {
                    "id": "task",
                    "elementId": "taskButton",
                    "template": ngdom,
                    "popStyle": {
                        "width": '1050px',
                        "height": '706px'
                    }
                }
            };

            function _loadTask() {
                start = 0;
                $scope.datasTaskTable.orderType = "desc",
                    $scope.datasTaskTable.orderBy = "startTime",
                    _initTaskList();
                $scope.datasTaskTable.curPage = {
                    "pageIndex": 0
                };
            }

            $scope.showAdvance = function() {
                currentFailedTask = 0;
                var statusOfTask = $("#task").css("display");
                ngdom.load(constsService.TASK_URL, function() {
                    currentClickedTaskId = null;
                    $compile($("#task-content"))($scope);
                    $scope.$apply();
                    $(".task_owner_info").hide();
                    $(".task_owner_loading").show();
                    if (statusOfTask == "none" || statusOfTask == undefined) {
                        $("#task").widget().setPopShow(true);
                    } else {
                        $("#task").widget().setPopShow(false);
                    }

                    //是否启用了搜索
                    if ($scope.taskQueryType) {
                        $("#taskStatusText").widget().opChecked($scope.taskQueryType);
                    }
                    _loadTask();
                });
            };

            var start = 0;
            //保存总选中项的list
            var totalSelectedTaskIds = [];
            totalSelectedTaskIds.put = function (aData){
                var taskId = aData.taskId,
                    taskResult = aData.taskResult,
                    regExp = RegExp('^' + aData.taskId + ','),
                    index = -1;
                angular.forEach(this, function(val, i){
                    if(regExp.test(val)){
                        index = i;
                    }
                });
                if(index === -1){
                    this.push(taskId + ',' + taskResult);
                }else{
                    this[index].split(',')[1] != taskResult && (this[index] = taskId + ',' + taskResult);
                }

            };
            totalSelectedTaskIds.remove = function (aData){
                var regExp = RegExp('^' + aData.taskId + ',');
                var index = -1;
                angular.forEach(this,function(val,i){
                    if(regExp.test(val)){
                        index = i;
                    }
                });
                index !== -1 && this.splice(index, 1);
            };

            var currentCatalogSelectedTaskIds = $scope.currentCatalogSelectedTaskIds = [];
            currentCatalogSelectedTaskIds.put = function(aData) {
                if(_.isEmpty(aData)){return;}
                var taskId = aData.taskId;
                this.indexOf(taskId) === -1 && this.push(taskId);
                totalSelectedTaskIds.put(aData);
                $scope.$apply();
            };
            currentCatalogSelectedTaskIds.remove = function(aData) {
                if(_.isEmpty(aData)){return;}
                var taskId = aData.taskId;
                var index = this.indexOf(taskId);
                index !== -1 && this.splice(index, 1);
                totalSelectedTaskIds.remove(aData);
                $scope.$apply();
            };
            currentCatalogSelectedTaskIds.init = function(cataId){
                var _this = this;
                this.splice(0,this.length);
                var arr = getCurrentCatalogCheckedIds(totalSelectedTaskIds, cataId);
                arr.map(function(item){
                    _this.push(parseInt(item,10));
                });
            }
            currentCatalogSelectedTaskIds.removeAll = function(){
                for(var i=this.length; i>0; i--){
                    this.remove({taskId:this[i-1]});
                }
            };
            var typeId = 2;
            var userClick = true;
            var currentClickedTaskId = null;
            $scope.datasTaskTable = {
                id: "datasTaskTable",
                columns: [{
                    "sTitle": "taskId",
                    "mData": "taskId",
                    "bVisible": false
                }, {
                    "sTitle": appUtils.getString("common_term_status_column"),
                    "mData": "taskResult",
                    "sWidth": "95px"
                }, {
                    "sTitle": appUtils.getString("task_term_name_label"),
                    "mData": "taskName",
                    "sWidth": "110px"
                }, {
                    "sTitle": appUtils.getString("task_term_operation_obj_label"),
                    "mData": "targetName",
                    "sWidth": "150px"
                }, {
                    "sTitle": appUtils.getString("task_term_operator_label"),
                    "mData": "createUser",
                    "bVisible": false
                }, {
                    "sTitle": appUtils.getString("task_term_begintime_label"),
                    "mData": "startTime",
                    "sWidth": "200px"
                }, {
                    "sTitle": appUtils.getString("task_term_endtime_label"),
                    "mData": "endTime",
                    "sWidth": "200px"
                }, {
                    "sTitle": appUtils.getString("task_term_progress_label"),
                    "mData": "taskProgress",
                    "sWidth": "140px"
                }, {
                    "sTitle": appUtils.getString("task_term_detail_label"),
                    "mData": "taskDetail",
                    "bVisible": false,
                    "sWidth": "200px"
                }, {
                    "sTitle": "",
                    "mData": "taskDetailParas",
                    "bVisible": false
                }, {
                    "sTitle": "",
                    "mData": "taskResultSet",
                    "bVisible": false
                }],
                checkbox: true,
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                totalRecords: 0,
                enablePaging: true,
                callback: function(evtObj) {
                    start = evtObj.currentPage - 1;
                    var pageSize = evtObj.displayLength;
                    var status = $("#taskStatusText").widget().getSelectedId();
                    if (!$scope.enabledSearch) {
                        status = "2";
                    }
                    _timeoutFlag = false;
                    communicationService.get(utilService.getResouceUrl("/backtasks?taskResult=" +
                            status + "&pageSize=" + pageSize + "&startPage=" + start + "&orderBy=" + $scope.datasTaskTable.orderBy + "&orderType=" + $scope.datasTaskTable.orderType), null, null, 60000)
                        .promise().always(_updateUI);
                    currentClickedTaskId = null;
                },
                renderRow: function(nRow, aData, iDataIndex) {
                    $("td:eq(1)", nRow).html(statusEnumService.getStatus("BACKTASK_STATUS", aData['taskResult']));
                    $("td:eq(2)", nRow).html(appUtils.getString(aData['taskName']));
                    var progressColumn = "<div class='progressbar'><tiny-progressbar id='id' label-position='position' color='color' value='value' width='width' height='height'></tiny-progressbar></div>";
                    var progressLink = $compile(progressColumn);
                    var progressScope = $scope.$new();
                    progressScope.id = "progress_" + iDataIndex;
                    progressScope.value = aData['taskProgress'];
                    progressScope.position = "right";
                    progressScope.width = "80px";
                    progressScope.height = "10px";
                    progressScope.color = constsService.COLOR_GREEN;
                    var progressNode = progressLink(progressScope);
                    $("td:eq(6)", nRow).html(progressNode);
                },
                drawCallback: function(oSetting) {

                    if (!$('#datasTaskTable').css('display')) {
                        return;
                    }

                    if(!currentClickedTaskId){
                        userClick = false;
                        $('tbody>tr:eq(0)>td:eq(1)','#datasTaskTable').click();
                        userClick = true;
                    }
                    currentCatalogSelectedTaskIds.init(typeId);
                    angular.forEach(currentCatalogSelectedTaskIds, function(value) {
                        $('#datasTaskTable').widget().setSelectedRow("taskId", value);
                    });
                },
                tHeadCheckboxFn: function(isAllChecked, event) {
                    var all = getCurrentPageADatas();

                    if (isAllChecked) {
                        angular.forEach(all, function(value) {
                            currentCatalogSelectedTaskIds.put(value);
                        });
                    } else {
                        angular.forEach(all, function(value) {
                            currentCatalogSelectedTaskIds.remove(value);
                        });
                    }
                },
                data: [],
                opAreaConfig: [{
                    id: "iconBackTaskBtnDelete",
                    template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                    clickActive: function() {
                        _deleteTask();
                    }
                }],
                cellClickActive: function(e, param) {
                    var id = param.taskId;
                    if (userClick) {
                        currentClickedTaskId = id;
                        var bool = isChecked(id);
                        if (!/dataTables_checkboxs/.test($(e.target).attr('class'))) {
                            bool = !bool;
                            if (bool) {
                                $('#datasTaskTable').widget().setSelectedRow("taskId", id);
                            } else {
                                $('#datasTaskTable').widget().cancelSelectedRow("taskId", id);
                            }
                        }
                        //add
                        if (bool) {
                            currentCatalogSelectedTaskIds.put(param);
                        } else {
                            //del
                            currentCatalogSelectedTaskIds.remove(param);
                        }
                    }

                    $(".task_detail_info").hide();
                    $(".task_detail_loading").show();
                    $timeout(function() {
                        if (param) {

                            //多组是表格展示
                            if (param["taskResultSet"] && param["taskResultSet"].length > 0) {
                                $("#taskInlineTable").show();
                                $("#taskInline").hide();
                                _getTaskData(param["taskResultSet"]);
                            } else if (param["taskDetail"] || !_.isEmpty(param["taskLink"])) {
                                //只有一个元素
                                $("#taskInlineTable").hide();
                                var text = "";
                                if(param['taskDetail'] == "1073948125"){
                                    var paramCopy = angular.copy(param),tailKey = "GB";
                                    if(paramCopy["taskDetailParas"][0].indexOf("num") != "-1"){
                                        tailKey = appUtils.getString("csha_single_label")
                                    }
                                    for(var i=1;i<paramCopy["taskDetailParas"].length;i++){
                                        paramCopy["taskDetailParas"][i] = paramCopy["taskDetailParas"][i] + tailKey
                                    };
                                    text = appUtils.getString(constsService.ERRORCODE_PRE + paramCopy['taskDetail'], paramCopy['taskDetailParas']);
                                }else if((param["taskName"] == "ism.drm.mount.replica" || param["taskName"] == "ism.drm.unmount.replica") && !_.isEmpty(param["taskLink"])){
                                    //挂载、卸载副本
                                    var logParams = {};
                                    try{
                                        logParams = {
                                            planId: param["taskLink"].split("/")[2],
                                            logId: param["taskLink"].split("/")[4],
                                            notShowMsgWin: true
                                        }
                                    }catch(err){};
                                    var openLink = "<span class='btn-link' ng-click='showLogDetail()'>"+ appUtils.getString("ism.drm.protect.policy.status.detail") +"</span>";
                                    $scope.showLogDetail = function(){
                                        var options = {
                                            "winId": constsService.EXCUTE_HISTORY_DETAIL_WIN.winId,
                                            "title": appUtils.getString(constsService.EXCUTE_HISTORY_DETAIL_WIN.title),
                                            "params": logParams,
                                            "height": constsService.EXCUTE_HISTORY_DETAIL_WIN.height,
                                            "width": constsService.EXCUTE_HISTORY_DETAIL_WIN.width,
                                            "modal": true,
                                            "content-type": "url",
                                            "draggable": true,
                                            "minimizable": false,
                                            "maximizable": false,
                                            "content": constsService.EXCUTE_HISTORY_DETAIL_WIN.url,
                                            "buttons": [{
                                                key: "close",
                                                label: appUtils.getString("common_term_close_button"),
                                                focused: true,
                                                handler: function(event) {
                                                    $("#" + constsService.EXCUTE_HISTORY_DETAIL_WIN.winId).widget().destroy();
                                                }
                                            }]
                                        };
                                        var win = new Window(options);
                                        win.show();
                                    };
                                    text = $compile(openLink)($scope);
                                } else if (param.taskName === "ism.drm.pg.export" && !_.isEmpty(param.taskLink)) {
                                    text = "<a class='link' onClick=(function(){window.exportPg('" + param.taskLink + "')})()>" + appUtils.getString("maintance_term_download_title") + "</a>";
                                } else {
                                    if (!_.isEmpty($.trim(param['taskDetail']))) {
                                        text = appUtils.getStringWithBothParams([constsService.ERRORCODE_PRE + param['taskDetail']].concat(param['taskDetailParas'] || []));
                                        param['taskDetail'] == "1073947478" && (text = text.split('\n').join("<br>"));
                                    } else {
                                        text = "--";
                                    }
                                }
                                $(".task_detail_loading").hide();
                                $(".task_detail_info").show();
                                $("#taskInline").html(text).show();
                            }  else if (param.taskName === "ism.drm.openstack.sdr.register" && param.taskResult == 1) {
                                text = appUtils.getString("ism.drm.openstack.sdr.register.desc");
                                $(".task_detail_loading").hide();
                                $(".task_detail_info").show();
                                $("#taskInline").html(text).show();
                            } else {
                                $(".task_detail_loading").hide();
                                $(".task_detail_info").show();
                                //无数据展示 -
                                $("#taskInline").text("--").show();
                                $("#taskInlineTable").hide();
                            }
                        }
                    }, 200);

                },
                orderType: "desc",
                orderBy: "startTime",
                sortCallback: function(nNode, sortArr) {
                    $scope.datasTaskTable.orderBy = $scope.datasTaskTable.columns[sortArr[0][0] - 1].mData;
                    $scope.datasTaskTable.orderType = sortArr[0][1];
                    start = 0;
                    _timeoutFlag = false;
                    _initTaskList();
                }

            };

            $scope.TASK_DETAIL = appUtils.getString("syslog_term_detail_label");
            $scope.datasTaskDetailTab = {
                id: "datasTaskDetailTab",
                columns: [{
                    "sTitle": appUtils.getString("common_term_status_column"),
                    "mData": "result",
                    "sWidth": "95px",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("task_term_name_label"),
                    "mData": "resName",
                    "sWidth": "440px",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("task_term_detail_label"),
                    "mData": "detail",
                    "sWidth": "440px",
                    "bSortable": false
                }],
                displayLength: 5,
                enablePaging: true,
                callback: function(evtObj) {

                },
                renderRow: function(nRow, aData, iDataIndex) {
                    if (null != aData['result']) {
                        $("td:eq(0)", nRow).html(statusEnumService.getStatus("BACKTASK_STATUS", aData['result']));
                        $("td:eq(2)", nRow).html(appUtils.getStringWithBothParams([aData['detail']].concat(aData['detailParas'] || [])));
                    }
                }

            };

            var _getTaskData = function(data) {
                if (data.length > $scope.datasTaskDetailTab.displayLength) {
                    $scope.datasTaskDetailTab.enablePaging = true;
                } else {
                    $scope.datasTaskDetailTab.enablePaging = false;
                }
                var dealedResult = [];
                _.each(data, function(d) {
                    var tmo = _.pick(d, "result", "resName", "detail", "detailParas");
                    dealedResult.push(tmo);
                });
                $scope.datasTaskDetailTab.data = dealedResult;
                $scope.datasTaskDetailTab.totalRecords = data.length;
                $(".task_detail_loading").hide();
                $(".task_detail_info").show();
                $scope.$apply();
            };

            var _setDefaultSelected = function() {
                var index = appUtils.getIndexFromArray($scope.datasTaskTable.data, "taskId", $scope.currentBackTaskId);
                !index && (index = 0);

                if (_.isEmpty($scope.datasTaskTable.data)) {
                    $(".task_detail_loading").hide();
                    $(".task_detail_info").show();
                }

            };

            $scope.taksPageRefresh = function() {
                $(".task_owner_info").hide();
                $(".task_owner_loading").show();
                start = 0;
                $scope.datasTaskTable.orderType = "desc",
                    $scope.datasTaskTable.orderBy = "startTime",
                    _initTaskList();
                $scope.datasTaskTable.curPage = {
                    "pageIndex": 0
                };
            };

            $scope.enabledSearch = false;
            var _deleteTask = function() {
                var currentid = $("#datasTaskTable").widget().getHoverData()[0].taskId;
                var name = appUtils.getString($("#datasTaskTable").widget().getHoverData()[0].taskName);
                var param = [currentid];
                message.warn({
                    content: appUtils.getString("home.term.deleteTask.message"),
                    ok: function() {
                        communicationService.remove(utilService.getResouceUrl("/backtasks"), param).promise().always(function(result) {
                            if (exception.check(result)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        _initTaskList();
                                        $scope.showAdvance();
                                    }
                                });
                            }
                        })
                    }
                });
            };

            $scope.queryBackTask = function() {
                $scope.enabledSearch = true;
                start = 0;
                _initTaskList();
                $scope.datasTaskTable.curPage = {
                    "pageIndex": 0
                };
            };

            $scope.closeTaskWin = function () {
                $("#task").widget().setPopShow(false);
            };

            var _timeoutFlag = false;
            var _initTaskList = function() {
                var url = "/backtasks?pageSize=" + constsService.TABLE_COUNT_PER_PAGE + "&startPage=" + start + "&orderBy=" + $scope.datasTaskTable.orderBy + "&orderType=" + $scope.datasTaskTable.orderType;
                $scope.datasTaskTable.displayLength = constsService.TABLE_COUNT_PER_PAGE;
                if ($scope.enabledSearch) {
                    var status = $("#taskStatusText").widget().getSelectedId();
                    url = "/backtasks?pageSize=" + constsService.TABLE_COUNT_PER_PAGE + "&startPage=" + start + "&taskResult=" + status + "&orderBy=" + $scope.datasTaskTable.orderBy + "&orderType=" + $scope.datasTaskTable.orderType;
                }
                communicationService.get(utilService.getResouceUrl(url)).promise().always(function(result) {
                    _updateUI(result);
                });
            };

            var _updateUI = function(result) {
                var isTimeout = appUtils.getString("common_request_timeout_msg") == exception.check(result, false);
                if (!isTimeout) {
                    if (result.totalCount == "0") {
                        $("#taskInlineTable").hide();
                        $("#taskInline").hide();
                    }
                    if (result.totalCount > constsService.TABLE_COUNT_PER_PAGE) {
                        $scope.datasTaskTable.enablePaging = true;
                    } else {
                        $scope.datasTaskTable.enablePaging = false;
                    }
                    var dealedResult = [];
                    _.each(result.records, function(d) {
                        var tmo;
                        if (!_.isEmpty(d["taskLink"])) {
                            tmo = _.pick(d, "taskId", "taskResult", "taskName", "targetName", "createUser", "startTime", "endTime", "taskProgress", "taskDetail", "taskDetailParas", "taskResultSet", "taskLink");
                        } else {
                            tmo = _.pick(d, "taskId", "taskResult", "taskName", "targetName", "createUser", "startTime", "endTime", "taskProgress", "taskDetail", "taskDetailParas", "taskResultSet");
                        }
                        dealedResult.push(tmo);
                    });
                    $scope.datasTaskTable.data = appUtils.encodeForHTML(dealedResult);
                    $scope.datasTaskTable.totalRecords = result.totalCount;
                    if (!securityService.checkRight("ism.drm.task.mgt.delete.operateID")) {
                        $scope.datasTaskTable.opAreaConfig = [];
                    }
                    $(".task_owner_loading").hide();
                    $(".task_owner_info").show();
                    _setDefaultSelected();
                    $scope.$apply();
                    if ($("#task").css("display") != "none") {
                        taskListRunningFnTimer = $timeout(function() {
                            _initTaskList();
                            _timeoutFlag = true;
                        }, 4 * 1E3);
                    } else {
                        _timeoutFlag = false;
                    }
                }

            };
            /******end task ****/
            $scope.PRRVIEW = {
                DRM_PROCESS: appUtils.getString("quickstart_term_workflow_title"),
                DRM_PROCESS_TIPS: appUtils.getString("quickstart_term_workflow_des_label"),
                OPERATION_VIDEO: appUtils.getString("common_term_operationVideo_label"),
                DISCOVERY: appUtils.getString("common.term.drResource.label"),
                DISCOVERY_DES: appUtils.getString("quickstart_resource_task_add_des_label"),
                CREATE_REMOTE_SERVER: appUtils.getString("quickstart_resource_task_createRemoteServer_label"),
                ADD_RESOURCE: appUtils.getString("quickstart_resource_task_addResource_label"),
                PG: appUtils.getString("ism.drm.guide.protection"),
                PG_DES: appUtils.getString("quickstart_protection_task_createPG_des_label"),
                CREATE_PG: appUtils.getString("home.term.addPgGroup.label"),
                RECOVERY: appUtils.getString("ism.drm.protect.group.recovery.label"),
                RECOVERY_DES: appUtils.getString("quickstart_recovery_task_manageRecoveryPlan_des_label"),
                CREATE_RECOVERY: appUtils.getString("home.term.addPlan.label"),
                EXECUTE_RECOVERY: appUtils.getString("recovery.term.recovery.plan.operate.excute")
            };

            window.onresize = function() {
                _changeQuickStartToCenter();
                _changeAboutToCenter();
            }
            var _changeQuickStartToCenter = function() {
                var margin = $(".main_container").css("margin-left");
                margin = margin.replace("px", "") * 1;
                if (!margin) {
                    margin = 0;
                }
                $("#quickStart-win").css("left", (margin + 20) + "px");
                $("#quickStart-win").css("right", (margin + 20) + "px");
            }
            var _changeAboutToCenter = function() {
                $("#about-win").css("top", (document.documentElement.scrollTop + (document.documentElement.clientHeight - $("#about-win").height()) / 2) + "px");
                $("#about-win").css("left", (document.documentElement.scrollLeft + (document.documentElement.clientWidth - $("#about-win").width()) / 2) + "px");
            }

            var _dropDown = function(div) {
                var nowspeed = 320; //当前速度
                var niudun = 3; //(牛顿)加速度
                var freqEnd = -350;
                var dpx = 72; //假定地平线坐标
                var tx = 0.2; //弹性系数
                var top = parseInt(div.style.top);

                function run() {
                    if (top < freqEnd) {
                        top += nowspeed;
                        if (top >= freqEnd) {
                            nowspeed = 10;
                        }
                    } else {
                        nowspeed += niudun;
                        top += nowspeed;
                        if (top > dpx) {
                            top = dpx - (top - dpx) * 0.08;
                            nowspeed *= -1 * tx;
                            if (Math.abs(nowspeed) < 5) {
                                div.style.top = dpx + 'px';
                                return;
                            }
                        }
                    }
                    div.style.top = top + 'px';
                    setTimeout(run, 30);
                }
                run();
            }

            $scope.quickStart = {
                title: appUtils.getString("common_term_quickstart_label"),
                isOut: true,
                click: function() {
                    $("#quickStart").removeClass("quick_start").addClass("quick_start-disabled");
                    _changeQuickStartToCenter();
                    if (parseInt($("#quickStart-win")[0].style.top) != -500) {
                        return;
                    }
                    $("#quickStart-win").mouseleave(function() {
                        $scope.quickStart.isOut = true;
                    });
                    $("#quickStart-win").mouseenter(function() {
                        $scope.quickStart.isOut = false;
                    });
                    $(".main_container").mousedown(function() {
                        if ($scope.quickStart.isOut) {
                            $scope.quickStart.close();
                        }
                    });
                    _dropDown($("#quickStart-win")[0]);

                },
                close: function() {
                    var speed = 50;
                    var position = -500;
                    var div = $("#quickStart-win")[0];
                    var top = parseInt(div.style.top);

                    function run() {
                        if (top > position) {
                            top -= speed;
                        } else {
                            top = position;
                            div.style.top = top + 'px';
                            return;
                        }
                        div.style.top = top + 'px';
                        setTimeout(run, 30);
                    }
                    run();
                    $("#quickStart").removeClass("quick_start-disabled").addClass("quick_start");
                }
            }

            $scope.discoveredPreviewRes = [];
            $scope.containCloud = false;
            $scope.sitesPreview = [{
                name: appUtils.getString("common_term_remoteSite_label"),
                des: appUtils.getString("home_workflow_task_createSite_createLocalSite_des_label") + appUtils.getString("home_workflow_task_createSite_createRemoteSite_des_label"),
                iconCls: "site",
                openStatus: "/settings/siteAdd"
            }];
            $scope.pgsPreview = [];

            /**定时检测的时间间隔**/
            var TIMEOUT_INTERVAL = 3 * 1E3;
            /**会话过期时间**/
            //TODO 从后台去取 默认10分钟
            var SESSION_OUT_TIME = 10 * 60 * 1E3;
            cookieService.put("sessionIdleTime", TIMEOUT_INTERVAL);
            /** 绑定事件**/
            $rootScope.$on('TimeoutEvent', forwardLoginPage);
            angular.element(window).bind("mousedown", function() {
                cookieService.put("sessionIdleTime", TIMEOUT_INTERVAL);
            });

            /** 定时器检查鼠标多长时间没有点击**/
            function checkSessionTimeout() {
                var sessionIdleTime = cookieService.get("sessionIdleTime");
                if (angular.isUndefined(sessionIdleTime)) {
                    sessionIdleTime = TIMEOUT_INTERVAL;
                } else {
                    sessionIdleTime = parseInt(sessionIdleTime, 10);
                }

                if (sessionIdleTime >= SESSION_OUT_TIME) {
                    angular.element(window).unbind('mousedown');
                    if (angular.isDefined(sessionTimeoutTimer)) {
                        $timeout.cancel(sessionTimeoutTimer);
                    }
                    $rootScope.$broadcast("TimeoutEvent", {});
                    if (sessionTimeoutTimer) {
                        $timeout.cancel(sessionTimeoutTimer);
                    }
                    if (faultStaticTimer) {
                        $timeout.cancel(faultStaticTimer);
                    }
                    if (taskRunningFnTimer) {
                        $timeout.cancel(taskRunningFnTimer);
                    }

                    if (taskListRunningFnTimer) {
                        $timeout.cancel(taskListRunningFnTimer);
                    };
                } else {
                    sessionIdleTime += TIMEOUT_INTERVAL;
                    cookieService.put("sessionIdleTime", sessionIdleTime);
                    sessionTimeoutTimer = $timeout(checkSessionTimeout, TIMEOUT_INTERVAL);
                }
            };

            /** 跳转到登录界面**/
            function forwardLoginPage() {
                var url = "/ws/auth/logout";
                var timeoutMsg = appUtils.getString("user_term_timeout_message");
                storage.removeItem("failedNum");
                storage.removeItem("loginInCount");
                communicationService.post(url, {timeOut:true}).pipe(function(response, textStatus, request){
                    cookieService.removeToken();
                    var ssoUrl = request.getResponseHeader("redirect");
                    message.error({
                        content: timeoutMsg,
                        ok: function() {
                            if ( "sso" == cookieService.get("user.login.mode") && !_.isEmpty(ssoUrl)) {
                                window.location.href = ssoUrl;
                            }else{
                                var rootPath = utilService.getRootPath();
                                window.location.href = rootPath + constsService.LOGIN_URL;
                            }
                        },
                        close: function() {
                            if ( "sso" == cookieService.get("user.login.mode") && !_.isEmpty(ssoUrl)) {
                                window.location.href = ssoUrl;
                            }else{
                                var rootPath = utilService.getRootPath();
                                window.location.href = rootPath + constsService.LOGIN_URL;
                            };
                        }
                    });
                    var lagTime = setTimeout(function() {
                        clearTimeout(lagTime);
                        if ( "sso" == cookieService.get("user.login.mode") && !_.isEmpty(ssoUrl)) {
                            window.location.href = ssoUrl;
                        }else{
                            var rootPath = utilService.getRootPath();
                            window.location.href = rootPath + constsService.LOGIN_URL;
                        };
                    }, 10 * 1E3);
                }, function(err){
                    var rootPath = utilService.getRootPath();
                    window.location.href = rootPath + constsService.LOGIN_URL;
                });
            };

            /**告警统计***/
            var _faultStatic = function() {
                if (appUtils.checkRight('lego.evtMgr.curtAlarm.scan')) {
                    communicationService.get(utilService.getResouceUrl("/alarms/statistic"), function(response) {
                        try {
                            var responseText = JSON.parse(response);
                            $rootScope.$apply(function() {
                                $rootScope.alarm_critical = responseText.critical;
                                $rootScope.alarm_major = responseText.major;
                                $rootScope.alarm_warning = responseText.minor;
                                $rootScope.alarm_info = responseText.warning;
                                updateTotalAlarms(responseText.critical, responseText.major, responseText.minor, responseText.warning);
                                $rootScope.enableAlarmStatus = responseText["switch"] == "0" ? "iconbutton-cancelsound" : "iconbutton-sound";
                                if (responseText["switch"] == "0") {
                                    $scope.SOUND_TIPS = $scope.SOUND_ENABLED;
                                } else {
                                    $scope.SOUND_TIPS = $scope.SOUND_DISABLED;
                                }
                                _alarmLinkage(responseText);
                            })

                            faultStaticTimer = $timeout(_faultStatic, 30 * 1E3);
                        } catch (e) {

                        }
                    }, function(response) {

                    });
                }
            }

            var _alarmLinkage = function(response) {

                var voiceSwitch = response["switch"];
                var url = "";
                // 判断告警级别,1为全局开启
                if (voiceSwitch == "1") {
                    var criticalCount = response["criticalUnconfirm"];
                    var majorCount = response["majorUnconfirm"];
                    var warnCount = response["minorUnconfirm"];
                    var infoCount = response["warningUnconfirm"];

                    var criticalSwitch = response["critical-switch"];
                    var majorSwitch = response["major-switch"];
                    var warnSwitch = response["warn-switch"];
                    var infoSwitch = response["info-switch"];

                    if (criticalCount != "0" && criticalSwitch == "1") {
                        var criticalHidden = response["critical-audio"];
                        if (criticalHidden == "1") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/critical.mp3";
                        } else if (criticalHidden == "2") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/critical_loop.mp3";
                        }
                    } else if (majorCount != "0" && majorSwitch == "1") {
                        var majorHidden = response["major-audio"];
                        if (majorHidden == "1") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/major.mp3";
                        } else if (majorHidden == "2") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/major_loop.mp3";
                        }
                    } else if (warnCount != "0" && warnSwitch == "1") {
                        var warnHidden = response["warn-audio"];
                        if (warnHidden == "1") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/warn.mp3";
                        } else if (warnHidden == "2") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/warn_loop.mp3";
                        }
                    } else if (infoCount != "0" && infoSwitch == "1") {
                        var infoHidden = response["info-audio"];
                        if (infoHidden == "1") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/info.mp3";
                        } else if (infoHidden == "2") {
                            url = "/src/app/business/recoverydirector/monitor/views/alarm/audio/info_loop.mp3";
                        }
                    }
                }

                // 设置告警播放器
                if (url == "") {
                    document.getElementById("flashPlayer").innerHTML = "";
                    return;
                }
                //仅当含有当前告警权限时，才会发出告警通知声音
                var voiceObject = document.getElementById("flashPlayer");

                if (voiceObject) {
                    document.getElementById("flashPlayer").innerHTML =
                        "<audio src='" + url + "' autoplay='autoplay'></audio>";
                } else {
                    document.getElementById("flashPlayer").innerHTML = "";
                }
            };

            /**静音***/
            $scope.alarmAudio = function() {
                communicationService.put(utilService.getResouceUrl("/audio/action/modifyAudioStatus")).promise().always(function(result) {
                    if (exception.check(result)) {
                        document.getElementById("flashPlayer").innerHTML = "";
                        _faultStatic();
                    }
                });

            };


            function isChecked(id) {
                var arr = $('#datasTaskTable').widget().getTableCheckedItems();
                arr = arr.map(function(obj) {
                    return obj.taskId;
                }) || [];
                if (arr.indexOf(id) === -1) {
                    return false;
                } else {
                    return true;
                }
            }
            function getCurrentCatalogCheckedIds(totalArr, cataId){
                var arr = [];
                //2代表全部
                if(cataId === 2 || cataId === undefined){
                    arr = totalArr.map(function(item){
                        return item.split(',')[0];
                    });
                }else{
                    angular.forEach(totalArr, function(value){
                        var tempArr = value.split(',');
                        if(tempArr[1] == cataId){
                            arr.push(tempArr[0]);
                        }
                    });
                }
                return arr;
            }

            function getCurrentPageADatas() {
                var length = $('tbody tr', '#datasTaskTable').length;
                var arr = [];
                for (var i = 0; i < length; i++) {
                    arr.push($('#datasTaskTable').widget().getTableData(i));
                }
                return arr;
            }

            $scope.$watch('currentCatalogSelectedTaskIds.length',function(newVal){
                $scope.model.btn.label = appUtils.getString("common_term_selected_label", newVal);
            });

            function batchDelTask() {
                message.warn({
                    content: appUtils.getString("home.term.deleteTask.message"),
                    ok: function() {
                        communicationService.remove(utilService.getResouceUrl("/backtasks"), currentCatalogSelectedTaskIds).promise().always(function(result) {
                            if (exception.check(result)) {
                                currentCatalogSelectedTaskIds.removeAll();
                                currentClickedTaskId = null;
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        _initTaskList();
                                        $scope.showAdvance();
                                    }
                                });
                            }
                        })
                    }
                });
            }

            /**更新总告警数**/
            function updateTotalAlarms() {
                var sum = 0,
                    arr = [];
                angular.forEach(arguments, function(value) {
                    arr.push(value.length);
                    /\d+/.test(value) && (sum += parseInt(value, 10));
                });
                if (parseInt($('#alarm-total').text()) !== sum) {
                    $('#alarm-total').text(sum + '');
                }
                //如果总告警数比最高子告警多一位,则修改标志位,下次打开告警下拉框时修改css以对齐
                if (arr.indexOf((sum + '').length) === -1) {
                    normalState && (normalState = false);
                } else {
                    normalState || (normalState = true);
                }
            }

            var taskListRunningFnTimer;
            var faultStaticTimer;
            var taskRunningFnTimer;
            var sessionTimeoutTimer = $timeout(checkSessionTimeout, TIMEOUT_INTERVAL);
            $rootScope.$on("$destroy", function() {
                if (sessionTimeoutTimer) {
                    $timeout.cancel(sessionTimeoutTimer);
                }
                if (faultStaticTimer) {
                    $timeout.cancel(faultStaticTimer);
                }
                if (taskRunningFnTimer) {
                    $timeout.cancel(taskRunningFnTimer);
                }
                if (taskListRunningFnTimer) {
                    $timeout.cancel(taskListRunningFnTimer);
                };
            });

            $scope.backTask_count = 0;
            $scope.failedTask_count = 0;
            var saveRunningTask = [];
            var currentFailedTask = _.isEmpty(storage.getItem("failedNum")) ? 0 : parseInt(storage.getItem("failedNum"),10);
            var _taskRunningFn = function() {
                $timeout.cancel(taskRunningFnTimer);
                //要获取全部数据以便获得在运行中的task个数
                var runningTask = [],failedTask = [];
                communicationService.get(utilService.getResouceUrl("/backtasks?taskResult=2&pageSize=100"), null, null, 60000)
                    .promise().always(function(result) {
                        var isTimeout = appUtils.getString("common_request_timeout_msg") == exception.check(result, false);
                        if (!isTimeout) {
                            _.each(result.records,function(val){
                                val.taskResult == "-1" && (runningTask.push(val));
                                val.taskResult == "1" && (failedTask.push(val));
                            });
                            _.each(saveRunningTask,function(val,index){
                                _.each(failedTask,function(val_f,index_f){
                                    if((val_f.taskId == val.taskId)){
                                        currentFailedTask++;
                                    }
                                })
                            });
                            storage.setItem("failedNum",currentFailedTask);
                            saveRunningTask = runningTask;
                            if (runningTask.length > 99) {
                                $scope.BACKTASK_COUNT = "99+";
                            } else {
                                $scope.BACKTASK_COUNT = runningTask.length;
                            }
                            $scope.FAILEDTASK_COUNT = currentFailedTask;
                            $scope.failedTask_count = currentFailedTask;
                            $scope.backTask_count = parseInt(runningTask.length, 10);
                            $scope.$apply();
                            taskRunningFnTimer = $timeout(_taskRunningFn, 4 * 1E3);
                        }
                    });
            };

            var _init = function() {
                /***tasklist**/
                _initTaskList();
                _taskRunningFn();
                /***alarm**/
                _faultStatic();
                /****policy**/
                $("#loginInfoDiv").hide();
                var url = "/ws/securitypolicy";
                communicationService.get(url, function(result) {
                    if (exception.check(result)) {
                        SESSION_OUT_TIME = parseInt(result.sessionTime, 10) * 60 * 1E3;
                    }

                    var isUserquickStart = JSON.parse(localStorage.getItem($.base64.encode(''+currentUser+','+domainIp+''))),
                        state = window.location.hash.indexOf("home/staticView") > -1;
                    if(isUserquickStart && state) {
                        $scope.quickStart.click();
                    }
                });

                communicationService.get("/ws/userLoginInfo").promise().always(function (result) {
                    loginInfo = result;
                    var loginInCount = storage.getItem("loginInCount");
                    var firstLoginFlag = loginInfo.isFirstLogin == 1;
                    if(!firstLoginFlag && loginInCount < 2) {
                        var TIMEOUT_HIDDEN = 4 * 1E3;

                        $("#loginInfoDiv").show();
                        var z = setTimeout(function() {
                            $("#loginInfoDiv").hide();
                            clearTimeout(z);
                        }, TIMEOUT_HIDDEN);
                        storage.setItem("loginInCount", 2);
                    }

                    if(loginInfo.failedTimes > 0) {
                        $scope.isLastLoginSucessed = false;
                        $scope.info.user.lastSuessed = false;
                        $scope.info.user.lastfailed = true;

                        var firstFailedTime = appUtils.convertDate2String(loginInfo.startTime),
                            lastFailedTime = appUtils.convertDate2String(loginInfo.endTime),
                            failedCount = loginInfo.failedTimes;
                        $scope.info.user.failedTimeValue = lastFailedTime;
                        $scope.info.user.failedCountLabel = failedCount > 1 ?
                            resource.get("common_term_loginFailedCount_label", firstFailedTime, lastFailedTime, failedCount)
                            : resource.get("common_term_loginPreviusCount_label", firstFailedTime);
                    } else {
                        $scope.isLastLoginSucessed = true;
                        $scope.info.user.lastSuessed = true;
                        $scope.info.user.lastfailed = false;
                        $scope.info.user.sucessTimeValue = appUtils.convertDate2String(loginInfo.startTime);
                        $scope.info.user.sucessTerminalLabel = resource.get("common_term_lastLoginIP_label", loginInfo.ip);
                    }
                });
                $(".main_container").mousedown(function(event) {
                    var target = $(event.target);
                    if(target.attr("id") != "loginInfoDiv" && target.attr("id") != "tip4" && target.attr("id") != "loginDetails") {
                        $("#loginInfoDiv").hide();
                    }
                });
            };

            _init();

            $scope.linkClickHandle = function(evt) {
                $(evt.target).trigger("mouseout")
            }

            window._taskRunningFn = _taskRunningFn;
            window.exportPg = function(url) {
                appUtils.export(url);
            }
        }

        ctrl.$injector = ["$rootScope", "$scope", "$compile", "$state", "$timeout", "utilService", "appUtils", "communicationService",
            "cookieService", "message", "exception", "constsService", "securityService", "statusEnumService", "mask", "infoTransferredService", "servicesPlugin", "restService"
        ];
        return ctrl;
    });
