define(["tiny-common/UnifyValid"],
function (UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "appUtils", "mask", "message", "exception", "communicationService", "cookieService", "utilService", "constsService",
        function ($scope, appUtils, mask, message, exception, communicationService, cookieService, utilService, constsService) {

            var minLen = 0, pwdComplex = 0;
            var userId = $('#modifyPwdWin').widget().option('data').userId;
            var userName = $('#modifyPwdWin').widget().option('data').userName || "";

            $("#modifyPwdWin").widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function(event) {
                    $scope.model._submit();
                }
            },
            {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#modifyPwdWin").widget().destroy();
                }
            }]);

            $scope.model = {
                width: constsService.W2,
                nameLabel: appUtils.getString("common_term_username_label"),
                cpOldPwd: {
                    label: appUtils.getStringWithColon("Login_Label_Old_Password"),
                    id: "cpOldPwd",
                    type: "password",
                    value: ""
                },
                cpNewPwd: {
                    label: appUtils.getStringWithColon("Login_Label_New_Password"),
                    id: "cpNewPwd",
                    extendFunction: ["validateNewPassword"],
                    validate: "validateNewPassword : extend function;",
                    type: "password",
                    value: ""
                },
                cpConfirmPwd: {
                    label: appUtils.getStringWithColon("Login_Label_Confirm_Password"),
                    id: "cpConfirmPwd",
                    extendFunction: ["validateConfirmPassword"],
                    validate: "validateConfirmPassword : extend function;",
                    type: "password",
                    value: ""
                },
                _submit: function() {
                    if (!UnifyValid.FormValid($("#login-modify-password-div"), {focusInvalid: true})) {
                        return;
                    }
                    mask.show();
                    var param = {};
                    var url = utilService.getResouceUrl("/users/action/userModifyPassword");
                    param.newPassword = $("#cpNewPwd").widget().getValue();
                    param.confirmPassword = $("#cpConfirmPwd").widget().getValue();
                    param.oldPassword = $("#cpOldPwd").widget().getValue();
                    if (userId) {
                        param.userPassword = $("#cpNewPwd").widget().getValue();
                        param.userId = userId;
                        delete param.oldPassword;
                        delete param.newPassword;
                        url = utilService.getResouceUrl("/users/action/adminModifyPassword");
                    }
                    communicationService.put(url, param).promise().always(function (result) {
                        mask.hide();
                        if (exception.check(result)) {
                            if(!_.isUndefined(data) && data.syncAdminFlag){
                                message.prompt({
                                    content: appUtils.getString("common_term_modify_syncAdmin_tips_label"),
                                    ok: function(){
                                        message.success(appUtils.getString("common_term_operation_success_label"))
                                    }
                                })
                                $("#modifyPwdWin").widget().destroy();
                                return;
                            };
                            message.success(appUtils.getString("common_term_operation_success_label"));
                            $("#modifyPwdWin").widget().destroy();
                        }
                    });
                }
            };
            var data = $('#modifyPwdWin').widget().option('data');
            var userId;
            if (data && data.userId) {
                userId = data.userId;
                $scope.model.cpOldPwd.validate = "";
                $scope.model.selfPwd = false;
                $scope.model.othersPwd = true;
            } else {
                $scope.model.cpOldPwd.validate = "required : " + appUtils.getString("Login_Message_Password_Empty_Old"),
                $scope.model.selfPwd = true;
                $scope.model.othersPwd = false;
            }

            UnifyValid.validateNewPassword = function () {
                var oldPwd = $("#cpOldPwd").widget().getValue();
                var newPwd = $("#cpNewPwd").widget().getValue();

                if (!newPwd) {
                    return appUtils.getString("Login_Message_Password_Empty_New");
                }

                if ($scope.model.selfPwd && oldPwd == newPwd) {
                    return appUtils.getString("Login_Message_Password_Same");
                }

                //TODO: compare password with user name
                var reverseName = userName.split('').reverse();
                reverseName = reverseName.join('');
                var isSameWithName = newPwd == userName || newPwd == reverseName;

                if (!appUtils.checkUserPwd(newPwd, minLen, pwdComplex, 64, true) || isSameWithName) {
                    var message = appUtils.getString("Login_Message_Password_Complex", $.trim(minLen), 64, "");
                    if (pwdComplex == 2) {
                        message = appUtils.getString("Login_Message_Password_Complex",
                                $.trim(minLen), 64,
                                appUtils.getString("Login_Message_Password_Complex_Special"));
                    }
                    return message;
                }

                return "";
            };
            UnifyValid.validateConfirmPassword = function () {
                var newPwd = $("#cpNewPwd").widget().getValue();
                var confirmPwd = $("#cpConfirmPwd").widget().getValue();

                if (newPwd !== confirmPwd) {
                    return appUtils.getString("Login_Message_Password_Different");
                }

                return "";
            };
            function init() {
                communicationService.get(utilService.getResouceUrl("/securitypolicy")).promise().always(function (response) {
                    if (exception.check(response)) {
                        minLen = response.passLenVal;
                        pwdComplex = response.passComplexVal;
                    }
                });
            }

            init();
        }];

        var modifyPwdModule = angular.module("home.config");
        modifyPwdModule.tinyController("login.modifyPwdCtrl", ctrl);
        return modifyPwdModule;
    });
