define(["tiny-extra-lib/jquery.base64"], function() {
    "use strict";
    var ctrl = function($rootScope, $scope, $state, $timeout, appUtils, communicationService, infoTransferredService,
                            message, exception, servicesPlugin, cookieService, constsService) {

        var localStorage = window.localStorage;

        $scope.isPrivateConsole = window.isPrivateConsole;

        function close(quick) {
            function run() {
                if (top > position) {
                    top -= speed;
                } else {
                    top = position;
                    div.style.top = top + 'px';
                    return;
                }
                div.style.top = top + 'px';
                setTimeout(run, 30);
            }
            if (quick) {
                $("#quickStart-win").css("top", "-500px");
            } else {
                var speed = 50;
                var position = -500;
                var div = $("#quickStart-win")[0];
                var top = parseInt(div.style.top);
                run();
            }
        }

        var username = cookieService.get("userName"),
            domainIp = window.location.hostname,
            isquickStart = localStorage.getItem($.base64.encode(''+username+','+domainIp+''));
        var quickStartFlag;
        if(!_.isEmpty(isquickStart)) {
            quickStartFlag = JSON.parse(isquickStart);
        } else {
            quickStartFlag = true;
        }

        localStorage.setItem($.base64.encode(''+[username, domainIp]+''), JSON.stringify(quickStartFlag));
        $scope.PRRVIEW = {
            DRM_PROCESS: appUtils.getString("quickstart_term_workflow_title"),
            DRM_PROCESS_TIPS: appUtils.getString("quickstart_term_workflow_des_label"),
            OPERATION_VIDEO: appUtils.getString("common_term_operationVideo_label"),
            DISCOVERY: appUtils.getString("common.term.drResource.label"),
            DISCOVERY_DES: appUtils.getString("quickstart_resource_task_add_des_label"),
            CREATE_REMOTE_SERVER: appUtils.getString("quickstart_resource_task_createRemoteServer_label"),
            ADD_RESOURCE: appUtils.getString("quickstart_resource_task_addResource_label"),
            PG: appUtils.getString("ism.drm.guide.protection"),
            PG_DES: appUtils.getString("quickstart_protection_task_createPG_des_label"),
            CREATE_PG: appUtils.getString("home.term.addPgGroup.label"),
            RECOVERY: window.isUltraVR ? appUtils.getString("recovery_title") : appUtils.getString("menus_dataused_title"),
            RECOVERY_DES: appUtils.getString("quickstart_recovery_task_manageRecoveryPlan_des_label"),
            CREATE_RECOVERY: appUtils.getString("menus_create_recovery_title"),
            EXECUTE_RECOVERY: appUtils.getString("recovery_create_datamount_label"),
            DATAMOUNT_DES: appUtils.getString("quickstart_recovery_task_manageDataMount_des_label")
        };

        $scope.quickStart = {
            url: constsService.QUICK_START_URL,
            remoteServerTip: appUtils.getString("quickstart_resource_task_createRemoteServer_des_tip"),
            goToPlan: function(param) {
                close("quickMode");
                var hasRight = appUtils.checkRight("ism.drm.drp.auth.add");
                if (!hasRight) {
                    message.error(appUtils.getString("common_term_right_message"));
                    return;
                }
                $state.go(param);
            },
            goToRes: function(param, type) {
                close("quickMode");
                if (type == "remoteServer") {
                    if (!appUtils.checkRight("9318")) { //创建远端管理服务器
                        message.error({
                            content: appUtils.getString("common_term_right_message")
                        });
                        return;
                    }
                    $state.go(param);
                }

                if (_.isUndefined(type)) {
                    if (!appUtils.checkRight("9324")) { //创建站点并添加资源
                        message.error({
                            content: appUtils.getString("common_term_right_message")
                        });
                        return;
                    }
                    $state.go(param);
                }

                var fn;
                "remoteServer" == type && (fn = setInterval(function() {
                        if (!_.isEmpty($("#edit").widget())) {
                            clearInterval(fn);
                            return;
                        }
                        !_.isEmpty(infoTransferredService.get("server", "currentServer")) && infoTransferredService.get("server", "currentServer").add();
                    }, 500)
                );

            },
            goToVideo: function(html) {
                close("quickMode");
                var url = "";
                if (cookieService.get("language") == "en") {
                    url = "/help/quickstart_en/" + html;
                } else {
                    url = "/help/quickstart_zh/" + html;
                }
                window.open(url);
            }

        }

        $scope.quickStartCheck = {
            id: "quickStart-check",
            text: appUtils.getString("dashboard_quickStart_term_dontShow_option_checkbox"),
            checked: quickStartFlag === false ? true : false,
            change: function(){
                var stat = $("#quickStart-check").widget().option("checked");
                if(stat){
                    quickStartFlag = false;
                }else {
                    quickStartFlag = true;
                };
                localStorage.setItem($.base64.encode(''+[username, domainIp]+''), JSON.stringify(quickStartFlag));
            }
        };
        $scope.closeQuickStart = function() {
            close("quickMode");
        };

        $scope.hideCreateDataMountPlan = window.isUltraVR || window.isPrivateConsole;
    }

    ctrl.$injector = ["$rootScope", "$scope", "$state", "$timeout", "appUtils", "communicationService", "infoTransferredService",
                       "message", "exception", "servicesPlugin", "cookieService", "constsService"];
    return ctrl;
});
