/**
 * 框架Controller， 设置服务菜单的视图控制逻辑
 *
 */
define(["tiny-lib/underscore"], function (_) {
    "use strict";

    var ctrl = function ($rootScope, $compile, $state, $stateParams,$timeout, servicesPlugin,
    		mask, communicationService, exception, utilService, cookieService ,
    		constsService,appUtils , message) {
        $rootScope.menus = {
            url: constsService.MENU
        };
        $rootScope.$state = $state;
        $rootScope.$stateParams = $stateParams;
        $rootScope.plugins = servicesPlugin.plugins;
        $rootScope.copyright = appUtils.getString("common_term_copyright_label", new Date().getFullYear());
        $rootScope.REFRESH   = appUtils.getString("common_term_refresh_button");
        $rootScope.isUltraVR = window.isUltraVR;
       /**开关**/
        $rootScope.model = {
    		viewSwitch:{
                id : "viewSwitch",
                items : [{label: appUtils.getString("common_term_staticView_label"), value:0},
                        {label: appUtils.getString("common_term_topoView_label"), value:1}],
                selected : _.isEmpty($.trim(localStorage.getItem('viewSwitch_selectedId'))) ? 0 : localStorage.getItem('viewSwitch_selectedId'),
                standard: false,
                change: function(param) {
                    localStorage.setItem('viewSwitch_selectedId', param.newValue);
                    $rootScope.$broadcast(constsService.TOPIC_HOME_SWITCH ,param.newValue);
                }
           }
         };

        $rootScope.firstLoginTip = {
            show: false,
            content: appUtils.getString("common_term_admin_first_login_content_label", location.protocol + "//" + location.host),
            content1: appUtils.getString("common_term_admin_first_login_content1_label"),
            close: function () {
                $rootScope.firstLoginTip.show = false;
            }
        }

        function isShowFirstLoginTip() {
            var url = "/ws/users/1";
            communicationService.get(url, function(result){
                if(result && result.mustModifyPwd){
                    $rootScope.firstLoginTip.show = result.mustModifyPwd && window.isPrivateConsole;
                }
            })
        }
        isShowFirstLoginTip();

        /**监听状态变化，更新面包屑*/
        $rootScope.$on('$stateChangeSuccess', function(e, params) {
            var html = "";
            var stateArr = [];
            var path = $state.$current.path;
            var _path = $.trim(_.pluck(path, 'name'));
            //首页需要切换开关
            if(window.isUltraVR && (_.contains([",home,home.staticView", ",home,home.topoVew"], _path))) {
            	$rootScope.enabledSwitch = true;
            	$("#service-nav").removeClass("sub_breadcrumbs").addClass("main_breadcrumbs")
            }else{
            	$rootScope.enabledSwitch = false;
            	$("#service-nav").addClass("sub_breadcrumbs").removeClass("main_breadcrumbs")
            }

            for ( var i = 0; i < path.length; i++) {
                var crumb = path[i].self.breadcrumbs;
                if (crumb) {
                    if (_.isArray(crumb)) {
                        stateArr = _.union(stateArr, crumb);
                    } else {
                        stateArr.push(crumb);
                    }
                }
            }

            //创建保护组开启回到主列表
            if (path.toString().indexOf("protection.pg.create") !== -1) {
                stateArr.splice(1, 0, {name: appUtils.getString("protect_object")[params.poType], state:"protection.pg.list"});
            }

            //创建数据恢复开启回到主列表
            if(path.toString().indexOf("dataUse.createRecoveryPlan") != -1) {
                stateArr.splice(0, 1, {name: appUtils.getString("menus_recovery_datarecovery_label"), state:"dataUse.dataRecovery.abstract"});
            }

            //创建数据挂载开启回到主列表
            if(path.toString().indexOf("dataUse.createDataMountPlan") != -1) {
                stateArr.splice(0, 1, {name: appUtils.getString("menus_recovery_datamount_label"), state:"dataUse.dataMount.abstract"});
            }

            //数据恢复列表
            if (path.toString().indexOf("dataUse.dataRecovery") != -1) {
                stateArr.splice(0, 2, {name: appUtils.getString("menus_recovery_datarecovery_label")});
            }

            //数据挂载列表
            if (path.toString().indexOf("dataUse.dataMount") != -1) {
                stateArr.splice(0, 2, {name: appUtils.getString("menus_recovery_datamount_label")});
            }

            //TOPO详情开启回到主列表
            if (path.toString().indexOf("monitor.protectGroupTopo.topogoly") != -1) {
                stateArr.splice(1, 1, {name: appUtils.getString("topo_title"), state:"monitor.topo"});
            };

            

            _.each(stateArr, function(value, index) {
                var name = appUtils.getString(value.name);
                if (index == stateArr.length-1) {
                    html += "<span class='last'>" + name + "</span>";
                } else if (value.state) {
                    html += "<a class='btn-link' ui-sref='" + value.state + "'>" + name + "</a> > ";
                } else {
                    html += "<span>" + name + "</span> > ";
                }
            });
            $( "#service-nav" ).html( html );
            $compile($( "#service-nav" ))($rootScope);
        });

        /**动态设置内容区的高度*/
        $rootScope.$on("$viewContentLoaded", function () {
            dynamicHeight();
        });

        angular.element(window).bind("resize", dynamicHeight);
        angular.element("#service-content").bind("scroll", dynamicHeight);

        function dynamicHeight() {
            var topHeight = parseInt($("#service-menus").css("height")) + parseInt($("#service-nav").css("height"));
            var footHeight = 10;
            var contentHeight = document.documentElement.clientHeight - topHeight - footHeight;
            $("#service-content").css({"min-height":768 - topHeight - footHeight,"height":contentHeight+6});
            $(".view-container").css("height",contentHeight+6);
            $(".tiny-layout-west").css("height",contentHeight);
            $(".floatingpanel-container").css("min-height",contentHeight-43);
            $(".setting-container>.floatingpanel-container").css("min-height",contentHeight-86);
            $('#treeDiv').length != 0 && $('#treeDiv').height(contentHeight - 60);
        };


        /**权限相关**/
        $rootScope.user = {};

        setTimeout(function() {
            if (appUtils.isEn()) {
                $("style[id='schedule']").html("#ui-datepicker-div .ui-datepicker-year-name{width:30px !important;}*{font-family: Arial, 'Microsoft Yahei', 'SimSun', Tahoma;}");
            }
        });
    };
    ctrl.$injector = ["$rootScope", "$compile", "$state", "$stateParams", "$timeout", "servicesPlugin","mask",
                      "communicationService", "exception", "utilService","cookieService","constsService","appUtils","message"];
    return ctrl;
});
