define([], function() {
    "use strict";
    var ctrl = ["$scope", "$state", "constsService", "appUtils", "$sce", "message", "restService", "infoTransferredService", "$timeout",
        function($scope, $state, constsService, appUtils, $sce, message, restService, infoTransferredService, $timeout) {
            var stepIndex = 0;
            var widget = $("#" + constsService.WIZARD_WIN.winId).widget();
            var data = widget.option("data");
            var previousBtn = {
                    key: "previous",
                    label: appUtils.getString("common_term_previous_record_label"),
                    focused: false,
                    btnCls: "tiny-btn-disable",
                    handler: function() {
                        if ($("#previous").attr("class").indexOf("tiny-btn-disable") != -1) {
                            return;
                        }
                        --stepIndex;
                        $scope.model.steps = _.each($scope.model.steps, function(step) {
                            step.show = step.id == stepIndex;
                        });

                        var firstBtn = _.first($scope.model.steps);
                        if (firstBtn.id == stepIndex) {
                            $("#previous").removeClass("tiny-btn").addClass("tiny-btn-disable");
                        }

                        $scope.model.agreen.checked = true;
                        $scope.model.operateRecordTip = appUtils.getString("common_term_operaterecordtip_label", _.size(data.steps), stepIndex + 1, _.size(data.steps));
                        $("#next").removeClass("tiny-btn-disable").addClass("tiny-btn");
                        $("#next").text(appUtils.getString("common_term_next_record_label"));
                        $scope.$apply();
                    }
                },
                nextBtn = {
                    key: "next",
                    label: appUtils.getString("common_term_next_record_label"),
                    focused: false,
                    btnCls: "tiny-btn-disable",
                    handler: function() {
                        if ($("#next").attr("class").indexOf("tiny-btn-disable") != -1) {
                            return;
                        }
                        ++stepIndex;
                        $scope.model.steps = _.each($scope.model.steps, function(step) {
                            step.show = step.id == stepIndex;
                        });

                        var lastBtn = _.last($scope.model.steps);
                        var firstBtn = _.first($scope.model.steps);

                        if (lastBtn.id == stepIndex) {
                            $("#next").text(tinyLanguage.language.finishBtnTitle);
                        }

                        if (firstBtn.id != stepIndex) {
                            $("#previous").removeClass("tiny-btn-disable").addClass("tiny-btn");
                        }

                        $scope.model.agreen.checked = false;
                        $scope.model.operateRecordTip = appUtils.getString("common_term_operaterecordtip_label", _.size(data.steps), stepIndex + 1, _.size(data.steps));

                        if (stepIndex == _.size(data.steps)) {
                            data.finish();
                            $("#" + constsService.WIZARD_WIN.winId).widget().destroy();
                        }
                        $("#next").removeClass("tiny-btn").addClass("tiny-btn-disable");
                        $scope.$apply();
                    }
                },
                cancelBtn = {
                    key: "cancel",
                    label: appUtils.getString('common_term_cancel_button'),
                    focused: false,
                    btnCls: "tiny-btn",
                    handler: function(event) {
                        $("#" + constsService.WIZARD_WIN.winId).widget().destroy();
                    }
                },
                buttons = _.size(data.steps) < 2 ? [_.extend(nextBtn, { label: tinyLanguage.language.okBtnTitile }), cancelBtn] : [previousBtn, nextBtn, cancelBtn];

            widget.option("buttons", buttons);
            widget.setButton("next", _.findWhere(buttons, { key: "next" })["handler"]);

            $scope.model = {
                isEn: appUtils.isEn(),
                operateRecordTip: appUtils.getString("common_term_operaterecordtip_label", _.size(data.steps), 1, _.size(data.steps)),
                type: function() {
                    if (_.isEmpty($.trim(data.type)) || !_.contains(['confirm', 'prompt', 'error', 'warn'], $.trim(data.type))) {
                        return "warn";
                    }
                    return $.trim(data.type);
                }(),
                steps: function() {
                    _.each(data.steps, function(step, index) {
                        step.id = index;
                        step.show = !index;
                        step.content = $sce.trustAsHtml(step.content);
                    });

                    return data.steps;
                }(),
                agreen: {
                    id: "agreen",
                    checked: false,
                    text: appUtils.getString("common_warn_checkBox_confim_label"),
                    click: function() {
                        var isChecked = $("#agreen").widget().option("checked");
                        if (isChecked) {
                            $("#next").removeClass("tiny-btn-disable").addClass("tiny-btn");
                        } else {
                            $("#next").removeClass("tiny-btn").addClass("tiny-btn-disable");
                        }
                    }
                }
            }
        }
    ];

    var module = angular.module("home.config");
    module.tinyController("message.confirmWizardWinCtrl", ctrl);
    return module;
})