/**
 * RD UI Module 启动器，负责以下两项任务：
 *
 * 1、加载module依赖模块，并创建framework module
 *
 * 2、在创建好的module中注册service
 *
 */
define(["tiny-lib/jquery", "tiny-lib/angular"], function($, angular) {

    var MODULE_NAME = "framework";

    var launcherDtd = $.Deferred();

    var loadModuleDeps = function(angular) {

        var dtd = $.Deferred();

        require(["tiny-directives/Directive",
                "ui-router/angular-ui-router.min",
                "lib/utils/stateEvents",
                "ibase/ibase",
                "app/framework/base/configures/frameworkRouterConfig",
                "app/business/recoverydirector/setting/configures/routerConfig",
                "app/business/recoverydirector/home/configures/routerConfig",
                "app/business/recoverydirector/protection/configures/routerConfig",
                "app/business/recoverydirector/recovery/configures/routerConfig",
                "app/business/recoverydirector/monitor/configures/routerConfig",
                "app/business/recoverydirector/site/configures/routerConfig"
            ],
            function(wcc, router, stateEvents, platform, frmRouter, settingsRouter, homeRouter, protectionRouter, recoveryRouter, rdMonitorRouter, siteRouter) {

                var deps = ["ng", "wcc", "ui.router", "ui.router.state.events", "ui.platform", frmRouter.name, settingsRouter.name, homeRouter.name, protectionRouter.name, recoveryRouter.name, rdMonitorRouter.name, siteRouter.name];

                var frmModule = angular.module(MODULE_NAME, deps);

                dtd.resolve(frmModule);
            },
            function(err) {

                throw new Error("RD UI System create module <framework> failed. cause by " + err);

                dtd.reject(undefined);
            }
        );

        return dtd.promise();
    };

    var publishService = function(module) {

        var dtd = $.Deferred();

        if (!module) {
            throw new Error("RD UI System register service failed. cause by module is empty.");
            dtd.reject(undefined);
            return dtd.promise();
        }

        require(["app/services/maskService",
                "app/services/i18nService",
                "app/services/exceptionService",
                "app/services/msgService",
                "app/services/constsService",
                "app/services/appUtilsService",
                "app/services/treeTableRenderService",
                "app/services/statusEnumService",
                "app/services/securityService",
                "app/services/restService",
                "app/services/modelService",
                "app/services/servicePlugins",
                "app/services/recoveryService",
                "app/services/widgetService",
                "app/services/createTopoService"
            ],
            function(maskService, i18nService, exceptionService, msgService, constsService, appUtilsService, treeTableRenderService, statusEnumService, securityService, restService, modelService, servicePlugins, recoveryService, widgetService, createTopoService) {

                var secHolder = new securityService(module);
                $.when(new i18nService(module).load(), secHolder.load()).then(function() {

                    secHolder.register();

                    module.service("mask", maskService);
                    module.service("exception", exceptionService);
                    module.service("message", msgService);
                    module.service("constsService", constsService);
                    module.service("appUtils", appUtilsService);
                    module.service("servicesPlugin", servicePlugins);
                    module.service("restService", restService);
                    module.service("treeTableRenderService", treeTableRenderService);
                    module.service("statusEnumService", statusEnumService);
                    module.service("recoveryService", recoveryService);
                    module.service("widgetService", widgetService);
                    module.service("model", modelService);
                    module.service("topoService", createTopoService);

                    dtd.resolve(module);
                });
            },
            function(err) {
                throw new Error("RD UI System register service failed, cause by " + err);
                dtd.reject();
            }
        );

        return dtd.promise();

    };

    function publishDirective(module) {

        var dtd = $.Deferred();

        if (!module) {
            throw new Error("RD UI System register directive failed. cause by module is empty");
            dtd.reject(undefined);
            return dtd.promise();
        }

        require(["lib/tiny-extra/directives/Directives"],
            function(directives) {
                module.directive(directives);
            },
            function(err) {
                throw new Error("RD UI System register directive failed, cause by " + err);
                dtd.reject();
            }
        );

        return dtd.promise();
    }

    /**
     * 向tiny的UnifyValid添加自定义的校验方法
     * @return {[boolean]} true表示通过，false表示不通过
     */
    function extendUnifyValid() {
        var _is_non_input = function(val) {
            if (!val && val !== 0) {
                return true;
            }

            return val.length === 0;
        }

        window.tinyWidget.UnifyValid.addFunction({
            "notEqual": function(paras) {
                var value = $(this).val();
                return value != paras;
            },
            "isScript": function(param) {
                var reg = /^[a-zA-Z0-9_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\w-_]*[\.]{1}(bat|sh){1}$/;
                var value = $(this).val();
                if (_is_non_input(value)) {
                    return true;
                }
                return reg.test(value);
            },
            "ipv4Standard": function(params) {
                var reg = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/;
                var value = $(this).val();
                if (_is_non_input(value)) {
                    return true;
                }

                var ipArray = value.split(".");
                if (ipArray.length == 4) {
                    if (ipArray[0] == "0" || ipArray[0] == "127" || ipArray[3] == "0") {
                        return false;
                    }
                }
                return reg.test(value);
            }
        })

    }
    /**
     * 使用jQuery的Deferred对象来控制，只有注册完了service之后才返回成功
     */
    $.when(loadModuleDeps(angular)).then(function(module) {
        $.when(publishService(module)).then(publishDirective(module)).then(function(module) {
            launcherDtd.resolve(module);
            extendUnifyValid();
        }, function() {
            launcherDtd.reject();
        })
    }, function(err) {
        launcherDtd.reject();
    });

    return launcherDtd.promise();

});
