define(["tiny-lib/jquery", "tiny-lib/underscore", "tiny-common/UnifyValid"], function($, _, UnifyValid) {
    "use strict";
    var Base = {
        edit: function(obj) {
            var that = this;
            that.restService.getRecoveryByUuidInfo(obj.planId, function(data) {
                var buttons = [{
                    key: "ok",
                    label: that.appUtils.getString("common_term_confirm_button"),
                    focused: true,
                    handler: function(event) {
                        if (!UnifyValid.FormValid($("#editRecoveryPlanDiv"), { focusInvalid: true })) {
                            return;
                        }
                        that.restService.updateRecoveryInfo(data.uuid, {
                            "data": {
                                name: $.trim($("#planName").widget().getValue()),
                                description: $.trim($("#description").widget().getValue()),
                                planType: $.trim($("#" + that.constsService.EDIT_RECOVERY.winId).widget().option("data").planType)
                            },
                            "success": function(data) {
                                //发广播更新当前选中行的数据
                                obj.$scope.$emit("recoveryExecute", obj.planId);
                                //发广播更新Tab页信息
                                obj.$scope.$broadcast(that.constsService.RECOVERY_TAB, obj);
                                that.message.success({
                                    content: that.appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $("#" + that.constsService.EDIT_RECOVERY.winId).widget().destroy();
                                    }
                                })
                            }
                        })
                    }
                }, {
                    key: "cancel",
                    label: that.appUtils.getString("common_term_cancel_button"),
                    focused: false,
                    handler: function(event) {
                        $("#" + that.constsService.EDIT_RECOVERY.winId).widget().destroy();
                    }
                }]
                that.utils.openWin(that.constsService.EDIT_RECOVERY.winId, that.appUtils.getString(that.constsService.EDIT_RECOVERY.title),
                    data, that.constsService.EDIT_RECOVERY.width, that.constsService.EDIT_RECOVERY.height, that.constsService.EDIT_RECOVERY.url, buttons);
            })
        },
        del: function(obj) {
            var that = this;
            that.message.warn({
                content: that.appUtils.getString("recovery_messsage_delete_warn_tips", obj.name),
                ok: function() {
                    that.restService.deleteRecovery(obj.planId, function(response) {
                        //删除显示有更多的div浮动层
                        $("#recoveryTable .OpButton_main").hide();
                        //发广播更新当前选中行的数据
                        obj.$scope.$emit("recoveryExecute");
                        that.message.success(that.appUtils.getString("common_term_operation_success_label"));
                    })
                }
            })
        },
        reprotect: function(obj) {
            var that = this;
            if (_.contains([30,31,32], parseInt(obj.templateType,10))) {
                var wizardWin = angular.copy(that.constsService.WIZARD_WIN);
                wizardWin.data = {
                    steps: [{
                        content: that.appUtils.getString("recovery_messsage_reprotect_confirm_tips_1", obj.name) + "<br>"
                                + that.appUtils.getString("recovery_messsage_reprotect_confirm_tips_2")
                    }, {
                        content: obj.poType == 11 ? that.appUtils.getString("recovery_reprotect_lunwarninfo_step2_label")
                            : that.appUtils.getString("recovery_reprotect_warninfo_step2_label")
                    }],
                    finish: function() {
                        that.restService.reprotectRecovery(obj.planId, {
                            "data": {
                                isReserved: true
                            },
                            "success": function(response) {
                                !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                                //发广播更新当前选中行的数据
                                obj.$scope.exec = true;
                                obj.$scope.$emit("recoveryExecute", obj.planId);
                                that.message.success({
                                    content: that.appUtils.getString("common_term_command_send_success_label"),
                                    ok: function() {
                                        $("#" + that.constsService.REPROTECT_RECOVERY.winId).widget().destroy();
                                        obj.$state.go("dataUse.dataRecovery.procedure");
                                    }
                                });
                            }
                        })
                    }
                }
                that.appUtils.showWindow(wizardWin);
                return;
            }
            var buttons = [{
                key: "ok",
                label: that.appUtils.getString("common_term_confirm_button"),
                focused: false,
                handler: function(event) {
                    var params = {
                        isReserved: $("#reprotectCheckBox").widget().option("checked")
                    };
                    (_.contains([25, 34, 37], +obj.templateType) || obj.serviceInstanceType == "replication") && _.extend(params, {
                        region_id: obj.props.regionName,
                        az_id: obj.props.zoneName
                    });
                    that.restService.reprotectRecovery(obj.planId, {
                        "data": params,
                        "success": function(response) {
                            !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                            //发广播更新当前选中行的数据
                            obj.$scope.exec = true;
                            obj.$scope.$emit("recoveryExecute", obj.planId);
                            that.message.success({
                                content: that.appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    $("#" + that.constsService.REPROTECT_RECOVERY.winId).widget().destroy();
                                    obj.$state.go("dataUse.dataRecovery.procedure");
                                }
                            });
                        }
                    })
                }
            }, {
                key: "cancel",
                label: that.appUtils.getString("common_term_cancel_button"),
                focused: true,
                handler: function(event) {
                    $("#" + that.constsService.REPROTECT_RECOVERY.winId).widget().destroy();
                }
            }];
            var height = 300,
                width = 350;
            _.contains([30,31,32,35,36,26,27], parseInt(obj.templateType,10)) && (height = 235)
            if ((obj.serviceInstanceType == "replication" && obj.templateType == 22) || _.contains([25, 34, 37], +obj.templateType)) {
                height = 300;
            };
            if (that.cookieService.get("language") == "en") {
                height = 330;
                width = 370;
                _.contains([30,31,32,35,36,26,27], parseInt(obj.templateType,10)) && (height = 265)
                if ((obj.serviceInstanceType == "replication" && obj.templateType == 22) || _.contains([25, 34, 37], +obj.templateType)) {
                    height = 320;
                }
            }
            if((obj.serviceInstanceType == "replication" && obj.templateType == 22) || obj.templateType == 34){
                that.restService.getRecoveryProtectObjectInfo([obj.planId], function(result){
                    var bmsFlag = false;
                    if(!_.isEmpty(result.records)){
                        $.each(result.records, function(index, po){
                            if(po.props.vm_type == "BMS"){
                                bmsFlag = true;
                                return false;
                            }
                        });
                    };
                    obj.bmsFlag = bmsFlag;
                    that.utils.openWin(that.constsService.REPROTECT_RECOVERY.winId, that.appUtils.getString(that.constsService.REPROTECT_RECOVERY.title),
                        obj, width, height, that.constsService.REPROTECT_RECOVERY.url, buttons);
                });
                return;
            };

            that.utils.openWin(that.constsService.REPROTECT_RECOVERY.winId, that.appUtils.getString(that.constsService.REPROTECT_RECOVERY.title),
                obj, width, height, that.constsService.REPROTECT_RECOVERY.url, buttons);
        },
        clear: function(obj) {
            var that = this;
            var contentMess = "recovery_messsage_clear_confirm_tips";
            //Oracle、DB2、SQLSERVER、SAPHANA 、Cachē、Exchange
            if(_.contains([1,2,3,8,15,16], parseInt(obj.poType))){
                contentMess = "recovery_messsage_database_clear_confirm_tips";
            };
            if (obj.PROVIDER_TYPE == "FusionSphereOpenstack") {
                contentMess = "recovery_messsage_openstackClear_confirm_tips";
            }
            //SAN双活清理提示
            if(obj.templateType == 15){
                contentMess = "recovery_san_hypermetro_clear_label"
            }
            that.message.tipPrompt({
                content: that.appUtils.getString(contentMess, obj.name),
                width: "330px",
                ok: function() {
                    function sendMsg() {
                        !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                        //发广播更新当前选中行的数据
                        obj.$scope.exec = true;
                        obj.$scope.$emit("recoveryExecute", obj.planId);
                        that.message.success({
                            content: that.appUtils.getString("common_term_command_send_success_label"),
                            ok: function() {
                                obj.$state.go("dataUse.dataRecovery.procedure");
                            }
                        });
                    }
                    if (obj.planType == 1) {
                        that.restService.localClearRecovery(obj.planId, function(response) {
                            sendMsg();
                        });
                    } else {
                        that.restService.remoteClearRecovery(obj.planId, function(response) {
                            sendMsg();
                        });
                    };
                }
            });
        },
        running: function(obj) {
            var that = this;
            var buttons = [{
                key: "ok",
                label: that.appUtils.getString("ism.drm.protect.group.rollback.recovery.label"),
                focused: true,
                handler: function(event) {
                    var data = _.first($("#replicaTable").widget().getTableCheckedItems());
                    if (_.isEmpty(data) || _.isUndefined(data)) {
                        that.message.error(that.appUtils.getString("recovery.term.test.replica.message.least"));
                        return;
                    }

                    var rollbackTips = parseInt(obj.poType, 10) === 11 ?
                        that.appUtils.getString("lun_recovery_messsage_rollback_confirm_tips", obj.name, data.timeStamp):
                        that.appUtils.getString("recovery_messsage_rollback_confirm_tips", obj.name, data.timeStamp);

                    //VMware
                    if (+obj.poType == 10) {
                        rollbackTips = that.appUtils.getString("recovery_wmware_rollbackwarn_label", obj.name, data.timeStamp);
                        //VMware NAS快照
                        if (_.contains([14, 17, 28], +obj.templateType)) {
                            rollbackTips = that.appUtils.getString("recovery_messsage_vmware_rollback_confirm_tips", obj.name, data.timeStamp);
                        }
                    }

                    //Oracle、DB2、SQLSERVER、SAPHANA 、Cachē、Exchange
                    if(_.contains([1,2,3,8,15,16], parseInt(obj.poType))){
                        rollbackTips = that.appUtils.getString("recovery_messsage_database_rollback_confirm_tips", obj.name, data.timeStamp)
                    };
                    var _sendReq = function(data) {
                        that.message.warn({
                            content: rollbackTips,
                            ok: function() {
                                var params = {
                                    uuid: obj.planId,
                                    replicaId: data.id,
                                    disasterSiteId: data.recoverySiteId,
                                };

                                //回滚速率设置
                                var speedInputWidget = $("#input_" + data.id).widget();
                                if(!_.isEmpty(speedInputWidget) && data.type != 101){
                                    _.extend(params, {restoreSpeed: speedInputWidget.getSelectedId()});
                                };

                                that.restService.localRunningRecovery(params, function(response) {
                                    !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                                    //发广播更新当前选中行的数据
                                    obj.$scope.exec = true;
                                    obj.$scope.$emit("recoveryExecute", obj.planId);
                                    that.message.success({
                                        content: that.appUtils.getString("common_term_command_send_success_label"),
                                        ok: function() {
                                            $("#" + that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId).widget().destroy();
                                            obj.$state.go("dataUse.dataRecovery.procedure");
                                        }
                                    })
                                })
                            }
                        });
                    };
                    obj.name = that.appUtils.encodeForHTML(obj.name);
                    data.timeStamp = that.appUtils.encodeForHTML(data.timeStamp);
                    var confirmRunning = function(diff) {
                        if (diff.length > 0) {
                            that.message.warn({
                                content: that.appUtils.getString("recovery_protectedObj_not_same_tips"),
                                ok: function() {
                                    _sendReq(data);
                                }
                            });
                            return;
                        }
                        _sendReq(data);
                    }
                    that.compareProtectedObject(data.id, obj.uuid, obj.protectUuid, confirmRunning);
                }
            }, {
                key: "cancel",
                label: that.appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId).widget().destroy();
                }
            }];
            if (that.appUtils.isEn()) {
                that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.width = 850;
            } else {
                that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.width = 810;
            }
            that.utils.openWin(that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId, that.appUtils.getString(that.constsService.LOCAL_TEST_EXCUTE_WIN_TITLE.excute),
                _.extend(obj, { operateType: "running" }), that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.width, that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.height,
                that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.url, buttons);
        },
        localTest: function(obj) {
            var that = this;
            var buttons = [{
                key: "ok",
                label: that.appUtils.getString("ism.drm.drp.auth.test"),
                focused: true,
                handler: function(event) {
                    var data = _.first($("#replicaTable").widget().getTableCheckedItems());
                    if (_.isEmpty(data) || _.isUndefined(data)) {
                        that.message.error(that.appUtils.getString("recovery.term.test.replica.message.least"));
                        return;
                    }
                    var hostSn = $("#hostGroup").widget().getSelectedId();
                    if (_.isEmpty(hostSn) || "-1" === hostSn) {
                        that.message.error(that.appUtils.getString("recovery.term.recovery.unusedHost.message.least"));
                        return;
                    }

                    function _sendAjax() {
                        var params = {
                            uuid: obj.planId,
                            replicaId: data.id,
                            productSiteId: data.recoverySiteId,
                            disasterHostSn: hostSn
                        };
                        that.restService.localRecoveryTest(params, {
                            data: {},
                            success: function() {
                                !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                                //发广播更新当前选中行的数据
                                obj.$scope.exec = true;
                                obj.$scope.$emit("recoveryExecute", obj.planId);
                                that.message.success({
                                    content: that.appUtils.getString("common_term_command_send_success_label"),
                                    ok: function() {
                                        $("#" + that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId).widget().destroy();
                                        obj.$state.go("dataUse.dataRecovery.procedure");
                                    }
                                });
                            }
                        });
                    };

                    function confirmTest(diff) {
                        if (diff.length > 0) {
                            that.message.warn({
                                content: that.appUtils.getString("test_protectedObj_not_same_tips"),
                                ok: function() {
                                    _sendAjax();
                                }
                            });
                            return;
                        };
                        _sendAjax();
                    }

                    //VMware
                    if (+obj.poType == 10) {
                        that.message.warn({
                            content: that.appUtils.getString("recovery_wmware_localTestwarn_label", obj.name),
                            ok: function() {
                                _sendAjax();
                            }
                        });
                    } else {
                        that.compareProtectedObject(data.id, obj.uuid, obj.protectUuid, confirmTest);
                    }
                }
            }, {
                key: "cancel",
                label: that.appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId).widget().destroy();
                }
            }];

            if (that.appUtils.isEn()) {
                that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.width = 820;
            } else {
                that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.width = 800;
            }
            that.utils.openWin(that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.winId, that.appUtils.getString(that.constsService.LOCAL_TEST_EXCUTE_WIN_TITLE.test),
                _.extend(obj, { operateType: "localTest" }), that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.width, that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.height,
                that.constsService.LOCAL_TEST_EXCUTE_RECOVERY.url, buttons);
        },
        sanHypermetroTest: function(obj){
            var that = this;
            var buttons = [{
                label : that.appUtils.getString("common_term_test_button"),
                handler : function(){
                    var checkedItem = $("#localRadio").widget().option("checked") ? $("#localRadio").widget().option("value") : $("#remoteRadio").widget().option("value");
                    that.message.warn({
                        content: that.appUtils.getString("recovery_san_hypermetro_test_excute_warn_label", obj.name),
                        ok: function(){
                            that.restService.remoteRecoveryTest([obj["planId"]],{
                                data: {priorityStationType: checkedItem},
                                mask: true,
                                success: function(){
                                    !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                                    obj.$scope.exec = true;
                                    obj.$scope.$emit("recoveryExecute", obj.planId);
                                    that.message.success({
                                        content: that.appUtils.getString("common_term_command_send_success_label"),
                                        ok: function(){
                                            $("#"+that.constsService.SAN_HYPERMETRO_TEST_WIN.winId).widget().destroy();
                                            obj.$state.go("dataUse.dataRecovery.procedure");
                                        }
                                    })
                                },
                                callback: function(){}
                            })
                        }
                    })
                }
            }, {
                label : that.appUtils.getString("common_term_cancel_button"),
                handler : function(){
                    $("#" + that.constsService.SAN_HYPERMETRO_TEST_WIN.winId).widget().destroy();
                }
            }];
            that.utils.openWin(that.constsService.SAN_HYPERMETRO_TEST_WIN.winId,that.appUtils.getString(that.constsService.SAN_HYPERMETRO_TEST_WIN.title),
                obj,that.constsService.SAN_HYPERMETRO_TEST_WIN.width, that.constsService.SAN_HYPERMETRO_TEST_WIN.height,
                that.constsService.SAN_HYPERMETRO_TEST_WIN.content,buttons)
        },
        nasSwitchover: function(obj){
            var that = this;
            var buttons = [{
                label : that.appUtils.getString("common_term_confirm_button"),
                handler : function(){
                    that.restService.switchNasRecovery([obj["planId"]],{
                        mask: true,
                        success: function(){
                            !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[obj.uuid];
                            obj.$scope.exec = true;
                            obj.$scope.$emit("recoveryExecute", obj.planId);
                            that.message.success({
                                content: that.appUtils.getString("common_term_command_send_success_label"),
                                ok: function(){
                                    $("#"+that.constsService.NAS_HYPERMETRO_SWITCH_WIN.winId).widget().destroy();
                                    obj.$state.go("dataUse.dataRecovery.procedure");
                                }
                            })
                        },
                        callback: function(){}
                    })
                }
            }, {
                label : that.appUtils.getString("common_term_cancel_button"),
                handler : function(){
                    $("#" + that.constsService.NAS_HYPERMETRO_SWITCH_WIN.winId).widget().destroy();
                }
            }];
            that.utils.openWin(that.constsService.NAS_HYPERMETRO_SWITCH_WIN.winId,that.appUtils.getString(that.constsService.NAS_HYPERMETRO_SWITCH_WIN.title),
                obj,that.constsService.NAS_HYPERMETRO_SWITCH_WIN.width, that.constsService.NAS_HYPERMETRO_SWITCH_WIN.height,
                that.constsService.NAS_HYPERMETRO_SWITCH_WIN.content,buttons);
        },
        oracleProSetting: function(obj) {
            var that = this;

            var buttons = [{
                key: "ok",
                label: that.appUtils.getString("common_term_confirm_button"),
                focused: true,
                handler:function(event) {
                    var oracleParams = [];
                    var startTableData = $("#oracleStartOrderTable").widget().getTableData();
                    if(_.isEmpty(startTableData)) {
                        that.message.error(that.appUtils.getString("recovery.protectobj.validation.msg"));
                        return;
                    };

                    $.each(startTableData, function(index, data) {
                        var isStartMap = { "name": "isStart" },
                            startOrderMap = { "name": "startOrder" },
                            PDBMap = {"name": "PDB"};

                        if(data.props.IS_CDB == "1") {
                            data.props.PDB = _.filter(data.props.PDB, function(child){
                                if(_.has(child, "type")) {
                                    return child.type == "PDB";
                                } else {
                                    return data.props.PDB;
                                }
                            });
                        };

                        isStartMap.uuid = data.uuid;
                        isStartMap.value = $("#isCDBStart_" + data.uuid).widget().getSelectedId() == "0";
                        if(!_.isEmpty(data.props.PDB)) {
                            var modifiedPDBs = [];
                            var cachePDBs;
                            if($('select[id^=' + data.uuid + ']').length == 0) {
                                var isCDBStarted = $('#isCDBStart_' + data['uuid']).widget().getSelectedId();
                                $.each(data.props.PDB, function(m, child) {
                                    modifiedPDBs.push({
                                        "conID": child.conID,
                                        "pdbName": child.pdbName,
                                        "isStart": isCDBStarted == 0 ? child.isStart : false
                                    })
                                });
                                PDBMap.value = JSON.stringify(modifiedPDBs);
                            } else {
                                var modifiedPDBs = [];
                                $.each(data.props.PDB, function(n, pdb) {
                                    if(_.isEmpty($.trim(pdb.isStart))) {
                                        pdb.isStart = true;
                                    };
                                    if($('select[id^=' + data.uuid + ']').length !=0 ) {
                                        $.each($('select[id^=' + data.uuid + ']'), function(m, child) {
                                            var conID = $(child).attr("id").split("_")[1];
                                            if(conID == pdb.conID) {
                                                pdb.isStart = $(child).val() == 0;
                                            };
                                        });
                                    };

                                    modifiedPDBs.push({
                                        "conID": pdb.conID,
                                        "pdbName": pdb.pdbName,
                                        "isStart": pdb.isStart
                                    });
                                });
                                PDBMap.value = JSON.stringify(modifiedPDBs);
                            }
                            PDBMap.uuid = data.uuid;
                            oracleParams.push(PDBMap);
                        };
                        if (isStartMap.value) {
                            startOrderMap.uuid = data.uuid;
                            startOrderMap.value = $("#startOrder_" + data.uuid).widget().option("value");
                            oracleParams.push(startOrderMap);
                        };
                        oracleParams.push(isStartMap);
                    });

                    var _content = that.appUtils.getString("ism.drm.drp.modify.setting.msg1") + "</br>" + that.appUtils.getString("ism.drm.drp.modify.setting.msg2") + "</br>" + that.appUtils.getString("ism.drm.drp.modify.setting.msg3");
                    that.message.warn({
                        content: _content,
                        ok: function() {
                            that.restService.setProObjectStartSetting(obj.uuid, {
                                "data": oracleParams,
                                "success": function(result) {
                                    that.message.success({
                                        content: that.appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            $("#" + that.constsService.ORACLE_PROSTART_SETTING_WIN.winId).widget().destroy();
                                            obj.$scope.$broadcast("ORACLE_RECOVERY_TAB");
                                        }
                                    });
                                }
                            })
                        }
                    });
                }
            },{
                key: "cancel",
                label: that.appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + that.constsService.ORACLE_PROSTART_SETTING_WIN.winId).widget().destroy();
                }
            }];
            that.utils.openWin(that.constsService.ORACLE_PROSTART_SETTING_WIN.winId,
                that.appUtils.getString(that.constsService.ORACLE_PROSTART_SETTING_WIN.title), obj, 760, 640, that.constsService.ORACLE_PROSTART_SETTING_WIN.url, buttons);
        },
        proStartSetting: function(obj) {
            var that = this;
            var openStackFlag = obj.poType == 12 && obj.PROVIDER_TYPE == "FusionSphereOpenstack";
            var width;
            openStackFlag ? width = 720 : width = 600;

            var buttons = [{
                key: "ok",
                label: that.appUtils.getString('common_term_confirm_button'),
                focused: true,
                handler: function(event) {
                    var params = [];
                    var tableDatas = $("#startOrderTable").widget().getTableData();
                    if (_.isEmpty(tableDatas)) {
                        that.message.error(that.appUtils.getString("recovery.protectobj.validation.msg"));
                        return;
                    }
                    _.each(tableDatas, function(data, index) {
                        var isStartMap = { "name": "isStart" },
                            startOrderMap = { "name": "startOrder" },
                            needRecoveryMap = { "name": "needRecovery" },
                            placeholdvmId = { "name": "PLACEHOLDVM" },
                            placeholdvmName = { "name": "PLACEHOLDVMNAME" };

                        isStartMap.uuid = data.uuid;
                        placeholdvmId.uuid = data.uuid;
                        placeholdvmName.uuid = data.uuid;
                        isStartMap.value = $("#isStart_" + data.uuid).widget().getSelectedId() == 0;
                        if (isStartMap.value) {
                            startOrderMap.uuid = data.uuid;
                            startOrderMap.value = $("#startOrder_" + data.uuid).widget().option("value");
                            params.push(startOrderMap);
                        }
                        if (openStackFlag) {
                            //如果为openstack虚拟机，增加设置占位虚拟机信息。
                            if (typeof $("#placeholder_" + data.uuid).widget().getSelectedId == "function" && typeof $("#placeholder_" + data.uuid).widget().getSelectedLabel == "function") {
                                placeholdvmId.value = $("#placeholder_" + data.uuid).widget().getSelectedId();
                                placeholdvmName.value = $("#placeholder_" + data.uuid).widget().getSelectedLabel();
                                if (placeholdvmId.value != "-1") {
                                    params.push(placeholdvmId);
                                    params.push(placeholdvmName);
                                }
                            } else {
                                var placeholdvmSpecial = $("#placeholder_" + data.uuid).widget().option("values");
                                placeholdvmName.value = $("#placeholder_" + data.uuid).widget().getValue();
                                var placeholdvmIdFrom = _.where(placeholdvmSpecial, { label: placeholdvmName.value });
                                placeholdvmId.value = _.isEmpty(placeholdvmIdFrom) ? "-1" : placeholdvmIdFrom[0].selectId;
                                if (placeholdvmId.value != "-1") {
                                    params.push(placeholdvmId);
                                    params.push(placeholdvmName);
                                }
                            }
                        }
                        params.push(isStartMap);
                    });
                    if (openStackFlag) {
                        var vmVal = [];
                        _.each(_.filter(params, function(val) {
                            return val.name == "PLACEHOLDVM" }), function(val) {
                            vmVal.push(val.value)
                        });
                        //如果设置的与需要设置的虚拟机不相等则表明有虚拟机未设置，需给出错误提示。
                        if (vmVal.length != tableDatas.length) {
                            that.message.error(that.appUtils.getString("placeholder_vms_set_not_msg"));
                            return;
                        }
                        if (_.uniq(vmVal).length != vmVal.length) {
                            that.message.error(that.appUtils.getString("placeholder_vms_set_wrong_msg"));
                            return;
                        }
                    };
                    var _content = that.appUtils.getString("ism.drm.drp.modify.setting.msg1") + "</br>" + that.appUtils.getString("ism.drm.drp.modify.setting.msg2") + "</br>" + that.appUtils.getString("ism.drm.drp.modify.setting.msg3");

                    that.message.warn({
                        content: _content,
                        ok: function() {
                            that.restService.setProObjectStartSetting(obj.uuid, {
                                "data": params,
                                "success": function(result) {
                                    that.message.success({
                                        content: that.appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            $("#" + that.constsService.START_SETTING_WIN.winId).widget().destroy();
                                            obj.$scope.$broadcast("RECOVERY_TAB");
                                        }
                                    });
                                }
                            })
                        }
                    });
                }
            }, {
                key: "cancel",
                label: that.appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function(event) {
                    $("#" + that.constsService.START_SETTING_WIN.winId).widget().destroy();
                }
            }];
            that.utils.openWin(that.constsService.START_SETTING_WIN.winId,
                that.appUtils.getString(that.constsService.START_SETTING_WIN.title), obj, width, 500, that.constsService.START_SETTING_WIN.url, buttons);
        },
        editProcess: function(obj) {
            var that = this;
            var buttons = [{
                label: that.appUtils.getString("common_term_close_button"),
                key: "cancle",
                focused: true,
                handler: function(event) {
                    var isApplied;
                    if(!_.isUndefined(that.infoTransferredService.get("recoveryStep", "isStepApplied"))) {
                        isApplied = that.infoTransferredService.get("recoveryStep", "isStepApplied");
                        that.infoTransferredService.remove("recoveryStep", "isStepApplied");
                    }
                    if(isApplied == false) {
                        that.message.confirm({
                            content: that.appUtils.getString("recoveryStep_term_cancelEdit_warn"),
                            ok:function () {
                                $("#" + that.constsService.EDIT_STEP_WIN.winId).widget().destroy();
                            },
                            cancel:function(){
                                that.infoTransferredService.put("recoveryStep", "isStepApplied", isApplied);
                            }
                        })
                    } else {
                        $("#" + that.constsService.EDIT_STEP_WIN.winId).widget().destroy();
                    }

                }
            }];
            var closeIcon = function(){
                var isApplied;
                var isAllowClose = false;
                if(!_.isUndefined(that.infoTransferredService.get("recoveryStep", "isStepApplied"))) {
                    isApplied = that.infoTransferredService.get("recoveryStep", "isStepApplied");
                    that.infoTransferredService.remove("recoveryStep", "isStepApplied");
                }
                if(isApplied == false) {
                    that.message.confirm({
                        content: that.appUtils.getString("recoveryStep_term_cancelEdit_warn"),
                        ok:function () {
                            $("#" + that.constsService.EDIT_STEP_WIN.winId).widget().destroy();
                        },
                        cancel:function(){
                            isAllowClose = false;
                            that.infoTransferredService.put("recoveryStep", "isStepApplied", isApplied);
                        }
                    })
                } else {
                    isAllowClose = true;
                }
                return isAllowClose;
            }
            that.utils.openWin(that.constsService.EDIT_STEP_WIN.winId, that.appUtils.getString(that.constsService.EDIT_STEP_WIN.title), obj,
                that.constsService.EDIT_STEP_WIN.width, that.constsService.EDIT_STEP_WIN.height, that.constsService.EDIT_STEP_WIN.url, buttons, null, closeIcon);

        },
        hotMigration: function(obj) {
            var that = this;
            that.message.warn({
                content: that.appUtils.getString("recovery_messsage_plan_hotMigration_confirm_tips", obj.name),
                ok: function() {
                    that.restService.hotMigration(obj.planId, {
                        data: {
                            region_id: obj.props.regionName,
                            az_id: obj.props.zoneName
                        },
                        success: function(data) {
                            that.message.success({
                                content: that.appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    obj.$state.go("dataUse.dataRecovery.procedure");
                                }
                            });
                        }
                    })
                }
            })
        }
    };
    return _.extend(Base);
})
