define(["tiny-lib/jquery", "tiny-lib/underscore", "./base", "tiny-common/UnifyValid"], function ($, _, Base, UnifyValid) {
    "use strict";

    var FusionSphere = {
        networkSetFusionCompute: function(params) {
            var that = this;
            that.utils.openWin(that.constsService.HUAWEI_VM_IP_WIN.winId, that.appUtils.getString(that.constsService.HUAWEI_VM_IP_WIN.title),
                params, that.constsService.HUAWEI_VM_IP_WIN.width, that.constsService.HUAWEI_VM_IP_WIN.height, that.constsService.HUAWEI_VM_IP_WIN.url);
        },
        networkSetFusionManager : function(params) {
            var that = this;
            if("zh" === that.cookieService.get("language") || "zh_CN" === that.cookieService.get("language")) {
                that.constsService.FM_VM_IP_WIN.width = "650px";
            };
            that.utils.openWin(that.constsService.FM_VM_IP_WIN.winId, that.appUtils.getString(that.constsService.FM_VM_IP_WIN.title),
                params, that.constsService.FM_VM_IP_WIN.width, that.constsService.FM_VM_IP_WIN.height, that.constsService.FM_VM_IP_WIN.url);
        },
        networkSetFusionSphereOpenstack : function (params) {
            var that = this;
            that.utils.openWin(that.constsService.OPENSTACK_SET_TEST_NETWORK_WIN.winId,that.appUtils.getString(that.constsService.OPENSTACK_SET_TEST_NETWORK_WIN.title),
                params,that.constsService.OPENSTACK_SET_TEST_NETWORK_WIN.width,that.constsService.OPENSTACK_SET_TEST_NETWORK_WIN.height,that.constsService.OPENSTACK_SET_TEST_NETWORK_WIN.content,
                null,"fmIpSetWinId")
        },
        test: function(params) {
            var that = this;
            if(params.PROVIDER_TYPE == "FusionSphereOpenstack") {
                that.restService.getRecoveryProtectObjectInfo({uuid:params.planId},function(result){
                    if(_.isEmpty(result.records[0].props.PLACEHOLDVMNAME)){
                        params.$scope.exec = true;
                        params.$scope.$emit("recoveryExecute", "true"+params.planId);
                        that.message.confirm({
                            content: that.appUtils.getString("recovery_messsage_confirm_set_placeholdvm"),
                            ok:function(){
                                if(params.$state.current.name == "dataUse.dataRecovery.protected"){
                                    that.execute(_.extend(params,{
                                        action: "proStartSetting"
                                    }))
                                }else{
                                    params.$state.go("dataUse.dataRecovery.protected");
                                    that.infoTransferredService.put("OpenWinModule","isOpenWin",true);
                                }
                            }
                        })
                    } else {
                        that.message.warn({
                            content: that.appUtils.getString("recovery_messsage_openstackRemote_test_confirm_tips", params.name),
                            ok : function(){
                                that.restService.remoteRecoveryTest(params.planId,{
                                    "data":{},
                                    "success":function(data) {
                                        !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                                        //发广播更新当前选中行的数据
                                        params.$scope.exec = true;
                                        params.$scope.$emit("recoveryExecute", params.planId);
                                        that.message.success({
                                            content: that.appUtils.getString("common_term_command_send_success_label"),
                                            ok: function() {
                                                params.$state.go("dataUse.dataRecovery.procedure");
                                            }
                                        });
                                    }
                                })
                            }
                        });
                    }
                });

                return;
            };

            that.utils.openWin("fusionSphere3dcExcuteWin", that.appUtils.getString("common_term_test_button"),
            _.extend(params, {operateType: "test"}), 752, 650, "app/business/recoverydirector/recovery/views/operate/fusionSphere3dcExecute.html", []);
        },
        move: function(params) {
            var that = this;
            function remoteRecoveryPlannedMigration(msg, datas, callback) {
                that.message.warn({
                    content: msg,
                    ok: function () {
                        that.restService.remoteRecoveryPlannedMigration(params.planId, {
                            "data": datas || {},
                            "success": function () {
                                !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                                //发广播更新当前选中行的数据
                                params.$scope.exec = true;
                                params.$scope.$emit("recoveryExecute", params.planId);
                                that.message.success({
                                    content: that.appUtils.getString("common_term_command_send_success_label"),
                                    ok: function () {
                                        _.isFunction(callback) && callback();
                                        params.$state.go("recovery.procedure");
                                    }
                                });
                            }
                        })
                    }
                })
            }
            var instanceRegion = {
                region_id: params.props.regionName,
                az_id: params.props.zoneName,
                is_confirm_reprotection : params.supportConfirmReprotection
            };
            if(params.PROVIDER_TYPE == "FusionSphereOpenstack") {
                var msg = that.appUtils.getString("recovery_messsage_plan_openstackMove_confirm_tips", params.name);
                if (params.supportConfirmReprotection) {
                    msg = that.appUtils.getString("recovery_plan_switchover_paused_warn_label", params.name);
                }
                if (params.serviceInstanceType == "replication" || _.contains([25, 34, 37], params.templateType)) {
                    msg = that.appUtils.getString("recovery_messsage_plan_instanceMove_confirm_tips", params.name);
                    if (params.supportConfirmReprotection) {
                        msg = that.appUtils.getString("recovery_plan_switchover_paused_warn_label", params.name);
                    }
                    if(params.serviceInstanceType == "replication" || params.templateType == 34) {
                        //csdr包括ecs和bms需要区分描述信息,需要查询保护对象加以区分
                        that.restService.getRecoveryProtectObjectInfo([params.planId], function(result){
                            if(!_.isEmpty(result.records)){
                                var bmsFlag = false;
                                $.each(result.records, function(index, po){
                                    if(po.props.vm_type == "BMS"){
                                        bmsFlag = true;
                                        return false;
                                    }
                                });
                                if (bmsFlag) {
                                    msg = that.appUtils.getString("recovery_messsage_plan_instanceMove_bms_confirm_tips", params.name);
                                    if (params.supportConfirmReprotection) {
                                        msg = that.appUtils.getString("recovery_plan_switchover_paused_bms_warn_tips", params.name);
                                    }
                                }
                            };
                            remoteRecoveryPlannedMigration(msg, instanceRegion);
                        });
                        return;
                    }

                    if (params.templateType == 37) {
                        var win = angular.copy(that.constsService.RECOVERY_REGION_AZ_WIN);
                        win.data = params;
                        that.appUtils.showWindow(win, function () {
                            var options = this.options;
                            if (!UnifyValid.FormValid($("#" + options.verifyId), { focusInvalid: true })) {
                                return;
                            }

                            var regionId = $("#targetRegion").widget().getSelectedId();
                            if (regionId == "-1") {
                                that.message.error(that.appUtils.getString("validate_select_value_label", "recovery_migration_csha_csdr_targetregion_label"));
                                return;
                            }

                            var datas = {
                                "recovery_region_id": regionId,
                                "recovery_az_id": $("#targetAzId").text()
                            }

                            _.extend(datas, instanceRegion)

                            remoteRecoveryPlannedMigration(that.appUtils.getString("recovery_migration_csha_csdr_confirm_tips", params.name), datas, function () {
                                $("#" + options.winId).widget().destroy();
                            });
                        })
                        return;
                    }
                };
                remoteRecoveryPlannedMigration(msg, instanceRegion);
                return;
            };

            that.utils.openWin("fusionSphere3dcExcuteWin", that.appUtils.getString("common_term_plan_move_button"),
            _.extend(params, {operateType: "move"}), 752, 650, "app/business/recoverydirector/recovery/views/operate/fusionSphere3dcExecute.html", []);
        },
        fault: function(params) {
            var that = this, height = 330;
            var instanceRegion = {
                region_id: params.props.regionName,
                az_id: params.props.zoneName
            };
            function remoteRecoveryDiaster(msg, data, callback){
                that.message.warn({
                    content: msg,
                    ok: function() {
                        that.restService.remoteRecoveryDiasterRecovery(params.planId, {
                            "data": data || {},
                            "success": function(data) {
                                !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                                //发广播更新当前选中行的数据
                                params.$scope.exec = true;
                                params.$scope.$emit("recoveryExecute", params.planId);
                                that.message.success({
                                    content: that.appUtils.getString("common_term_command_send_success_label"),
                                    ok: function() {
                                        _.isFunction(callback) && callback();
                                        params.$state.go("dataUse.dataRecovery.procedure");
                                    }
                                });
                            }
                        })
                    }
                })
            };
            if(params.PROVIDER_TYPE == "FusionSphereOpenstack"){
                var msg = that.appUtils.getString("recovery_messsage_openstackFault_recovery_confirm_tips", params.name);
                if(_.contains([25,34,37], +params.templateType) || params.serviceInstanceType == "replication"){
                    msg = that.appUtils.getString("recovery_messsage_instanceFault_recovery_confirm_tips", params.name);
                };
                if(_.contains([37], +params.templateType)){
                    var win = angular.copy(that.constsService.RECOVERY_REGION_AZ_WIN);
                    win.title = that.appUtils.getString("ism.drm.protect.group.fault.recovery.label");
                    win.data = params;
                    that.appUtils.showWindow(win, function () {
                        var options = this.options;
                        if (!UnifyValid.FormValid($("#" + options.verifyId), { focusInvalid: true })) {
                            return;
                        }

                        var regionId = $("#targetRegion").widget().getSelectedId();
                        if (regionId == "-1") {
                            that.message.error(that.appUtils.getString("validate_select_value_label", "recovery_migration_csha_csdr_targetregion_label"));
                            return;
                        }

                        var datas = {
                            "recovery_region_id": regionId,
                            "recovery_az_id": $("#targetAzId").text()
                        }

                        _.extend(datas, instanceRegion);

                        remoteRecoveryDiaster(that.appUtils.getString("recovery_fault_csha_csdr_confirm_tips", params.name), datas, function() {
                            $("#" + options.winId).widget().destroy();
                        });
                    })
                    return;
                };
                remoteRecoveryDiaster(msg, instanceRegion);
                return;
            };

            that.utils.openWin("fusionSphere3dcExcuteWin", that.appUtils.getString("ism.drm.protect.group.fault.recovery.label"),
            _.extend(params, {operateType: "fault"}), 752, 650, "app/business/recoverydirector/recovery/views/operate/fusionSphere3dcExecute.html", []);
        },
        fusionsphereLocalTest: function(params) {
            var that = this, url = params.PROVIDER_TYPE;
            that.utils.openWin(that.constsService.FUSIONSPHERE_LOCAL_EXECUTE.winId,
                that.appUtils.getString("common_term_test_button"),
                params,
                that.constsService.FUSIONSPHERE_LOCAL_EXECUTE.width,
                that.constsService.FUSIONSPHERE_LOCAL_EXECUTE.heigth,
                that.constsService.FUSIONSPHERE_LOCAL_EXECUTE[url],null,
                "localTestExcuteWinId");
        }
    };

    return _.extend(FusionSphere, Base);
});