define(["tiny-lib/jquery", "tiny-lib/underscore", "./base"], function($, _, Base) {
    "use strict";

    /**
     * 公共类型的模型
     * 适用于Oracle, SQLServer, DB2, MySQL, Informaix, Sybase, KingBasees, Exchange, FileSystem, LUN, Exchange2007等模型继承
     * @type {{test: Function, move: Function, fault: Function}}
     */
    var General = {
        test: function(params) {
            _sendAjax(this, this.appUtils.getString("common_term_test_button"), _.extend(params, {operateType: "test"}));
        },
        move: function(params) {
            _sendAjax(this, this.appUtils.getString("common_term_plan_move_button"), _.extend(params, {operateType: "move"}));
        },
        fault: function(params) {
            _sendAjax(this, this.appUtils.getString("ism.drm.protect.group.fault.recovery.label"), _.extend(params, {operateType: "fault"}));
        }
    };

    function _sendAjax(context, title, params) {
        var that = context,
            buttons = [{
                key: "ok",
                label: title,
                focused: true,
                handler: function(event) {
                    var data = $("#hostTable").widget().getTableCheckedItems();
                    if (_.isEmpty(data)) {
                        that.message.error(that.appUtils.getString('recovery.term.recovery.hostGroup.message.least'));
                        return;
                    }

                    function doAjax() {
                        var config = {
                                data: {
                                    "disasterHostSn": _.first(data).deviceSn
                                },
                                "success": function(data) {
                                    !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                                    //发广播更新当前选中行的数据
                                    params.$scope.exec = true;
                                    params.$scope.$emit("recoveryExecute", params.planId);
                                    that.message.success({
                                        content: that.appUtils.getString("common_term_command_send_success_label"),
                                        ok: function() {
                                            $("#" + that.constsService.REMOTE_TEST_RECOVERY.winId).widget().destroy();
                                            params.$state.go("dataUse.dataRecovery.procedure");
                                        }
                                    });
                                }
                            },
                            siteName = that.appUtils.encodeForHTML($("#recoverySites").widget().getSelectedLabel());

                        if ("test" === params.operateType) {
                            that.message.warn({
                                content: that.appUtils.getString("recovery_messsage_remote_test_confirm_tips", params.name, siteName),
                                ok: function() {
                                    that.restService.remoteRecoveryTest(params.planId, config);
                                }
                            })
                        } else if ("move" === params.operateType) {
                            that.message.warn({
                                content: _.contains([1, 2, 3, 8, 15, 16], +params.poType) ? that.appUtils.getString("recovery_plan_move_warn_label", params.name) : that.appUtils.getString("recovery_messsage_plan_move_confirm_tips", params.name),
                                ok: function() {
                                    that.restService.remoteRecoveryPlannedMigration(params.planId, config);
                                }
                            })
                        } else if ("fault" === params.operateType) {
                            that.message.warn({
                                content: that.appUtils.getString("recovery_messsage_fault_recovery_no_test_confirm_tips", params.name),
                                ok: function() {
                                    that.restService.remoteRecoveryDiasterRecovery(params.planId, config);
                                }
                            })
                        }
                    }

                    if (params.poType == 1 && _.first(data)["isMounted"]) {
                        that.message.confirm({
                            content: that.appUtils.getString("recovery_repro_test_ismounted_tips_label"),
                            ok: function() {
                                doAjax();
                            }
                        });
                    }
                    else {
                        doAjax();
                    }

                }
            },
                {
                    key: "cancel",
                    label: that.appUtils.getString("common_term_cancel_button"),
                    focused: false,
                    handler: function(event) {
                        $("#" + that.constsService.REMOTE_TEST_RECOVERY.winId).widget().destroy();
                    }
                }
            ]
        that.utils.openWin(that.constsService.REMOTE_TEST_RECOVERY.winId, title, params, 600, 500, "app/business/recoverydirector/recovery/views/operate/remoteTestRecovery.html", buttons);
    }

    return _.extend(General, Base);
});