define(["tiny-lib/jquery", "tiny-lib/underscore", "./base"], function($, _, Base) {
    "use strict";
    var Nas = {
        test: function(params) {
            var that = this;
            that.message.warn({
                content: that.appUtils.getString("recovery_messsage_remote_test_nas_confirm_tips", params.name),
                ok: function() {
                    that.restService.remoteRecoveryTest(params.planId, {
                        data: {
                            "disasterHostSn": ""
                        },
                        "success": function(data) {
                            !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                            //发广播更新当前选中行的数据
                            params.$scope.exec = true;
                            params.$scope.$emit("recoveryExecute", params.planId);
                            that.message.success({
                                content: that.appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    params.$state.go("dataUse.dataRecovery.procedure");
                                }
                            });
                        }
                    });
                }
            })
        },
        move: function(params) {
            var that = this;
            that.message.warn({
                content: that.appUtils.getString("recovery_messsage_plan_move_confirm_tips", params.name),
                ok: function() {
                    that.restService.remoteRecoveryPlannedMigration(params.planId, {
                        data: {
                            "disasterHostSn": ""
                        },
                        "success": function(data) {
                            !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                            //发广播更新当前选中行的数据
                            params.$scope.exec = true;
                            params.$scope.$emit("recoveryExecute", params.planId);
                            that.message.success({
                                content: that.appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    params.$state.go("dataUse.dataRecovery.procedure");
                                }
                            });
                        }
                    });
                }
            })
        },
        fault: function(params) {
            var that = this;
            that.message.warn({
                content: that.appUtils.getString("recovery_messsage_fault_recovery_confirm_tips", params.name),
                ok: function() {
                    that.restService.remoteRecoveryDiasterRecovery(params.planId, {
                        data: {
                            "disasterHostSn": ""
                        },
                        "success": function(data) {
                            !_.isEmpty(that.infoTransferredService.get("tipModule", "obj")) && delete that.infoTransferredService.get("tipModule", "obj")[params.uuid];
                            //发广播更新当前选中行的数据
                            params.$scope.exec = true;
                            params.$scope.$emit("recoveryExecute", params.planId);
                            that.message.success({
                                content: that.appUtils.getString("common_term_command_send_success_label"),
                                ok: function() {
                                    params.$state.go("dataUse.dataRecovery.procedure");
                                }
                            });
                        }
                    });
                }
            })
        }
    };

    return _.extend(Nas, Base);
});