define(["tiny-lib/jquery", "tiny-lib/underscore", "tiny-common/UnifyValid", "./base"], function($, _, UnifyValid, Base) {
    "use strict";

    var VmwareSanSnapshot = {
        test: function(params) {
            if (this.appUtils.isEn()) {
                this.constsService.VMWARE_EXECUTE.winSize.width = 820;
                this.constsService.VMWARE_EXECUTE.winSize.heigth = 800;
            } else {
                this.constsService.VMWARE_EXECUTE.winSize.width = 780;
                this.constsService.VMWARE_EXECUTE.winSize.heigth = 800;
            }
            this.utils.openWin("vmwareIncrementTypeExecute",
                this.appUtils.getString("common_term_test_button"),
                _.extend(params, {networkType: "testNetwork", operateType: "test"}),
                this.constsService.VMWARE_EXECUTE.winSize.width,
                this.constsService.VMWARE_EXECUTE.winSize.heigth,
                "app/business/recoverydirector/recovery/views/operate/vmwareExecute.html", null, "vmwareIncrementTypeExecuteTest");
        },

        move: function(params){
            this.utils.openWin("vmwareIncrementTypeExecute",
                this.appUtils.getString("common_term_plan_move_button"),
                _.extend(params, {networkType: "recoveryNetwork", operateType: "move"}),
                this.constsService.VMWARE_EXECUTE.winSize.width,
                this.constsService.VMWARE_EXECUTE.winSize.heigth,
                "app/business/recoverydirector/recovery/views/operate/vmwareExecute.html", null, "vmwareIncrementTypeExecuteMove");
        },

        fault: function(params) {
            this.utils.openWin("vmwareIncrementTypeExecute",
                this.appUtils.getString("ism.drm.protect.group.fault.recovery.label"),
                _.extend(params, {networkType: "recoveryNetwork", operateType: "fault"}),
                this.constsService.VMWARE_EXECUTE.winSize.width,
                this.constsService.VMWARE_EXECUTE.winSize.heigth,
                "app/business/recoverydirector/recovery/views/operate/vmwareExecute.html", null, "vmwareIncrementTypeExecuteFault");
        },
        networkSet: function(params) {
            var that = this,
                buttons = [{
                    key: "ok",
                    label: that.appUtils.getString('common_term_confirm_button'),
                    focused: true,
                    handler: function(event) {
                        var mac = $("#networkCard").widget().getSelectedId();
                        if ("default" == mac || _.isEmpty(mac)) {
                            that.message.error(that.appUtils.getString("protect_object_select_netcard_label"));
                            return;
                        }
                        if (!UnifyValid.FormValid($("#vmwarepSetDiv"), {focusInvalid: true})) {
                            return;
                        }
                        var dhcpEnabled4 = $("#ipSetWay").widget().opChecked("checked") == "auto";
                        var ip = $("#ipv4").widget().getValue();
                        var gateway = $("#gateway").widget().getValue();
                        var netmask = $("#netmask").widget().getValue();
                        var autoDns4 = $("#dnsSetWay").widget().opChecked("checked") == "auto";
                        var setDns = $("#firstChoose").widget().getValue();
                        var addDns = $("#reserveChoose").widget().getValue();
                        that.restService.modifyVmwareNetwork({mac: mac, planId: params.planId, poId: params.uuid}, {
                            data: {
                                ip: ip,
                                dhcpEnabled4: dhcpEnabled4,
                                netmask: netmask,
                                gateway: gateway,
                                autoDns4: autoDns4,
                                setDns: setDns,
                                addDns: addDns
                            },
                            success: function(data) {
                                that.message.success({
                                    content: that.appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $("#" + that.constsService.VMWARE_VM_IP_WIN.winId).widget().destroy();
                                    }
                                });
                            }
                        });
                    }
                },
                    {
                        key: "cancel",
                        label: that.appUtils.getString('common_term_cancel_button'),
                        focused: false,
                        handler: function(event) {
                            $("#" + that.constsService.VMWARE_VM_IP_WIN.winId).widget().destroy();
                        }
                    }
                ];
            that.utils.openWin(that.constsService.VMWARE_VM_IP_WIN.winId,
                that.appUtils.getString(that.constsService.VMWARE_VM_IP_WIN.title),
                params,
                that.constsService.VMWARE_VM_IP_WIN.width,
                that.constsService.VMWARE_VM_IP_WIN.height,
                that.constsService.VMWARE_VM_IP_WIN.url,
                buttons);
        }
    };

    return _.extend(VmwareSanSnapshot, Base);
});
