/**
 * 公共常量定义
 * 常量服务
 */
define(["language/platform/widgets/validateLanguage"], function(language) {
    // "use strict";

    var service = function() {

        var Consts = this;

        /***cookie常量******/
        this.CSRF_TOKEN = "rd_randomStr_HW";
        this.LANGUAGE = "language";
        this.INVALID_SGEMENT = "--";

        /**URL地址常量****/
        this.MENU = "app/framework/base/views/menus.html";
        this.TASK_URL = "app/business/recoverydirector/home/views/home/taskList.html";
        this.QUICK_START_URL = "app/business/recoverydirector/home/views/home/quickStart.html";
        this.ABOUT_URL = "app/framework/base/views/about.html";
        this.LOGIN_URL = "/src/login/view/login.html";
        this.INDEX_URL = "/src/index.html#/home/staticView";
        this.PASSWORD_EDIT_URL = "modifyPassword.html";
        this.SITE_EDIT_URL = "app/business/recoverydirector/setting/views/site/siteEdit.html";
        this.SITE_REMOTE_EDIT_URL = "app/business/recoverydirector/setting/views/site/siteRemoteEdit.html";
        this.STORAGE_ADD_URL = "app/business/recoverydirector/setting/views/site/storageAdd.html";
        this.VRG_ADD_URL = "app/business/recoverydirector/setting/views/site/vrgAdd.html";
        this.CLOUD_ADD_URL = "app/business/recoverydirector/setting/views/site/cloudAdd.html";
        this.VCENTER_ADD_URL = "app/business/recoverydirector/setting/views/site/vcenterAdd.html";
        this.HOST_APP_URL = "app/business/recoverydirector/setting/views/site/hostApp.html";
        this.HOST_ADD_URL = "app/business/recoverydirector/setting/views/site/hostAdd.html";
        this.HOST_GROUP_ADD_URL = "app/business/recoverydirector/setting/views/site/hostGroupAdd.html";
        this.HOST_GROUP_EDIT_URL = "app/business/recoverydirector/site/views/resource/host/group/hostGroupEdit.html";
        this.RES_AILES_EDIT_URL = "app/business/recoverydirector/site/views/resource/base/aliasEdit.html";
        this.RES_VRG_HOST_EDIT_URL = "app/business/recoverydirector/site/views/resource/base/vrgHostEdit.html";
        this.RES_SNMPV3_URL = "app/business/recoverydirector/site/views/resource/base/snmpv3Form.html";
        this.RES_EDIT_PROTOCAL_URL = 'app/business/recoverydirector/site/views/resource/host/protocalEdit.html';
        this.USER_IP_RANGE_EDIT_URL = "app/business/recoverydirector/setting/views/user/range.html";
        this.SITE_LEFT_URL = "app/business/recoverydirector/setting/views/site/left.html";
        this.SITE_RIGHT_URL = "app/business/recoverydirector/setting/views/site/right.html";
        this.SITE_TITLE_URL = "app/business/recoverydirector/setting/views/site/title.html";
        this.REPLICATION_LINK_URL = "app/business/recoverydirector/monitor/views/topo/linkTopoDetail.html";
        this.INITIATOR_LINK_URL = "app/business/recoverydirector/monitor/views/topo/initiatorTopoDetail.html";
        this.QUORUM_LINK_URL = "app/business/recoverydirector/monitor/views/topo/quorumTopoDetail.html";
        this.TOPO_HOST_APP_URL = "app/business/recoverydirector/monitor/views/topo/topoHostAppView.html";
        this.PROCEDURE_LEFT_TITLE_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareLeftTitle.html";
        this.PROCEDURE_LEFT_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareLeft.html";
        this.PROCEDURE_RIGHT_TITLE_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareRightTitle.html";
        this.PROCEDURE_RIGHT_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareRight.html";
        this.COURRENT_ALARM_DETAIL_TITLE = "current_alarm_term_win_detail_title";
        this.COURRENT_ALARM_COUNT_TITLE = "current_alarm_term_win_count_title";
        this.ALARM_CLEAR_ERROR_TITLE = "current_alarm_term_win_batch_result_title";
        this.COURRENT_ALARM_DETAIL_URL = "app/business/recoverydirector/monitor/views/alarm/current/currentAlarmDetail.html";
        this.COURRENT_ALARM_COUNT_URL = "app/business/recoverydirector/monitor/views/alarm/current/currentAlarmCount.html";
        this.COURRENT_BATCH_RESULT_URL = "app/business/recoverydirector/monitor/views/alarm/current/batchResultWin.html";
        this.USER_AUTH_URL = "app/business/recoverydirector/setting/views/user/userAuth.html";

        this.VMWARE_TREE_NODE = "com.huawei.ism.drm.vsphere.recovery.process.VsHangupNoncriticalVmProcessor"; //挂起VMWARE低优先级虚拟机管理
        this.HANGUP_TREE_NODE_1 = "com.huawei.ism.drm.galax.recovery.process.HangUpNoncriticalVmRecoveryProcessor"; //挂起云平台低优先级虚拟机管理
        this.HANGUP_TREE_NODE_2 = "com.huawei.ism.drm.galax.recovery.process.HangUpNoncriticalVmRecoveryProcessor"; //挂起VMWARE低优先级虚拟机管理
        this.START_VM_HOST_TREE_NODE_2 = "com.huawei.ism.drm.galax.storage.recovery.process.PowerOnHostRecoveryProcessor"; //上电主机管理
        this.HISTORY_EXCUTE_DETAIL = "recovery.term.history.colum.excuteDetail.check";
        this.VMware_VM_TYPE = 10;
        this.HUAWEI_VM_TYPE = 12;
        this.ORACLE_RECOVERY_TAB = "ORACLE_RECOVERY_TAB";
        this.RECOVERY_TAB = "RECOVERY_TAB";
        this.RECOVERY_BASIC_INFO_EVENT = "RECOVERY_BASIC_INFO_EVENT";
        this.ERRORCODE_PRE = "lego.err.";

        /**REST接口定义****/
        var PREFIX = "../ws";
        this.REST = {
            //查询站点
            querySites: ["get"    , "/sites?{serverUuid}"],
            //查询本地服务器
            queryLocalServer: ["get"    , "/drmservers/local"],
            //查询远端服务器信息
            queryRemoteServer:["get" ,"/drmservers/remote/{ip}"],
            //查询站点的存储
            queryStorageBySite: ["get"    , "/storages?{siteId}"],
            //查询存储资源池
            getStorageResourcePools: ["get" , "/storagepool?{deviceSn}&{type}"],
            //查询指定资源池
            getStorageResourcePool: ["get" , "/storagepool/{uuid}"],
            //查询资源池下的lun容量分布
            getStoragePoolResourcesStatistic: ["put", "/storagepool/{uuid}/action/getStorageResourcesStatistic?{templateType}"],
            //查询存储下的lun容量分布
            getStorageResourcesStatistic: ["put", "/storages/{deviceSn}/action/getStorageResourcesStatistic?{templateType}"],
            //查询站点下的主机
            queryHostBySite: ["get", "/hostgroups?{siteId}&{searchType}&{systemVersion}"],
            //查询站点下的vcenter
            queryVCenterBySite: ["get"    , "/vcenters/action/getRegisteredVCenter?{siteId}"],
            //查询主机下的应用
            queryProtectObjects: ["get"    , "/protectgroups/action/getAvailableProtectObject?{poType}&{deviceSn}&{_FILTER}"],
            //分页查询可用的保护对象(vmware可用)
            pageQueryAvailableProtectObject: ["get"    , "/protectgroups/action/pageQueryAvailableProtectObject?{poType}&{deviceSn}&{_FILTER}&{_PAGE}"],
            //分页查询可用的保护对象(添加保护对象)
            pageAddQueryAvailableProtectObject: ["get"    , "/protectgroups/{protectGroupId}/action/pageQueryAddAvailableProtectObject?{poType}&{_FILTER}&{_PAGE}"],
            //删除保护组
            delProtectGroup: ["delete" , "/protectgroups/{pgId}"],
            //检查保护组名称是否已经存在
            checkNameExisted: ["get"    , "/protectgroups/action/checkNameExisted?{name}"],
            //增加保护对象
            addProtectObject: ["put"    , "/protectgroups/{pgId}/action/addProtectObjects"],
            //移除保护对象
            delProtectObject: ["put"    , "/protectgroups/{pgId}/action/removeProtectObjects"],
            //数据库认证
            validateAuthInfo: ["post"   , "/protectgroups/action/validateAuthInfo?{poType}"],
            //修改认证信息
            updateAuthInfo: ["put"    , "/protectgroups/{pgId}/action/updateProtectObjectProps"],
            //修改归档日志
            updateProtectObjectProps: ["put"    , "/hosts/action/updateArchieveLogSetting?{protectGroupId}"],
            //加载存储信息
            loadStorageInfo: ["post"   , "/protectgroups/action/getStorageInfo"],
            //修改保护组
            updateProtectGroup: ["put"    , "/protectgroups/{protectGroupId}"],
            //执行保护组
            excuteProtectGroup: ["put"    , "/protectgroups/{pgId}/action/executeProtectGroup"],
            //禁用保护组
            disableProtectGroup: ["put"    , "/protectgroups/{pgId}/action/disableProtectGroup"],
            //激活保护组
            enableProtectGroup: ["put"    , "/protectgroups/{pgId}/action/enableProtectGroup"],
            //刷新保护组
            refreshProtectGroup: ["put"    , "/protectgroups/{pgId}/action/refreshProtectGroup"],
            //导出保护组
            exportProtectGroup: ["post"    , "/protectgroups/action/exportProtectGroup"],
            //加载策略模板
            loadAvailablePolicyTemplate: ["post"   , "/policytemplates/action/getAvailablePolicyTemplate?{poType}&{replicationType}"],
            //系统支持的支持的应用
            getSupportProtectObjectTypes: ["get"    , "/protectgroups/action/getSupportProtectObjectTypes"],
            //查询系统支持的所有策略模板
            getAllPolicyTemplates: ["get"    , "/policytemplates"],
            //查询策略模板详情
            getPolicyTemplateDetail: ["get"    , "/policytemplates/{uuid}"],
            //创建保护组
            createProtectGroup: ["post"   , "/protectgroups?{createRecoveryPlan}"],
            //分页查询保护组
            queryProtectGroups: ["get"    , "/protectgroups?{poType}&{_PAGE}&{_FILTER}"],
            //查询指定保护组
            queryProtectGroupById: ["get"    , "/protectgroups/{protectgroupId}"],
            //查询保护组摘要页信息
            getGroupBriefInfo: ["get"    , "/protectgroups/{protectgroupId}/action/getBriefInfo"],
            //查询保护组执行信息
            getProtectGroupStatisticInfo: ["get"    , "/protectgroups/{protectgroupId}/action/getProtectGroupStatisticInfo?{range}"],
            //分页查询保护对象
            queryProtectObjectsByPage: ["get"    , "/protectgroups/{protectgroupId}/protectobjects?{poType}&{_PAGE}"],
            //查询保护组副本信息
            queryProtectGroupReplicas: ["get"    , "/protectgroups/{protectgroupId}/replicas?{status}&{startTime}&{endTime}"],
            //查询保护组执行历史
            queryProtectGroupLogs: ["get"    , "/protectgroups/{protectgroupId}/logs?{_PAGE}"],
             //查询保护组执行步骤
            queryProtectGroupActions: ["get"    , "/protectgroups/{protectgroupId}/actions"],
            //启用执行步骤
            enablePgStepAction: ["put", "/protectgroups/{protectgroupId}/actions/{actionId}/enable"],
            //禁用执行步骤
            disablePgStepAction: ["put", "/protectgroups/{protectgroupId}/actions/{actionId}/disable"],
            //启用执行步骤
            modifyPgStepAction: ["put", "/protectgroups/{protectgroupId}/actions/{actionId}"],
            //查询保护组执行详情
            queryProtectGroupLogDetail: ["get", "/protectgroups/{protectgroupId}/logs/{logId}/details"],
            //增加保护对象,查询可用的保护对象
            getAddAvailableProtectObject: ["get", "/protectgroups/{pgId}/action/getAddAvailableProtectObject?{poType}&{_FILTER}"],
            //查询可用存储组
            getAvailableDataStoreStorageGroup: ["get", "/datastoregroups?{providerSN}&{protectionType}"],
            //查询可用存储组(添加保护对象时)
            queryAddAvailableDatastoreGroup: ["get", "/datastoregroups/action/queryAddAvailableDatastoreGroup?{protectGroupId}"],
            //查询虚拟机
            getVMByDataStoreGroup: ["get", "/datastoregroups/action/getVMByDataStoreGroup?{datastoreGroupIds}&{protectionType}&{vmType}&{_FILTER}&{_PAGE}"],
            //修改策略模板
            modifyPolicy: ["put", "/protectgroups/{protectgroupId}/action/modifyPolicy"],
            //查询阵列间链路状态
            getStorageLinkDetail: ["get", "/replication/{srcDeviceSn}/{tgtDeviceSn}/action/getReplicationLinks"],
            //通过主机查询Exchange版本
            getExchangeversions: ["get", "/hosts/{hostSn}/exchangeversions"],
            //查询一致性下的LUN
            getSrcLunByReplicationUUID: ["get", "/storages/action/getSrcLunByReplicationUUID?{replicationId}"],
            //查询vmware数据存储资源
            getDataStoreStorageGroupStorageResource: ["get", "/datastoregroups/{groupId}/storageresources"],
            //添加ds到dsg
            addDatastoreToProtectGroup: ["put", "/datastoregroups/action/addDatastoreToProtectGroup?{protectGroupId}"],
            //从dsg中移除ds
            removeDatastoreFromProtectGroup: ["put", "/datastoregroups/action/removeDatastoreFromProtectGroup?{protectGroupId}"],
            //查询保护中的dsg
            queryDatastoreGroup: ["get", "/datastoregroups/action/queryDatastoreGroup?{protectGroupId}"],
            //查询华为虚拟机数据存储资源
            queryUsedStorageResourceSet: ["get", "/fusionsphere/{datastoreGroupId}/action/queryUsedStorageResourceSet"],
            //查询站点下的云平台
            queryCloudBySite: ["get", "/fusionsphere?{siteId}&{cloudType}"],
            //查询云平台下的数据存储组列表
            getDataGroupByCloud : ["get","/fusionsphere/{cloudSn}/datastoregroup?{isavailable}&{protectionType}"],
            //查询指定存储组下的虚拟机
            getGalaxVMByDataStoreGroup : ["get","/fusionsphere/action/getGalaxVMByDataStoreGroup?{datastoreGroupIds}&{_PAGE}"],
            //改变华为虚拟机的状态
            exeProtectAction: ["put", "/hostpolicytemplate/action/exeProtectAction"],
            //修改华为虚拟机策略模板
            modifyHwHostTemplate: ["put", "/hostpolicytemplate/action/modifyHostTemplate?{protectgroupId}"],
            //查询策略模板时间策略站点信息
            getScheduleSiteInfo : ["post","/policytemplates/action/getScheduleSiteInfo?{poType}&{ptUuid}"],
            //查询编辑步骤
            getPgActionLogs: ["get","/protectgroups/{protectGroupId}/actions/logs"],
            //查询编辑步骤
            getStorageLunsStatistic: ["put","/protectgroups/action/getStorageLunsStatistic?{poType}&{templateType}"],
            //查询保护组使用的存储信息
            getStorageResources: ["put","/protectgroups/action/getStorageResources?{poType}&{templateType}"],
            //查询指定存储上的远端设备
            queryRemoteDevices: ["get", "/storages/{deviceSn}/remoteDevices?{siteId}"],
            //查询指定远端设备上,可用于创建一体化备份的文件系统
            getHyperVaultTargetFs: ["get", "/storages/{deviceSn}/action/getHyperVaultTargetFs?{srcFileSystemId}&{remoteDeviceSn}"],
            //查询指定Openstack Keystone下的Region
            getOpenStackRegions: ["get", "/openstack/{openstackId}/regions"],
            //查询指定Openstack Keystone下的Project
            getOpenStackProject: ["get", "/openstack/{openstackId}/projects?{enabled}"],
            //查询指定Project可以访问的Availability Zone
            getOpenStackZone: ["get", "/openstack/{openstackId}/availabilityZones?{projectId}&{zoneState}&{regionId}"],
            //查询指定虚拟机所用卷信息
            getOpenStackVolumes: ["post", "/openstack/volumes?{projectId}&{regionId}"],
            //查询指定Project可以使用的VolumeType
            getOpenStackVolumeType: ["get", "/openstack/{openstackId}/volumeTypes?{srcProjectId}&{srcRegionId}&{srcVolumeTypeName}&{regionId}&{projectId}"],
            //同步保护组脚本解决方案到恢复计划
            syncPgScriptPlan: ["put", "/recoveryplans/{planId}/sync/props"],
            //创建恢复计划
            createRecovery: ["post", "/recoveryplans"],
            //查询创建恢复计划所需的可用保护组
            getProtectGroups: ["get", "/recoveryplans/action/getAvailableProtectGroups"],
            //分页查询恢复计划列表
            getRecoveryListData: ["get", "/recoveryplans?{startPage}&{pageSize}&{orderBy}&{orderType}&{planType}&{Rp.appType}&{Rp.name}&{Rp.planStatus}&{Rp.productSiteId}&{Rp.protectGroupId}&{Rp.createStartTime}&{Rp.createEndTime}&{Rp.replicaId}&{Rp.mountSiteId}&{Rp.mountHostId}&{Rp.regionId}&{Rp.azId}&{Rp.projectId}&{Rp.instProtectType}"],
            //获取单个恢复计划信息
            getRecoveryByUuidInfo: ["get", "/recoveryplans/{uuid}"],
            //修改单个恢复计划信息
            updateRecoveryInfo: ["put", "/recoveryplans/{uuid}"],
            //删除恢复计划
            deleteRecovery: ["delete", "/recoveryplans/{uuid}"],
            //远程恢复计划测试
            remoteRecoveryTest: ["put", "/recoveryplans/{uuid}/action/test"],
            //远程恢复计划计划性迁移
            remoteRecoveryPlannedMigration: ["put", "/recoveryplans/{uuid}/action/plannedMigration"],
            //操作暂停后的重保护
            pausedContinue: ["put", "/recoveryplans/{uuid}/action/{actionType}/continue"],
            //远程恢复计划灾难恢复
            remoteRecoveryDiasterRecovery: ["put", "/recoveryplans/{uuid}/action/diasterRecovery"],
            //重保护恢复计划
            reprotectRecovery: ["put", "/recoveryplans/{uuid}/action/reprotect"],
            //远程清理恢复计划
            remoteClearRecovery: ["put", "/recoveryplans/{uuid}/action/testCleanup"],
            //本地清理恢复计划
            localClearRecovery: ["put", "/recoveryplans/{uuid}/action/testLocalCleanup"],
            //查询本地恢复计划本地测试所需的副本信息
            getReplicasList: ["get", "/protectgroups/{protectUuid}/replicas?status=1"],
            //查询本地恢复计划测试所需要的主机或主机组
            getAvailableDrHost: ["get", "/hosts/action/getAvailableDrHost?{planId}"],
            //查询远程恢复计划测试所需要的主机或主机组
            getRemoteAvailableDrHost: ["get", "/hosts/action/getAvailableDrHost?{siteId}&{planId}"],
            //本地执行恢复计划
            localRunningRecovery: ["put", "/recoveryplans/{uuid}/action/executePlan?{replicaId}&{disasterSiteId}&{restoreSpeed}"],
            //查询远程灾备站点
            getRemoteDisasterSite: ["get", "/recoveryplans/{uuid}/recoverySites"],
            //查询恢复计划是否已经测试执行过
            getRecoveryHavingTest: ["get", "/recoveryplans/{uuid}/globalSettings?{key}"],
            //查询vmware网络映射列表
            getVmwareNetworkmappings: ["get", "/vcenters/networkmappings?{planId}&{networkType}"],
            //查询vmware单个网络数据
            getVmwareNetwork: ["get", "/vcenters/networks?{planId}"],
            //查询fusionsphere网络映射列表
            getFusionsphereNetworkmappings: ["get", "/resourcemapping/action/getTestnetworks?{planId}"],
            //查询fusionsphere单个网络数据
            getFusionshpereByUrn: ["get", "/fusionsphere/networks?{planId}&{recNetworkUrn}"],
            //本地测试恢复计划
            localRecoveryTest: ["put", "/recoveryplans/{uuid}/action/testLocalDrp?{replicaId}&{productSiteId}&{disasterHostSn}"],
            //恢复计划详情
            getRecoveryAbstractInfo: ["get", "/recoveryplans/{uuid}/action/abstractInfo"],
            //分页查询单个恢复计划的保护对象
            getRecoveryProtectObject: ["get", "/recoveryplans/{uuid}/protectObjects?{startPage}&{pageSize}&{orderBy}&{orderType}"],
            //保护对象启动设置
            setProObjectStartSetting: ["put", "/recoveryplans/action/setRecoverySettings?{planId}"],
            //查询保护对象启动设置详情列表(不分页)
            getRecoveryProtectObjectInfo: ["get", "/recoveryplans/{uuid}/protectObjects?startPage=0&pageSize=10000"],
            //vmware网络恢复设置
            modifyVmwareNetwork: ["put", "/vcenters/networkadpaters/{mac}?{planId}&{poId}"],
            //查询fusionsphere网络设置的网卡信息
            getNetworkadapters: ["get", "/fusionsphere/networkadapters?{poId}&{planId}"],
            //根据网卡ID查询网络配置信息
            getNetworkSettingInfo: ["get", "/fusionsphere/networkadapters/{mac}?{planId}&{poId}"],
            //fusionsphere的FusionCompute网络设置
            modifyFusionComputeNetwork: ["put", "/fusionsphere/networkadapters/{mac}?{poId}&{planId}"],
            //fusionsphere的FusionManager网络设置
            modifyFusionManagerNetwork: ["put", "/fusionsphere/networkadapters/{mac}?{poId}&{planId}"],
            //查询的单个个恢复计划的编辑步骤
            getRecoveryProcessList: ["get", "/recoveryplans/{uuid}/logs/steps?{procType}"],
            //分页查询单个恢复计划的执行历史
            getRecoveryExcuteHistoryList: ["get", "/recoveryplans/{uuid}/logs?{startPage}&{pageSize}&{orderBy}&{orderType}"],
            //查询指定vCenter的计算集群
            getvCenterTestCluster: ["get", "/vcenters/{vcenterUuid}/action/getAllHostOrCluster"],
            //查询恢复计划保护对象的计算资源
            getRecoveryClusterMapping: ["get", "/vcenters/hostmappings?{planId}&{queryType}"],
            //查询灾备主机网络
            getRecoveryHostNetwork: ["get", "/vcenters/networks?{hostOrClusterId}&{vcenterUuid}"],
            //查询恢复计划NAS共享信息
            getNasSharePortIp: ["get", "/vcenters/nasconfig/sharePortIp?{planId}"],
            //查询已挂起的非重要端虚拟机
            getNoncriticalVm: ["get", "/vcenters/vms/action/getNoncriticalVm?{planId}"],
            //查询未挂起的虚拟机列表
            getCriticalVm: ["get", "/vcenters/vms/action/getCriticalVm?{hostOrClusterId}&{vcenterUuid}"],
            //查询FusionSphere恢复计划保护对象的计算资源
            getFusionSphereClusterMapping: ["get", "/fusionsphere/clusterMappings?{planId}&{queryType}"],
            //查询FusionSphere灾备主机集群
            getFusionSphereClusterHost: ["get", "/fusionsphere/{cloudSn}/hostClusters"],
            //查询FusionSphere组件下端口组映射信息
            getFusionSphereMappingGroup: ["get", "/fusionsphere/revoceryPortGroupMappings?{planId}&{queryType}&{replicaId}"],
            //查询FusionSphere组件下灾备端口组
            getFusionSphereDisaterGroup: ["get", "/fusionsphere/{cloudSn}/portGroups"],
            //查询FusionSphere组件下网络映射信息
            getFusionSphereNetworkMapping: ["get", "/fusionsphere/revoceryNetworkMappings?{planId}&{queryType}"],
            //查询FusionSphere组件下灾备网络
            getFusionSphereDisaterNetwork: ["get", "/fusionsphere/{cloudSn}/networks"],
            //查询FusionSphere组件下安全组映射信息
            getFusionSphereSecurityGroupMapping: ["get", "/fusionsphere/securityGroupMappings?{planId}&{queryType}"],
            //查询FusionSphere组件下灾备安全组
            getFusionSphereDisaterSecurityGroup: ["get", "/fusionsphere/{cloudSn}/securityGroups"],
            //查询vmware下网络配置信息
            getVmareNetWorkIpInfo:["get","/vcenters/networkadpaters?{planId}&{poId}"],
            //设置vmware下网络配置信息
            setVmareNetWorkIpInfo:["put","/vcenters/networkadpaters?{planId}&{poId}"],
            //查询副本中的保护对象
            getCopyProtectgroups:["get","/protectgroups/{protectgroupId}/replicas/{replicaId}/protectobjects"],
            //查询保护组中保护对象的卷信息（仅用于OpenStack虚拟机）
            getProtectedVolumeInfo:["get","/openstack/volumes/poVolumeInfos?{protectGroupId}"],
            //更新保护对象的卷信息（仅用于OpenStack虚拟机）
            setProtectedVolumeInfo:["put","/openstack/volumes/updatePoVolumeInfos?{protectGroupId}"],
            //查询可用做测试的网络（openstack）
            getOpenStackNetWorks:["get","/openstack/networks?{planId}&{poUuid}"],
            //查询可用做测试的端口
            getOpenStackPorts:["get","/openstack/ports?{planId}&{networkId}"],
            //查询可用作测试的子网
            getOpenStackSubnets:["get","/openstack/subnets?{planId}&{networkId}"],
            //创建测试端口
            postOpenStackAddPorts:["post","/openstack/ports"],
            //设置指定虚拟机的测试网络
            setOpenStackTestNetworks:["put","/openstack/testNetworks?{planId}&{poUuid}"],
            //查询恢复计划的恢复设置
            getRecoveryPlanSetInfo:["get","/recoveryplans/action/getRecoverySettings?{planId}"],
            //查询可用作占位虚拟机的虚拟机
            getPlaceholderVmsInfo:["get","/openstack/placeholderVms?{planId}"],
            //删除卷类型映射
            delVolumTypePair:["delete","/openstack/{openstackUuid}/voltypepairs/action/delete"],
            //添加卷类型映射
            addVolumTypePair:["post","/openstack/{openstackUuid}/voltypepairs/action/create"],
            //删除AZ配对
            delOpenstackAzPair:["delete","/openstack/{openstackUuid}/azpairs/action/delete"],
            //添加AZ配对
            addOpenstackAzPair:["post","/openstack/{openstackUuid}/azpairs/action/create"],
            //设置OC对接信息
            setOcAlarmService:["put","/system/thirdservice/oc"],
            //设置租户北向API配置
            setNorthAPIConfig:["put","/system/thirdservice/manageone"],
            //查询租户北向API配置
            getNorthAPIConfig:["get","/system/thirdservice/manageone"],
            //查询OC对接信息
            getOcAlarmService:["get","/system/thirdservice/oc"],
            //BCM域名设置
            setBcmDomainService:["put","/system/thirdservice/domain"],
            //查询BCM域名设置
            getBcmDomainService:["get","/system/thirdservice/domain"],
            //查询日志上报服务
            getBcmLognotify:["get","/system/action/querylognotify?{logType}"],
            //设置日志上报服务
            setBcmLognotify:["put","/system/action/setlognotify"],
            //查询灾备站点（FC/FM）
            getfusionSphere3dcSite:["get","/fusionsphere/hostmappings?{planId}&queryType=test"],
            //保存低优先级虚拟机
            saveNonCriticalvms:["put","/fusionsphere/vms/action/setNonCriticalvms"],
            //保存需上电的主机
            savefusionSphereHosts:["put","/fusionsphere/hosts/action/setHosts"],
            //查询fusionsphere3dc网络映射列表
            getFusionsphere3dcNetworkmappings: ["get", "/resourcemapping/action/getTestnetworks?{planId}&{recoverySiteId}"],
            //根据租户UUID查询文件系统信息
            getFileSystemInfo: ["get", "/storages/filesystem?{vstoreuuid}"],
            //查询保护组使用的存储(仅用于SAN双活测试和NAS双活切换)
            getRecoveryStorageInfo: ["get", "/protectgroups/{protectGroupId}/useHypermetroStorage"],
            //对NAS双活进行主从切换
            switchNasRecovery: ["put", "/recoveryplans/{planId}/action/swap"],
            //添加Region
            addOpenstackRegion: ["post", "/openstack/{openstackId}/regions"],
            //修改Region
            modifyOpenstackRegion: ["put", "/openstack/{openstackId}/regions/{regionId}"],
            //删除Region
            deleteOpenstackRegion: ["delete", "/openstack/{openstackId}/regions/{regionId}"],
            //查询region容灾配置
            queryRegionConfig: ["get", "/openstack/{openstackId}/regions/{regionId}/configs"],
            //修改region容灾配置
            modifyRegonConfig: ["put", "/openstack/{openstackId}/regions/{regionId}/configs"],
            //重映射卷（仅用于OpenStack VHA CSHA 保护组）
            reMappingOpenstackPg: ["put", "/openstack/reMappingVol?{protectGroupId}"],
            //副本挂载
            sanHyperReplicaMount: ["post", "/protectgroups/{protectgroupId}/replicas/{replicaId}/action/mount"],
            //副本卸载
            sanHyperReplicaUnmount: ["post", "/protectgroups/{protectgroupId}/replicas/{replicaId}/action/unmount?{deleteReplica}"],
            //二级副本创建
            sanHyperReplicaCreate: ["post", "/protectgroups/{protectgroupId}/replicas/{replicaId}/action/createReplica?{isNeedMount}"],
            //副本过期
            sanHyperReplicaDelete: ["delete", "/protectgroups/{protectgroupId}/replicas/{replicaId}"],
            //查询是否是hyperCDP
            getHostAllLicense: ["get", "/storages/{storageSn}/getStorageAllLicense"],
            //查询预置方案的脚本信息
            getPresetScrpits: ["get", "/hosts/{hostSn}/action/schemes"],
            //查询某个预置方案的脚本信息
            getPresetScrpitsBySchemeId: ["get", "/hosts/action/schemes/{schemeId}"],
            //查询所有客置自定义方案的脚本名称
            getCustomScrpits: ["get", "/hosts/{hostSn}/action/custom/scripts"],
            //查询是否需要进行同步策略信息
            getIsSyncSchemeInfo: ["get", "/recoveryplans/{planId}/sync/demand"],
            //查询恢复计划编辑步骤
            getRecoveryProcess: ["get", "/recoveryplans/{planId}/procdefs/{procType}/tasks"],
            //查询可用的占位虚拟机
            getAvailableNonCirticalVm : ["get", "/fusionsphere/vms/action/getAvailableNonCirticalVm?planId={planId}"],
            //查询已选择的占位虚拟机
            getSelectedNonCriticalVm: ["get", "/fusionsphere/vms/action/getSelectedNonCriticalVm?planId={planId}"],
            //查询可用的虚拟主机
            getAvailableHost: ["get", "/fusionsphere/hosts/action/getAvailableHost?planId={planId}"],
            //查询已选择的虚拟机主机
            getSelectedHost: ["get", "/fusionsphere/hosts/action/getSelectedHost?planId={planId}"],
            //删除指定的步骤
            deleteStepByStepId: ["delete", "/recoveryplans/{planId}/procdefs/{procType}/tasks/{stepId}"],
            //添加自定义步骤
            addStep: ["post", "/recoveryplans/{planId}/procdefs/{procType}/tasks"],
            //启用步骤
            enableStep: ["put", "/recoveryplans/{planId}/procdefs/{procType}/tasks/{stepId}/action/enable"],
            //禁用步骤
            disableStep: ["put", "/recoveryplans/{planId}/procdefs/{procType}/tasks/{stepId}/action/disable"],
            //更新编辑步骤
            updateStepInfo: ["put", "/recoveryplans/{planId}/procdefs/{procType}/tasks/{stepId}"],
            //分页查询副本信息
            queryPageSizeReplicas: ["get", "/protectgroups/{protectGroupId}/pageQueryReplicas?&{startTime}&{endTime}&{siteId}&{startPage}&{replicaType}"],
	        //查询可配置的灾备存储池
            queryTargetStorages: ["get", "/storages/{devSn}/targetStorages"],
            //查询保护磁盘信息
            getProtectedDiskInfo: ["get", "/protectgroups/{protectGroupId}/diskInfo"],
            //更新磁盘保护
            updateDiskInfo: ["post", "/protectgroups/{protectgroupId}/action/updateDisk"],
            //查询保护组存储池映射
            getProtecionGroupStorageMapping: ["get", "/protectgroups/{protectGroupId}/storagePoolMapping"],
            //查询卷类型映射
            queryVolTypePairs: ["get", "/openstack/{openstackUuid}/voltypepairs"],
            //修改卷类型映射优先级
            updateVolTypePairs: ["put", "/openstack/{openstackUuid}/voltypepairs/action/update"],
            //查询Az配对列表
            queryAzPairs: ["get", "/openstack/{openstackUuid}/azpairs?{type}"],
            //查询软件信息
            getSoftwareInfo : ["get"    , "/softwareInfo"],
            //agent升级
            agentUpgrade: ["put", "/hosts/{hostSn}/action/upgrade"],
            //agent信息收集
            dataCollect: ["put", "/hosts/action/dataCollect"],
            //查询指定Openstack Keystone下的Region
            getRegionList: ["get", "/openstack/{openstackId}/regions"],
            //查询系统时间
            getSystemTime: ["get", "/systemtime"],
            //查询ftp hostkey信息
            getFtpHostKey: ["get","/system/action/getFtpHostKey?{ip}&{port}"],
            //测试系统配置数据自动备份
            testAutoBackupConfig: ["put","/system/action/testAutoBackupConfig"],
            //查询指定站点信息
            getSiteDetails: ["get", "/sites/{siteId}"],
            //批量查询代理信息
            queryProxys: ["get", "/backup_proxies"],
            //创建备份代理
            createProxy: ["post", "/backup_proxies"],
            //修改备份代理
            editProxy: ["put", "/backup_proxies/{proxyId}"],
            //删除代理
            deleteProxy: ["delete", "/backup_proxies/{proxyId}"],
            //查询指定的代理
            queryProxy: ["get", "/backup_proxies/{proxyId}"],
            //查询备份保管库列表
            queryBackupRespo: ["get", "/sites/{siteId}/backup_vaults?{limit}&{startPage}&{resourceType}&{protectType}&{cloudType}"],
            //查询云服务器列表
            queryCloudServer: ["get", "/sites/{siteId}/cloud_servers?{orderBy}&{pageSize}&{startPage}&{orderType}"],
            //批量查询备份存储池
            queryStoragePools: ["get", "/backup_engines/{backup_engine_id}/backup_storage_pools?{name}&{storageType}"],
            //创建备份存储池
            createStoragePool: ["post", "/backup_engines/{backup_engine_id}/backup_storage_pools"],
            //修改备份存储池
            editStoragePool: ["put", "/backup_engines/{backup_engine_id}/backup_storage_pools/{poolId}"],
            //删除备份存储池
            deleteStoragePool: ["delete", "/backup_engines/{backup_engine_id}/backup_storage_pools/{poolId}"],
            //查询指定的备份存储池
            queryStoragePool: ["get", "/backup_engines/{backup_engine_id}/backup_storage_pools/{poolId}"],
            //创建备份存储库
            createStorageRespo: ["post", "/backup_engines/{backup_engine_id}/backup_storage_repositories"],
            //修改备份存储库
            editStorageRespo: ["put", "/backup_engines/{backup_engine_id}/backup_storage_repositories/{repositoryId}"],
            //删除备份存储库
            deleteStorageRespo: ["delete", "/backup_engines/{backup_engine_id}/backup_storage_repositories/{repositoryId}"],
            //批量查询备份存储库
            queryStorageRespos: ["get", "/backup_engines/{backup_engine_id}/backup_storage_repositories?{name}&{storageType}"],
            //查询指定备份存储库
            queryStorageRespo: ["get", "/backup_engines/{backup_engine_id}/backup_storage_repositories/{repositoryId}"],
            //创建桶
            createWood : ["post", "/backup_engines/wood"],
            //创建挂载计划
            creatMountPlan: ["post", "/recoveryplans/action/createMountPlan"],
            //查询存储License
            queryStorageLicense: ["get", "/storages/{storageSn}/licenses"],
            //挂载计划执行挂载
            excuteMountAction: ["post", "/recoveryplans/{planId}/action/mount"],
            //挂载计划执行卸载
            excuteUnmountAction: ["post", "/recoveryplans/{planId}/action/unmount?{bDelReplica}"],
            //修改挂载计划策略
            modifyMountPlanPolicy: ["put", "/recoveryplans/{planId}/action/modifyPolicy"],
            //查询保护组关联的任务计划表
            queryPgSchedules: ["get", "/protectgroups/{protectGroupId}/schedules"],
            //修改任务计划表
            modifyPgSchedule: ["put", "/protectgroups/{protectgroupId}/schedules/{scheduleId}"],
            //增加任务计划时间表
            addPgSchedule: ["post", "/protectgroups/{protectgroupId}/schedules"],
            //修改任务计划表
            excuteBackupAction: ["put", "/protectgroups/{protectgroupId}/schedules/{scheduleId}/action/run"],
            //查询云站点
            queryCloudSites: ["get", "/sites?{serverUuid}&{cloudServiceProvider}"],
            //查询挂载计划的副本详情
            getDataMountAbstractInfo: ["get", "/protectgroups/{protectgroupId}/replicas/{replicaId}"],
            //获取站点关系
            getSitesRelation: ['get', "/sites/links"],
            //禁用任务计划
            disableSchedule: ["put", "/protectgroups/{protectgroupId}/schedules/{scheduleId}/action/disable"],
            //启用任务计划
            enableSchedule: ["put", "/protectgroups/{protectgroupId}/schedules/{scheduleId}/action/enable"],
            //创建Region配置
            createRegion: ["post", "/cloud_regions"],
            //修改Region配置
            modifyRegion: ["put", "/cloud_regions/{uuid}"],
            //删除Region配置
            deleteRegion: ["delete", "/cloud_regions/{uuid}"],
            //批量查询Region配置
            queryRegions: ["get", "/cloud_regions"],
            //查询指定的Region配置
            queryRegion: ["get", "/cloud_regions/{uuid}"],
            //查询华为云平台信息
            queryHwstackInfo: ["get", "/openstack/hwStackInfo"],
            //热迁移(CSHA远程恢复计划)
            hotMigration: ["post", "/recoveryplans/{planId}/action/hotMigration"],
            //查询计划性迁移或故障恢复的AZ选择
            queryRecoveryRegionAz: ["get", "/openstack/{planId}/action/recoveryRegionAZ"],
        };

        for (var i in this.REST) {
            if (this.REST.hasOwnProperty(i)) {
                this.REST[i][1] = PREFIX + this.REST[i][1];
            }
        }

        /**日志执行状态**/
        this.staticLogStatus = {
            "0": "recovery.term.history.runResult.success",
            "1": "recovery.term.history.runResult.failed",
            "2": "recovery.term.history.runResult.someSuccess",
            "3": "recovery.term.history.runResult.running"
        };

        this.staticRecLogType = {
            "0": "recovery.term.history.runType.faultRecovery",
            "1": "recovery.term.history.runType.planMove",
            "2": "recovery.term.history.runType.drillingTest",
            "3": "recovery.term.history.runType.clear",
            "4": "recovery.term.history.runType.lunRollback",
            "7": "recovery.term.history.runType.protect",
            "8": "recovery.term.history.runType.swap"
        };

        this.covertPgStatus = {
            "0": "1", //失败
            "1": "0", //成功
            "2": "3" //执行中
        };
        //SAN一体化挂载状态
        this.pgMountStatus = {
            "0": "protection_object_mount_status_mounting_label",
            "2": "protection_object_mount_status_mountFail_label",
            "3": "protection_object_mount_status_unmounting_label",
            "4": "protection_object_mount_status_unmount_label",
            "5": "protection_object_mount_status_unmountFail_label"
        };

        /**列表排序常用的常量值**/
        this.start = 0;
        this.pageSize = 10;
        this.orderBy = "name";
        this.orderType = "asc";

        /***图形颜色值常量***/
        this.COLOR_GREEN = "#5ecc49";
        this.COLOR_BLUE = "#5ecc49";
        this.COLOR_RED = "#fc5043";
        this.CLOLOR_ORANGE = "#ffa235";
        this.COLOR_GREY = "#cccccc";
        this.COLOR_THIN_GREY = "#e5e5e5";
        /**按照UCD栅格定义控件宽度，数字x标识占x个格子*/
        this.W1 = 72;
        this.W2 = 152;
        this.W3 = 232;
        this.W4 = 312;
        this.W5 = 360;
        this.W6 = 100;
        this.W7 = 160;

        /**描述文本框的宽高定义*/
        this.DESCR_WIDTH = this.W4;
        this.DESCR_HEIGHT = 56;

        /**名称文本框的宽高定义*/
        this.NAME_WIDTH = this.W4;
        this.NAME_HEIGHT = 26;


        /**容量单位*/
        this.KB = "KB";
        this.MB = "MB";
        this.GB = "GB";
        this.TB = "TB";
        this.PB = "PB";
        this.EB = "EB";

        /**表格单页显示的数据条数*/
        this.TABLE_COUNT_PER_PAGE = 10;
        this.TABLE_COUNT_PER_PAGE_BIG = 15;
        this.TABLE_COUNT_MAX_PAGE = 10000;
        this.TABLE_LENGTH_MENU = [10, 20, 50];
        this.TABLE_LENGTH_AUTO_MENU = [10, 15, 25, 50, 100];

        /**条件查询时，精确匹配内容*/
        this.SEARCH_EXACT_SIGN = '::';
        /**条件查询时，模糊匹配内容*/
        this.SEARCH_UNEXACT_SIGN = ':';

        /**修改密码窗口size*/
        this.MODIFY_PWD_WIN = {
            width: 330,
            width_en: 400,
            height: 230,
            height_en: 235
        };

        this.MODIFY_SITE_WIN = {
            width: 450,
            height: 338
        };

        this.STORAGE_ADD_WIN = {
            width: 660,
            height: 450
        };

        //UCD窗口大小规格(宽高,单位px)
        this.WIN_SIZE = {
            S1: [330, 162],
            S2: [450, 338],
            S3: [500, 375],
            S4: [600, 450],
            S5: [750, 565],
            S6: [800, 600],
            S7: [900, 600]
        };
        _.map(this.WIN_SIZE, function(v, k) {
            !/\dpx/.test(v[0]) && (v[0] += "px");
            !/\dpx/.test(v[1]) && (v[1] += "px");
        });

        this.Regex = {
            ip: "^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])$",
            ipv4 : "^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$",
            mask: "^(0.0.0.0|128.0.0.0|192.0.0.0|224.0.0.0|240.0.0.0|248.0.0.0|252.0.0.0|254.0.0.0|255.0.0.0|255.128.0.0|255.192.0.0|255.224.0.0|255.240.0.0|255.248.0.0|255.252.0.0|255.254.0.0|255.255.0.0|255.255.128.0|255.255.192.0|255.255.224.0|255.255.240.0|255.255.248.0|255.255.252.0|255.255.254.0|255.255.255.0|255.255.255.128|255.255.255.192|255.255.255.224|255.255.255.240|255.255.255.248|255.255.255.252|255.255.255.254|255.255.255.255)$",
            name: "^[\\u4e00-\\u9fa50-9a-zA-Z_]{1}[\\u4e00-\\u9fa5a-zA-Z_0-9-]{3,31}$",
            nameOther: "^[\\u4e00-\\u9fa5a-zA-Z_]{1}[\\u4e00-\\u9fa5a-zA-Z_0-9-]{0,31}$",
            ipv6: "^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$",
            subnetLeng: "^([1-9]?\d|1[01]\d|12[0-8])$",
            ipv6DefaultGatway: "^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$",
            ipv6DNS: "^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$",
            ipv6DNSBack: "^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$",
            telephone: "^[+]?(\\d|\\d[-]?\\d)+$",
            email: "^[a-zA-Z0-9\\.\\-_\\!\\#\\$\\%\\&\\'\\*\\+\\/\\=\\?\\^\\`\\{\\|\\}\\~]+@[a-zA-Z0-9\\-_]+(\\.[a-zA-Z0-9\\-_]+)+$",
            userName: "^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-.]*$",
            roleName: "^[\\u4e00-\\u9fa5a-zA-Z_]{1}[\\u4e00-\\u9fa5a-zA-Z_0-9-]{0,63}$",
            https:"^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$",
            az:"^[a-zA-Z_]{1}[\\w-.]{0,254}$",
        };

        /**------验证常量--------**/
        this.VALID = {
             NAME: [{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.name+"/"], errorDetail:language.validate_term_common_name_rule_msg}],
             NAME_DEVALIAS: [{validFn:"regularCheck", params:["/"+this.Regex.name+"/"], errorDetail:language.validate_term_common_name_rule_msg}],
             NAME_OTHER: [{validFn:"regularCheck", params:["/"+this.Regex.nameOther+"/"], errorDetail:language.validate_term_common_name_1_32_msg}],
             NAME_OTHER_REQUIRED: [{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.nameOther+"/"], errorDetail:language.validate_term_common_name_1_32_msg}],
             NAME_REQUIRED: [{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.name+"/"], errorDetail:language.validate_term_common_name_rule_msg}],
             ROLE_NAME_REQUIRED: [{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.roleName+"/"], errorDetail:language.validate_term_common_role_name_rule_msg}],
             NAME_DEVICE_MODIFY: [{validFn:"required"},{validFn:"rangeSize", params:[4,32], errorDetail:language.validate_term_common_length_range_4_32_msg}],
             NAME_EMPTY: [{validFn:"regularCheck", params:["/"+this.Regex.name+"/"], errorDetail:language.validate_term_common_name_rule_msg}],
             EMAIL: [{validFn:"maxSize", params:[254], errorDetail:language.validate_term_common_length_range_0_254_msg},{validFn:"regularCheck", params:["/"+this.Regex.email+"/"], errorDetail:language.validate_term_email}],
             EMAIL_REQUIRED: [{validFn:"required"},{validFn:"maxSize", params:[254], errorDetail:language.validate_term_common_length_range_1_254_msg},{validFn:"regularCheck", params:["/"+this.Regex.email+"/"], errorDetail:language.validate_term_email}],
             EMAIL_REQUIRED_NEW: [{validFn:"required"},{validFn:"maxSize", params:[254], errorDetail:language.validate_term_common_length_range_1_254_msg},{validFn:"regularCheck", params:["/"+this.Regex.email+"/"], errorDetail:language.validate_term_email}],
             AUTH_NAME: [{validFn:"required"},{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_1_32_msg}],
             AUTH_PWD: [{validFn:"required"},{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_1_32_msg}],
             AUTH_PWD_64: [{validFn:"required"},{validFn:"maxSize", params:[64], errorDetail:language.validate_term_common_length_range_1_64_msg}],
             Trap_NAME: [{validFn:"required"},{validFn:"maxSize", params:[64], errorDetail:language.validate_term_common_length_range_1_64_msg}],
             Trap_AUTH: [{validFn:"maxSize", params:[64], errorDetail:language.validate_term_common_length_range_0_64_msg}],
             Trap_AUTH_NAME: [{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_0_32_msg}],
             REMARK: [{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_0_32_msg}],
             REMARK_REQUIRED: [{validFn:"required"},{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_1_32_msg}],
             DES_REMARK: [{validFn:"maxSize", params:[255], errorDetail:language.validate_term_common_length_range_0_255_msg}],
             DES_REMARK_HUNDRED: [{validFn:"maxSize", params:[100], errorDetail:language.validate_term_common_length_range_0_100_msg}],
             DES_REMARK_REQUIRED: [{validFn:"required"},{validFn:"maxSize", params:[255], errorDetail:language.validate_term_common_length_range_1_255_msg}],
             TEL: [{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_1_32_msg},{validFn:"regularCheck", params:["/"+this.Regex.telephone+"/"], errorDetail:language.validate_term_common_tel_rule_msg}],
             TEL_REQUIRED: [{validFn:"required"},{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_1_32_msg},{validFn:"regularCheck", params:["/"+this.Regex.telephone+"/"], errorDetail:language.validate_term_common_tel_rule_msg}],
             SCRIPT_NAME: [{validFn:"regularCheck", params:["/^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*(\.bat|\.sh){1}$/"], errorDetail:language.validate_term_common_script_rule_msg}],
             SCRIPT_NAME_REQUIRED: [{validFn:"required"},{validFn:"regularCheck", params:["/^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*([.]bat|[.]sh){1}$/"], errorDetail:language.validate_term_common_script_rule_msg}],
             ALARM_REPORT_NAME:[{validFn:"required"},{validFn:"maxSize", params:[64], errorDetail:language.validate_term_common_length_range_1_64_msg},{validFn:"regularCheck", params:["/^[\\x00-\\xff]*$/"], errorDetail:language.validate_term_common_simple_name_rule_msg}],
             ENGINE_ID:[{validFn:"maxSize", params:[64], errorDetail:language.validate_term_common_length_range_1_64_msg},{validFn:"regularCheck", params:["/^[\\x00-\\xff]*$/"], errorDetail:language.validate_term_common_simple_name_rule_msg}],
             ENV_NAME:[{validFn:"maxSize", params:[64], errorDetail:language.validate_term_common_length_range_0_64_msg}],
             PWD: [{validFn:"required"},{validFn:"rangeSize", params:[8,32], errorDetail:language.validate_term_common_length_range_8_32_msg}],
             CONTEXT_ENGINE: [{validFn:"rangeSize", params:[5,32], errorDetail:language.validate_term_common_length_range_5_32_msg}],
             IP: [{validFn:"regularCheck", params:["/"+this.Regex.ip+"/"], errorDetail:language.validate_term_common_ip_rule_msg}],
             IPV4 : [{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.ipv4+"/"], errorDetail:language.validate_term_common_ip_v4_rule_msg}],
             OPENSTACK_IPV6 : [{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.ipv6+"/"], errorDetail:language.validate_term_common_ip_v6_rule_msg}],
             IP_STANDARD : [{validFn:"required"}, {validFn:"ipv4Standard", errorDetail:language.validate_term_common_ip_standard_rule_label}],
             MASK: [{validFn:"regularCheck", params:["/"+this.Regex.mask+"/"], errorDetail:language.validate_term_common_mask_rule_msg}],
             AUTH_ALARM_SOURCE : [{validFn:"maxSize", params:[32], errorDetail:language.validate_term_common_length_range_0_32_msg}],
             IP_STANDARD_NOT: [{validFn:"ipv4Standard", errorDetail:language.validate_term_common_ip_standard_rule_label}],
             HTTPS:[{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.https+"/"], errorDetail:language.validate_term_common_https_rule_msg}],
             AZ:[{validFn:"required"},{validFn:"regularCheck", params:["/"+this.Regex.az+"/"], errorDetail:language.validate_term_common_https_rule_msg}],
            /**
             * 合并验证规则
             * @param Array|String 验证规则,支持多个参数
             * @return Array 合并后的验证规则
             */
            union: function() {
                var arr = [];
                var len = arguments.length;

                for (var i = 0; i < len; i++) {
                    arr = arr.concat(toArray(arguments[i]));
                }

                return arr;

                //验证规则: string -> array
                function toArray(rule) {
                    if (angular.isArray(rule)) return rule;

                    var ruleArr = [];
                    var validFn, params, errorDetail;

                    rule.split(";").forEach(function(item) {
                        var temp = item.split(":")[0];
                        var sepIndex = temp.indexOf("(");
                        if (sepIndex != -1) {
                            validFn = temp.slice(0, sepIndex);
                            params = temp.slice(sepIndex + 1, temp.length - 1);
                        } else {
                            validFn = temp;
                            params = null;
                        }
                        errorDetail = item.split(":")[1];

                        var obj = {
                            validFn: validFn
                        };
                        params && (obj.params = params);
                        errorDetail && (obj.errorDetail = errorDetail);

                        ruleArr.push(obj);
                    });

                    return ruleArr;
                }
            }
        };

        /**------定义父子Controller间通讯的主题号 begin------*/
        this.TOPIC = {};
        /**设置通知*/
        this.TOPIC.SITE_TAB = "SITE_TAB";
        this.TOPIC.SITE_ISLOCAL = "LOCAL_SITE";
        this.TOPIC_HOME_SWITCH = "HOME_SWITCH";
        this.TOPIC.SITE_STORAGE_TAB = "SITE_STORAGE_TAB";
        this.TOPIC.SITE_CLOUD_TAB = "SITE_CLOUD_TAB";
        this.TOPIC.SITE_VRG_TAB = "SITE_VRG_TAB";

        /**------定义父子Controller间通讯的主题号 end------*/

        /**------定义临时缓存的key begin------*/
        this.CACHE = {};

        this.CACHE.BRICK_SEARCH_CONDITION = "BRICK_SEARCH_CONDITION";

        this.CACHE.NAMESPACE_SEARCH_CONDITION = "NAMESPACE_SEARCH_CONDITION";

        /**------定义当前告警相关begin------*/
        this.ALARM_BATCH_DEAL = {
            confirm: "/alarms/action/confirm",
            cancelConfirm: "/alarms/action/cancelConfirm",
            clear: "/alarms/action/clearAlarmConfirm",
            exportSelect: "/alarms/action/exportSelectedAlarms"
        };
        this.AlARM_TYPE_URL = {
            current: "/alarms",
            history: "/alarms/action/queryHistoryAlarms"
        };
        this.ALARM_LEVEL = {
            all: {
                id: "0",
                label: "common_term_all_label"
            },
            critical: {
                id: 4,
                label: "alarm_term_critical_label"
            },
            major: {
                id: 3,
                label: "alarm_term_major_label"
            },
            warn: {
                id: 2,
                label: "alarm_term_send_label"
            },
            info: {
                id: 1,
                label: "alarm_term_info_label"
            }
        };

        this.QUERY_TIME = {
            all: 0,
            oneMonth: 1,
            threeMonth: 3,
            sixMonth: 6,
            oneYear: 12,
            Time_24Hours: 24,
            threeDays: 3,
            Time_7Day: 7,
            Time_30Days: 30
        }
        this.COURRENT_ALARM_DETAIL_TITLE = "current_alarm_term_win_detail_title";
        this.COURRENT_ALARM_COUNT_TITLE = "current_alarm_term_win_count_title";
        this.ALARM_CLEAR_ERROR_TITLE = "current_alarm_term_win_batch_result_title";
        this.COURRENT_ALARM_DETAIL_URL = "app/business/recoverydirector/monitor/views/alarm/current/currentAlarmDetail.html";
        this.COURRENT_ALARM_COUNT_URL = "app/business/recoverydirector/monitor/views/alarm/current/currentAlarmCount.html";
        this.COURRENT_BATCH_RESULT_URL = "app/business/recoverydirector/monitor/views/alarm/current/batchResultWin.html";


        /**------定义临时缓存的key begin------*/
        this.NAS_TYPE = 14;
        this.VMware_VM_TYPE = 10;
        this.HUAWEI_VM_TYPE = 12;
        this.SelectDefaultId = "default";
        this.ORACLE_RECOVERY_TAB = "ORACLE_RECOVERY_TAB";
        this.RECOVERY_TAB = "RECOVERY_TAB";
        this.VMWARE_TREE_NODE = "com.huawei.ism.drm.vsphere.recovery.process.VsHangupNoncriticalVmProcessor"; //挂起VMWARE低优先级虚拟机管理
        this.HANGUP_TREE_NODE_1 = "com.huawei.ism.drm.galax.recovery.process.HangUpNoncriticalVmRecoveryProcessor"; //挂起云平台低优先级虚拟机管理
        this.HANGUP_TREE_NODE_2 = "com.huawei.ism.drm.galax.recovery.process.HangUpNoncriticalVmRecoveryProcessor"; //挂起VMWARE低优先级虚拟机管理
        this.START_VM_HOST_TREE_NODE_2 = "com.huawei.ism.drm.galax.storage.recovery.process.PowerOnHostRecoveryProcessor"; //上电主机管理
        this.HISTORY_EXCUTE_DETAIL = "recovery.term.history.colum.excuteDetail.check";

        /**------------定义恢复计划状态枚举值 -----------------**/
        this.VMWARE_EXECUTE = {
            winSize: {
                width:  752,
                heigth: 650
            },
            _tabTitle: {
                test: {
                    clusterMapping: "recovery.term.vCenterandClusterMapping.tab",
                    networkMapping: "recovery.term.networkMapping.tab"
                },
                fault: {
                    clusterMapping: "recovery.term.recoveryCluster.tab",
                    networkMapping: "recovery.term.recoveryNetwork"
                },
                move: {
                    clusterMapping: "recovery.term.recoveryCluster.tab",
                    networkMapping: "recovery.term.recoveryNetwork"
                }
            },
            _copyDesc: {
                test: {
                    sanSnapshot: "recovery.vm.task.testBasedOnSANSnapshot.des.label",
                    sanCopy: "recovery.vm.task.testBasedOnSANCopy.des.label",
                    nasCopy: "recovery.vm.task.testBasedOnNASCopy.des.label"
                },
                fault: {
                    sanSnapshot: "recovery.vm.task.recoveryBasedOnSANSnapshot.des.label",
                    sanCopy: "recovery.vm.task.recoveryBasedOnSANCopy.des.label",
                    nasCopy: "recovery.vm.task.recoveryBasedOnNASCopy.des.label"
                },
                move: {
                    sanSnapshot: "recovery.vm.task.recoveryBasedOnSANSnapshot.des.label",
                    sanCopy: "recovery.vm.task.recoveryBasedOnSANCopy.des.label",
                    nasCopy: "recovery.vm.task.recoveryBasedOnNASCopy.des.label"
                }
            },
            _clusterMappingDesc: {
                test: "recovery.vm.task.test.selvCenterAndCluster.label",
                fault: "recovery.vm.task.recovery.selvCenterAndCluster.label",
                move: "recovery.vm.task.recovery.selvCenterAndCluster.label"
            },
            _networkMappingDesc: {
                test: "recovery.vm.task.test.addNetworkMapping.des.label",
                fault: "recovery.vm.task.recovery.addNetworkMapping.des.label",
                move: "recovery.vm.task.recovery.addNetworkMapping.des.label"
            },
            _accessSettingDesc: {
                test: "recovery.vm.task.test.setAccess.des.label",
                fault: "recovery.vm.task.recovery.setAccess.des.label",
                move: "recovery.vm.task.recovery.setAccess.des.label"
            },
            _uncriticalVMDesc: {
                test: "recovery.vm.task.selUncriticalVM.des.label",
                fault: "recovery.vm.task.reocvery.selUncriticalVM.des.label",
                move: "recovery.vm.task.reocvery.selUncriticalVM.des.label"
            }
        };

        //私有云保护类型
        this.RECOVERY_PROTECTED_TYPE = {
            "csha": "CSHA",
            "csdr": "CSDR",
            "vha_csdr": "VHA+CSDR",
            "csha_csdr": "CSHA+CSDR"
        };


        this.LOCAL_TEST_REPLICAS_STATUS = {
            0: "disactivate",
            1: "activate"
        };

        this.RECOVERY_PLAN_EXECUTE_RESULT = {
            0: "success",
            1: "failed",
            2: "part_success",
            3: "running",
            "-1": "other"
        };

        this.RECOVERY_PLAN_EXECUTE_TYPE = {
            0: "disaster_recovery",
            1: "planed_motion",
            2: "drilling",
            3: "clean_drilling",
            4: "snapshot_rollback",
            7: "reprotect",
            8: "swap",
            9: "mount",
            10: "unmount",
            11: "hotmigration",
            "-1": "-1"
        };

        this.PROTECT_OBJECT_TYPE = {
            1: "Oracle",
            2: "SQLServer",
            3: "DB2",
            8: "Exchange",
            9: "FileSystem",
            10: "VMwareMachine",
            11: "LUN",
            12: "FusionSphereMachine"
        };

        this.PROTECT_OBJECT_STATUS = {
            0: "notstart",
            1: "completed",
            2: "failed",
            3: "running"
        };
        this.CURRENT_ALARM_DETAIL_APP = {
            0: "Oracle",
            1: "DB2",
            2: "SQL Server",
            3: "Exchange",
            4: "protection.term.localFS.label"
        };
        this.PROTECT_GROUP_STATUS = {
            /**
             *正常
             */
            NORMAL: 1,

            /**
             * 已禁用
             */
            DISABLED: 0,

            /**
             * 等待下次执行
             */
            WAITTING: 2,

            /**
             * 已锁定
             */
            LOCKED: 4,

            /**
             * 无效
             */
            INVALID: 3,

            /**
             * 正在执行
             */
            RUNNING: 5
        };

        this.POLICY_TEMPLATE_TYPE = {
            /**
             * 阵列点对点同步策略模板
             */
            ARRAY_REPLICA_SYNC: 0,

            /**
             * 阵列点对点异步策略模板
             */
            ARRAY_REPLICA_ASYNC: 1,

            /**
             * 阵列快照策略模板
             */
            ARRAY_SNAPSHOT: 2,

            /**
             * 阵列串联同步+异步策略模板
             */
            ARRAY_CASCADE_SYNC_ASYNC: 3,

            /**
             * 阵列串联异步+异步策略模板
             */
            ARRAY_CASCADE_ASYNC_ASYNC: 4,

            /**
             * 阵列并联同步+异步策略模板
             */
            ARRAY_CONCURRENT_SYNC_ASYNC: 5,

            /**
             * 阵列并联异步+异步策略模板
             */
            ARRAY_CONCURRENT_ASYNC_ASYNC: 6,

            /**
             * VIS双活+阵列异步复制策略模板
             */
            VIS_ASYNC_REPLICATION: 7,

            /**
             * VIS双活策略模板
             */
            VIS_REMOTE_MIRROR: 8,

            /**
             * VIS快照
             */
            VIS_SNAPSHOT: 9,

            /**
             * VIS三镜像
             */
            VIS_LOCAL_MIRROR: 10,

            /**
             * 主机复制(VRG)
             */
            VIRTUAL_REPLICATION_GATEWAY: 11,

            /**
             * VIS远程复制
             */
            VIS_REPLICATION: 12
        };


        /**------------恢复计划弹出窗口常理 -----------------**/
        this.EDIT_SETP_TREE_STATUS_ICON = {
            enable: "/theme/recoverydirector/images/recovery/ic_step_actived.png",
            disabled: "/theme/recoverydirector/images/recovery/ic_step_deactived.png"
        }

        this.remoteNetworkTitle = {
            "test": "recovery_network_test_label",
            "move": "recovery_network_move_label",
            "fault": "recovery_network_fault_label"
        }

        this.remoteNetworkValidate = {
            "test": "recovery_network_test_value",
            "move": "recovery_network_move_value",
            "fault": "recovery_network_fault_value"
        }

        this.LOCAL_TEST_EXCUTE_WIN_TITLE = {
            "test": "common_term_test_button",
            "excute": "ism.drm.protect.group.rollback.recovery.label"
        };

        this.REMOTE_MOVE_FAULT_PROTECT_WIN_TITLE = {
            "move": "common_term_plan_move_button",
            "fault": "common_term_fault_recovery_button",
            "protect": "common_term_protect_button",
            "test": "common_term_test_button"
        };

        this.EDIT_RECOVERY = {
            winId: "editRecoveryWinId",
            title: "recovery.term.recovery.plan.operate.edit",
            width: this.MODIFY_SITE_WIN.width,
            height: this.MODIFY_SITE_WIN.height,
            url: "app/business/recoverydirector/recovery/views/operate/editRecovery.html"
        };
        this.REPROTECT_RECOVERY = {
            winId: "reprotectRecoveryWinId",
            title: tinyLanguage.language.warnTitle,
            width:340,
            height:340,
            url: "app/business/recoverydirector/recovery/views/operate/reprotectRecovery.html"
        };
        //副本时刻保护对象和当前保护对象对比窗口
        this.COPY_PROTECTOBJ_DETAIL_WIN = {
            "winId":"protectObjDetailWinId",
            "title":"be_connected_protected_objects",
            "modal":true,
            "draggable": true,
            "width":900,
            "height":680,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/operate/protectObjInfo.html"
        };
        this.LOCAL_TEST_EXCUTE_RECOVERY = {
            winId: "localTestExcuteWinId",
            title: "recovery.term.recovery.plan.operate.test", //默认是测试
            width: 780,
            height: 700,
            url: "app/business/recoverydirector/recovery/views/operate/localTestExcuteRecovery.html"
        };
        this.REMOTE_TEST_RECOVERY = {
            winId: "remoteTestWinId",
            title: "recovery.term.recovery.plan.operate.test",
            width: 600,
            height: 450,
            networkType: {
                "test": "testNetwork",
                "move": "recoveryNetwork",
                "fault": "recoveryNetwork"
            },
            content: {
                huawei: "app/business/recoverydirector/recovery/views/operate/remoteTestRecovery.html",
                fusionsphere: "app/business/recoverydirector/recovery/views/operate/fusionsphereExecute.html",
                vmware: "app/business/recoverydirector/recovery/views/operate/vmwareExecute.html",
                msgWindow: "app/business/recoverydirector/recovery/views/operate/msgWindow.html"
            }
        };

        this.FUSIONSPHERE_LOCAL_EXECUTE = {
            winId: "fusionsphereLocalExcuteWinId",
            title: "recovery.term.recovery.plan.operate.test",
            width: 760,
            heigth: 640,
            FusionCompute: "app/business/recoverydirector/recovery/views/operate/fusionComputeExecute.html",
            FusionManager: "app/business/recoverydirector/recovery/views/operate/fusionManagerExecute.html"
        };

        this.ORACLE_PROSTART_SETTING_WIN = {
             winId: "oracleStartSettingWinId",
             width: 760,
             height: 640,
             url: "app/business/recoverydirector/recovery/views/protected/oracleSettingStart.html",
             title: "recovery.term.protected.startSetting.label"
         };

        this.START_SETTING_WIN = {
            winId: "startSettingWinId",
            width: 600,
            height: 500,
            url: "app/business/recoverydirector/recovery/views/protected/excuteSettingStart.html",
            title: "recovery.term.protected.startSetting.label"
        };

        this.VMWARE_VM_IP_WIN = {
            winId: "vmwareIpSetIdWinId",
            width: 500,
            height: 450,
            url: "app/business/recoverydirector/recovery/views/protected/vmwareIpSet.html",
            title: "recovery.term.protected.setIpAddress.label"
        };

        this.HUAWEI_VM_IP_WIN = {
            winId: "huaweiVMIpSetWinId",
            width: 700,
            height: 650,
            url: "app/business/recoverydirector/recovery/views/protected/fcIpSet.html",
            title: "recovery.term.protected.setIpAddress.label"
        };

        this.FM_VM_IP_WIN = {
            winId: "fmIpSetWinId",
            width: 700,
            height: 500,
            url: "app/business/recoverydirector/recovery/views/protected/fmIpSet.html",
            title: "recovery.term.protected.setIpAddress.label"
        };

        this.EDIT_STEP_WIN = {
            winId: "editStepWinId",
            width: 900,
            height: 650,
            url: "app/business/recoverydirector/recovery/views/procedure/editStep.html",
            title: "recovery.term.procedure.editStepLabel"
        };

        this.ADD_EDIT_STEP_WIN = {
            "winId": "addStepWinId",
            "verifyId": "addStepDiv",
            "width": 450,
            "height": 338,
            "data": {},
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "minimizable": false,
            "maximizable": false,
            "title": "recovery.term.procedure.addStepLabel",
            "content": "app/business/recoverydirector/recovery/views/procedure/addStep.html",
        };

        this.EXCUTE_HISTORY_DETAIL_WIN = {
            winId: "excuteDetailWinId",
            width: 1100,
            height: 600,
            url: "app/business/recoverydirector/recovery/views/history/viewExcuteDetail.html",
            title: "recovery.term.history.colum.excuteDetail.title"
        };
        this.MOVE_FM_FC_TO = {
            winId: "moveVMsToVrgId",
            width: 850,
            height: 600,
            url: "app/business/recoverydirector/site/views/resource/vrg/protectVMS/moveVMS.html",
            title: "vms_remove_to_vrg_title"
        };
        this.ADD_PROTECT_VMS = {
            winId: "addProtectVmsId",
            width: 900,
            height: 600,
            url: "app/business/recoverydirector/site/views/resource/vrg/protectVMS/addProtectVms.html",
            title: "add_protect_vms_title"
        };
        this.DELETE_FM_FC = {
            winId: "delete_pair_and_fm_fc",
            width: 330,
            height: 350,
            url: "app/business/recoverydirector/site/views/resource/vrg/protectVMS/deleteVmsAlarm.html",
            data: ["mapping_resource_rvg_vms_delete_warn_tips", "rvg_vms_enforce_delete_title", "rvg_delete_vms_help_title"],
            title: "delete_fm_fc_alarm_title"
        };
        this.DELETE_VRG_PAIR = {
            winId: "delete_pair_and_fm_fc",
            width: 330,
            height: 330,
            data: ["mapping_resource_vrg_delete_warn_tips", "rvg_vms_enforce_delete_title", "vrgPair_task_forceDelete_des_tip"],
            url: "app/business/recoverydirector/site/views/resource/vrg/protectVMS/deleteVmsAlarm.html",
            title: "delete_fm_fc_alarm_title"
        };

        //恢复计划执行历史详情弹出框
        this.RECOVERY_HISTORY_LOG = {
            "winId": this.EXCUTE_HISTORY_DETAIL_WIN.winId,
            "title": this.EXCUTE_HISTORY_DETAIL_WIN.title,
            "height": this.EXCUTE_HISTORY_DETAIL_WIN.height,
            "width": this.EXCUTE_HISTORY_DETAIL_WIN.width,
            "modal": true,
            "content-type": "url",
            "draggable": true,
            "minimizable": false,
            "maximizable": false,
            "content": this.EXCUTE_HISTORY_DETAIL_WIN.url
        };

        //恢复计划vmwareIp设置Linux
        this.VMWARE_LINUX_NETWORK_SET_WIN = {
            "winId": "linuxIpSetWinId",
            "data": {},
            "helpId": "vmwareIpSetIdWinId",
            "title": "recovery.term.protected.setIpAddress.label",
            "width":"650px",
            "height":"650px",
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/protected/vmNetworkSetLinux.html",
            "minimizable": false,
            "maximizable": false
        }

        //恢复计划windows下ip设置
        this.VMWARE_WINDOWS_NETWORK_SET_WIN = {
            "winId": "linuxIpSetWinId",
            "data": {},
            "helpId": "vmwareIpSetIdWinId",
            "title": "recovery.term.protected.setIpAddress.label",
            "width":"650px",
            "height":"650px",
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/protected/vmNetworkSetWindows.html",
            "minimizable": false,
            "maximizable": false
        }

        //恢复计划下openStack配置测试网络弹出窗口
        this.OPENSTACK_SET_TEST_NETWORK_WIN = {
            "winId": "openStackNetWorkSetWin",
            "data": {},
            "helpId":"fmIpSetWinId",
            "title": "reccovery_openstack_network_set_title",
            "width":"930px",
            "height":"565px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/protected/openStackNetWorkSet.html",
        };

        //FC批量导入测试网络配置信息错误提示弹出窗口
        this.FC_IMPORT_NETWORK_SETTING_ERROR_WIN = {
            "winId": "fcImportNetworkSettingErrorWin",
            "data": {},
            "title": "fc_import_network_setting_error_title",
            "width":"625px",
            "height":"470px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/protected/fcImportIpError.html",
            "controller": "app/business/recoverydirector/recovery/controllers/protected/fcImportIpErrorCtrl"
        };
        //fc导入文件窗口
        this.FC_IMPORT_NETWORK_SETTING_WIN = {
            "winId": "fcImportWin",
            "data": {},
            "title": "fc_import_network_setting_win_title",
            "width":"550px",
            "height":"220px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/protected/fcImpoetWin.html",
            "controller": "app/business/recoverydirector/recovery/controllers/protected/fcImportWinCtrl"
        };
        //azPair配对添加窗口
        this.ADD_AZ_PAIR_WIN = {
            "winId": "addAzPairWin",
            "data": {},
            "title": "common_term_add_button",
            "width":"450px",
            "height":"500px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/cloud/azPairAddWin.html",
            "controller": "app/business/recoverydirector/site/controllers/resource/cloud/azPairAddWinCtrl"
        };

	    //VHA azPair配对添加窗口
        this.ADD_VHA_AZ_WIN = {
            "winId": "vhaAzPairWin",
            "data": {},
            "title": "common_term_add_button",
            "verifyId": "vhaAzPairWin",
            "width":"450px",
            "height":"400px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/cloud/vhaAzPairAddWin.html",
            "controller": "app/business/recoverydirector/site/controllers/resource/cloud/vhaAzPairAddWinCtrl"
        };

        //添加region（endpoint）信息
        this.ADD_REGION_ENDPOINT_WIN = {
            "winId": "addRegionEndpointWin",
            "data": {},
            "title": "common_term_openstack_add_region_title",
            "width":"500px",
            "height":"520px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/cloud/addRegionEndpoint.html",
            "controller": "app/business/recoverydirector/site/controllers/resource/cloud/addRegionEndpointCtrl"
        };
        //修改Openstack下的Region的容灾设置窗口
        this.MODIFY_REGION_CONFIG_WIN = {
            "winId": "modifyRegionConfigWin",
            "data": {},
            "title": "common_term_openstack_add_region_title",
            "width":"540px",
            "height":"450px",
            "draggable": true,
            "modal": true,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/cloud/modifyRegionConfig.html",
            "controller": "app/business/recoverydirector/site/controllers/resource/cloud/modifyRegionConfigCtrl"
        }

        this.PROCEDURE_LEFT_TITLE_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareLeftTitle.html";
        this.PROCEDURE_LEFT_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareLeft.html";
        this.PROCEDURE_RIGHT_TITLE_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareRightTitle.html";
        this.PROCEDURE_RIGHT_URL = "app/business/recoverydirector/recovery/views/procedure/vmwareRight.html";

        /**------ 站点类型------*/
        this.SITE_TYPE = {
            0: "common_term_local_label",
            1: "common_term_remote_label",
            2: "common_term_all_site_label"
        };

        /**------ 窗口静态配置 ------*/
        //增加保护对象
        this.ADD_PO_WIN = {
            "winId": "ADD_PO_WIN",
            "title": "ism.drm.add.po.batch.title",
            "width": Consts.WIN_SIZE.S3[0],
            "height": 620,
            enAddtionWidth: "80",
            "minimizable": false,
            "maximizable": false,
            "content-type": "url"
        };

        //虚拟机增加保护对象
        this.VM_ADD_PO_WIN = {
            "winId": "ADD_PO_WIN",
            "title": "ism.drm.add.po.batch.title",
            "width": 900,
            "height": 600,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/addProtectObjects.html"
        };

        //vm_nas快照添加移除保护对象
        this.VM_NAS_PO_MODIFY = {
            "winId": "VM_NAS_PO_MODIFY",
            "title": "ism.drm.add.po.batch.title",
            "width": 900,
            "height": 600,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/nasSnapshotModifyProtectObjects.html"
        };

        //openStack卷管理窗口
        this.VOLUME_MANAGE_WIN = {
            "winId":"VOLUME_MANAGE_WIN",
            "title":"volume_manage_win_title_label",
            "helpId":"VOLUME_MANAGE_WIN",
            "width":800,
            "height":600,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content":"app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/volumeManage.html"
        }


        //修改保护对象
        this.MODIFY_PO_WIN = "MODIFY_PO_WIN";
        //修改保护组
        this.MODIFY_PG_WIN = {
            "winId": "MODIFY_PG_WIN",
            "title": "ism.drm.pg.modifypg",
            "width": Consts.MODIFY_SITE_WIN.width,
            "height": Consts.MODIFY_SITE_WIN.height,
            "minimizable": false,
            "maximizable": false,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/protectionGroupEdit.html"
        };
        //修改策略
        this.MODIFY_POLICY_WIN = {
            winId: "MODIFY_POLICY_WIN",
            title: "ism.drm.schedule.modify.title",
            width: Consts.WIN_SIZE.S4[0],
            height: Consts.WIN_SIZE.S4[1],
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/modifyPolicy.html"
        };
        //数据库测试连接窗口
        this.DB_TEST_WIN = {
            winId: "DB_TEST_WIN",
            title: "ism.drm.dialog.title.verify",
            width: "350",
            height: "265",
            enAddtionWidth: "60",
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/dbTestWin.html"
        };
        //修改认证信息
        this.MODIFY_DB_TEST_WIN = {
            winId: "MODIFY_DB_TEST_WIN",
            title: "ism.drm.host.modify.verify",
            width: "350",
            height: "265",
            enAddtionWidth: "50",
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/modifyDbTestWin.html"
        };
         //修改数据库保护设置
        this.MODIFY_DB_PROTECT_WIN = {
            winId: "MODIFY_DB_PROTECT_WIN",
            title: "protection_term_modifyProtectionSetting_button",
            width: "600",
            height: "338",
            enAddtionWidth: "40",
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/modifyDbProtectWin.html"
        };
        //创建保护组匹配失败的策略模板
        this.PT_FAILED_WIN = {
            winId: "PT_FAILED_WIN",
            title: "ism.drm.template.schedule.failed",
            width: Consts.WIN_SIZE.S6[0],
            height: Consts.WIN_SIZE.S6[1],
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/ptFailedWin.html"
        };
        //保护组执行详情窗口
        this.PG_EXEC_DETAIL = {
            winId: "PG_EXEC_DETAIL",
            title: "task_term_exec_detail_label",
            width: 1100,
            height: 600,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/pgExecDetail.html"
        };
        //保护组编辑步骤
        this.PG_EDIT_STEP = {
            winId: "PG_EDIT_STEP",
            title: "recovery.term.procedure.editStepLabel",
            width: 800,
            height: 600,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/editStep.html"
        };
        //vmware存储组和lun的对应关系
        this.DG_LUN_WIN = {
            winId: "DG_LUN_WIN",
            title: "protection_VMware_task_createPG_setProtectedObject_viewDSGroup_wintitle",
            width: 550,
            height: 590,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/viewStorageResWin.html"
        };
        //一致性组和lun的对应关系
        this.REP_LUN_WIN = {
            winId: "REP_LUN_WIN",
            title: "ism.drm.lun.list",
            width: 450,
            height: 500,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/lun/viewRepLunWin.html"
        };
        //nas保护对象
        this.NAS_PO_WIN = {
            winId: "NAS_PO_WIN",
            title: "protection_oracle_task_create_addNAS_label",
            width:  600,
            height: 600,
            enAddtionHeight : 20,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/nasPoWin.html"
        };
         //克隆存储配置信息
        this.CLONE_STORAGE_INFO = {
            winId: "CLONE_STORAGE_INFO",
            title: "protection_lun_task_setPolicy_para_storageConfigInfo_label",
            width:  600,
            height: 500,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/cloneStorageInfo.html"
        };
        //显示主机keys集合信息
        this.KEYS_WIN={
            winId:"keys",
            helpId: "hostKeysWinHelp",
            width:500,
            height:375,
            minimizable: false,
            maximizable: false,
            draggable: true,
            title: window.tinyLanguage.language.promptTitle,
            "content-type": "url",
            content: "app/framework/common/views/keysWin.html"
        };
        //系统配置数据导出密码输入窗口
        this.EXPORT_PWD_WIN={
            winId:"exportWin",
            winContentId:"dataExportWin",
            "helpId": "dataExportWinHelp",
            width:400,
            height:300,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            content:"app/business/recoverydirector/setting/views/maintance/exportWin.html"
        };
        //openstack添加region窗口
        this.ADD_OPENSTACK_REGION_WIN={
            winId:"addRegionWin",
            title:"common_term_openstack_add_region_title",
            width:500,
            height:375,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            content:"app/business/recoverydirector/site/views/resource/storage/addRegion.html"
        };
        //保护组查看插件数据库的窗口
        this.SHOW_POCONLIST_WIN={
            winId:"showPoConList",
            title:"common_term_showConPoList_button",
            width: 600,
            height: 535,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            content:"app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/showProPdbList.html"
        };
        //NAS租户下的文件系统窗口
        this.NAS_FILE_SYSTEM_WIN={
            winId: "NAS_FILE_SYSTEM_WIN",
            title: "ism.drm.add.pg.fs.title",
            width: 450,
            height: 500,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/nasfs/viewNasFileWin.html"
        };
        //SAN双活测试窗口
        this.SAN_HYPERMETRO_TEST_WIN={
            winId: "SAN_HYPERMETRO_TEST_WIN",
            title: "common_term_test_button",
            width: 500,
            height: 375,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            content: "app/business/recoverydirector/recovery/views/operate/sanTestExcute.html"
        };
        //NAS双活切换窗口
        this.NAS_HYPERMETRO_SWITCH_WIN={
            winId: "NAS_HYPERMETRO_SWITCH_WIN",
            title: "conmon_ter_msg_label",
            width: 500,
            height: 420,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            content: "app/business/recoverydirector/recovery/views/operate/nasSwitchExcute.html"
        };
        //SAN一体化备份挂载策略设置窗口
        this.SAN_MOUNT_POLICY_WIN = {
            winId: "san_mount_policy_win",
            data: {},
            title: "",
            helpId: "",
            width: 630,
            height: 460,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/mountPolicyWin.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/mountPolicyWinCtrl"
        };
        //SAN一体化备份挂载副本窗口
        this.SAN_REPLICA_MOUNT_WIN = {
            winId: "san_replica_mount_win",
            data: {},
            title: "",
            helpId: "",
            width: 475,
            height: 350,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/replicaMountWin.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/virtualization/replicaMountWinCtrl"
        };
        //SAN一体化备份创建二级副本窗口
        this.SAN_CREATE_REPLICA_WIN = {
            winId: "san_create_replica_win",
            data: {},
            title: "",
            helpId: "",
            width: 500,
            height: 400,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/createReplicaWin.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/virtualization/createReplicaWinCtrl"
        };
        //SAN一体化备份卸载副本窗口
        this.SAN_UNMOUNT_REPLICA_WIN = {
            "winId": "san_unmount_replica_win",
            "data": {},
            "title": "",
            "helpId": "",
            "width": 400,
            "height": 225,
            "minimizable": false,
            "maximizable": false,
            "draggable": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/ummountReplicaWin.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/virtualization/ummountReplicaWinCtrl"
        }
        //FusionStorage异步复制复制目标存储窗口
        this.TARGET_STORAGE_POOL_WIN = {
            winId: "target_storage_pool_win",
            data: {},
            title: "",
            helpId: "",
            width: 600,
            height: 550,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/copyStoragePolicy.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/copyStoragePolicyCtrl"
        }
        //FusionStorage异步复制添加保护组
        this.ADD_FUSIONSTORAGE_PO_WIN = {
            winId: "add_fusionstorage_po_win",
            data: {},
            title: "",
            helpId: "",
            width: 920,
            height: 640,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/fusionStorageAddProtectObjects.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/virtualization/fusionStorageAddProtectObjectsCtrl"
        }
        //FusionStorage异步复制卷管理窗口
        this.FUSIONSTORAGE_VOLUME_MANAGE_WIN = {
            winId: "fusionstorage_volume_manage_win",
            data: {},
            title: "",
            helpId: "",
            width: 650,
            height: 500,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/fusionStorageVolManage.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/virtualization/fusionStorageVolManageCtrl"
        }
        //FusionStorage异步复制卷管理更新窗口
        this.FUSIONSTORAGE_VOLUME_UPDATE_WIN = {
            winId: "fusionstorage_volume_update_win",
            data: {},
            title: "",
            helpId: "",
            width: 550,
            maxHeight: 450,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/fusionStorageVolUpdate.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/virtualization/fusionStorageVolUpdateCtrl"
        }
        //vmware挂载窗口设置网络窗口
        this.VM_MOUNT_NETWORK_CONFIG_WIN = {
            winId: "vm_mount_network_config_win",
            data: {},
            title: "",
            helpId: "",
            width: 700,
            height: 560,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/vmwareMountNetworkConfig.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/vmwareMountNetworkConfigCtrl"
        };

        //配置脚本参数窗口
        this.CONFIG_SCRIPT_PARAMS_WIN = {
            "winId": "config_script_params_win",
            "verifyId": "config_script_params_win",
            "data": {},
            "title": "protection_lun_script_config_label",
            "helpId": "",
            "width": "600px",
            "height": "500px",
            "minimizable": false,
            "maximizable": false,
            "modal": true,
            "draggable": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/configScriptParamWin.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/configScriptParamWinCtrl",
            "sysDefController": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/configPublicScriptParamWinCtrl"
        };
        //vmware 挂载计划虚拟机IP设置窗口
        this.VMWARE_MOUNT_IP_CONFIG_WIN = {
            winId: "vmware_mount_ip_config_win",
            data: {},
            title: "",
            helpId: "",
            width: 800,
            height: 600,
            minimizable: false,
            maximizable: false,
            draggable: true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/vmwareMountIpConfig.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/vmwareMountIpConfigCtrl"
        }
        //挂载策略和创建挂载计划取消勾选挂载前先卸载已挂载的副本提示框
        this.UNMOUNTPREVIOUSCOPY_TIPS_WIN = {
            "winId": "datamount_unmountPreviousCopy_tips_win",
            "data": {},
            "title": "",
            "helpId": "",
            "width": 300,
            "height": 220,
            "minimizable": false,
            "maximizable": false,
            "draggable": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/operate/unmountpreviouscopyTipsWin.html",
            "controller": "app/business/recoverydirector/recovery/controllers/operate/unmountpreviouscopyTipsWinCtrl"
        };

        /**------ 事件 ------*/
        //第二步预览区事件
        this.PG_STEP2_CUSTOM_PREVIEW_EVENT = "PG_STEP2_CUSTOM_PREVIEW_EVENT";
        //选择保护组的数据类型
        this.PG_TYPE_SELECT_EVENT = "PG_TYPE_SELECT_EVENT";
        //选择策略模版
        this.PG_SELECT_EVENT = "PG_SELECT_EVENT";
        this.TP_SELECT_EVENT = "TP_SELECT_EVENT";
        //修改策略模版
        this.TP_MODIFY_EVENT = "TP_MODIFY_EVENT";
        //策略_时间表数据收集
        this.SCHEDULE_DATA_COLLECTION_EVENT = "SCHEDULE_DATA_COLLECTION_EVENT";
        //策略_应用配置数据收集
        this.SCHEDULE_APP_DATA_COLLECTION_EVENT = "SCHEDULE_APP_DATA_COLLECTION_EVENT";
        //策略_快照数据收集
        this.SCHEDULE_SNAPSHOT_DATA_COLLECTION_EVENT = "SCHEDULE_SNAPSHOT_DATA_COLLECTION_EVENT";
        //策略_vis快照数据收集
        this.SCHEDULE_VIS_SNAPSHOT_DATA_COLLECTION_EVENT = "SCHEDULE_VIS_SNAPSHOT_DATA_COLLECTION_EVENT";
        //策略RPO数据收集
        this.SCHEDULE_RPO_DATA_COLLECTION_EVENT = "SCHEDULE_RPO_DATA_COLLECTION_EVENT";
        this.TP_MODIFY_RESULT_EVENT = "TP_MODIFY_RESULT_EVENT";
        this.TP_MODIFY_PARAMFILL_EVENT = "TP_MODIFY_PARAMFILL_EVENT";
        this.TP_MODIFY_PARAMFILL_BACK = "TP_MODIFY_PARAMFILL_BACK";
        this.MODIFY_PO_WIN = "MODIFY_PO_WIN";
        this.middle = "middle";
        //超时时间半个小时
        this.AJAX_TIMEOUT = "1800000";
        //无效值
        this.INVALID_VALUE = "--";
        //标点符号
        this.COLON = ":";
        //状态改变
        this.TOPIC.PG_STATUS_CHANGE = "PG_STATUS_CHANGE";
        //列表更新
        this.TOPIC.PG_LIST_UPDATE = "PG_LIST_UPDATE";
        //站点更改
        this.TOPIC.PG_SITE_CHANGE = "PG_SITE_CHANGE";
        //存储更改
        this.TOPIC.PG_STORAGE_CHANGE = "PG_STORAGE_CHANGE";

        //策略模板修改时间策略窗口配置
        this.TP_SCHEDULE_WIN = {
            //快照
            toSnapHostModifyTempLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 550,
                height: 565,
                enAddtionWidth: "50",
                minimizable: false,
                maximizable: false,
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/snapshotTemplateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/snapshotTemplateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl"
            },
            //vis快照
            toVisSnapHostModifyTempLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 540,
                height: 580,
                enAddtionWidth: "50",
                minimizable: false,
                maximizable: false,
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/visSnapshotTemplateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/visSnapshotTemplateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl"
            },
            //异步复制
            toModifyTemplateLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 550,
                height: 500,
                minimizable: false,
                maximizable: false,
                enAddtionHeight: "40",
                enAddtionWidth: "50",
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl"
            },
            //同步复制
            toModifySyncTemplateLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 550,
                height: 485,
                minimizable: false,
                maximizable: false,
                enAddtionHeight: "40",
                enAddtionWidth: "50",
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelSyncContent.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelSyncContentCtrl"
            },
            //3dc
            toAsSyncsModifyTemplateLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 530,
                height: 480,
                minimizable: false,
                maximizable: false,
                enAddtionHeight: "40",
                enAddtionWidth: "70",
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/asSyncsTemplateModifyPanel.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/asSyncsTemplateModifyPanelCtrl"
            },
            //主机复制
            toModifyHostTemplate: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 515,
                height: 590,
                enAddtionWidth: "50",
                minimizable: false,
                maximizable: false,
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/hostTemplateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/hostTemplateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl"
            },

            //克隆
            toModifyHyperCloneTemplateLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 530,
                height: 560,
                minimizable: false,
                maximizable: false,
                enAddtionHeight: "40",
                enAddtionWidth: "70",
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModifyClone.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyCloneCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelClone.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelCloneCtrl"
            },

            //双活+快照
            toHyperMetroSnapShotModifyTempLink:{
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 540,
                height: 560,
                enAddtionWidth: "50",
                minimizable: false,
                maximizable: false,
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/snapshotTemplateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/snapshotTemplateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/asSyncsTemplateModifyPanel.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/asSyncsTemplateModifyPanelCtrl"
            },

            //一体化备份
            toHyperVaultModifyTempLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 540,
                height: 540,
                enAddtionWidth: "50",
                minimizable: false,
                maximizable: false,
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/snapshotTemplateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/snapshotTemplateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/toHyperVaultModifyTempLink.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/toHyperVaultModifyTempLinkCtrl"
            },

            toOpenStackVolumnModifyTempLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 550,
                height: 500,
                minimizable: false,
                maximizable: false,
                enAddtionHeight: "20",
                enAddtionWidth: "50",
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelOpenStackSync.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelOpenStackSyncCtrl"
            },
            //FSB Block 快照支持挂载
            toFsbBlockSnapHostModifyTempLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 550,
                height: 565,
                enAddtionWidth: "50",
                minimizable: false,
                maximizable: false,
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/snapshotTemplateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/snapshotTemplateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/fusionStorageBlockSnapTempLink.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/fusionStorageBlockSnapTempLinkCtrl"
            },
            //FusionStorage 异步复制
            toFusionStorageModifyTemplateLink: {
                winId: "ModifyTempLink",
                title: "ism.drm.schedule.modify.title",
                width: 550,
                height: 500,
                minimizable: false,
                maximizable: false,
                enAddtionHeight: "40",
                enAddtionWidth: "50",
                "content-type": "url",
                content: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModify.html",
                controller: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyCtrl",
                panelView: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/scheduleFusionStorageAsync.html",
                panelCtrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/scheduleFusionStorageAsyncCtrl"
            },

            get: function(editTemplateUrl,isBaseWin){
                if(!editTemplateUrl && _.isUndefined(isBaseWin)) return;

                var winId;

                if( editTemplateUrl ){
                    //双活+异步复制和异步复制+双活复用异步复制
                    if( editTemplateUrl.indexOf("toAsyncHypermetroModifyTemplateLink") != -1 || editTemplateUrl.indexOf("toHypermetroAsyncModifyTemplateLink") != -1 || editTemplateUrl.indexOf("toHypermetroAsyncRingModifyTemplateLink") != -1 || editTemplateUrl.indexOf("toAsyncHypermetroRingModifyTemplateLink") != -1){
                        winId = "toModifyTemplateLink";
                    }else if (editTemplateUrl.indexOf("toHyperMetroVaultModifyTempLink") != -1 ){
                        winId = "toHyperVaultModifyTempLink";
                    } else {
                        angular.forEach(["toModifyTemplateLink", "toVisSnapHostModifyTempLink", "toHyperMetroSnapShotModifyTempLink",
                                "toSnapHostModifyTempLink", "toAsSyncsModifyTemplateLink", "toModifyHostTemplate", "toModifyHyperCloneTemplateLink", "toHyperVaultModifyTempLink"
                            ],
                            function(v) {
                                if (editTemplateUrl.indexOf(v) != -1) {
                                    winId = v;
                                }
                            }
                        );
                    }
                }

                //复制速率,同步 4DC复用3DC的模板
                if( isBaseWin == "3" ||  isBaseWin == "5" || isBaseWin == "35" || isBaseWin == "36"){
                    winId = "toAsSyncsModifyTemplateLink";
                } else if (isBaseWin == "0" || isBaseWin == "23" || isBaseWin == "24") {
                    winId = "toModifySyncTemplateLink";
                } else if (isBaseWin == "21" || isBaseWin == "22") {
                    winId = "toOpenStackVolumnModifyTempLink";
                } else if (isBaseWin == "28") {
                    winId = "toHyperVaultModifyTempLink";
                } else if (isBaseWin == "30" || isBaseWin == "31" || isBaseWin == "32") {
                    //SAN一体化备份和SAN双活+一体化备份复用nas一体化备份
                    winId = "toHyperVaultModifyTempLink";
                }else if(isBaseWin == "33"){
                    //FusionStorage虚拟化异步复制容灾
                    winId = "toFusionStorageModifyTemplateLink";
                }else if (isBaseWin == "2"){
                    //FSB Block 快照
                    winId = "toFsbBlockSnapHostModifyTempLink";
                } else if (isBaseWin === true) {
                    var win = angular.copy(this[winId]);
                    win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/scheduleWin.html";
                    return win;
                }

                return angular.copy(this[winId]);
            }
        };

        //启动华为虚拟机
        this.startFusionsphereLink = {
            winId: "startFusionsphereLink",
            title: "protection_VR_task_start_title_label",
            width: Consts.WIN_SIZE.S1[0],
            height: Consts.WIN_SIZE.S2[1],
            enAddtionHeight: "20",
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            content: "app/business/recoverydirector/protection/views/protectiongroup/fusionsphere/startFusionsphereWin.html"
        };

        //错误描述配置
        this.ERROR_DESC = {
            "err_hasPublicFolder" : "protection_createExchange_task_selObject_para_db_notSupportpublicFolder_validation"
        };

        this.RM_ENUM = {
            'cluster' : 0,
            'host' : 1,
            'network' : 3,
            'portGroup' : 2,
            'securityGroup' : 4,
            'dataStore' : 6,
            'vrg' : 5,
            "getName": function(type) {
                var name = "";
                angular.forEach(this,function(value,key){
                    value === +type && (name = key);
                });

                return name;
            }
        };

        this.RM_EDIT = {
            winId: "RM_EDIT",
            title: "rm_term_modify_title",
            width: Consts.WIN_SIZE.S5[0],
            height: Consts.WIN_SIZE.S5[1],
            minimizable: false,
            maximizable: false,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            content: "app/business/recoverydirector/site/views/resource/base/rm/editMapping.html"
        };

        this.RM_URL = {
            mappingURL: "/resourcemapping",
            fusionsphereURL: "/fusionsphere"
        };

        this.DEFAULT_DISPLAY = "--";

        this.AppType = {
            1: "Oracle",
            2: "SQL Server",
            3: "DB2",
            8: "Exchange",
            9: "FileSystem",
            getType: function(label) {
                for (var type in this) {
                    if (label == this[type]) {
                        return type;
                    }
                }
                return -1;
            }
        };

        this.COLON = ":";

        this.WIN_HELP_MAP = {
            "storageLinkDetail": "add_device.html",
            "hostLinkDetail": "add_host.html",
            "hostKeysWinHelp": "add_host.html",
            "switchVisCluster": "add_device.html",
            "currentAlarmDetailWin": "deal_current_alarm.html",
            "excuteDetailWinId": "view_recoveryplan.html",
            "addStepWinId": "as_custom_rpstep.html",
            "hostAddToGroupWinId": "add_host.html",
            "modifyHostGoupWinId": "manager_hostg.html",
            "modifyDevAliasWinId": "manager_storage.html",
            "visWinId": "add_device.html",
            "addProtectVmsId": "add_protected_vm.html",
            "moveVMsToVrgId": "manager_pv.html",
            "aboutWin": "view_homepage.html",
            "modifyPwdWin": "modify_loguser_password.html",
            "resetPwdWin": "login.html",
            "win_role_view_id": "system_admin_group_management.html",
            "win_role_users_id": "system_admin_management.html",
            "MODIFY_DB_TEST_WIN": "manager_protect_object.html",
            "DB_TEST_WIN": "as_execute_pg.html",
            "PG_EXEC_DETAIL": "view_protectgroup.html",
            "PG_EDIT_STEP": "edit_protectgroup_step.html",
            "NAS_PO_WIN": "as_create_protectgroup_oracle.html",
            "PT_FAILED_WIN": "manager_pp.html",
            "MODIFY_PG_WIN": "manager_pg.html",
            "ADD_PO_WIN": "add_protectobject.html",
            "ModifyTempLink": "manager_pp.html",
            "startFusionsphereLink": "as_create_protectgroup_fsvm.html",
            "DG_LUN_WIN": "add_device.html",
            "currentCountDetailWin": "deal_current_alarm.html",
            "editRecoveryWinId": "view_recoveryplan.html",
            "localTestExcuteWinId": "test_rp.html",
            "remoteTestWinId": "test_rp.html",
            "startSettingWinId": "as_custom_start.html",
            "vmwareIpSetIdWinId": "as_custom_start.html",
            "huaweiVMIpSetWinId": "as_custom_start.html",
            "fmIpSetWinId": "as_custom_start.html",
            "editStepWinId": "as_custom_rpstep.html",
            "vrgPair": "manager_resource_mapping.html",
            "addSite": "as_create_site.html",
            "modifySite": "manager_site.html",
            "createResourcePool": "lp_add_device.html",
            "modifyResourcePool": "manager_pool.html",
            "addRemoteServer": "discover_remoteserver.html",
            "modifyLocalServer": "manager_managementserver.html",
            "modifyRemoteServer": "manager_managementserver.html",
            "addTrapAddress": "config_north_trap.html",
            "modifyTrapAddress": "config_north_trap.html",
            "addNotifyObj": "config_remote_notify.html",
            "modifyNotifyObj": "config_remote_notify.html",
            "addSeg": "create_admin_user.html",
            "modifySeg": "modify_admin.html",
            "vmwareIncrementTypeExecuteTest": "test_rp.html",
            "vmwareIncrementTypeExecuteMove": "planned_migration.html",
            "vmwareIncrementTypeExecuteFault": "faultrecovery.html",
            "addHostSettintProtocal" : "add_host.html",
            "addVrgSettintProtocal" : "add_vrg.html",
            "modifyHostDevAlias" : "manager_hostg.html",
            "modifyVrgDevAlias" : "manager_fs.html",
            "modifyFcAndFm" : "manager_fs.html",
            "modifyvCenter" : "manager_vcenter.html",
            "RM_EDIT" : "manager_resource_mapping.html",
            "PG_EDIT_STEP": "edit_protectgroup_step.html",
            "dataExportWinHelp": "export_data.html",
            "modifyOpenstackAlias": "manager_fs.html",
            "VOLUME_MANAGE_WIN": "volume_manage.html",
            "PG_AD_VIRTUAL_WIN": "add_openstvm.html",
            "oracleStartSettingWinId": "as_custom_start.html",
            "addBcvObjectsHelp": "bcv_addremove.html",
            "setBcvPolicyHelp": "bcv_modify_policy.html",
            "modifyBcvStepsHelp": "bcv_custom_rpstep.html",
            "addBackupPool": "bcv_create_storage_pool.html",
            "addBackupStorageRespo": "bcv_create_storage_respo.html"
        };

        this.HELP_MAP = {
            "home.staticView": "view_homepage.html",
            "home.topoVew": "view_homepage.html",
            "protection.pg.list": "view_protectgroup.html",
            "protection.pg.list.abstract": "view_protectgroup.html",
            "protection.pg.list.topogoly": "view_protectgroup.html",
            "protection.pg.list.protectobjects": "view_protectgroup.html",
            "protection.pg.list.protectobjects_vmware": "view_protectgroup.html",
            "protection.pg.list.protectobjects_fusionsphere": "view_protectgroup.html",
            "protection.pg.list.policy": "view_protectgroup.html",
            "protection.pg.list.duplica": "view_protectgroup.html",
            "protection.pg.list.executionhistory": "view_protectgroup.html",
            "protection.template": "manager_pp.html",
            "protection.template.abstract": "manager_pp.html",
            "dataUse.createRecoveryPlan": "create_recoveryplan.html",
            "dataUse.dataRecovery.abstract": "view_recoveryplan.html",
            "dataUse.dataRecovery.protected": "view_recoveryplan.html",
            "dataUse.dataRecovery.procedure": "view_recoveryplan.html",
            "dataUse.dataRecovery.history": "view_recoveryplan.html",
            "monitor.topo": "as_topo.html",
            "monitor.currentalarmlist": "deal_current_alarm.html",
            "monitor.historyalarmlist": "deal_history_alarm.html",
            "monitor.alarmnotify": "config_remote_notify.html",
            "monitor.modifyNotify": "config_remote_notify.html",
            "monitor.modifyNotify.basicInfo": "config_remote_notify.html",
            "monitor.modifyNotify.notifyTarget": "config_remote_notify.html",
            "monitor.modifyNotify.resources": "config_remote_notify.html",
            "monitor.modifyNotify.alarm": "config_remote_notify.html",
            "monitor.audiosetting": "config_audio_notify.html",
            "monitor.groupstatreport": "as_view_pg_reporter.html",
            "monitor.recoverytestreport": "as_view_rp_reporter.html",
            "settings": "view_homepage.html",
            "site.discovery?type=homestorage": "add_device.html",
            "site.discovery?type=homevCenter": "add_vCenter.html",
            "site.discovery?type=storage": "add_device.html",
            "site.discovery?type=vCenter": "add_vCenter.html",
            "site.discovery?type=openStack": "add_fsopenstack.html",
            "site.siteList": "manager_site.html",
            "site.home": "manager_site.html",
            "site.storage.resourcePool": "manager_storage.html",
            "site.cloud": "manager_fs.html",
            "site.addRMWizard": "manager_resource_mapping.html",
            "site.cloud.relationVM": "manager_pv.html",
            "site.cloud.rm?type=network": "manager_resource_mapping.html",
            "site.cloud.rm?type=securityGroup": "manager_resource_mapping.html",
            "site.cloud.rm?type=cluster": "manager_resource_mapping.html",
            "site.cloud.rm?type=host": "manager_resource_mapping.html",
            "site.cloud.rm?type=portGroup": "manager_resource_mapping.html",
            "site.cloud.rm?type=dataStore": "manager_resource_mapping.html",
            "site.vmware": "manager_vcenter.html",
            "settings.userList": "system_admin_management.html",
            "settings.userAdd": "create_admin_user.html",
            "settings.userEdit": "modify_admin.html",
            "settings.roleList": "system_admin_group_management.html",
            "settings.roleAdd": "create_admin_group.html",
            "settings.roleEdit": "modify_admin_group.html",
            "settings.onlineUserList": "config_online_admin.html",
            "settings.securityPolicy": "config_security_policy.html",
            "settings.performance": "view_monitor.html",
            "settings.operLogMaintance": "set_log_dump.html",
            "settings.alarmMaintance": "config_alarm_dump.html",
            "settings.sysData": "export_data.html",
            "settings.dataExport": "import_server_archive.html",
            "settings.sysOperLog": "export_operation_log.html",
            "settings.debugLog": "export_debug_log.html",
            "settings.approveServer": "config_radius_server.html",
            "settings.license": "import_license.html",
            "site.vmware.vmList" : "manager_vcenter.html",
            "site.cloud.vmList" : "manager_fs.html",
            "site.cloud.openStackVmList" : "manager_fs.html",
            "site.cloud.pairInfo" : "configure_vrgpair.html",
            "site.addRMWizard?type=cluster" : "manager_resource_mapping.html",
            "site.addRMWizard?type=network" : "manager_resource_mapping.html",
            "site.addRMWizard?type=securityGroup" : "manager_resource_mapping.html",
            "site.addRMWizard?type=cluster" : "manager_resource_mapping.html",
            "site.addRMWizard?type=host" : "manager_resource_mapping.html",
            "site.addRMWizard?type=portGroup" : "manager_resource_mapping.html",
            "site.addRMWizard?type=dataStore" : "manager_resource_mapping.html",
            "site.cloud.openStackAzPairList": "add_openstackmapping_C10.html",
            "settings.oc_manage": "cloud_service_OC_access_C30.html",
            "settings.sys_manage": "cloud_service_systemConfig_C10.html",
            "settings.sysLog_manage": "report_sysLog_C10.html",
            "site.addPair": "add_openstackmapping_C10.html",
            "site.cloud.region": "manager_fs.html",
            "settings.sysLog_protocal_manage": "import_CA_csha.html",
            "dataUse.createDataMountPlan": window.isEn ? "en-us_topic_0161668688.html" : "zh-cn_topic_0153087820.html",
            "dataUse.dataMount.abstract": "manager_datamount.html",
            "dataUse.dataMount.protected": "manager_datamount.html",
            "dataUse.dataMount.procedure": "manager_datamount.html",
            "dataUse.dataMount.history": "manager_datamount.html",
            "site.storage.backupRespo": "manager_storage.html",
            "site.storage.backupPool": "manager_storage.html"
        };

        this.PT_SOLUTION = {
        //主备容灾解决方案
            //同步复制(阵列)
            "array.replica.sync.name": "common_term_activeBackupSolution_label",
            //异步复制(阵列)
            "array.replica.async.name": "common_term_activeBackupSolution_label",
            //异步复制(vis)
            "vis.replication.sync.name": "common_term_activeBackupSolution_label",
            //镜像(vis) + 异步复制(阵列)
            "vis.mirror.replica.async.name": "common_term_activeBackupSolution_label",
            //主机复制
            "protection.term.RepBasedOnHost.label": "common_term_activeBackupSolution_label",
            //一体化备份
            "array.integratedBackup.name": "common_term_activeBackupSolution_label",
            //两地3中心解决方案
            //级联复制(同步+异步)
            "array.cascade3dc.syncasync.name": "common_term_3dcSolution_label",
            //级联复制(异步+异步)
            "array.cascade3dc.asyncasync.name": "common_term_3dcSolution_label",
            //并联复制(同步+异步)
            "array.concurrent3dc.syncasync.name": "common_term_3dcSolution_label",
            //并联复制(异步+异步)
            "array.concurrent3dc.asyncasync.name": "common_term_3dcSolution_label",
            //双活+异步复制(阵列)
            "vis.replica.async.name": "common_term_3dcSolution_label",
             //双活+异步复制
            "array.activeactive.async.name":"common_term_3dcSolution_label",
            //异步复制+双活
            "array.async.activeactive.name":"common_term_3dcSolution_label",
            //双活加同步复制 + 同步复制+双活
            "array.activeactive.sync.name":"common_term_3dcSolution_label",
            "array.sync.activeactive.name":"common_term_3dcSolution_label",
            //双活+异步和异步+双活环形组网
            "array.async.activeactive.ring.name":"common_term_3dcSolution_label",
            "array.activeactive.async.ring.name":"common_term_3dcSolution_label",

        //三地4中心解决方案
            //4DC级联复制(异步+异步)
            "array.cascade4dc.asyncasync.name": "common_term_4dcSolution_label",
            //4DC并联复制(异步+异步)
            "array.concurrent4dc.asyncasync.name": "common_term_4dcSolution_label",

        //本地高可用解决方案
            //vis镜像
            "vis.mirror.name": "common_term_localHASolution_label",
            //双活数据中心解决方案
            //vis双活
            "vis.active.name": "common_term_AAdataCenterSolution_label",
            //双活+快照
            "array.activeactive.storageSnapshot.name": "common_term_AAdataCenterSolution_label",
            //NAS双活+一体化备份
            "array.hyperMetroVault.name": "common_term_AAdataCenterSolution_label",
            //本地保护解决方案,vis快照
            "vis.snap.name": "common_term_localProtectionSolution_label",
            //阵列快照
            "array.snapshot.name": "common_term_localProtectionSolution_label",
            //克隆
            "array.clone.name": "common_term_localProtectionSolution_label"
        };

        this.SERVER_REMOTE_ADD_EDIT = {
            winId: "edit",
            verifyId: "serverRemoteModifySiteContainer",
            title: "addManageServer",
            width: 400,
            height: 375,
            minimizable: false,
            maximizable: false,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            content: "app/business/recoverydirector/site/views/server/serverRemoteAddEdit.html"
        };
        this.SERVER_LOCAL_EDIT = {
            winId: "edit",
            verifyId: "serverRemoteModifySiteContainer",
            title: "modifyLoalServer",
            width: 400,
            height: 225,
            minimizable: false,
            maximizable: false,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            content: "app/business/recoverydirector/site/views/server/serverRemoteAddEdit.html"
        };

        this.SITE_ADD_EDIT = {
            "winId": "login-addModify-site-div",
            "data": {},
            "verifyId": "login-addModify-site-div",
            "title": "siteManage",
            "width": window.isUltraVR ? Consts.WIN_SIZE.S2[0] : Consts.WIN_SIZE.S4[0],
            "height": window.isUltraVR ? Consts.MODIFY_SITE_WIN.height : Consts.WIN_SIZE.S5[1],
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "helpId": "addSite",
            "content": "app/business/recoverydirector/site/views/add/siteAddEdit.html",
            "controller": "src/app/business/recoverydirector/site/controllers/add/siteAddEditCtrl",
            "minimizable": false,
            "maximizable": false,
        };
        this.VRG_PAIR_WIN = {
            "winId": "vrgPair",
            "data": {},
            "verifyId": "vrgPair",
            "title": "vrgPair",
            "width": 750,
            "height": 565,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/cloud/vrgPair.html",
            "minimizable": false,
            "maximizable": false
        };
        this.CREATE_RESOURCE_POOL_WIN = {
            "winId": "createResourcePool",
            "data": {},
            "verifyId": "createResourcePool",
            "title": "site_resourcePool_task_create_button",
            "width": 800,
            "height": 740,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/storage/createResourcePool.html",
            "controller": "app/business/recoverydirector/site/controllers/resource/storage/createResourcePoolCtrl",
            "minimizable": false,
            "maximizable": false,
        };

        this.HOST_AGENT_UPGRADE = {
            "winId": "agentUpgrade",
            "data": {},
            "verifyId": "host-agentUpgrade-container",
            "title": "site_term_agentUpgrade_label",
            "width": Consts.WIN_SIZE.S2[0],
            "height": Consts.MODIFY_SITE_WIN.height,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/host/agentUpgrade.html",
            "minimizable": false,
            "maximizable": false,
        };

        this.BATCH_HOST_GROUP_REFRESH = {
            "winId": "refreshDetailsWinId",
            "data": {},
            "verifyId": "refreshGroupMessages",
            "title": "site_term_hostGroupRefresh_result",
            "width": "650px",
            "height": "400px",
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/site/views/resource/host/hostGroupRefresh.html",
            "minimizable": false,
            "maximizable": false,
            "buttons": null
        };

        this.PG_OPERATION_RESULT_WIN = {
            "winId": "operationResultWinid",
            "data": {},
            "title": "recovery_test_term_excute_result_column",
            "width": "520px",
            "height": "390px",
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/operationResultWin.html",
            "minimizable": false,
            "maximizable": false,
            "buttons": null
        };

        this.RESOURCE_TREE_MODEL = {
            "server0": "LocalServerTreeNode",
            "server1": "RemoteServerTreeNode",
            "site0": "LocalSiteNode",
            "site1": "RemoteSiteNode",
            "siteHuaweiCloud": "CloudSiteNode",
            "storage": "StorageTreeNode",
            "host": "HostTreeNode",
            "fusionsphere": "CloudTreeNode",
            "drvsphere": "VRGTreeNode",
            "backupRespo": "BackupRespoTreeNode",
            "cloudServer": "CloudServerTreeNode",
        };
        this.RESOURCE_MAINTYPE_ENUM = {
            "storage": {
                deviceType: "ism.deviceType.storage.mainType",
                deviceSubType: "ism.storage.manufacture.0huawei"
            },
            "host": {
                deviceType: "ism.drm.deviceType.drhost.mainType"
            },
            "fc": {
                deviceType: "ism.drm.deviceType.fusionsphere.mainType",
                deviceSubType: "ism.drm.deviceType.cloud.subType",
                paramMap: {
                    devicetype: "FusionCompute"
                }
            },
            "fm": {
                deviceType: "ism.drm.deviceType.fusionsphere.mainType",
                deviceSubType: "ism.drm.deviceType.cloud.subType",
                paramMap: {
                    devicetype: "FusionManager"
                }
            },
            "vCenter": {
                deviceType: "ism.drm.deviceType.drvsphere.mainType",
                deviceSubType: ""
            },
            "vrg": {
                deviceType: "ism.drm.deviceType.fusionsphere.mainType",
                deviceSubType: "ism.drm.deviceType.vrg.subType"
            },
            "openStack": {
                deviceType: "ism.drm.deviceType.fusionsphere.mainType",
                deviceSubType: "ism.drm.deviceType.fusionsphereopenstack.subType",
                paramMap: {
                    devicetype: "FusionSphereOpenstack"
                }
            }
        };

        this.FUSIONSPHERE_ENUM = {
            "FusionCompute": 0,
            "FusionManager": 1,
            "VRG": 2,
            "OpenStack": 3
        };

        this.PROTECTGROUP_EXECUTE_BACKUP_WIN = {
            winId: "protectionGroupExecuteBackUpWin",
            verifyId: "protectionGroupExecuteBackUpWin",
            title: "ism.drm.protectgroup.auth.execute",
            width: 450,
            height: 400,
            minimizable: false,
            maximizable: false,
            helpId: "executeBackUpHelp",
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/template/execute/executeBackUp.html",
            "controller": "app/business/recoverydirector/protection/controllers/template/execute/executeBackUpCtrl"
        }

        this.PROTECTGROUP_EXECUTE_19_WIN = {
            winId: "sanSnapshotExecuteContainer",
            verifyId: "sanSnapshotExecuteContainer",
            title: "common_term_excute_button",
            width: 450,
            height: 338,
            minimizable: false,
            maximizable: false,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/template/execute/sanSnapshotExecute.html",
            "controller": "app/business/recoverydirector/protection/controllers/template/execute/sanSnapshotExecuteCtrl"
        }

        this.PROTECTGROUP_EXECUTE_17_WIN = {
            winId: "integrationBackupExecuteContainer",
            verifyId: "integrationBackupExecuteContainer",
            title: "common_term_excute_button",
            width: 450,
            height: 338,
            minimizable: false,
            maximizable: false,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/template/execute/integrationBackupExecute.html",
            "controller": "app/business/recoverydirector/protection/controllers/template/execute/integrationBackupExecuteCtrl"
        }

        this.COPYRATE_SETTING_WIN = {
            winId: "COPYRATE_SETTING_WIN",
            title: "protection.copyrate.wintitle",
            width: 380,
            height: 240,
            enAddtionWidth: 40,
            enAddtionHeight: 20,
            minimizable: false,
            maximizable: false,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/copyrateSettingWin.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/copyrateSettingCtrl"
        }

        this.OPENSTACK_VOLUMN_SETTING_WIN = {
            winId: "ModifyTempLink",
            title: "openstack_term_volumn_setting_label",
            width: 800,
            height: 765,
            minimizable: false,
            maximizable: false,
            helpId: "",
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/templateModifyOpenstackVolumn.html",
            "controller": "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/templateModifyOpenstackVolumnCtrl"
        }

        this.OPENSTACK_DR_VOLUMN_SETTING_WIN = {
            winId: "OPENSTACK_DR_VOLUMN_SETTING_WIN",
            title: "rm_term_batch_setting_dr_volumn_title",
            width: 500,
            height: 300,
            minimizable: false,
            maximizable: false,
            helpId: "ModifyTempLink",
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/batchVolumnSetting.html",
        }

        this.PG_AD_VIRTUAL_WIN = {
            "winId": "pg_ad_virtual_win",
            "data": {},
            "helpId": "PG_AD_VIRTUAL_WIN",
            "title": "rm_term_virtual_add",
            "width": 900,
            "height": 750,
            "draggable": true,
            "modal": true,
            "buttons": null,
            "content-type": "url",
            "content": "app/business/recoverydirector/protection/views/protectiongroup/fusionsphere/addOpenstackVirtualWin.html",
            "minimizable": false,
            "maximizable": false,
        }

        this.PROXY_ADD_EDIT_WIN = {
            "winId": "addModifyProxy-div",
            "data": {},
            "verifyId": "addModifyProxy-div",
            "title": "proxy_win_create_label",
            "helpId": "",
            "width": Consts.WIN_SIZE.S3[0],
            "height": Consts.WIN_SIZE.S2[1],
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/setting/views/proxy/backupProxyAddEdit.html",
            "controller": "app/business/recoverydirector/setting/controllers/proxy/backupProxyAddEditCtrl",
            "minimizable": false,
            "maximizable": false,
        };

        this.DATAMOUNT_CTEATE_PRO_OBJ_WIN = {
            "winId": "ProtectObject-div",
            "data": {},
            "verifyId": "ProtectObject-div",
            "title": "dataMount_create_protectobjects_lable",
            "width": Consts.WIN_SIZE.S4[0],
            "height": Consts.WIN_SIZE.S3[1],
            "helpId": "addSite",
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/operate/createDataMountProtectObj.html",
            "controller": "app/business/recoverydirector/recovery/controllers/operate/createDataMountProtectObjCtrl",
            "minimizable": false,
            "maximizable": false,
        };

        //创建挂载计划保护列表
        this.CREATE_DATAMOUNT_PROTECT_LIST_WIN = {
            "winId": "create_datamount_protect_list_win",
            "verifyId": "create_datamount_protect_list_win",
            "data": {},
            "title": "datamount_create_selete_plan_label",
            "helpId": "",
            "width": "800px",
            "height": "500px",
            "minimizable": false,
            "maximizable": false,
            "modal": true,
            "draggable": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/operate/createDataMountPlanList.html",
            "controller": "app/business/recoverydirector/recovery/controllers/operate/createDataMountPlanListCtrl",
        };

        this.AREA_ADD_EDIT_WIN = {
            "winId": "addModifyArea-div",
            "data": {},
            "verifyId": "addModifyArea-div",
            "helpId": "",
            "width": Consts.WIN_SIZE.S3[0],
            "height": Consts.WIN_SIZE.S2[1],
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/setting/views/cloudServiceManage/areaAddEdit.html",
            "controller": "app/business/recoverydirector/setting/controllers/cloudServiceManage/areaAddEditCtrl",
            "minimizable": false,
            "maximizable": false,
        };

        this.RECOVERY_REGION_AZ_WIN = {
            "winId": "recovery-regionAz-div",
            "data": {},
            "verifyId": "recovery-regionAz-div",
            "title": "common_term_plan_move_button",
            "width": 400,
            "height": 260,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/business/recoverydirector/recovery/views/operate/recoveryRegionAz.html",
            "controller": "app/business/recoverydirector/recovery/controllers/operate/recoveryRegionAzCtrl",
            "minimizable": false,
            "maximizable": false,
        };

        /**
         * @data {Object} 参数说明
         * {
         *     type: "warn", //窗口类型，默认warn，可选参数： confirm,prompt,error,warn
         *     steps: [   //详细步骤，必传项
         *     {
         *         content: "内容1"
         *     },
         *     {
         *         content: "内容2"
         *     }, {
         *        ....
         *     }],
         *     finish: function() {} //点击完成的回调函数
         * }
         **/
        this.WIZARD_WIN = {
            "winId": "confirm_wizard_win",
            "data": {},
            "helpId": "",
            "verifyId": "confirm_wizard_win",
            "title": tinyLanguage.language.warnTitle,
            "width": 470,
            "height": 320,
            "draggable": true,
            "modal": true,
            "content-type": "url",
            "content": "app/framework/common/views/wizardWin.html",
            "controller": "src/app/framework/common/controllers/wizardWinCtrl",
            "minimizable": false,
            "maximizable": false
        }
        /*
        存储复制:1
        存储快照:4
        SAN双活:5
        VIS双活:2（当前不支持此种类型的数据存储组）
        VIS存储镜像:3（当前不支持此种类型的数据存储组）
        一体化备份:6
         */
         this.VM_PROTECT_TYPE = {
            STORAGE_REP: 1,
            STORAGE_SNAPSHOT: 4,
            SAN_DOUBLEACTIVE: 5,
            VIS_DOUBLEACTIVE: 2,
            VIS_STORAGEMIRROR: 3,
            INTEGRATION: 6
        };

        /*---------------保护组事件 START-----------------*/

        //状态改变
        this.TOPIC.PG_STATUS_CHANGE = "PG_STATUS_CHANGE";
        //列表更新
        this.TOPIC.PG_LIST_UPDATE = "PG_LIST_UPDATE";
        //站点更改
        this.TOPIC.PG_SITE_CHANGE = "PG_SITE_CHANGE";
        //存储更改
        this.TOPIC.PG_STORAGE_CHANGE = "PG_STORAGE_CHANGE";

        /*---------------保护组事件 END-----------------*/

        //华为云网址
        this.WEBSITE = {
            HUAWEI_CLOUD_WEBSITE : "https://www.huaweicloud.com/",
            GETAKSK : "https://support.huaweicloud.com/usermanual-ca/zh-cn_topic_0046606340.html",
            GETPROJECTID: "https://support.huaweicloud.com/usermanual-ca/zh-cn_topic_0046606344.html",
            BUYECS:"https://console.huaweicloud.com/ecm/?region=cn-north-1&locale=zh-cn#/ecs/createVm ",
        },
        this.HUAWEI_CLOUD_WEBSITE = "https://www.huaweicloud.com/",

        //存储特性枚举值定义
        this.STORAGE_FEATURE_ENUM = {
            HyperCDP: 98,  //HyperCDP
            HyperCopy: 99,  //HyperCopy
            CloudBackup: 101, //云备份
            HyperMetro: 63, //SAN双活
            HyperVault: 64, //一体化备份
            HyperMetro: 72, //NAS双活
            HyperSnap: 2, //快照
            HyperClone: 3, //克隆
            HyperCopy: 4, //LUN拷贝
            HyperReplication: 24, //远程复制
            HyperMirror: 47, //卷镜像
            CloneVol: 10002, //链接克隆卷
        },

        this.DEFAULT_SELECTID = "-1"

    };

    return service;
});
