define([], function() {
    var service = function($timeout, $log, restService, utilService, exception, appUtils, communicationService) {
        var self = this;
        var sitesLinks = [];
        var sitesArray = [];
        var maxWidth, maxHeight;
        //生成站点位置
        this.createSiteLocation = function(sites, containerWidth, containerHeight) {
            var num = sites.length;
            var row_w = Math.ceil(Math.sqrt(num));
            var row_h = Math.round(Math.sqrt(num));
            var base_w = containerWidth / (row_w + 1);
            var base_h = containerHeight / (row_h + 1);
            for (var i = 0; i < sites.length; i++) {
                var x = (i + 1) % row_w == 0 ? row_w * base_w : ((i + 1) % row_w) * base_w;
                var y = i + 1 > row_w ? Math.ceil((i + 1) / row_w) * base_h : base_h;
                if (i % 2 == 0) {
                    x = x + 23
                    y = y + 23
                };
                sites[i].x = x;
                sites[i].y = y;
            };
        };
        //处理动画
        var animateFn = function(dom, len) {
            typeof len == "undefined" && (len = 10);
            var pathLong = parseInt(dom.getAttribute("stroke-dasharray").replace(",", " ").split(" ")[0]) + parseInt(dom.getAttribute("stroke-dasharray").replace(",", " ").split(" ")[1]);
            dom.setAttribute("stroke-dashoffset", len);
            len -= pathLong / 30;
            if (Math.abs(len) > pathLong) {
                len = 10
            };
            $timeout(function() {
                animateFn(dom, len)
            }, 50)
        };
        //IE兼容处理动画
        var animateGo = function() {
            var element = document.getElementsByClassName("topo-link");
            for (var i = 0; i < element.length; i++) {
                animateFn(element[i])
            };
        };
        //获取站点信息
        this.getSitesInfo = function(containerX, containerY, sites, bindEvent, callback) {
            self.createSiteLocation(sites, containerX, containerY);
            _.isFunction(callback) && callback(sites, [], bindEvent);
            restService.getSitesRelation([], {
                isShowMsgBox: false,
                success: function(result) {
                    var links = [];
                    if (!_.isEmpty(result.links)) {
                        //处理双活
                        _.each(result.links, function(value) {
                            _.each(result.links, function(item) {
                                if (value.type == "0" && item.type == "0" && value.sourceSiteId == item.targetSiteId && value.targetSiteId == item.sourceSiteId && !item.isBack) {
                                    value.isBack = true;
                                };
                            });
                            if (value.type == "1") {
                                links.push({
                                    sourceSiteId: value.targetSiteId,
                                    targetSiteId: value.sourceSiteId,
                                    type: "1"
                                });
                            };
                            links.push(value)
                        });
                    };
                    _.isFunction(callback) && callback(sites, links, bindEvent);
                },
                fail: function(err){
                	_.isFunction(callback) && callback(sites, [], bindEvent);
                }
            });
        };
        //生成站点图标
        this.updateTopo = function(nodes, sitesLinks, bindEvent) {
            var topo_nodes_enter = d3.select('.topo-root')
                .selectAll('g.topo-node')
                .data(nodes)
                .enter()
                .append('g')
                .attr('id', function(d) {
                    return d.id
                })
                .attr('style', function(d){
                    return !d.isCloudSite ? 'cursor: pointer' : ''
                })
                .attr('class', 'topo-node');
            //节点文字
            topo_nodes_enter.append('text')
                .attr('class', 'text-container')
                .attr('x', function(d) {
                    return -10
                })
                .attr('y', function(d) {
                    return -40
                })
                .attr('width', 100)
                .text(function(d) {
                    return d.name
                })
                //节点图片
            topo_nodes_enter.append('svg:image')
                .attr('xlink:href', function(d) {
                    return d.isCloudSite ? '/theme/hcp/images/cloud_site.svg' : '/theme/hcp/images/site.svg'
                })
                .attr('width', 77)
                .attr('height', 88)
                .attr('transform', 'translate(-32,-32)');
            //拖拽
            topo_nodes_enter.call(self.topoDrag(bindEvent));
            //鼠标hover
            self.topoHover();
            //增加path
            d3.select('.topo-root')
                .selectAll("path.topo-link")
                .data(sitesLinks)
                .enter()
                .insert('path', ':first-child')
                .attr('class', 'topo-link');
            //动画效果
            d3.select('.topo-root')
                .selectAll("path.pathway-link")
                .data(sitesLinks)
                .enter()
                .insert('path', ':first-child')
                .attr('class', 'pathway-link');
            //刷新视图
            self.refreshTopo(nodes);
            animateGo();
        };
        //站点之间的连线生成
        this.refreshTopo = function(nodes) {
            _.isUndefined(nodes) && (nodes = sitesArray);
            //节点位置
            d3.select('.topo-root')
                .selectAll("g.topo-node")
                .attr("transform", function(d) {
                    return "translate(" + d.x + "," + d.y + ")"
                });
            //连线轨道
            d3.select('.topo-root')
                .selectAll("path.pathway-link")
                .attr('d', function(d) {
                    var source_node, target_node;
                    source_node = _.filter(nodes, function(val) {
                        return val.siteId == d.sourceSiteId
                    })[0];
                    target_node = _.filter(nodes, function(val) {
                        return val.siteId == d.targetSiteId
                    })[0];
                    if (_.isEmpty(source_node) || _.isEmpty(target_node)) {
                        return "";
                    };
                    if (d.type == "1") {
                        return "M " + (source_node.x + 12) + " " + (source_node.y + 12) + " L " + (target_node.x + 12) + " " + (target_node.y + 12)
                    };
                    if (d.isBack) {
                        return "M " + (source_node.x + 20) + " " + (source_node.y + 20) + " L " + (target_node.x + 20) + " " + (target_node.y + 20)
                    };
                    return "M " + source_node.x + " " + source_node.y + " L " + target_node.x + " " + target_node.y
                })
                .attr('stroke', '#D9E0EE')
                //连线位置
            d3.select('.topo-root')
                .selectAll("path.topo-link")
                .attr('d', function(d) {
                    var source_node, target_node;
                    source_node = _.filter(nodes, function(val) {
                        return val.siteId == d.sourceSiteId
                    })[0];
                    target_node = _.filter(nodes, function(val) {
                        return val.siteId == d.targetSiteId
                    })[0];
                    if (_.isEmpty(source_node) || _.isEmpty(target_node)) {
                        return "";
                    };
                    if (d.type == "1") {
                        return "M " + (source_node.x + 12) + " " + (source_node.y + 12) + " L " + (target_node.x + 12) + " " + (target_node.y + 12)
                    };
                    if (d.isBack) {
                        return "M " + (source_node.x + 20) + " " + (source_node.y + 20) + " L " + (target_node.x + 20) + " " + (target_node.y + 20)
                    };
                    return "M " + source_node.x + " " + source_node.y + " L " + target_node.x + " " + target_node.y
                })
                .attr('stroke', '#2788ff')
                .attr('stroke-width', '1.5')
                .attr('stroke-dasharray', function(d) {
                    var source_node, target_node;
                    source_node = _.filter(nodes, function(val) {
                        return val.siteId == d.sourceSiteId
                    })[0];
                    target_node = _.filter(nodes, function(val) {
                        return val.siteId == d.targetSiteId
                    })[0]
                    if (_.isEmpty(source_node) || _.isEmpty(target_node)) {
                        return "";
                    };
                    var lenY = Math.abs(parseInt(target_node.y) - parseInt(source_node.y)) * Math.abs(parseInt(target_node.y) - parseInt(source_node.y));
                    var lenX = Math.abs(parseInt(target_node.x) - parseInt(source_node.x)) * Math.abs(parseInt(target_node.x) - parseInt(source_node.x));
                    var len = Math.sqrt(lenY + lenX);
                    return "20" + " " + (len - 20)
                })
                .attr('stroke-dashoffset', '0')
        };
        //拖拽
        this.topoDrag = function(bindEvent) {
            var drag = d3.behavior.drag();
            drag.on('dragstart', function(d) {
                    d.startDragX = d3.event.x;
                    d.startDragY = d3.event.y;
                })
                .on("drag", function(d) {
                    d.x = d3.event.x < 0 ? 40 : d3.event.x > (maxWidth - 77) ? (maxWidth - 77) : d3.event.x;
                    d.y = d3.event.y < 0 ? 10 : d3.event.y > (maxHeight - 44) ? (maxHeight - 44) : d3.event.y;
                    self.refreshTopo();
                })
                .on('dragend', function(d) {
                    if (d.startDragX == d3.event.x && d.startDragY == d3.event.y) {
                        //do someting
                        _.isFunction(bindEvent) && bindEvent(d.siteId, function(clickFlag){
                            if (!clickFlag) {
                                return;
                            };
                            d3.selectAll("image")
                                .attr('xlink:href', function(item) {
                                    if (d.siteId == item.siteId && !d.isCloudSite) {
                                        return '/theme/hcp/images/site_selected.svg'
                                    } else {
                                        return item.isCloudSite ? '/theme/hcp/images/cloud_site.svg' : '/theme/hcp/images/site.svg'
                                    }
                                });
                        });
                    }
                });

            return drag;
        };
        //hover上去显示当前站点的设备信息
        this.topoHover = function() {
            d3.selectAll('image')
                .on('mouseover', function(d) {
                    var offset = !_.isEmpty($(".main_container").offset()) ? $(".main_container").offset().left : 0;
                    //查询站点的设备信息
                    communicationService.get(utilService.getResouceUrl("/sites/" + d.siteId + "/action/sumResource")).promise().always(function(response) {
                    	var excep = exception.check(response, false);
                        if (angular.isString(excep)) {
                        	$log.error("query sumResource failed >>>>>>");
                            return;
                        };
                        var tipContainer = "";
                        if (d.isCloudSite) {
                            tipContainer = "<div id='siteTipDiv' class='tiny-tip-content-right' style='position: absolute;top:" + (d.y + 80) + "px;left:" + (d.x + offset + 100) + "px;border: 1px solid #ccc;z-index: 10001;border-radius: 6px;color: #666;background: #fbfbfb;padding: 5px 10px 15px 15px;'>" +
                                "<h1 style='font-size:14px;margin-bottom:6px;'>" + d.name + "</h1>" +
                                "<table>" +
                                "<tr>" +
                                "<td style='color:#999999'>" + appUtils.getStringWithColon("ism.deviceType.cloudVault.mainType") + "<td>" +
                                "<td style='padding-left:8px'>" + response.result['ism.deviceType.cloudVault.mainType'] + "<td>" +
                                "</tr>" +
                                "<tr>" +
                                "<td style='color:#999999'>" + appUtils.getStringWithColon("ism.deviceType.cloudServer.mainType") + "<td>" +
                                "<td style='padding-left:8px'>" + response.result['ism.deviceType.cloudServer.mainType'] + "<td>" +
                                "</tr>" +
                                "</table>" +
                                "</div>";
                        } else {
                            var showFs = !_.isUndefined(response.result['ism.drm.deviceType.fusionsphere.mainType']);
                            tipContainer = "<div id='siteTipDiv' class='tiny-tip-content-right' style='position: absolute;top:" + (d.y + 80) + "px;left:" + (d.x + offset + 100) + "px;border: 1px solid #ccc;z-index: 10001;border-radius: 6px;color: #666;background: #fbfbfb;padding: 5px 10px 15px 15px;'>" +
                                "<h1 style='font-size:14px;margin-bottom:6px;'>" + d.name + "</h1>" +
                                "<table>";
                            if (showFs) {
                                tipContainer += "<tr><td style='color:#999999'>" + appUtils.getStringWithColon("ism.drm.deviceType.fusionsphere.mainType") + "<td><td style='padding-left:8px'>" + response.result['ism.drm.deviceType.fusionsphere.mainType'] + "<td></tr>";
                            };
                            tipContainer += "</table></div>";
                        };
                        !d.isTriggerAhead && $("#siteTipDiv").length == 0 && $("body").append($(tipContainer));
                        d.isTriggerAhead = false;
                    });
                })
                .on('mouseout', function(d) {
                    //isTriggerAhead 处理手速过快，导致mouseout先于mouseover触发，生产tip后无法移除
                    if ($("#siteTipDiv").length) {
                        d.isTriggerAhead = false;
                    } else {
                        d.isTriggerAhead = true;
                    };
                    $("#siteTipDiv").length != 0 && $("#siteTipDiv").remove();
                })
            d3.selectAll("svg")
            	.on('mouseout', function(){
            		$("#siteTipDiv").length != 0 && $("#siteTipDiv").remove();
            	})
        };
        //初始化
        this.initTopo = function(containerX, containerY, sites, bindEvent) {
            maxWidth = containerX;
            maxHeight = containerY;
            sitesArray = sites;
            self.getSitesInfo(containerX, containerY, sites, bindEvent, self.updateTopo);
        };
    };
    service.$injector = ["$timeout", "restService", "utilService", "exception", "appUtils", "communicationService"];
    return service;
})