define(["tiny-lib/angular", "tiny-lib/jquery", "app/services/nodepsAppUtilService"],

    /**
     * 异常服务(对于远程请求的响应，应该先用checkException这个接口处理，返回true则说明没有错误)
     */
    function (angular, $, UtilsService) {
        "use strict";

        var appUtils = new UtilsService();
        var LOGIN_URL = "/src/login/view/login.html";
        var ERRORCODE_PRE = "lego.err.";
        var exception = function ( i18nService, message, cookieService) {

            var translate = function ( key, param ) {
                if (!param) {
                    return i18nService.get(key);
                }
                if (typeof param === "string") {
                    return appUtils.stringFormat(i18nService.get(key), i18nService.get(param));
                }
                if (angular.isArray(param)) {
                    var len = param.length, i = 0;
                    for (; i < len; i++) {
                        param[i] = i18nService.get(param[i]);
                    }
                    return appUtils.stringFormat(i18nService.get(key), param);
                }
                return i18nService.get(key);
            };

            this.check = function (response, isShowMsgBox, callback) {
            	var rootScope = angular.element(document.body).scope();
                var injector = angular.element(document).injector();
                var appUtilsService = injector.get("appUtils");
                var eventArgs = { data: [] };

                if (angular.isObject(response)) {
                    !_.isUndefined(response["redirect"]) && "sso" == cookieService.get("user.login.mode") && (LOGIN_URL = response["redirect"])
                    if (response.status == 401) {
                        eventArgs.error = {
                            code: -1,
                            description: translate("user_term_timeout_message"),
                            redrectURL: LOGIN_URL,
                            suggestion: ""
                        };
                    } else if (response.status == 403) {
                        eventArgs.error = {
                            code: -1,
                            description: translate("common_term_request_403_label"),
                            suggestion: ""
                        };
                    } else if (response.status == 404) {
                        eventArgs.error = {
                            code: 404,
                            description: translate("common_term_request_404_label"),
                            suggestion: ""
                        };
                    } else if (angular.isDefined(response.responseText) && response.responseText.indexOf('"errorCode":') > -1) {
                        var code;
                        var param;
                        var des;
                        try {
                            code = ERRORCODE_PRE + JSON.parse(response.responseText).errorCode;
                            param = JSON.parse(response.responseText).detailParam;
                            des = appUtilsService.getStringWithBothParams([code].concat(param || []));
                            eventArgs.error = {
                                code: -1,
                                description: des,
                                suggestion: ""
                            };
                        } catch (e) {
                            eventArgs.error = {
                                code: -1,
                                description: translate("common_json_format_error_msg"),
                                suggestion: ""
                            };
                        }

                        if (response.responseText.indexOf('"errorMessage":"systemTimeout"') > -1) {
                            eventArgs.error = {
                                code: -1,
                                description: translate("common_system_timeout_msg"),
                                redrectURL: LOGIN_URL,
                                suggestion: ""
                            };
                        }
                    } else if (angular.isDefined(response.statusText) && response.statusText == "timeout") {
                        eventArgs.error = {
                            code: -1,
                            description: translate("common_request_timeout_msg"),
                            suggestion: ""
                        };
                    }
                } else if (response && angular.isString(response)) {
                    try {
                        if( !JSON.parse(response).errorCode ) return true;
                        var code = ERRORCODE_PRE + JSON.parse(response).errorCode;
                        var param = JSON.parse(response).detailParam;
                        var des;
                        if(param){
                        	des = appUtilsService.getStringWithBothParams([code].concat(param || [])) || code;
                        }else{
                        	des = translate(code) || code;
                        }
                        eventArgs.error = {
                            code: -1,
                            description: des,
                            suggestion: ""
                        };
                    } catch (e) {
                        eventArgs.error = {
                            code: -1,
                            description: translate("common_json_format_error_msg"),
                            suggestion: ""
                        };
                    }
                } else {

                    if (!response) {
                        eventArgs.error = {
                            code: 0,
                            description: "",
                            suggestion: ""
                        }
                    } else {
                        eventArgs.error = {
                            code: -1,
                            description: translate("common_operation_unknown_error_msg"),
                            redrectURL: LOGIN_URL,
                            suggestion: ""
                        };
                    }
                }

                // Add multi delete response logic
                if (response && _.has(response, "succeedCount") && _.has(response, "failCount")) {
                    var total = response.totalCount;
                    // 批量操作需要业务自己处理，这里不做业务逻辑
                    if (total != 1) {
                        return true;
                    }

                    try {
                        if (response.succeedCount !== 1) {
                            var errorCode = response.result[0].errorCode;
                            var param = response.result[0].detailParam;
                            if (!errorCode) {
                                errorCode = "-1";
                            }
                            errorCode =  ERRORCODE_PRE + errorCode;
                            errorCode = appUtilsService.getStringWithBothParams([errorCode].concat(param || []));
                            eventArgs.error = {
                                code: errorCode,
                                description: errorCode,
                                suggestion: ""
                            };
                        }
                    } catch (err) {
                        eventArgs.error = {
                            code: -1,
                            description: translate("common_operation_unknown_error_msg"),
                            redrectURL: "",
                            suggestion: ""
                        };
                    }
                }

                if (eventArgs.error && eventArgs.error.code != 0) {
                	if(angular.isDefined(isShowMsgBox) && !isShowMsgBox && response.status != 401) {
                    	return eventArgs.error.description;
                    }

                    var description = eventArgs.error.description ? eventArgs.error.description : "null";
                    var redrectURL = eventArgs.error.redrectURL ? eventArgs.error.redrectURL : null;
                    //只建立一个实例
                    if ($("body").find("div[id^='messageDialog_main_MessageDialog_']")[0]) {
                        $("body").find("div[id^='messageDialog_main_MessageDialog_']").remove();
                    }
                    //超时发destory广播,10S跳到登录
                    if(redrectURL && redrectURL == LOGIN_URL){
                    	rootScope.$broadcast("$destroy",{});
                    	var lagTime = setTimeout(function(){
                    	         clearTimeout(lagTime);
                                 window.location.href = LOGIN_URL;
                        },10*1E3);
                    }
                    message.error({
                        content: $.encoder.encodeForHTML(description),
                        ok: function () {
                            if (redrectURL) {
                                window.location.href = redrectURL;
                            }
                            if (callback) {
                                callback();
                            }
                        }
                    });
                    return false;
                } else {
                    return true;
                }
            };

            this.checkSessionTimeout = function(rep,cb) {
				if( angular.isObject(rep) && rep.status == 401){
					angular.isFunction(cb) && cb(rep);
					return true;
				}
				return false;
			};

        };

        exception.$injector = ["i18nService", "message", "cookieService"];
        return exception;
    });
