define(["tiny-lib/jquery", "tiny-lib/Class"], function ( $, Class ) {

    var _hasLoaded = false, _lang = {};

    var I18NService = Class.extend({
        init: function (module) {
            var service = this;
            service.module = module;
        },
        _loadI18nFiles: function (files) {
            var dtd = $.Deferred();
            var service = this;

            if (!files) {
                dtd.resolve();
                return dtd.promise();
            }

            require(files, function () {
                    var i = 0, length = arguments.length;
                    for (; i < length; i++) {
                        $.extend(_lang, arguments[i]);
                    }
                    dtd.resolve();
                },
                function (err) {
                    dtd.resolve();
                }
            );

            return dtd.promise();
        },
        load: function () {
            var dtd = $.Deferred();
            var that = this;

            if (_hasLoaded) {
                return dtd.promise();
            }

            _hasLoaded = true;

            $.when(that._loadI18nFiles(["language/widgetsLanguage","language/platform/ui/commonLang", "language/platform/ui/errorcodeLang"]),
                that._loadI18nFiles(["language/app/ui/commonLang", "language/app/ui/errorcodeLang"]),
                that._loadI18nFiles(["language/vsphere/ui/commonLang", "language/vsphere/ui/errorcodeLang"]),
                that._loadI18nFiles(["language/virtualization/ui/commonLang", "language/virtualization/ui/errorcodeLang"]),
                that._loadI18nFiles(["language/fusionshpere/ui/commonLang", "language/fusionshpere/ui/errorcodeLang"]),
                that._loadI18nFiles(["language/openstack/ui/errorcodeLang"])
            ).then(function() {
                dtd.resolve();
            }, function() {
                _hasLoaded = false;
                dtd.reject();
            });

            that.module.service("i18nService", function() {
                return {get: that.get, resource: that.resource };
            });

            return dtd.promise();
        },
        get: function (key, defaultVal) {
            (defaultVal === undefined) && (defaultVal = key);

            if (!key) {
                return defaultVal;
            }
            //没有国际化的错误码公共错误提示
            if (_.isUndefined(this.resource()[key]) && key.indexOf("lego.err") != -1) {
                return this.resource()["system_unknown_error_code_label"].replace("{0}", key.replace("lego.err.", ""));
            }

            return this.resource()[key] || defaultVal;
        },
        resource: function() {

            !_hasLoaded && this.load();

            return _lang;
        }
    });


    return I18NService;

});
