define(["tiny-lib/jquery"], function ($) {
    "use strict";
    var service = function (i18nService) {
        var DEFAULT_LOADING_TEXT = "Loading";
        var loadingText = i18nService.get("common_term_loading_label", DEFAULT_LOADING_TEXT);
        var html = '<div class="loading"><div class="inner circle"><div class="backgrdClass"><span></span></div><div id="maskInfoContainer" style="font-size: 12px;margin-top:8px;"></div></div></div>';

        this.background = $('<div unselectable="on" style="-moz-user-select:none;-webkit-user-select:none;"></div>').css({
            "z-index": 10000000000,
            "background": "50% 50% repeat-x rgba(0,0,0,.15)",
            "position": "fixed",
            "top": 0,
            "left": 0,
            "width": "100%",
            "height": "100%"
        });
        this.loading = $(html);

        this.show = function (info) {
            $("body").append(this.background).append(this.loading);
            if (!_.isEmpty(info)) {
                $("#maskInfoContainer").text(info);
                $(".loading .circle span").css({
                    "display": "inline-block",
                    "float": "none"
                });
            }else{
                $("#maskInfoContainer").text("");
                $(".loading .circle span").css({
                    "float": "left"
                });
            }
        };

        this.hide = function () {
            this.background.remove();
            this.loading.remove();
        };
    };

    service.$injector = ["i18nService"];

    return service;
});
