/**
 * 定义模型
 */
define(["tiny-lib/Class", "tiny-lib/underscore", "tiny-widgets/Window", "tiny-common/UnifyValid", "app/business/recoverydirector/protection/configures/appConfig"],
    function(Class, _, Window, UnifyValid, appConfig) {
        "use strict";
        var service = ["$state", "$q", "message", "appUtils", "restService", "cookieService", "constsService", "communicationService", "utilService", "exception", "mask", "infoTransferredService",
            function($state, $q, message, appUtils, Rest, cookieService, constsService, communicationService, utilService, exception, mask, infoTransferredService) {

                //国际化
                var resource = appUtils.resource();

                /**-----------------Model基类------------------------------*/
                var Model = Class.extend({
                    //过滤字段
                    filter: function(predicate, target) {
                        target = _.isUndefined(target) ? this : target;
                        _.map(target, function(v, k) {
                            if (predicate(k) && k != '_super') {
                                delete target[k];
                            }
                        });
                        return target;
                    },

                    //遍历并返回满足条件的项
                    slicer: function(includes, target, deep) {
                        target = _.isUndefined(target) ? this : target;
                        includes = _.isUndefined(target) ? function() {
                            return true;
                        } : includes;

                        var result = {};
                        for (var key in target) {
                            if ((!deep && target.hasOwnProperty(key) || deep) && includes(key)) {
                                result[key] = target[key];
                            }
                        }
                        return result;
                    },

                    //过滤掉未注册的字段
                    removeUnregisteredProperties: function(props) {
                        var predicate = function(key) {
                            return !props.hasOwnProperty(key);
                        };

                        _.isFunction(this.filter) ? this.filter(predicate) : Model.prototype.filter(predicate, this);
                    }
                });

                /**-------------------默认数据模型----------------------------*/
                var DEFAULT_Conf = {
                    //保护对象
                    "ProtectObject": {
                        poId: "",
                        uuid: "",
                        name: "",
                        poType: 0,
                        moUuid: "",
                        poStatus: 0,
                        providerSN: "",
                        providerName: "",
                        usedStorageResourceSet: [],
                        props: {
                            USERNAME: '',
                            PASSWD: '',
                            INSTANCENAME: '',
                            DATABASES: '',
                            SERVICENAME: '',
                            ASM_INSTANCENAME: '',
                            ASM_USERNAME: '',
                            ASM_PASSWD: '',
                            IS_MANUAL: '0'
                        }
                    },

                    //策略模板
                    PolicyTemplate: {
                        ptId: "",
                        uuid: "",
                        name: "",
                        description: ""
                    },

                    //保护组
                    ProtectGroup: {
                        pgId: "",
                        name: "",
                        poType: 0,
                        description: "",
                        productSiteId: "",
                        productSiteName: "",
                        poProviderSN: "",
                        polist: [],
                        template: {},
                        props: {
                            storageType: '',
                            IS_MANUAL: '0',
                            cgUuid: '',
                            PROVIDER_TYPE: ''
                        }
                    }
                };

                /**-------------------前置条件配置----------------------------*/
                var BusinessPreCondition = {
                    //公用文件夹检查
                    publicFolderCheck: function(po) {
                        if (po.props && (po.props.EXCHANGE_HASPUBFOLDER == "true" || po.props.EXCHANGE_HASPUBFOLDER == true)) {
                            return "err_hasPublicFolder";
                        }
                        return true;
                    }
                };

                var ConditionMapper = {
                    //exchange
                    8: {
                        "ProtectObject.loadStorageInfo": BusinessPreCondition.publicFolderCheck
                    }
                };

                /**为业务模型代理(增加前置条件检查)
                 * @param proto 业务模型
                 * @prram modelType 业务类型(目前主要是保护组[ProtectGroup]和保护对象[ProtectObject],取poType判断)
                 * */
                function modelProxy(proto, modelType) {
                    var proxyObj = {};
                    _.map(proto, function(fn, fnName) {
                        proxyObj[fnName] = function(args) {
                            /**
                             * _super
                             * Class.js检查是否使用了_super标记,继承机制,增加_model增加_super()
                             * */
                            var _super;
                            var _model = this;

                            var cdtfn = getConditionFn(_model, fnName);
                            if (_.isFunction(cdtfn)) {
                                var ret = cdtfn(_model);
                                if (ret === true) {
                                    return fn.apply(_model, arguments);
                                }
                                return ret;
                            }
                            return fn.apply(_model, arguments);
                        };
                    });

                    return proxyObj;

                    function getConditionFn(model, fnName) {
                        var poType = model.poType;
                        var mapper = ConditionMapper[poType];
                        if (_.isObject(mapper)) {
                            var k = modelType + "." + fnName;
                            return mapper[k];
                        }
                    }
                }


                /**-----------------保护组|Model定义------------------------------*/

                var ProtectObject = Model.extend(modelProxy({
                    "init": function(options) {
                        _.extend(this, DEFAULT_Conf.ProtectObject, options);
                        var props;
                        if ((props = angular.copy(this.props))) {
                            for(var i in props){
                                if( _.isArray(props[i]) ){
                                    props[i] = JSON.stringify(props[i]);
                                }
                            }
                        }
                        this.props = props;

                        this.filter(function(key) {
                            return _.isEmpty(key) || !DEFAULT_Conf.ProtectObject.hasOwnProperty(key);
                        });
                    },
                    "validateAuthInfo": function(config) {
                        var config = config || {};
                        this.removeUnregisteredProperties();

                        config.data = this;
                        Rest.validateAuthInfo(this.poType, config);
                    },
                    "loadStorageInfo": function(config) {

                        //加载存储
                        if (_.isFunction(config)) {}
                        var config = config || {};
                        this.removeUnregisteredProperties();

                        config.data = this;
                        Rest.loadStorageInfo([], config);
                    },
                    "updateAuthInfo": function(pgId, config) {
                        var config = config || {};
                        this.removeUnregisteredProperties();

                        config.data = [this];
                        Rest.updateAuthInfo(pgId, config);
                    },
                    "removeUnregisteredProperties": function() {
                        this._super(DEFAULT_Conf.ProtectObject);
                    }

                }, "ProtectObject"));

                /**-----------------------------------------------*/


                /**-----------------策略模板|Model定义------------------------------*/

                var PolicyTemplate = Model.extend({
                    "init": function(options) {
                        _.extend(this, DEFAULT_Conf.PolicyTemplate, options);
                    }
                });



                /**-----------------保护组|Model定义------------------------------*/

                var ProtectGroup = Model.extend(modelProxy({
                    "init": function(options) {
                        var oldProps = DEFAULT_Conf.ProtectGroup.props;
                        DEFAULT_Conf.ProtectGroup.props = angular.copy(oldProps);
                        _.extend(this, DEFAULT_Conf.ProtectGroup, options);
                        DEFAULT_Conf.ProtectGroup.props = oldProps;
                    },

                    //增加保护对象
                    "addProtectObject": function(config) {
                        var pg = this;
                        var config = config || {};

                        if (!pg || !pg.polist || pg.polist.length == 0) {
                            message.error(resource.get("ism.drm.common.pg.add.po.select.null.msg"));
                            return;
                        }

                        if (!this.checkPoNumSpecification(config.poNum)) {
                            message.error(resource.get("protection.addProtectedObj.task.para.ObjectNO.range.validation", appConfig.PO_NUM_SPECiFICATION[this.poType]));
                            return;
                        }

                        this.removeUnregisteredProperties();

                        config.data = this.polist;

                        _.each(config.data,function(val,index){
                            delete val.name;
                        })

                        Rest.addProtectObject(this.pgId, config);

                    },
                    //删除保护对象
                    "delProtectObject": function(config) {
                        var pg = this;
                        config.data = pg.polist;
                        _.each(config.data,function(val,index){
                            delete val.name;
                        });

                        Rest.delProtectObject(this.pgId, config);
                    },
                    //修改保护组基本信息
                    "updateProtectGroup": function(config) {
                        if (angular.isFunction(config)) {
                            var temp = config,
                                config = {};
                            config.success = temp;
                            config.data = this;
                        }
                        Rest.updateProtectGroup([this.uuid], config);
                    },
                    //删除保护组
                    "delProtectGroup": function(config) {
                        Rest.delProtectGroup(this.uuid, config);
                    },
                    //执行保护组
                    "excuteProtectGroup": function(config) {
                        Rest.excuteProtectGroup(this.uuid, config);
                    },
                    //激活保护组
                    "enableProtectGroup": function(config) {
                        Rest.enableProtectGroup(this.uuid, config);
                    },
                    //禁用保护组
                    "disableProtectGroup": function(config) {
                        Rest.disableProtectGroup(this.uuid, config);
                    },
                    //刷新保护组
                    "refreshProtectGroup": function(config) {
                        Rest.refreshProtectGroup(this.uuid, config);
                    },
                    //创建保护组
                    "create": function(config) {
                        if (angular.isFunction(config)) {
                            var temp = config,
                                config = {};
                            config.success = temp;
                        }
                        this.removeUnregisteredProperties();
                        var createRp = false;
                        if (this.props.createRp) {
                            createRp = true;
                            delete this.props.createRp;
                        }
                        config.data = this;
                        Rest.createProtectGroup(createRp, config);
                    },
                    "checkPoNumSpecification": function(poNum) {
                        var specification = G_APP.getPoNumSpecification();
                        if (_.isUndefined(specification)) return true;
                        return specification > (this.polist.length + poNum || 0);
                    },
                    "removeUnregisteredProperties": function() {
                        this._super(DEFAULT_Conf.ProtectGroup);
                        var that = this;
                        _.each(this.polist, function(po) {
                            po instanceof Model ? po.removeUnregisteredProperties(DEFAULT_Conf.ProtectObject) :
                                that._super.call(po, DEFAULT_Conf.ProtectObject);
                        });
                    }
                }, "ProtectGroup"));

                function ViewModel(conf) {
                    if (!conf) return;
                    this.data = conf.data || {};
                    this.valid = conf.valid || true;
                    this.dataProps = [];
                    this.defer = $q.defer();
                    this.promise = this.defer.promise;

                    for (var prop in conf) {
                        if (prop != "data" && conf.hasOwnProperty(prop)) {
                            this[prop] = conf[prop];
                        }
                    }

                    for (var prop in this.data) {
                        if (angular.isUndefined(this.data[prop])) {
                            delete this.data[prop];
                        } else {
                            this.dataProps.push(prop);
                        }
                    }
                }

                ViewModel.extend = function(destObj) {
                    if (arguments.length < 2) return;

                    for (var i = 1, len = arguments.length; i < len; i++) {
                        var vm = arguments[i];
                        angular.extend(destObj, vm.data);
                        vm.dataProps.forEach(function(prop) {
                            if (!vm.data.hasOwnProperty(prop)) {
                                delete destObj[prop];
                            }
                        });
                    }

                    return destObj;
                }

                ViewModel.create = function(conf) {
                    return new ViewModel(conf);
                }

                /* 工具
                 * ----------------------------------------------------*/

                var util = {
                    generatePoListFromTable: function(tableId, single) {
                        var poList = [],
                            checkedItems;

                        if (_.isObject(tableId)) {
                            var tableFixer = tableId;
                            checkedItems = tableFixer.getSelectedRow();
                        } else {
                            checkedItems = single === true ? $("#" + tableId).widget().getHoverData() :
                                $("#" + tableId).widget().getTableCheckedItems();
                        }

                        angular.forEach(checkedItems, function(item) {
                            poList.push(new ProtectObject(item));
                        });

                        return poList;
                    },

                    fillPg: function(pg, config) {

                        if (_.isEmpty(pg) || _.isEmpty(config)) return false;

                        var siteDomId = config.siteDomId,
                            hostDomId = config.hostDomId,
                            tableId = config.tableId,
                            poData = config.poData,
                            single = config.single,
                            tableFixer = config.tableFixer;

                        if (!siteDomId || !hostDomId) return false;

                        var tiny_site = $("#" + siteDomId).widget();
                        var tiny_host = $("#" + hostDomId).widget();

                        var selectSite = tiny_site.getSelectedId();
                        if (!selectSite || selectSite == "-1") {
                            message.error(resource.get("ism.drm.common.pg.yield.site.info"));
                            return false;
                        }
                        pg.productSiteId = selectSite;
                        pg.productSiteName = tiny_site.getSelectedLabel();

                        var selectStorage = tiny_host.getSelectedId();
                        if (!selectStorage || selectStorage == "-1") {
                            var poType = pg.poType;
                            var key = "ism.drm.common.pg.yield.host.info";
                            if (poType == 11) {
                                key = "ism.drm.common.pg.storage.info";
                            } else if (poType == 10) {
                                key = "ism.drm.common.pg.vCenter.info";
                            } else if (poType == 12) {
                                key = "ism.drm.common.pg.cloud.info";
                            }


                            message.error(resource.get(key));
                            return false;
                        }
                        pg.poProviderSN = selectStorage;

                        if (tableFixer) {
                            poData = util.generatePoListFromTable(tableFixer);
                        }
                        else if (tableId) {
                            poData = util.generatePoListFromTable(tableId, single);
                        }
                        else{
                            var tmpPoList = [];
                            if( _.isArray(poData) && poData.length != 0 ){
                                _.each(poData, function(po){
                                   tmpPoList.push(new ProtectObject(po));
                                });
                            }
                            poData = tmpPoList;
                        }

                        var polist = poData;
                        if (!angular.isArray(polist) || polist.length == 0) {
                            message.error(resource.get("ism.drm.common.pg.add.po.select.null.msg"));
                            return false;
                        } else if (polist.length > appConfig.PO_NUM_SPECiFICATION[pg.poType]) {
                            message.error(resource.get("protection.createProtectedObj.task.selObject.para.ObjectNO.range.validation",
                                appConfig.PO_NUM_SPECiFICATION[pg.poType]));
                            return false;
                        }
                        pg.polist = polist;

                        return true;
                    },

                    formatHosts: function(data) {
                        var hosts = [];
                        if (angular.isArray(data)) {
                            data.forEach(function(item) {
                                //主机
                                if (item.isVirtualGroup) {
                                    angular.isArray(item.childResources) && item.childResources.forEach(function(res) {
                                        hosts.push({
                                            deviceSn: res.deviceSn,
                                            name: res.name
                                        });
                                    });
                                }
                                //主机组
                                else {
                                    hosts.push({
                                        deviceSn: item.deviceSn,
                                        name: item.name + "(" + resource.get("ism.drm.hostgroup") + ")"
                                    });
                                }
                            });
                        }
                        return hosts;
                    },

                    formatIstName: function(name) {
                        try{
                            name = JSON.parse(name)
                        }catch(err){};

                        if (angular.isUndefined(name)) {
                            return "";
                        }
                        if (angular.isArray(name)) {
                            var temp = "";
                            name.forEach(function(item) {
                                temp += item.INSTANCENAME + ",";
                            });
                            return temp.substring(0, temp.length - 1);
                        }
                        return name;
                    },

                    checkError: function(msg) {
                        if (_.isUndefined(msg)) {
                            return true;
                        }
                        return msg.indexOf("err_") == -1;
                    },

                    //英文界面用空格分隔
                    concatText: function() {
                        var text = "";

                        var language = cookieService.get("language");
                        if (language == "en") {
                            _.each(arguments, function(param) {
                                text += param + " ";
                            });
                            text = text.slice(0, text.length - 1);
                        } else {
                            _.each(arguments, function(param) {
                                text += param;
                            });
                        }

                        return text;
                    },

                    //判断是否是英文版本
                    isEn: function() {
                        return cookieService.get("language") == "en";
                    },

                    //策略模版: 图片和站点对应
                    /* html模版
                    <div id="scheduleSiteNameDivId">
                        <span class="nowrap"></span>
                        <span class="nowrap"></span>
                        <span class="nowrap"></span>
                    </div>
                    */
                    ptImgSiteName: function(ptType, protectLocation, protectedSiteName, recoverySiteName) {
                        var div = $("#scheduleSiteNameDivId");
                        if (!div) return;
                        //级联
                        if (ptType == 3 || ptType == 4) {
                            //A->B
                            if (protectLocation == 1) {
                                div.find("span:eq(0)").text(protectedSiteName).attr("title", protectedSiteName);
                                div.find("span:eq(1)").text(recoverySiteName).attr("title", recoverySiteName);
                            } else {
                                div.find("span:eq(1)").text(protectedSiteName).attr("title", protectedSiteName);
                                div.find("span:eq(2)").text(recoverySiteName).attr("title", recoverySiteName);
                            }
                        }
                        //并联
                        else {
                            //A->B
                            if (protectLocation == 1) {
                                div.find("span:eq(1)").text(protectedSiteName).attr("title", protectedSiteName);
                                div.find("span:eq(0)").text(recoverySiteName).attr("title", recoverySiteName);
                            } else {
                                div.find("span:eq(1)").text(protectedSiteName).attr("title", protectedSiteName);
                                div.find("span:eq(2)").text(recoverySiteName).attr("title", recoverySiteName);
                            }
                        }
                    }
                };

                /* 工具定义结束
                 * -----------------------------------------------------*/

                //public api
                this.ProtectObject = ProtectObject;
                this.ProtectGroup = ProtectGroup;
                this.PolicyTemplate = PolicyTemplate;
                this.util = util;
                /*------------------------------------------------------*/
                /*---------TreeNode定义tree的基本属性和各种类型的treenode事件-------------------------*/
                var TreeNode = function(node) {
                    if (_.isEmpty(node)) {
                        return;
                    }
                    this.id = node.id;
                    this.pId = node.pId;
                    this.name = node.name;
                    this.open = node.isOpen;
                    this.selected = node.isSelected;
                    this.disable = node.isDisable;
                    this.iconSkin = node.iconSkin;
                };
                TreeNode.prototype = {
                    add: function() {},
                    modify: function() {},
                    delete: function() {},
                    refresh: function() {},
                    getTree: function() {
                        return $("#tree").widget().getZTreeObj();
                    }
                };
                /*------------ServerTreeNode继承TreeNode，并定义本地和远程服务器的公用方法，如click/add-------------*/
                var ServerTreeNode = function() {
                    TreeNode.apply(this, arguments);
                };
                ServerTreeNode.prototype = new TreeNode();
                ServerTreeNode.prototype.constructor = ServerTreeNode;
                ServerTreeNode.prototype.onClick = function() {
                    if (!appUtils.checkRight("9323")) {
                        return;
                    }
                    infoTransferredService.put("server", "currentServer", this);
                    $state.go("site.siteList", {
                        "serverUuid": this.id,
                        randomId: Math.floor(Math.random() * 10000)
                    });
                };
                ServerTreeNode.prototype.onLoad = function(callback) {
                    if (!appUtils.checkRight("9323")) {
                        return;
                    }
                    mask.show();
                    var that = this;
                    communicationService.get(utilService.getResouceUrl("/sites?serverUuid=" + that.id), null, null, 3600000).promise().always(function(result) {
                        mask.hide();

                        if (!exception.check(result)) {
                            return;
                        }

                        var nodes = [],
                            treeNodeDom = that.getTree(),
                            updateNode = [],
                            selectNode = infoTransferredService.get("resource", "currentNode");
                        _.each(result, function(site) {
                            var node = {
                                type: site.siteType,
                                id: site.siteId,
                                pId: site.serverUuid,
                                iconSkin: site.isCloudSite ?  "cloud_site" : "site",
                                isOpen: true,
                                isSelected: false,
                                isDisable: false
                            };
                            site.description = _.isNull(site.description) ? "null" : $.trim(site.description);
                            site.name = _.isEmpty(site.name) ? "null" : $.trim(site.name);

                            _.extend(node, site);

                            var nodeModelName = constsService.RESOURCE_TREE_MODEL["site" + (site.isCloudSite ? site.cloudServiceProvider : node.type)],
                                nodeObj = new TreeNodes[nodeModelName](node);
                            _.extend(nodeObj, site);


                            this.push(nodeObj);
                        }, nodes);

                        //delete and add
                        var olderChild = treeNodeDom.removeChildNodes(that);

                        _.each(nodes, function(node, i) {
                            var old = _.findWhere(olderChild, _.pick(node, "id"));
                            if (!_.isEmpty(old)) {
                                delete old.name;
                                delete old.description;

                                _.extend(node, old);
                            }
                        });
                        treeNodeDom.addNodes(that, nodes);

                        if (!_.isEmpty(selectNode)) {
                            selectNode = $("#tree").widget().getZTreeObj().getNodeByParam("id", selectNode.id);
                            treeNodeDom.selectNode(selectNode);
                            selectNode.onClick();
                            infoTransferredService.put("resource", "currentNode", selectNode);

                        };

                        that.isInit = true;

                        _.isFunction(callback) && (callback())
                    });
                };

                ServerTreeNode.prototype.add = function(callback) {
                    var win = angular.copy(constsService.SERVER_REMOTE_ADD_EDIT),
                        selectNode = this;
                    win.data = {
                        isLocal: false,
                        isModify: false
                    };
                    win.helpId = "addRemoteServer";
                    win.height = 435;
                    appUtils.isEn() && (win.height += 50);
                    var allNodes = $("#tree").widget().getZTreeObj().getNodes();
                    !_.isEmpty(allNodes) && infoTransferredService.put("resource", "allServerNodes", allNodes);
                    appUtils.showWindow(win, function() {
                        if (!UnifyValid.FormValid($("#" + constsService.SERVER_REMOTE_ADD_EDIT.verifyId), {focusInvalid: true}) || !/^\d+$/.test($("#port :text").val())) {
                            return;
                        }
                        var server = {
                            "devAlias": $.trim($("#devAlias").widget().getValue()),
                            "ip": $("#ip").widget().getValue(),
                            "port": $("#port").widget().options.value,
                            "user": $.trim($("#username").widget().getValue()),
                            "pwd": $("#password").widget().getValue()
                        };

                        mask.show();
                        communicationService.post(utilService.getResouceUrl("/drmservers"), server, null, null, 360000).promise().always(function(result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $("#" + constsService.SERVER_REMOTE_ADD_EDIT.winId).widget().destroy();
                                        (callback)(selectNode);
                                    }
                                });
                            }
                        });
                    });
                };

                /*-----------------LocalServerTreeNode继承ServerTreeNode,并定义本地的修改，无删除---------------------------------*/
                var LocalServerTreeNode = function() {
                    ServerTreeNode.apply(this, arguments);
                    this.delete = undefined;
                    this.refresh = undefined;
                };
                LocalServerTreeNode.prototype = new ServerTreeNode();
                LocalServerTreeNode.prototype.constructor = LocalServerTreeNode;
                LocalServerTreeNode.prototype.modify = function(callback) {
                    var selectNode = this,
                        settingWin = angular.copy(constsService.SERVER_LOCAL_EDIT);
                    settingWin.data = {
                        name: selectNode.name,
                        isLocal: true
                    };
                    settingWin.helpId = "modifyLocalServer";

                    appUtils.showWindow(settingWin, function() {
                        if (!UnifyValid.FormValid($("#" + constsService.SERVER_LOCAL_EDIT.verifyId), {focusInvalid: true})) {
                            return;
                        }
                        var param = {
                            name: $.trim($("#name").widget().getValue())
                        };
                        mask.show();
                        communicationService.put(utilService.getResouceUrl("/drmservers/" + selectNode.id), param, null, null, 360000).promise().always(function(result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $("#" + constsService.SERVER_LOCAL_EDIT.winId).widget().destroy();
                                        (callback)(selectNode);
                                    }
                                });
                            }
                        });
                    });
                };
                /*-----------------RemoteServerTreeNode继承ServerTreeNode,并定义远程的修改，删除,刷新-----------------------*/
                var RemoteServerTreeNode = function() {
                    var nodeObj = arguments[0];
                    _.isNull(nodeObj.devAlias) && (nodeObj.devAlias = "null")
                    nodeObj.name = nodeObj.devAlias;
                    _.isUndefined(nodeObj.name) && (nodeObj.name = nodeObj.ip)
                    ServerTreeNode.apply(this, arguments);
                }
                RemoteServerTreeNode.prototype = new ServerTreeNode();
                RemoteServerTreeNode.prototype.constructor = RemoteServerTreeNode;
                RemoteServerTreeNode.prototype.modify = function(callback) {
                    var selectNode = this,
                        win = angular.copy(constsService.SERVER_REMOTE_ADD_EDIT);
                    win.title = appUtils.getString("modifyRemoteServer");
                    win.height += 35;
                    win.data = {
                        isLocal: false,
                        isModify: true
                    };
                    win.helpId = "modifyRemoteServer";
                    appUtils.isEn() && (win.height += 60,win.width += 40);
                    _.extend(win.data, selectNode);

                    appUtils.showWindow(win, function() {
                        if (!UnifyValid.FormValid($("#" + constsService.SERVER_REMOTE_ADD_EDIT.verifyId), {focusInvalid: true}) || !/^\d+$/.test($("#port :text").val())) {
                            return;
                        }

                        var isOn = $("#authinfo").widget().option("selected") == "on",
                            server = {
                                "devAlias": $.trim($("#devAlias").widget().getValue()),
                            };
                        var setUserName = "";
                        if(selectNode.user == "SyncAdmin"){
                            setUserName = $.trim($("#username").widget().getValue());
                        }else{
                            setUserName = $("#modifyUsername").widget().getSelectedId() != "SyncAdmin" ? "" : $("#modifyUsername").widget().getSelectedId()
                        };
                        isOn && (_.extend(server, {
                            "ip": $("#ip").widget().options.value,
                            "port": $("#port").widget().options.value,
                            "user": setUserName,
                            "pwd": $("#password").widget().getValue()
                        }));



                        var url = "/drmservers/" + selectNode.id;
                        mask.show();
                        communicationService.put(utilService.getResouceUrl(url), server, null, null, 360000).promise().always(function(result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $("#" + constsService.SERVER_REMOTE_ADD_EDIT.winId).widget().destroy();
                                        (callback)(selectNode);
                                    }
                                });
                            }
                        });
                    });
                };
                RemoteServerTreeNode.prototype.delete = function(callback) {
                    //this is select node
                    var selectNode = this,
                        msg = [appUtils.getString("site_DRmanagementServer_task_delete_warm_msg1", selectNode.name), appUtils.getString("site_DRmanagementServer_task_delete_warm_msg2"), appUtils.getString("site_DRmanagementServer_task_delete_warm_msg3")].join("<br/>");
                    message.warn(msg).then(function() {
                        communicationService.remove(utilService.getResouceUrl("/drmservers/" + selectNode.id)).promise().always(function(response) {
                            if (exception.check(response)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        (callback)(selectNode);
                                    }
                                });
                            }
                        });
                    });
                };
                RemoteServerTreeNode.prototype.refresh = function(callback) {
                    var selectNode = this;
                    communicationService.put(utilService.getResouceUrl("/drmservers/" + this.id + "/action/refresh")).promise().always(function(response) {
                        if (exception.check(response)) {
                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {
                                    (callback)(selectNode);
                                }
                            });
                        }
                    });
                };
                /*-----------------SiteNode继承TreeNode,提供本地和远程的站点公用方法定义，如创建，修改，删除----------------*/
                var SiteNode = function() {
                    ServerTreeNode.apply(this, arguments);
                };
                SiteNode.prototype = new ServerTreeNode();
                SiteNode.prototype.constructor = SiteNode;
                SiteNode.prototype.onLoad = function() {
                    mask.show();
                    var that = this,
                        url = utilService.getResouceUrl("/resources/action/getSupportResource");
                    communicationService.get(url).promise().always(function(result) {
                        mask.hide();

                        if (!exception.check(result)) {
                            return;
                        }
                        if (that.isCloudSite) {
                            result = [
                                {"type": "ism.deviceType.cloudServer.mainType", "description": "cloudServer"},
                                {"type": "ism.deviceType.cloudVault.mainType", "description": "backupRespo"}
                            ]
                        }
                        var nodes = [],
                            treeNodeDom = that.getTree(),
                            resNode = {
                                "ism.drm.deviceType.fusionsphere.mainType": "fusionsphere",
                                "ism.deviceType.cloudVault.mainType": "backupRespo",
                                "ism.deviceType.cloudServer.mainType": "cloudServer"
                            },
                            sortBy = _.values(resNode),
                            selectNode = infoTransferredService.get("resource", "currentNode");

                        _.each(result, function(resource) {
                            var nodeType = resNode[resource.type];
                            if (_.isUndefined(nodeType)) {
                                return;
                            }

                            var node = {
                                    id: resource.type,
                                    pId: that.id,
                                    name: appUtils.getString(resource.type),
                                    iconSkin: nodeType,
                                    isOpen: true,
                                    isSelected: false,
                                    isDisable: false
                                },
                                nodeModelName = constsService.RESOURCE_TREE_MODEL[nodeType],
                                nodeObj = new TreeNodes[nodeModelName](node);

                            //default select node
                            nodeObj.selected = !_.isEmpty(selectNode) && selectNode.id === nodeObj.id;

                            this.push(nodeObj);
                        }, nodes);

                        treeNodeDom.removeChildNodes(that);

                        nodes.sort(function(a, b) {
                            return sortBy.indexOf(a.iconSkin) - sortBy.indexOf(b.iconSkin);
                        });
                        treeNodeDom.addNodes(that, nodes);
                        that.isInit = true;
                    });
                };
                SiteNode.prototype.add = function(callback) {
                    var selectNode = this;
                    var win = angular.copy(constsService.SITE_ADD_EDIT);
                    win.title = appUtils.getString("home.term.addSite.label");
                    win.helpId = "addSite";
                    win.data = {
                        isCreateSite: true
                    };

                    var allSites = $("#tree").widget().getZTreeObj().getSelectedNodes()[0].getParentNode().children;
                    !_.isEmpty(allSites) && infoTransferredService.put("resource", "sitesAttachServer", allSites);
                    appUtils.showWindow(win, function() {
                        if (!UnifyValid.FormValid($("#" + constsService.SITE_ADD_EDIT.verifyId), {focusInvalid: true})) {
                            return;
                        }

                        var isCloudSite = !_.isEmpty($("#siteType").attr('checked'));
                        var validCloudSitesCfg = function() {
                            var regionId = $("#area").widget().getSelectedId();
                            if (regionId == "-1") {
                                message.error(appUtils.getString("validate_select_value_label", "site_create_area_label"));
                                return false;
                            }

                            var projectId = $("#project").widget().getValue();
                            if (projectId == "-1") {
                                message.error(appUtils.getString("validate_select_value_label", "site_create_project_label"));
                                return false;
                            }
                            return true;
                        };

                        if (isCloudSite && !validCloudSitesCfg()) {
                            return;
                        }

                        var param = {
                            name: $.trim($("#name").widget().getValue()),
                            description: $.trim($("#description").widget().getValue()),
                            serverUuid: infoTransferredService.get("server", "currentServer").id,
                            isCloudSite: isCloudSite,
                        };

                        if (isCloudSite) {
                            param.cloudServiceProvider = "HuaweiCloud";
                            param.ak = $("#ak").widget().getValue();
                            param.sk = $("#sk").widget().getValue();
                            param.regionId = $("#area").widget().getSelectedId();
                            param.projectId = $("#project").widget().getValue();
                            param.proxyId = $("#proxy").widget().getSelectedId() == "-1" ? "" : $("#proxy").widget().getSelectedId();
                        }

                        mask.show();
                        communicationService.post(utilService.getResouceUrl("/sites"), param, undefined, undefined, 10 * 60 * 1E3).promise().always(function(result) {
                            mask.hide();
                            if (exception.check(result)) {
                                message.success({
                                    content: appUtils.getString("common_term_operation_success_label"),
                                    ok: function() {
                                        $("#" + constsService.SITE_ADD_EDIT.winId).widget().destroy();
                                        (callback)(selectNode);
                                    }
                                });
                            }

                        });
                    })
                };

                SiteNode.prototype.modify = function(callback) {
                    var selectNode = this;
                    communicationService.get(utilService.getResouceUrl("/sites/" + selectNode.id)).promise().always(function(response) {
                        if (exception.check(response)) {
                            var data = {};
                            data.isCreateSite = false;
                            data.siteId = response.siteId;
                            data.name = _.isEmpty(response.name) ? "null" : $.trim(response.name);
                            data.description = _.isNull(response.description) ? "null" : $.trim(response.description);
                            data.siteType = +response.siteType;
                            data.proxyId = response.proxyId;
                            data.regionId = response.regionId;
                            data.isCloudSite = response.isCloudSite;
                            data.ak = appUtils.encodeForHTML(response.ak);

                            var win = angular.copy(constsService.SITE_ADD_EDIT);
                            if (!response.isCloudSite) {
                                win.width = constsService.WIN_SIZE.S3[0];
                                win.height = constsService.MODIFY_SITE_WIN.height;
                            } else {
                                win.width = appUtils.isEn() ? constsService.WIN_SIZE.S4[0] : constsService.WIN_SIZE.S3[0];
                                win.height = constsService.WIN_SIZE.S4[1];
                            }

                            win.data = data;
                            win.helpId = "modifySite";

                            appUtils.showWindow(win, function() {
                                var options = this.options;
                                if (!UnifyValid.FormValid($("#" + constsService.SITE_ADD_EDIT.verifyId), {focusInvalid: true})) {
                                    return;
                                }

                                var validCloudSitesCfg = function() {
                                    var regionId = $("#area").widget().getSelectedId();
                                    if (regionId == "-1") {
                                        message.error(appUtils.getString("validate_select_value_label", "site_create_area_label"));
                                        return false;
                                    }
                                    return true;
                                };

                                if (data.isCloudSite && !validCloudSitesCfg()) {
                                    return;
                                }

                                var param = {};
                                param.name = $.trim($("#name").widget().getValue());
                                param.description = $.trim($("#description").widget().getValue());
                                param.siteType = 0;
                                if (data.isCloudSite) {
                                    param.regionId = $("#area").widget().getSelectedId();
                                    param.ak = !infoTransferredService.get("akModule", "protocalName") ? "" : $.trim($("#ak").widget().getValue());
                                    param.proxyId = $("#proxy").widget().getSelectedId() == "-1" ? "" : $("#proxy").widget().getSelectedId();
                                    param.sk = !infoTransferredService.get("skPwdModule", "protocalPwd") ? "" : $.trim($("#sk").widget().getValue());
                                }
                                mask.show();
                                communicationService.put(utilService.getResouceUrl("/sites/" + options.data.siteId), param, undefined, undefined, 10 * 60 * 1E3).promise().always(function(result) {
                                    mask.hide();
                                    if (exception.check(result)) {
                                        message.success({
                                            content: appUtils.getString("common_term_operation_success_label"),
                                            ok: function() {
                                                $("#" + constsService.SITE_ADD_EDIT.winId).widget().destroy();
                                                (callback)(selectNode);
                                            }
                                        });
                                    }

                                });
                            })

                        }
                    });
                };

                SiteNode.prototype.onClick = function() {

                    //跨节点选中
                    infoTransferredService.put("server", "currentServer", this.getParentNode());
                    infoTransferredService.put("site", "currentSite", this);

                    $state.go("site.home", {
                        siteId: this.id,
                        randomId: Math.floor(Math.random() * 10000)
                    });

                };

                /*-------------LocalSiteNode继承SiteNode---------------------------*/
                var LocalSiteNode = function() {
                    SiteNode.apply(this, arguments);
                    this.refresh = undefined;
                }
                LocalSiteNode.prototype = new SiteNode();
                LocalSiteNode.prototype.constructor = LocalSiteNode;
                LocalSiteNode.prototype.delete = function(callback) {
                    //this is select node
                    var selectNode = this;
                    message.warn({
                        content: appUtils.getString("site_term_site_delete_message", selectNode.name),
                        ok: function() {
                            communicationService.remove(utilService.getResouceUrl("/sites/" + selectNode.id)).promise().always(function(response) {
                                if (exception.check(response)) {
                                    message.success({
                                        content: appUtils.getString("common_term_operation_success_label"),
                                        ok: function() {
                                            (callback)(selectNode);
                                        }
                                    });
                                }
                            });
                        }
                    });
                };

                /*-------------CloudSiteNode继承LocalSiteNode---------------------------*/
                var refresh = function() {
                    var selectNode = this;
                    mask.show();
                    communicationService.put(utilService.getResouceUrl("/sites/" + this.id + "/action/refreshRemoteSite"), null, null, null, 3600 * 1E3).promise().always(function(response) {
                        mask.hide();
                        if (exception.check(response)) {
                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {
                                    (callback)(selectNode);
                                }
                            });
                        }
                    });
                };
                var CloudSiteNode = function() {
                    LocalSiteNode.apply(this, arguments);
                    this.refresh = appUtils.checkRight("ism.drm.site.auth.refresh") ? refresh : undefined;
                };
                CloudSiteNode.prototype = new LocalSiteNode();
                CloudSiteNode.prototype.constructor = CloudSiteNode;

                /*-------------RemoteSiteNode继承SiteNode---------------------------*/
                var RemoteSiteNode = function() {
                    SiteNode.apply(this, arguments);
                    this.delete = undefined;
                }
                RemoteSiteNode.prototype = new SiteNode();
                RemoteSiteNode.prototype.constructor = RemoteSiteNode;
                RemoteSiteNode.prototype.refresh = function(callback) {
                    var selectNode = this;
                    mask.show();
                    communicationService.put(utilService.getResouceUrl("/sites/" + this.id + "/action/refreshRemoteSite"), null, null, null, 3600 * 1E3).promise().always(function(response) {
                        mask.hide();
                        if (exception.check(response)) {
                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {
                                    (callback)(selectNode);
                                }
                            });
                        }
                    });
                }
                /*-------------RemoteSiteNode继承SiteNode---------------------------*/
                var ResourceTreeNode = function() {
                    SiteNode.apply(this, arguments);
                    this.add = this.delete = this.refresh = this.modify = undefined;
                }
                ResourceTreeNode.prototype.click = function() {
                    var siteNode = this.getParentNode();
                    var serverNode = siteNode.getParentNode();
                    infoTransferredService.put("server", "currentServer", serverNode);
                    infoTransferredService.put("site", "currentSite", siteNode);
                }



                /*---------------------存储node-------------------------------------*/
                var StorageTreeNode = function() {
                    ResourceTreeNode.apply(this, arguments);
                }
                StorageTreeNode.prototype = new ResourceTreeNode();
                StorageTreeNode.prototype.constructor = StorageTreeNode;
                StorageTreeNode.prototype.onClick = function() {
                    this.click();
                    $state.go("site.home", {
                        siteId: this.pId
                    });
                }

                var HostTreeNode = function() {
                    ResourceTreeNode.apply(this, arguments);
                }
                HostTreeNode.prototype = new ResourceTreeNode();
                HostTreeNode.prototype.constructor = HostTreeNode;
                HostTreeNode.prototype.onClick = function() {
                    this.click();
                    $state.go("site.home", {
                        siteId: this.pId
                    });
                }

                var CloudTreeNode = function() {
                    ResourceTreeNode.apply(this, arguments);
                }
                CloudTreeNode.prototype = new ResourceTreeNode();
                CloudTreeNode.prototype.constructor = CloudTreeNode;
                CloudTreeNode.prototype.onClick = function() {
                    if($state.current.name.indexOf("site.cloud") === 0 && $state.params.siteId == this.pId){
                        return;
                    }
                    this.click();
                    $state.go("site.cloud.vmList", {
                        siteId: this.pId
                    });
                };

                var VRGTreeNode = function() {
                    ResourceTreeNode.apply(this, arguments);
                }
                VRGTreeNode.prototype = new ResourceTreeNode();
                VRGTreeNode.prototype.constructor = VRGTreeNode;
                VRGTreeNode.prototype.onClick = function() {
                    this.click();
                    $state.go("site.vmware.vmList", {
                        siteId: this.pId
                    });
                };

                var BackupRespoTreeNode = function() {
                    ResourceTreeNode.apply(this, arguments);
                }
                BackupRespoTreeNode.prototype = new ResourceTreeNode();
                BackupRespoTreeNode.prototype.constructor = BackupRespoTreeNode;
                BackupRespoTreeNode.prototype.onClick = function() {
                    this.click();
                    $state.go("site.backupRespo", {
                        siteId: this.pId
                    });
                }

                var CloudServerTreeNode = function() {
                    ResourceTreeNode.apply(this, arguments);
                }
                CloudServerTreeNode.prototype = new ResourceTreeNode();
                CloudServerTreeNode.prototype.constructor = CloudServerTreeNode;
                CloudServerTreeNode.prototype.onClick = function() {
                    this.click();
                    $state.go("site.cloudServer", {
                        siteId: this.pId
                    });
                }

                var TreeNodes = {},
                    authObj = {
                        server: {
                            "add": 9318,
                            "modify": 9319,
                            "delete": 9320,
                            "refresh": 9321
                        },
                        site: {
                            "add": 9324,
                            "modify": 9325,
                            "delete": 9326,
                            "refresh": 9327
                        }
                    };

                function checkAuthFilter(type) {
                    var checkObjs = Array.prototype.slice.call(arguments),
                        filterObj = authObj[type];
                    checkObjs = checkObjs.slice(1);

                    _.each(checkObjs, function(checkObj) {
                        _.each(filterObj, function(v, k) {
                            !appUtils.checkRight(+v) && (checkObj.prototype[k] = undefined);
                        }, checkObj);
                    });
                }

                checkAuthFilter("site", RemoteSiteNode, LocalSiteNode);
                checkAuthFilter("server", RemoteServerTreeNode, LocalServerTreeNode)

                TreeNodes.RemoteSiteNode = RemoteSiteNode;
                TreeNodes.LocalSiteNode = LocalSiteNode;
                TreeNodes.CloudSiteNode = CloudSiteNode;
                TreeNodes.RemoteServerTreeNode = RemoteServerTreeNode;
                TreeNodes.LocalServerTreeNode = LocalServerTreeNode;
                TreeNodes.StorageTreeNode = StorageTreeNode;
                TreeNodes.HostTreeNode = HostTreeNode;
                TreeNodes.CloudTreeNode = CloudTreeNode;
                TreeNodes.VRGTreeNode = VRGTreeNode;
                TreeNodes.BackupRespoTreeNode = BackupRespoTreeNode;
                TreeNodes.CloudServerTreeNode = CloudServerTreeNode;

                _.extend(this, TreeNodes);

                this.ViewModel = ViewModel;

            }
        ];

        return service;
    });
