/**
 * 消息提示框
 * MessageBox的公共服务
 */
define(["tiny-lib/underscore", "tiny-widgets/Message"],
    function(_, Message) {
    "use strict";

    var service = function(i18nService) {

        /**
         * 提示窗口
         * @options: {content: "提示内容"，ok: function(){...}}
         *
         */
        this.prompt = function(options) {
            if (_.isString(options)) {
                options = {
                    content: options
                };
            }


            var configs = _.extend({
                type: "confirm",
                buttons: [{
                    label: tinyLanguage.language.okBtnTitile,
                    focused: true,
                    handler: function(event) {
                        var position = $("body").find("div[id^='messageDialog_main_MessageDialog_']").offset();
                        msg.destroy();
                        msg = null;
                        if (options.content.indexOf("window.showTaskList()") != -1) {
                             window.taskUserGuide(position);
                        }
                        options.ok && options.ok();
                    }
                }]
            }, options);
            configs.close = configs.close || options.ok;
            if (options.content.indexOf("window.showTaskList()") != -1) {
                var tmp = configs.close;
                configs.close = function(event){
                    window.taskUserGuide(event);
                    if(_.isFunction(tmp)){
                        tmp();
                    }
                }
            }
            var msg = new Message(configs);
            msg.show();
            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(i18nService.get("common_message_win_information_title"));
            $("#"+msg.dialogId).css("min-height","40px");
            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("line-height","18px");
            return msg;
        };

        /**
         * 提示确认窗口， 新增cancel按钮
         * @options: {content: "提示内容"，ok: function(){...},close:function(){...}}
         *
         */
        this.tipPrompt = function(options){
            if (_.isString(options)) {
                options = {
                    content: options
                };
            }

            var configs = _.extend({
                type: "confirm",
                width: "450px",
                buttons: [{
                    label: tinyLanguage.language.okBtnTitile,
                    focused: false,
                    handler: function(event) {
                        var position = $("body").find("div[id^='messageDialog_main_MessageDialog_']").offset();
                        msg.destroy();
                        msg = null;
                        options.ok && options.ok();
                    }
                },{
                    label: tinyLanguage.language.cancelBtnTitile,
                    focused: true,
                    handler: function(event) {
                        msg.destroy();
                        msg = null;
                        options.cancel && options.cancel();
                    }
                }]
            }, options);
            var msg = new Message(configs);
            msg.show();
            _.isEmpty(options.title) && $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(i18nService.get("common_message_win_information_title"));
            $("#"+msg.dialogId).css("min-height","40px");
            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("line-height","18px");
            return msg;
        };

        /**
         * 成功提示窗口
         * @options: {content: "提示内容"，ok: function(){...}}
         *
         */
        this.success = function(options) {
            if (_.isString(options)) {
                options = {
                    content: options
                };
            }
            var configs = _.extend({
                type: "prompt",
                buttons: [{
                    label: tinyLanguage.language.okBtnTitile,
                    focused: true,
                    handler: function(event) {
                        msg.destroy();
                        msg = null;
                        options.ok && options.ok();
                    }
                }]
            }, options);
            configs.close = configs.close || options.ok;
            var msg = new Message(configs);
            msg.show();
            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(i18nService.get("common_message_win_success_title"));
            $("#"+msg.dialogId).css("min-height","40px");
            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("line-height","18px");
        };

        /**
         * 错误窗口
         * @options: {content: "提示内容"，ok: function(){...}}
         */
        this.error = function(options) {
            if (_.isString(options)) {
                options = {
                    content: options
                };
            }
            var configs = _.extend({
                type: "error",
                buttons: [{
                    label: tinyLanguage.language.okBtnTitile,
                    focused: true,
                    handler: function(event) {
                        msg.destroy();
                        msg = null;
                        options.ok && options.ok();
                    }
                }]
            }, options);
            configs.close = configs.close || options.ok;
            var msg = new Message(configs);
            if (!_.isEmpty(options.suggestion)) {
                msg.option("detail-msg", options.suggestion);
            }
            msg.show();
            $("#"+msg.dialogId).css("min-height","40px");
            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("line-height","18px");
        };

        /**
         * 确认窗口
         * @options: {content: "提示内容"，ok: function(){...}，cancel: function(){...}}
         */
        this.confirm = function(options) {
            if (_.isString(options)) {
                options = {
                    content: options
                };
            }
            var configs = _.extend({
                type: "confirm",
                buttons: [{
                    label: tinyLanguage.language.okBtnTitile,
                    accessKey: "2",
                    "focused": false,
                    handler: function(event) {
                        msg.destroy();
                        msg = null;
                        options.ok && options.ok();
                    }
                }, {
                    label: tinyLanguage.language.cancelBtnTitile,
                    accessKey: "3",
                    "focused": true,
                    handler: function(event) {
                        msg.destroy();
                        msg = null;
                        options.cancel && options.cancel();
                    }
                }]
            }, options);
            configs.close = configs.close || options.cancel;
            var msg = new Message(configs);
            msg.show();
            $("#"+msg.dialogId).find(".ti-info-circle").removeClass('tiny-img-confirm').addClass('message_win_picture');
            $("#"+msg.dialogId).css("min-height","40px");
            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(i18nService.get("common_message_win_question_title"));
            $("#"+msg.dialogId).find(".tinyMessageBox_msgBoxContent").css("font-size","14px").css("color","#333");
        };

        /**
         * 警告窗口
         * @options: {content: "提示内容"，ok: function(){...}，cancel: function(){...}}
         */
        this.warn = function(options) {
            if (_.isString(options)) {
                options = {
                    content: options
                };
            }
            var defer = $.Deferred(),configs = _.extend({
                type: "warn",
                width: "450px",
                buttons: [{
                    label: options.okLabel ? options.okLabel : tinyLanguage.language.okBtnTitile,
                    accessKey: "2",
                    "focused": false,
                    handler: function(event) {
                        if($($("#"+msg.dialogId).parent().find("button")[0]).hasClass("tiny-btn-disable")){
                            return;
                        }
                        msg.destroy();
                        msg = null;
                        options.ok && options.ok();
                        defer.resolve();
                    }
                }, {
                    label: options.cancelLabel ? options.cancelLabel : tinyLanguage.language.cancelBtnTitile,
                    accessKey: "3",
                    "focused": true,
                    handler: function(event) {
                        msg.destroy();
                        msg = null;
                        options.cancel && options.cancel();
                        defer.reject();
                    }
                }]
            }, options);
            configs.close = configs.close || options.cancel;
            var msg = new Message(configs);
            msg.show();
            $($("#"+msg.dialogId).parent().find("button")[0]).addClass("tiny-btn-disable");
            var checkHtml = $("<div style='width:315px;height:15px;margin-left:50px;margin-top:15px'><div id='checkBoxDiv'></div></div>");
            $("#"+msg.dialogId).find("div[id^='baseDiv_']").after(checkHtml);
            $("#"+msg.dialogId).css("min-height","130px");
            var check1 = new tinyWidget.Checkbox({
                "id": "checkBoxDiv",
                "disable" : false,
                "text" : i18nService.get("common_warn_checkBox_confim_label"),
                "change": function(event){
                    if(this.checked){
                       $($("#"+msg.dialogId).parent().find("button")[0]).removeClass("tiny-btn-disable");
                    }else{
                       $($("#"+msg.dialogId).parent().find("button")[0]).addClass("tiny-btn-disable");
                    }
                }
            });
            $("#checkBoxDiv").css({"color":"#333","font-size":"12px"});
            var lang = $("#"+msg.dialogId).find("div[id^='baseDiv_']").find(".tinyMessageBox_msgBoxContent").css("max-height","200px");
            if(lang.html().indexOf("<br>") != "-1"){
               var langArray = lang.html().split("<br>");
               var changHtml = "";
               for(var i=0;i<langArray.length;i++){
                    if(i==0){
                        langArray[i] = langArray[i].replace(/\(/g,"(<span style='font-weight:bold;word-break: break-word;'>");
                        langArray[i] = langArray[i].replace(/\)/g,"</span>)");
                        changHtml += "<span class='warn_main'>"+langArray[i]+"</span>";
                    }else if(i==langArray.length-1){
                        changHtml += "<span class='warn_suggest'>"+langArray[i]+"</span>";
                    }else{
                        changHtml += "<span class='warn_span'>"+langArray[i]+"</span>";
                    }
               }
               lang.html(changHtml);
            }
            return defer.promise();
        };

        this.notice = function(options) {
            var configs = _.extend({
                type: "systemNotice"
            }, options);
            configs.close = configs.close || options.cancel;
            var msg = new Message(configs);
            msg.show();
        };

    };

    service.$injector = ["i18nService"];

    return service;
});
