define([], function() {
        "use strict";

        var service = function () {};

        service.prototype = {
            toBoolean: function( value ) {
                if (value && value.length !== 0) {
                    var v = ("" + value).toLowerCase();
                    value = !(v == 'f' || v == '0' || v == 'false' || v == 'no' || v == 'n' || v == '[]');
                } else {
                    value = false;
                }
                return value;
            },
            /**
             * 将数据格式化，保留三位小数（截取方式）
             * 如123456.78901 显示为123,456.789
             *
             * @param number 原数字
             * @param decimals 保留小数个数 [默认3位]
             * @param dec_point 小数分隔副
             * @param thousands_sep 千分位分隔符
             * @returns 转化后的数字
             */
            numberFormat: function (number, decimals, dec_point, thousands_sep, isCeil) {
                if (angular.isUndefined(decimals)) {
                    decimals = 3;
                }
                number = (String(number)).replace(/[^0-9+-Ee.]/g, '');
                let n = isFinite(+number) ? +number : 0;
                let prec = isFinite(+decimals) ? Math.abs(decimals) : 0;
                let sep = (angular.isUndefined(thousands_sep)) ? ',' : thousands_sep;
                let dec = (angular.isUndefined(dec_point)) ? '.' : dec_point;
                let toFixedFix = function(n, prec, isCeil) {
                    let k = Math.pow(10, prec);
                    return isCeil ? String(Math.ceil(n * k) / k) : String(Math.floor(n * k) / k);
                };

                let s = (!prec ? String(Math.floor(n)) : toFixedFix(n, prec, isCeil)).split('.');
                if (s[0].length >= 4) {
                    s[0] = s[0].replace(/\B(?=(?:d{3})+(?!d))/g, sep);
                }

                if (s[1] && s[1].length > prec) {
                    s[1] += new Array(prec - s[1].length + 1).join('0');
                }
                if (angular.isUndefined(s[1])) {
                    s[1] = '0';
                }
                while ((s[1] || '').length < prec) {
                    s[1] += '0';
                }
                return s.join(dec);
            },
            stringFormat: function(str, params) {
                if (!str) {
                    return str;
                }

                str = $.trim(str);
                if ($.isArray(params)) {
                } else if (typeof params === "string" || typeof params === "number") {
                    params = Array.prototype.slice.call(arguments, 1);
                } else {
                    params = [];
                }

                return str.replace(/\{\d+\}/gi, function(match, index) {
                    var i = match.replace(/\D/g, function(match, index) { return ""; });
                    i = parseInt(i);
                    if (!isNaN(i) && (typeof params[i] !== "undefined")) {
                        return params[i];
                    } else {
                        return match;
                    }
                });
            }
        };

        return service;
    }
);
