define(["tiny-widgets/Window",
        "../recoverymodel/nas",
        "../recoverymodel/vmware",
        "../recoverymodel/fusionsphere",
        "../recoverymodel/oracle",
        "../recoverymodel/sqlserver",
        "../recoverymodel/db2",
        "../recoverymodel/mysql",
        "../recoverymodel/informaix",
        "../recoverymodel/sybase",
        "../recoverymodel/kingbase",
        "../recoverymodel/exchange",
        "../recoverymodel/filesystem",
        "../recoverymodel/lun",
        "../recoverymodel/exchange2007",
        "../recoverymodel/hana"],
    function(Window, Nas, Vmware, FusionSphere, Oracle, SqlServer, Db2, MySql, Informaix, Sybase, KingBase, Exchange, FileSystem, Lun, Exchange2007, Hana) {
        "use strict";
        var ModelManager = ["message", "appUtils", "constsService", "restService", "cookieService", "infoTransferredService", function(message, appUtils, constsService, restService, cookieService, infoTransferredService) {
            //服务作用于当前的上下文
            this.message = message;
            this.appUtils = appUtils;
            this.constsService = constsService;
            this.restService = restService;
            this.cookieService = cookieService;
            this.infoTransferredService = infoTransferredService;

        var context = this, //当前上下文
            //恢复计划模型映射,有恢复计划类型合保护组类型拼接而成
            _modelMapper = {},
            //本地恢复计划模型映射
            _localMapper = {
                "1_1": Oracle,
                "1_2": SqlServer,
                "1_3": Db2,
                "1_4": MySql,
                "1_5": Informaix,
                "1_6": Sybase,
                "1_7": KingBase,
                "1_8": Exchange,
                "1_9": FileSystem,
                "1_10": Vmware,
                "1_11": Lun,
                "1_12": FusionSphere,
                "1_13": Exchange2007,
                "1_14": Nas,
                "1_16": Hana
            },
            //远程恢复计划模型映射
            _remoteMapper = {
                "2_1": Oracle,
                "2_2": SqlServer,
                "2_3": Db2,
                "2_4": MySql,
                "2_5": Informaix,
                "2_6": Sybase,
                "2_7": KingBase,
                "2_8": Exchange,
                "2_9": FileSystem,
                "2_10": Vmware,
                "2_11": Lun,
                "2_12": FusionSphere,
                "2_13": Exchange2007,
                "2_14": Nas,
                "2_16": Hana
            };
            _.extend(_modelMapper, _localMapper, _remoteMapper);
            this.utils = {
                openWin: function(id, title, param, width, height, url, buttons, helpId, closeIcon) {
                    var options = {
                        "winId": id,
                        "title": title,
                        "data": param,
                        "height": height,
                        "width": width,
                        "modal": true,
                        "content-type": "url",
                        "draggable": true,
                        "content": url,
                        "minimizable": false,
                        "maximizable": false,
                        "buttons": buttons,
                        "helpId" : helpId,
                        "beforeClose": closeIcon
                    };
                    var win = new Window(options);
                    win.show();
                }
            };
            this.compareProtectedObject = function(copyId,currentId,protectUuid,callback1){
                var differenceObj = [];
                function copyInit(response){
                    restService.getCopyProtectgroups({protectgroupId:protectUuid,replicaId:copyId},{
                        success:function(result){
                           showDifference(result.records,response);
                           callback1(differenceObj);
                        }
                    })
                };
                function currentInit(callback){
                    var params = {
                        uuid:currentId,
                        startPage:0,
                        pageSize:512,
                        orderBy:"name",
                        orderType:"asc"
                    };
                    restService.getRecoveryProtectObject(params,{
                        success:function(result){
                            callback(result.records);
                        }
                    })
                };
                function showDifference(copyObj,currentObj){
                    var currentUuid = [],
                        copyUuid = [],
                        addUuid = [],
                        reduceUuid = [];
                    _.each(copyObj,function(obj){
                        copyUuid.push(obj.uuid);
                    });
                    _.each(currentObj,function(obj){
                        currentUuid.push(obj.uuid);
                    });
                    _.each(copyUuid,function(val){
                        if(!_.contains(currentUuid,val)){
                            reduceUuid.push(val);
                        }
                    });
                    _.each(currentUuid,function(val){
                        if(!_.contains(copyUuid,val)){
                            addUuid.push(val);
                        }
                    });
                    _.each(copyObj,function(val){
                        if(_.contains(reduceUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"-1"
                            });
                            differenceObj.push(val);
                        }
                    });
                    _.each(currentObj,function(val){
                        if(_.contains(addUuid,val.uuid)){
                            _.extend(val,{
                                differenceStatus:"1"
                            });
                            differenceObj.push(val);
                        }
                    });
                }
                currentInit(copyInit);
            }
            this.execute = function(obj) {
                _.extend(obj, {planType: $.trim(obj.planType), poType: $.trim(obj.poType)});
                if (_.isEmpty(obj.planType) || _.isEmpty(obj.poType)) {
                    return;
                }
                var key = $.trim(obj.planType) + "_" + $.trim(obj.poType);
                if (!_.has(_modelMapper, key)) {
                    return;
                }
                !_.isEmpty(_modelMapper[key]) && _.isFunction(_modelMapper[key][obj.action]) && _modelMapper[key][obj.action].call(context, obj);
            };

        }];
        return ModelManager;
    })
