define(["tiny-lib/jquery", "tiny-lib/Class"], function($, Class) {
    "use strict";

    var SECURITY_SERVICE = "securityService";
    var ServiceHolder = Class.extend({
        init: function(module) {
            var service = this;
            service.module = module;
            service.user = {
                _updated: false
            };
            service.privileges = {
                _updated: false
            };
            service._privileges_map = {
            };
        },
        register: function() {
            var that = this;

            var Service = function() {};

            Service.prototype = {
                getCurrentUser: function() {
                    return that.user;
                },
                isAdmin: function() {
                    return this.getCurrentUser().isAdmin;
                },
                checkRight: function(keys) {
                    if (!keys) {
                        return false;
                    }

                    if (this.isAdmin()) {
                        if (typeof keys === "string" || typeof keys === "number") {
                            return true;
                        }

                        var result = {};
                        if (_.isArray(keys)) {
                            _.each(keys, function(key) {
                                result[$.trim(key)] = true;
                            });
                        }

                        return result;
                    }

                    if (that.privileges._updated) {
                        that.load();
                    }

                    if (typeof keys === "string" || typeof keys === "number") {
                        return that.privileges[that._privileges_map[$.trim(keys)] || $.trim(keys)] || false;
                    }

                    var result = {};
                    if (_.isArray(keys)) {
                        _.each(keys, function(key) {
                            var p = that._privileges_map[$.trim(key)] || $.trim(key);
                            result[$.trim(key)] = that.privileges[p] || false;
                        });
                    }

                    return result;


                }
            };

            that.module.service(SECURITY_SERVICE, Service);
        },
        load: function() {
            var dtd = $.Deferred(),
                that = this,
                permissionsPromise = $.ajax({
                    type: "GET",
                    data: {},
                    timeout: 5000,
                    async: true,
                    url: "/ws/users/permissions",
                    contentType: "application/json; charset=utf-8",
                    headers: {
                        "If-Modified-Since": "0",
                        "Accept-Language": that._getCookie("rd_language"),
                        "rd_randomStr_HW": that._getCookie("rd_randomStr_HW")
                    },
                    success: function(response) {
                        that.privileges = {
                            updated: false
                        };
                        _.each(response, function(key) {
                            that.privileges[$.trim(key)] = true;
                        });

                        that.privileges.updated = true;
                    },
                    error: function(err) {
                        throw new Error('load permissions failed. cause by ' + err);
                        that.privileges = {
                            update: false
                        };
                    }
                }),
                privilegesPromise = $.ajax({
                    type: "GET",
                    data: {},
                    timeout: 5000,
                    async: true,
                    url: "/ws/systemPrivileges",
                    contentType: "application/json; charset=utf-8",
                    headers: {
                        "If-Modified-Since": "0",
                        "Accept-Language": that._getCookie("rd_language"),
                        "rd_randomStr_HW": that._getCookie("rd_randomStr_HW")
                    },
                    success: function(response) {
                        _.each(response, function(obj){
                            this[obj.name] = obj.id;
                        },that._privileges_map);
                    },
                    error: function(err) {
                        throw new Error('load systemPrivileges failed. cause by ' + err);
                    }
                });
            that.user = {
                updated: true,
                userId: that._getCookie('id'),
                userName: that._getCookie('userName'),
                isAdministrator: that._getCookie('isAdministrator') == "true",
                isAdmin: that._getCookie("userName") == "admin"
            };

            $.when(permissionsPromise, privilegesPromise).then(function() {
                dtd.resolve();
            }, function(err) {
                throw new Error('RD UI System load permision failed, cause by ' + err);
                dtd.reject();
            });

            return dtd.promise();
        },
        _getCookie: function(key) {
            var cookies = document.cookie.split("; ");
            var length = cookies.length;

            for (var i = 0; i < length; i++) {
                var cookiePair = cookies[i].split("=");
                if (cookiePair[0] == key) {
                    return decodeURIComponent(cookiePair[1]);
                }
            }
        }
    });

    return ServiceHolder;
});
