define(["tiny-lib/underscore"], function(_) {
    "use strict";

    var service = ["restService", "appUtils", "$q", "i18nService", "$rootScope", function(Rest, appUtilsService, $q, i18nService, $rootScope) {
        //保护组类型
        var protectionGroupTypes = [];
        var leftTreeAuth = [
            { state: "settings.userList", authKey: "lego.sys.operatorMgr.operator" },
            { state: "settings.userList", authKey: "lego.sys.operatorMgr.operator.scan" },
            { state: "settings.roleList", authKey: "lego.sys.role.scan" },
            { state: "settings.onlineUserList", authKey: "lego.sys.onlineUserMgr.scan" },
            { state: "settings.securityPolicy", authKey: "lego.sys.sysLoginPolicy" },
            { state: "settings.performance", authKey: "lego.sys.systemInfo" },
            { state: "settings.operLogMaintance", authKey: "lego.sys.dataStorage.sysOptLog" },
            { state: "settings.alarmMaintance", authKey: "lego.sys.dataStorage.event" },
            { state: "settings.sysData", authKey: "ism.drm.dump.configdata" },
            { state: "settings.dataExport", authKey: "ism.drm.dump.software.doc.menuname" },
            { state: "settings.sysOperLog", authKey: "lego.sys.sysLog.operLog" },
            { state: "settings.debugLog", authKey: "ism.drm.sys.exportrlog" },
            { state: "settings.sysLog_manage", authKey: "ism.drm.sys.log.notify" },
            { state: "settings.oc_manage", authKey: "ism.drm.thirdservice.oc" },
            { state: "settings.proxy", authKey: "ism.drm.thirdservice.oc" },
            { state: "settings", authKey: "ism.drm.proxyserver" }
        ];
        var filteredAuthTree = appUtilsService.flilterOperRight(leftTreeAuth);
        this.plugins = [];
        var _plugins = this.plugins;
        //包含的应用,保护组路由中会根据此配置加载对应应用的实现
        var poTypes = [];
        this.poTypes = poTypes;
        //home no auth
        this.plugins.push({
            "name": i18nService.get("home_title"),
            "state": "home",
            "authKey": "9379",
            "openState": "home.staticView",
            "id": "homeViewTab"
        })

        //site
        if (appUtilsService.checkRight("ism.drm.resource.menuname")) {
            var p = {
                "name": i18nService.get("common_term_source_label"),
                "state": "site",
                "authKey": "9315",
                "openState": "site",
                "id": "siteViewTab"
            }
            this.plugins.push(p);
        };

        //protect
        if (appUtilsService.checkRight("ism.drm.protection.menuname")) {
            var p = {
                "name": i18nService.get("protect_title"),
                "state": "protection",
                "authKey": "9000",
                "openState": "protection.pg.list",
                "id": "protectionViewTab"
            }
            this.plugins.push(p);
        };

        //Recovery
        if (appUtilsService.checkRight("ism.drm.disaster.recovery.menuname")) {

            if (window.isUltraVR || window.isPrivateConsole) {
                var p = {
                    "name": i18nService.get("recovery_title"),
                    "state": "dataUse",
                    "authKey":"9100",
                    "openState": "dataUse.dataRecovery.abstract",
                    "id": "recoveryViewTab"
                }
                this.plugins.push(p);
            } else {
                var p = {
                    "name": i18nService.get("menus_dataused_title"),
                    "state": "dataUse",
                    "authKey": "9100",
                    "id": "dataUseViewTab"
                };
                p.subPlugins = [{
                    "name": i18nService.get("menus_recovery_datarecovery_label"),
                    "state": "dataUse.dataRecovery.abstract",
                    "authKey": "9100",
                    "id": "dataRecoveryViewTab"
                }, {
                    "name": i18nService.get("menus_recovery_datamount_label"),
                    "state": "dataUse.dataMount.abstract",
                    "authKey": "9100",
                    "id": "dataMountViewTab"
                }];

                this.plugins.push(p);
            }
        };

        //monitor
        if (appUtilsService.checkRight("ism.drm.monitor.menuname")) {
            var p = {
                "name": i18nService.get("monitor_title"),
                "state": "monitor",
                "authKey": "73",
                "id": "monitorViewTab"
            }

            p.subPlugins = [];
            if (appUtilsService.checkRight("ism.drm.monitor.topology.mgt.menuname") && !window.isPrivateConsole) {
                p.subPlugins.push({
                    "name": i18nService.get("topo_title"),
                    "authKey": "9200",
                    "state": "monitor.topo",
                    "id": "monitorTopoTab"
                })

            }
            if (appUtilsService.checkRight("lego.evtMgr")) {
                var alarm = {
                    "name": i18nService.get("alarms_title"),
                    "authKey": "74",
                    "state": "monitor.alarm",
                    "id": "monitorAlarmTab"
                };
                p.subPlugins.push(alarm)
                alarm.subPlugins = [];
                if (appUtilsService.checkRight("lego.evtMgr.curtAlarm")) {
                    alarm.subPlugins.push({
                        "name": i18nService.get("alarms_current_title"),
                        "authKey": "75",
                        "state": "monitor.currentalarmlist({alarmType:''})",
                        "id": "currentalarmlistTab"
                    })
                }
                if (appUtilsService.checkRight("lego.evtMgr.hisAlarm")) {
                    alarm.subPlugins.push({
                        "name": i18nService.get("alarms_history_title"),
                        "authKey": "82",
                        "state": "monitor.historyalarmlist",
                        "id": "historyalarmlistTab"
                    })
                }
                if (appUtilsService.checkRight("lego.event.voice")) {
                    alarm.subPlugins.push({
                        "name": i18nService.get("audio_setting_title"),
                        "authKey": "123",
                        "state": "monitor.audiosetting",
                        "id": "audiosettingTab"
                    })
                }
            }
            if (appUtilsService.checkRight("ism.drm.monitor.report.mgt.menuname")) {
                var report = {
                    "name": i18nService.get("report_title"),
                    "authKey": "9203",
                    "state": "monitor.report",
                    "id": "monitorReportTab"
                };
                p.subPlugins.push(report);
                report.subPlugins = [];
                if (appUtilsService.checkRight("ism.drm.report.protection.menuname")) {
                    report.subPlugins.push({
                        "name": i18nService.get("report_pg_title"),
                        "authKey": "9204",
                        "state": "monitor.groupstatreport",
                        "id": "groupstatreportTab"
                    })
                }
                if (appUtilsService.checkRight("ism.drm.report.recovery.menuname")) {
                    report.subPlugins.push({
                        "name": i18nService.get("report_recovery_title"),
                        "authKey": "9207",
                        "state": "monitor.recoverytestreport",
                        "id": "recoverytestreportTab"
                    })
                }
            }
            this.plugins.push(p);
        };
        //setting 权限
        if (appUtilsService.checkRight("ism.drm.settings.menuname")) {
            var p = {
                "name": i18nService.get("settings_title"),
                "authKey": "130",
                "state": "settings",
                "openState": filteredAuthTree[0].state,
                "id": "settingsViewTab"
            }
            this.plugins.push(p);
        };

        $rootScope.plugins = angular.copy(_plugins);
        $rootScope.$apply();

    }];
    return service;
});