define([], function() {

    var service = function(constsService, appUtils) {

        var StatusEntity = function(name, color, iconClass) {
            this.name = name;
            this.color = color;
            this.iconClass = iconClass;
        };

        StatusEntity.prototype = {
            getColorSpan: function(name) {
                name = appUtils.encodeForHTML(name || this.name);
                if (!_.isEmpty(this.iconClass)) {
                    return "<span style='margin-right:5px;width:16px;height:16px;float:left;' class=" + this.iconClass + "></span><font style=color:" + this.color + ">" + name + "</font>";
                }
                if (!_.isEmpty(this.color)) {
                    return "<font style=color:" + this.color + ">" + name + "</font>";
                }
                return name;
            }
        };

        var statusMap = {} || statusMap;
        var commonStatus = {
            unknow: new StatusEntity("--", "", "")
        };

        var commonClass = {
            success: "icon-success",
            failed: "icon-failed",
            anySuccess: "icon-danger",
            running: "iconbutton-loading",
            warn: "normal",
            info: "information",
            important: "important",
            emergency: "emergency",
            paused: "iconbutton-pause"
        };

        statusMap.SYSTEM_LOGS_RESULT = {
            1: new StatusEntity(appUtils.getString("syslog_term_result_1"), "", "icon-success"),
            0: new StatusEntity(appUtils.getString("syslog_term_result_0"), "", "icon-failed"),
            "-1": new StatusEntity(appUtils.getString("syslog_term_result_2"), "", "icon-failed")
        };

        statusMap.SYSTEM_LOGS_LEVEL = {
            1: new StatusEntity(appUtils.getString("syslog_term_level_1"), "", ""),
            2: new StatusEntity(appUtils.getString("syslog_term_level_2"), constsService.CLOLOR_ORANGE, ""),
            3: new StatusEntity(appUtils.getString("syslog_term_level_3"), "", ""),
            4: new StatusEntity(appUtils.getString("syslog_term_level_4"), constsService.COLOR_RED, "")
        };

        statusMap.BACKTASK_STATUS = {
            0: new StatusEntity(appUtils.getString("common_term_succeed_label"), "", "icon-success"),
            1: new StatusEntity(appUtils.getString("common_term_failed_label"), "", "icon-failed"),
            "-1": new StatusEntity(appUtils.getString("common_term_running_label"), "", commonClass.running)
        };

        statusMap.DEVICE_STATUS = {
            2: new StatusEntity(appUtils.getString("common_term_status_normal_label"), "", "icon-registered"),
            0: new StatusEntity(appUtils.getString("common_term_status_offline_label"), "", "icon-unregistered"),
            "-1": new StatusEntity(appUtils.getString("common_term_status_abnormal_label"), "", "icon-unreachable")
        };

        statusMap.DEVICE_STORAGE_STATUS = {
            0: new StatusEntity(appUtils.getString("common_term_status_normal_label"), "", "icon-registered"),
            "-1": new StatusEntity(appUtils.getString("common_term_status_offline_label"), "", "icon-unregistered"),
            "2": new StatusEntity(appUtils.getString("common_term_status_abnormal_label"), "", "icon-unreachable")
        };

        statusMap.SITE_STATUS = {
            2: new StatusEntity(appUtils.getString("site_term_status_network_fault_label"), "", "icon-unreachable"),
            0: new StatusEntity(appUtils.getString("site_term_status_on_label"), "", "icon-registered"),
            "1": new StatusEntity(appUtils.getString("site_term_status_verify_label"), "", "icon-unregistered")
        };

        statusMap.ALARM_LEVEL = {
            "-1": new StatusEntity(appUtils.getString("alarm_term_illegal_label"), "", ""),
            1: new StatusEntity(appUtils.getString("alarm_term_info_label"), "", commonClass.info),
            2: new StatusEntity(appUtils.getString("alarm_term_send_label"), "", commonClass.warn),
            3: new StatusEntity(appUtils.getString("alarm_term_major_label"), "", commonClass.important),
            4: new StatusEntity(appUtils.getString("alarm_term_critical_label"), "", commonClass.emergency)
        };

        statusMap.ALARM_CONFIRMED_STATUS = {
            0: new StatusEntity(appUtils.getString("alarm_term_unconfirm_label"), "#e83917", ""),
            1: new StatusEntity(appUtils.getString("alarm_term_confirm_label"), "#008000", "")
        };

        statusMap.ALARM_CLEAR_STATUS = {
            1: new StatusEntity(appUtils.getString("alarm_term_clear_label"), "#008000", ""),
            0: new StatusEntity(appUtils.getString("alarm_term_unclear_label"), "#e83917", "")
        };

        statusMap.ALARM_NOTIF_YTYPE_STATUS = {
            1: new StatusEntity(appUtils.getString("alarm_term_notify_type_new"), "", ""),
            2: new StatusEntity(appUtils.getString("alarm_term_notify_type_auto"), "", ""),
            3: new StatusEntity(appUtils.getString("alarm_term_notify_type_manu"), "", "")
        };

        statusMap.ALARM_TYPE = {
            1: new StatusEntity(appUtils.getString("alarm_term_type_comm"), "", ""),
            2: new StatusEntity(appUtils.getString("alarm_term_type_env"), "", ""),
            3: new StatusEntity(appUtils.getString("alarm_term_type_dev"), "", ""),
            4: new StatusEntity(appUtils.getString("alarm_term_type_business"), "", ""),
            5: new StatusEntity(appUtils.getString("alarm_term_type_operation"), "", ""),
            6: new StatusEntity(appUtils.getString("alarm_term_type_security"), "", "")
        };

        statusMap.RECOVERY_STATUS = {
            0: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.READY"), "", ""),
            1: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.PLANED_MOTION_RUNNING"), "", commonClass.running),
            2: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.PLANED_MOTION_COMPLETED"), "", ""),
            3: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.PLANED_MOTION_FAILED"), "", ""),
            4: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.TEST_RUNNING"), "", commonClass.running),
            5: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.TEST_COMPLETED"), "", ""),
            6: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.TEST_FAILED"), "", ""),
            7: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.CLEAN_RUNNING"), "", commonClass.running),
            8: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.CLEAN_COMPLETED"), "", ""),
            9: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.CLEAN_FAILED"), "", ""),
            10: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.DISASTER_RECOVERY_RUNNING"), "", commonClass.running),
            11: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.DISASTER_RECOVERY_COMPLETED"), "", ""),
            12: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.DISASTER_RECOVERY_FAILED"), "", ""),
            15: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.ROLLBACK_RUNNING"), "", commonClass.running),
            16: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.REPROTECT_FAILED"), "", ""),
            17: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.REPROTECT_RUNNING"), "", commonClass.running),
            18: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.ROLLBACK_FAILED"), "", ""),
            19: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.ROLLBACK_COMPLETED"), "", ""),
            20: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.REPROTECT_COMPLETED"), "", ""),
            21: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.SWAP_RUNNING"), "", commonClass.running),
            22: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.SWAP_FAILED"), "", ""),
            23: new StatusEntity(appUtils.getString("mountPlan_status_mounting_replica"), "", commonClass.running),
            24: new StatusEntity(appUtils.getString("mountPlan_status_umounting_replica"), "", commonClass.running),
            25: new StatusEntity(appUtils.getString("mountPlan_status_mount_failed_replica"), "", ""),
            26: new StatusEntity(appUtils.getString("mountPlan_status_mount_completed_replica"), "", ""),
            27: new StatusEntity(appUtils.getString("mountPlan_status_unmount_completed_replica"), "", ""),
            28: new StatusEntity(appUtils.getString("mountPlan_status_unmount_failed_replica"), "", ""),
            29: new StatusEntity(appUtils.getString("plan_status_hot_migration_running"), "", commonClass.running),
            30: new StatusEntity(appUtils.getString("plan_status_hot_migration_failed"), "", ""),
            99: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.status.PLANED_MOTION_PAUSED"), "", ""),
        };

        statusMap.RECOVERY_TYPE = {
            1: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.planType.local"), "", ""),
            2: new StatusEntity(appUtils.getString("recovery.term.recovery.plan.planType.remote"), "", "")
        };

        statusMap.RECOVERY_EXECUTE_RESULT = {
            0: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.result.success"), "", commonClass.success),
            1: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.result.failed"), "", commonClass.failed),
            2: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.result.part_success"), "", commonClass.anySuccess),
            3: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.result.running"), "", commonClass.running),
            "-1": new StatusEntity(appUtils.getString("recovery.term.abstact.excute.result.other"), "", "")
        };

        statusMap.RECOVERY_EXECUTE_TYPE = {
            0: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.type.disaster_recovery"), "", ""),
            1: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.type.planed_motion"), "", ""),
            2: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.type.drilling"), "", ""),
            3: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.type.clean_drilling"), "", ""),
            4: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.type.snapshot_rollback"), "", ""),
            7: new StatusEntity(appUtils.getString("recovery.term.abstact.excute.type.reprotect"), "", "")
        };

        statusMap.PROTECT_OBJECT_STATUS = {
            0: new StatusEntity(appUtils.getString("recovery.term.protected.status.notstart"), "", ""),
            1: new StatusEntity(appUtils.getString("recovery.term.protected.status.completed"), "", ""),
            2: new StatusEntity(appUtils.getString("recovery.term.protected.status.failed"), "", ""),
            3: new StatusEntity(appUtils.getString("recovery.term.protected.status.running"), "", "")
        };

        statusMap.PROTECT_OBJECT_TYPE = {
            1: new StatusEntity(appUtils.getString("recovery.term.protected.type.Oracle"), "", ""),
            2: new StatusEntity(appUtils.getString("recovery.term.protected.type.SQLServer"), "", ""),
            3: new StatusEntity(appUtils.getString("recovery.term.protected.type.DB2"), "", ""),
            4: new StatusEntity(appUtils.getString("recovery.term.protected.type.MySQL"), "", ""),
            5: new StatusEntity(appUtils.getString("recovery.term.protected.type.Informaix"), "", ""),
            6: new StatusEntity(appUtils.getString("recovery.term.protected.type.Sybase"), "", ""),
            7: new StatusEntity(appUtils.getString("recovery.term.protected.type.KingBasees"), "", ""),
            8: new StatusEntity(appUtils.getString("recovery.term.protected.type.Exchange"), "", ""),
            9: new StatusEntity(appUtils.getString("recovery.term.protected.type.FileSystem"), "", ""),
            10: new StatusEntity(appUtils.getString("recovery.term.protected.type.VMwareMachine"), "", ""),
            11: new StatusEntity(appUtils.getString("recovery.term.protected.type.LUN"), "", ""),
            12: new StatusEntity(appUtils.getString("recovery.term.protected.type.GalaXVM"), "", ""),
            13: new StatusEntity(appUtils.getString("recovery.term.protected.type.Exchange2007"), "", ""),
            14: new StatusEntity(appUtils.getString("recovery.term.protected.type.NAS"), "", ""),
            15: new StatusEntity("InterSystems Caché", "", ""),
            16: new StatusEntity("SAP HANA", "", "")
        };

        statusMap.PROTECT_START_STATE = {
            "true": new StatusEntity(appUtils.getString("recovery.term.protected.colum.isStart.values.zero"), "", ""),
            "false": new StatusEntity(appUtils.getString("recovery.term.protected.colum.isStart.values.one"), "", "")
        };

        statusMap.PROTECT_NEED_RECOVERY = {
            "true": new StatusEntity(appUtils.getString("common_term_yes_label"), "", ""),
            "false": new StatusEntity(appUtils.getString("common_term_no_label"), "", "")
        };

        statusMap.HISTORY_LOG_TYPE = {
            0: new StatusEntity(appUtils.getString("recovery.term.history.runType.faultRecovery"), "", ""),
            1: new StatusEntity(appUtils.getString("recovery.term.history.runType.planMove"), "", ""),
            2: new StatusEntity(appUtils.getString("recovery.term.history.runType.drillingTest"), "", ""),
            3: new StatusEntity(appUtils.getString("recovery.term.history.runType.clear"), "", ""),
            4: new StatusEntity(appUtils.getString("recovery.term.history.runType.lunRollback"), "", ""),
            7: new StatusEntity(appUtils.getString("recovery.term.history.runType.protect"), "", ""),
            8: new StatusEntity(appUtils.getString("recovery.term.history.runType.swap"), "", ""),
            9: new StatusEntity(appUtils.getString("protection_object_action_mount_label"), "", ""),
            10: new StatusEntity(appUtils.getString("protection_object_action_umount_label"), "", ""),
            11: new StatusEntity(appUtils.getString("ism.drm.drp.auth.planed.hotmigration"), "", "")
        };

        statusMap.HISTORY_LOG_STATUS = {
            0: new StatusEntity(appUtils.getString("recovery.term.history.runResult.success"), "", commonClass.success),
            1: new StatusEntity(appUtils.getString("recovery.term.history.runResult.failed"), "", commonClass.failed),
            2: new StatusEntity(appUtils.getString("recovery.term.history.runResult.someSuccess"), "", commonClass.anySuccess),
            3: new StatusEntity(appUtils.getString("recovery.term.history.runResult.running"), "", ""),
            4: new StatusEntity(appUtils.getString("recovery.term.history.runResult.paused"), "", commonClass.paused)
        };

        statusMap.LOCAL_TEST_REPLICAS_STATUS = {
            0: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.unactived"), "", ""),
            1: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.actived"), "", ""),
            3: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.error"), "", "")
        };

        statusMap.REPLICAS_TYPE = {
            0: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.localcopy"), "", ""),
            4: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.remotecopy"), "", "")
        };

        statusMap.POLICY_TEMPLET_STATUS = {
            0: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_synch_copy") + appUtils.getString("report_policy_templet_synch_copy_solution"), "", ""),
            1: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_asynch_copy") + appUtils.getString("report_policy_templet_asynch_copy_solution"), "", ""),
            2: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_snapshot_array") + appUtils.getString("report_policy_templet_snapshot_array_solution"), "", ""),
            3: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_cascading_repli_synch_asynch") + appUtils.getString("report_policy_templet_cascading_repli_synch_asynch_solution"), "", ""),
            4: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_cascading_repli_asynch_asynch") + appUtils.getString("report_policy_templet_cascading_repli_asynch_asynch_solution"), "", ""),
            5: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_parallel_repli_synch_asynch") + appUtils.getString("report_policy_templet_parallel_repli_synch_asynch_solution"), "", ""),
            6: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_parallel_repli_asynch_asynch") + appUtils.getString("report_policy_templet_parallel_repli_asynch_asynch_solution"), "", ""),
            7: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_dulive_array_asynch_remote_repli") + appUtils.getString("report_policy_templet_dulive_array_asynch_remote_repli_solution"), "", ""),
            8: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_dulive_array") + appUtils.getString("report_policy_templet_dulive_array_solution"), "", ""),
            9: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_hostsnapvis") + appUtils.getString("report_policy_templet_hostsnapvis_solution"), "", ""),
            10: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_vis_mirror") + appUtils.getString("report_policy_templet_vis_mirror_solution"), "", ""),
            11: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_host_repli") + appUtils.getString("report_policy_templet_host_repli_solution"), "", ""),
            12: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_asynch_remote_repli") + appUtils.getString("report_policy_templet_asynch_remote_repli_solution"), "", ""),
            13: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_mirror_array_asynch_remote_repli") + appUtils.getString("report_policy_templet_mirror_array_asynch_remote_repli_solution"), "", ""),
            14: new StatusEntity(appUtils.getStringWithColon("array.snapshot.name") + appUtils.getString("report_policy_templet_snapshot_array_solution"), "", ""),
            15: new StatusEntity(appUtils.getStringWithColon("array.activeactive.name") + appUtils.getString("report_policy_templet_dulive_array_solution"), "", ""),
            16: new StatusEntity(appUtils.getStringWithColon("array.clone.name") + appUtils.getString("report_policy_templet_clone_solution"), "", ""),
            17: new StatusEntity(appUtils.getStringWithColon("array.integratedBackup.name") + appUtils.getString("report_policy_templet_integratedBackup_solution"), "", ""),
            18: new StatusEntity(appUtils.getStringWithColon("array.activeactive.asyncRep.name") + appUtils.getString("report_policy_templet_dulive_array_asynch_remote_repli_solution"), "", ""),
            19: new StatusEntity(appUtils.getStringWithColon("array.activeactive.storageSnapshot.name") + appUtils.getString("report_policy_templet_dulive_array_asynch_remote_repli_solution"), "", ""),
            20: new StatusEntity(appUtils.getStringWithColon("array.activeactive.asyncRep.name") + appUtils.getString("report_policy_templet_dulive_array_asynch_remote_repli_solution"), "", ""),
            21: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_synch_copy") + appUtils.getString("report_policy_templet_synch_copy_solution"), "", ""),
            22: new StatusEntity(appUtils.getStringWithColon("report_policy_templet_asynch_remote_repli") + appUtils.getString("report_policy_templet_asynch_remote_repli_solution"), "", ""),
            28: new StatusEntity(appUtils.getStringWithColon("array.hyperMetroVault.name") + appUtils.getString("report_policy_templet_dulive_array_solution"), "", ""),
            25: new StatusEntity(appUtils.getStringWithColon("vis.active.name") + appUtils.getString("common_term_AAdataCenterSolution_label"), "", ""),
            26: new StatusEntity(appUtils.getStringWithColon("array.activeactive.async.ring.name") + appUtils.getString("common_term_3dcSolution_label"), "", ""),
            27: new StatusEntity(appUtils.getStringWithColon("array.activeactive.async.ring.name") + appUtils.getString("common_term_3dcSolution_label"), "", ""),
            29: new StatusEntity(appUtils.getStringWithColon("vis.active.name") + appUtils.getString("common_term_AAdataCenterSolution_label"), "", ""),
            30: new StatusEntity(appUtils.getStringWithColon("array.integratedBackup.name") + appUtils.getString("report_policy_templet_integratedBackup_solution"), "", ""),
            31: new StatusEntity(appUtils.getStringWithColon("array.hyperMetroVault.name") + appUtils.getString("report_policy_templet_dulive_array_solution"), "", ""),
            32: new StatusEntity(appUtils.getStringWithColon("array.hyperMetroVault.name") + appUtils.getString("report_policy_templet_dulive_array_solution"), "", ""),
            34: new StatusEntity(appUtils.getStringWithColon("array.activeactive.async.ring.name") + appUtils.getString("common_term_3dcSolution_label"), "", ""),
            35: new StatusEntity(appUtils.getStringWithColon("array.cascade4dc.asyncasync.name") + appUtils.getString("common_term_4dcSolution_label"), "", ""),
            36: new StatusEntity(appUtils.getStringWithColon("array.concurrent4dc.asyncasync.name") + appUtils.getString("common_term_4dcSolution_label"), "", ""),
            37: new StatusEntity(appUtils.getStringWithColon("array.activeactive.async.ring.name") + appUtils.getString("common_term_3dcSolution_label"), "", "")
        };
            //FusionSphere 磁盘状态
            statusMap.PROTECTEDDISK_STATUS = {
                "PROTECTED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_protected_label"), "", "icon-success"),
                "UNPROTECTED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_unprotected_label"), "", "icon-danger"),
                "REMOVED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_removed_label"), "", "information"),
                "RELEASING": new StatusEntity(appUtils.getString("protection_fsb_vol_status_releasing_label"), "", "information"),
                "CONFIGING" : new StatusEntity(appUtils.getString("protection_fsb_vol_status_configing_label"), "", "information"),
                "EXPANDED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_expanded_label"), "", "icon-danger")
            }
            //FusionSphere 小lun受保护虚拟机状态
            statusMap.PROTECTEDVM_STATUS = {
                0: new StatusEntity(appUtils.getString("protection_fsb_vm_status_valid_label"), "", "icon-registered"),
                98: new StatusEntity(appUtils.getString("protection_fsb_vm_status_invalid_label"), "", "icon-unregistered"),
                99: new StatusEntity(appUtils.getString("protection_fsb_vm_status_unsupported_label"), "", "icon-unregistered")
            }
            //FusionSphere 磁盘状态
            statusMap.PROTECTEDDISK_STATUS = {
                "PROTECTED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_protected_label"), "", "icon-success"),
                "UNPROTECTED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_unprotected_label"), "", "icon-danger"),
                "REMOVED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_removed_label"), "", "information"),
                "RELEASING": new StatusEntity(appUtils.getString("protection_fsb_vol_status_releasing_label"), "", "information"),
                "CONFIGING" : new StatusEntity(appUtils.getString("protection_fsb_vol_status_configing_label"), "", "information"),
                "EXPANDED": new StatusEntity(appUtils.getString("protection_fsb_vol_status_expanded_label"), "", "icon-danger")
            }
            //FusionSphere 小lun受保护虚拟机状态
            statusMap.PROTECTEDVM_STATUS = {
                0: new StatusEntity(appUtils.getString("protection_fsb_vm_status_valid_label"), "", "icon-registered"),
                98: new StatusEntity(appUtils.getString("protection_fsb_vm_status_invalid_label"), "", "icon-unregistered"),
                99: new StatusEntity(appUtils.getString("protection_fsb_vm_status_unsupported_label"), "", "icon-unregistered")
            }

        statusMap.PROTECTGROUP_STATUS = {
            0: new StatusEntity(appUtils.getString("common_term_disabled_status_label"), "", "icon-unregistered"),
            1: new StatusEntity(appUtils.getString("common_term_status_normal_label"), "", "icon-registered"),
            3: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.error"), "", "icon-unregistered"),
            4: new StatusEntity(appUtils.getString("common_term_lock_button"), "", "iconbutton-lock"),
            5: new StatusEntity(appUtils.getString("ism.drm.drp.execute.result.now.run"), "", "iconbutton-loading")
        };

        statusMap.PROTECTOBJECT_STATUS = {
            0: new StatusEntity(appUtils.getString("common_term_status_normal_label"), "", "icon-registered")
        };

        statusMap.PG_EXECRESULT = {
            1: new StatusEntity(appUtils.getString("common_term_succeed_label"), "", "icon-success")
        };

        statusMap.LUN_STATUS = {
            0: new StatusEntity(appUtils.getString("common_term_status_normal_label"), "", "icon-registered"),
            2: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status0"), "", "icon-unregistered"),
            "-1": new StatusEntity(appUtils.getString("home_term_RPOmet_unknown_tab"), "", "")
        };

        statusMap.REP_STATUS = {
            "-1": new StatusEntity(appUtils.getString("home_term_RPOmet_unknown_tab"), "", ""),
            0: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status0"), "", "icon-unregistered"),
            1: new StatusEntity(appUtils.getString("common_term_status_normal_label"), "", "icon-registered"),
            2: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status2"), "", ""),
            3: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status3"), "", ""),
            4: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status4"), "", ""),
            5: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status5"), "", ""),
            6: new StatusEntity(appUtils.getString("ism.drm.protect.group.rep.status6"), "", "")
        };

        statusMap.DUPLICA_STATUS = {
            0: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.unactived"), "", "icon-unreachable"),
            1: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.actived"), "", "icon-registered"),
            "unknow": new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.error"), "", "icon-unregistered")
        };

        statusMap.PG_HISTORY_RESULT = {
            "unknow": new StatusEntity("--", "", ""),
            0: new StatusEntity(appUtils.getString("common_term_failed_label"), "", "icon-failed"),
            1: new StatusEntity(appUtils.getString("common_term_succeed_label"), "", "icon-success"),
        };

        statusMap.RVG_RESOURCE_MAPPING_STATUS = {
            0: new StatusEntity(appUtils.getString("ism.drm.protect.group.replica.status.unactived"), "", "icon-unreachable"),
            1: new StatusEntity(appUtils.getString("common_term_vrg_normal_lable"), "", "icon-registered"),
            2: new StatusEntity(appUtils.getString("common_term_vrg_pairing_lable"), "", "icon-unreachable"),
            3: new StatusEntity(appUtils.getString("common_term_vrg_pair_field_lable"), "", "icon-unreachable"),
            4: new StatusEntity(appUtils.getString("common_term_vrg_no_pair_lable"), "", "icon-unreachable"),
            5: new StatusEntity(appUtils.getString("common_term_vrg_pair_stop_lable"), "", "icon-unreachable"),
            6: new StatusEntity(appUtils.getString("common_term_unknow_label"), "", "icon-registerWarn")
        };

        statusMap.HOST_GROUP_REFRESH = {
            "": new StatusEntity(appUtils.getString("recovery.term.history.runResult.success"), "", commonClass.success),
            "fail": new StatusEntity(appUtils.getString("recovery.term.history.runResult.failed"), "", commonClass.failed)
        };

        statusMap.DATABASE_TYPE = {
            "-1": new StatusEntity(appUtils.getString("common_term_unknow_label"), "", ""),
            "0": new StatusEntity(appUtils.getString("common_term_isNot_pdb_label"), "", ""),
            "1": new StatusEntity(appUtils.getString("common_term_is_pdb_label"), "", "")
        };

        statusMap.IS_ENABLE_ANONYMOUS = {
            "true": new StatusEntity(appUtils.getString("common_term_enable_label"), "", ""),
            "false": new StatusEntity(appUtils.getString("common_term_disable_label"), "", "")
        };

        statusMap.LOG_EXECUTE_STATUS = {
            "0": new StatusEntity(appUtils.getString("recovery.term.history.runResult.success"), "", ""),
            "1": new StatusEntity(appUtils.getString("recovery.term.history.runResult.failed"), "", ""),
            "2": new StatusEntity(appUtils.getString("recovery.term.history.runResult.someSuccess"), "", ""),
            "3": new StatusEntity(appUtils.getString("recovery.term.history.runResult.running"), "", "")
        };

        statusMap.LOG_RECOVERY_STATUS = {
            "0": new StatusEntity(appUtils.getString("recovery.term.history.runType.faultRecovery"), "", ""),
            "1": new StatusEntity(appUtils.getString("recovery.term.history.runType.planMove"), "", ""),
            "2": new StatusEntity(appUtils.getString("recovery.term.history.runType.drillingTest"), "", ""),
            "3": new StatusEntity(appUtils.getString("recovery.term.history.runType.clear"), "", ""),
            "4": new StatusEntity(appUtils.getString("recovery.term.history.runType.lunRollback"), "", ""),
            "7": new StatusEntity(appUtils.getString("recovery.term.history.runType.protect"), "", ""),
            "8": new StatusEntity(appUtils.getString("recovery.term.history.runType.swap"), "", "")
        };

        statusMap.PG_MOUNT_STATUS = {
            "0": new StatusEntity(appUtils.getString("protection_object_mount_status_mounting_label"), "", ""),
            "1": new StatusEntity(appUtils.getString("protection_object_mount_status_mount_label"), "", ""),
            "2": new StatusEntity(appUtils.getString("protection_object_mount_status_mountFail_label"), "", ""),
            "3": new StatusEntity(appUtils.getString("protection_object_mount_status_unmounting_label"), "", ""),
            "4": new StatusEntity(appUtils.getString("protection_object_mount_status_unmount_label"), "", ""),
            "5": new StatusEntity(appUtils.getString("protection_object_mount_status_unmountFail_label"), "", "")
        };

        statusMap.IS_CLOUD_SITE = {
            "true": new StatusEntity(appUtils.getString("site_type_cloud_label"), "", ""),
            "false": new StatusEntity(appUtils.getString("site_type_physical_label"), "", ""),
        };

        statusMap.RESPO_BILLING_MODE = {
            "pre_paid": new StatusEntity(appUtils.getString("site_backuprespo_prepaid_label"), "", ""),
            "post_paid": new StatusEntity(appUtils.getString("site_backuprespo_postpaid_label"), "", ""),
        };

        statusMap.RESPO_TYPE = {
            "Server": new StatusEntity(appUtils.getString("site_backuprespo_resourcetype_server_label"), "", ""),
        };

        statusMap.RESPO_STATUS = {
            "available": new StatusEntity(appUtils.getString("site_backuprespo_status_available_label"), "", ""),
            "lock": new StatusEntity(appUtils.getString("site_backuprespo_status_lock_label"), "", ""),
            "frozen": new StatusEntity(appUtils.getString("site_backuprespo_status_frozen_label"), "", ""),
            "deleting": new StatusEntity(appUtils.getString("site_backuprespo_status_deleting_label"), "", ""),
            "error": new StatusEntity(appUtils.getString("site_backuprespo_status_error_label"), "", "")
        };

        statusMap.CLOUD_SERVER_TYPE = {
            "ecs": new StatusEntity(appUtils.getString("site_cloudserver_ecs_label"), "", ""),
            "metal": new StatusEntity(appUtils.getString("site_cloudserver_metal_label"), "", ""),
        };

        statusMap.CLOUD_SERVER_STATUS = {
            "ACTIVE": new StatusEntity(appUtils.getString("site_cloudserver_statusofactive_label"), "", ""),
            "BUILD": new StatusEntity(appUtils.getString("site_cloudserver_statusofbuild_label"), "", ""),
            "DELETED": new StatusEntity(appUtils.getString("site_cloudserver_statusofdeleted_label"), "", ""),
            "ERROR": new StatusEntity(appUtils.getString("site_cloudserver_statusoferror_label"), "", ""),
            "HARD_REBOOT":new StatusEntity(appUtils.getString("site_cloudserver_statusofhardreboot_label"), "", ""),
            "MIGRATING": new StatusEntity(appUtils.getString("site_cloudserver_statusofmigrating_label"), "", ""),
            "REBOOT": new StatusEntity(appUtils.getString("site_cloudserver_statusofreboot_label"), "", ""),
            "RESIZE": new StatusEntity(appUtils.getString("site_cloudserver_statusofresize_label"), "", ""),
            "REVERT_RESIZE": new StatusEntity(appUtils.getString("site_cloudserver_statusofrevertresize_label"), "", ""),
            "SHELVED": new StatusEntity(appUtils.getString("site_cloudserver_statusofshelved_label"), "", ""),
            "SHELVED_OFFLOADED": new StatusEntity(appUtils.getString("site_cloudserver_statusofshelvedoffloaded_label"), "", ""),
            "SHUTOFF": new StatusEntity(appUtils.getString("site_cloudserver_statusofshutoff_label"), "", ""),
            "UNKNOWN": new StatusEntity(appUtils.getString("site_cloudserver_statusofunknown_label"), "", ""),
            "VERIFY_RESIZE": new StatusEntity(appUtils.getString("site_cloudserver_statusofverifyresize_label"), "", ""),
        };

        statusMap.STORAGE_POOL_TYPE = {
            7: new StatusEntity(appUtils.getString("site_backuppool_s3_label"), "", ""),
            100: new StatusEntity(appUtils.getString("site_backuppool_huaweirespo_label"), "", ""),
        };

        statusMap.STORAGE_POOL_ACCESTATUS = {
            0: new StatusEntity(appUtils.getString("site_backuppool_accestatus0_label"), "", ""),
            1: new StatusEntity(appUtils.getString("site_backuppool_accestatus1_label"), "", ""),
            2: new StatusEntity(appUtils.getString("site_backuppool_accestatus2_label"), "", ""),
            3: new StatusEntity(appUtils.getString("site_backuppool_accestatus3_label"), "", ""),
        };

        statusMap.STORAGE_POOL_OFFLINESTATUS = {
            0: new StatusEntity(appUtils.getString("site_backuppool_offlinestatus0_label"), "", ""),
            1: new StatusEntity(appUtils.getString("site_backuppool_offlinestatus1_label"), "", ""),
            2: new StatusEntity(appUtils.getString("site_backuppool_offlinestatus2_label"), "", ""),
            3: new StatusEntity(appUtils.getString("site_backuppool_offlinestatus3_label"), "", ""),
        };

        statusMap.STORAGE_POOL_PROTOCOL_TYPE = {
            0: new StatusEntity(appUtils.getString("site_backuppool_protocoltype0_label"), "", ""),
            1: new StatusEntity(appUtils.getString("site_backuppool_protocoltype1_label"), "", "")
        };

        statusMap.STORAGE_RESPO_FULLQUOTA = {
            "false": new StatusEntity(appUtils.getString("site_backuprespo_fullquota0_label"), "", ""),
            "true": new StatusEntity(appUtils.getString("site_backuprespo_fullquota1_label"), "", ""),
        };

        statusMap.CLOUD_BRAND_ENUM = {
            "HuaweiCloud": new StatusEntity(appUtils.getString("site_brand_huawei_label"), "", "")
        };

        statusMap.REPLICA_TYPE = {
            3: new StatusEntity(appUtils.getString("pg_copybackuptype_snapshot_label"), "", ""),
            4: new StatusEntity(appUtils.getString("pg_copybackuptype_hypercdp_label"), "", ""),
            9: new StatusEntity(appUtils.getString("pg_copybackuptype_cloneduplica_label"), "", ""),
            101: new StatusEntity(appUtils.getString("pg_copybackuptype_cloudbackup_label"), "", ""),
        };

        statusMap.AVAILABILITY_ZONE_NAME = {
            "cn-north-1a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "cn-north-1b": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "2", "", ""),
            "cn-north-1c": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "3", "", ""),
            "cn-east-2a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "cn-east-2b": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "2", "", ""),
            "cn-east-2c": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "3", "", ""),
            "cn-east-2d": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "4", "", ""),
            "cn-south-1a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "cn-south-2b": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "2", "", ""),
            "cn-south-1c": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "3", "", ""),
            "ap-southeast-1a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "ap-southeast-1b": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "2", "", ""),
            "cn-northeast-1a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "ap-southeast-2a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "ap-southeast-2b": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "2", "", ""),
            "eu-west-0a": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "1", "", ""),
            "eu-west-0b": new StatusEntity(appUtils.getString("site_cloudserver_availabilityzone_label") + "2", "", ""),
        };

        statusMap.IS_PRESET_AREA = {
            "false": new StatusEntity(appUtils.getString("common_term_no_label"), "", ""),
            "true": new StatusEntity(appUtils.getString("common_term_yes_label"), "", ""),
        }

        statusMap.SERVICE_TYPE = {
            "compute": new StatusEntity("ECS", "", ""),
            "cce": new StatusEntity(appUtils.getString("dr_site_cce_deployment_label"), "", ""),
            "rds": new StatusEntity("RDS", "", ""),
            "dcs": new StatusEntity("DCS", "", ""),
            "csha": new StatusEntity("CSHA", "", ""),
        }

        statusMap.DR_TYPE = {
            "inter-az": new StatusEntity(appUtils.getString("dr_site_inter_az_label"))
        }

        /**
         * 获取具体的值
         * @param  {[type]} type       [description]
         * @param  {[type]} statusEnum [description]
         * @return {[type]}            [description]
         */
        this.getValueByKey = function(type, statusEnum) {
            if (angular.isUndefined($.trim(statusEnum)) || _.isEmpty($.trim(statusEnum)) || "--" == $.trim(statusEnum)) {
                return "--";
            }
            return statusMap[type][statusEnum].name;
        };

        /**
         * 获取指定type的JSON数组
         * @param  {[type]} type [description]
         * @return [{key: key1, value: value1},{key: key2, value: value2}, {...}]
         */
        this.getJsonArray = function(type) {
            if (_.isEmpty(type)) {
                return [];
            }

            var array = [];
            var json = statusMap[$.trim(type)];
            _.each(json, function(v, k) {
                var obj = {};
                obj[k] = v.name;
                array.push(obj);
            });
            return array;
        };

        /**
         * 根据枚举值获取国际化之后的内容
         * @param type 匹配枚举的前缀key 如statusMap.PG_HISTORY_RESULT
         * @param statusEnum 模型中的key 如果statusMap.PG_HISTORY_RESULT->0
         * @param name 模型中key对应的值
         * @returns {*}
         */
        this.getStatus = function(type, statusEnum, name) {
            type = $.trim(type);
            statusEnum = $.trim(statusEnum);
            if (_.isEmpty(statusEnum)) {
                statusEnum = (statusMap[type].unknow || commonStatus.unknow).getColorSpan();
            }

            if (!statusMap[type]) {
                return commonStatus.unknow.getColorSpan();
            }
            if (!statusMap[type][statusEnum]) {
                return (statusMap[type].unknow || commonStatus.unknow).getColorSpan();
            }
            return statusMap[type][statusEnum].getColorSpan(name);
        };

        this.setRenderRowStatus = function(renderRow, render) {
            var nRow = renderRow[0],
                aData = renderRow[1],
                iDataIndex = renderRow[2];

            var self = this;
            angular.forEach(render, function(v, k) {
                if (v[0] == "I18N") {
                    $('td:eq(' + k + ")", nRow).html(v[1]);
                } else {
                    $('td:eq(' + k + ")", nRow).html(self.getStatus(v[0], aData[v[1]], v[2]));
                }
            });
        };

    };

    service.$injector = ["constsService", "i18nService", "appUtils"];
    return service;
});
