define([],
    function() {
        "use strict";
        var service = function(constsService, communicationService, utilService, exception, mask, infoTransferredService, statusEnumService, appUtils, cookieService) {
            this.map = [];
            this.val = {};
            this._key = "";
            this.childrenIdMap = [];
            this.treeTableBuf = "";
            this.getStatus = function(s) {
                var statusMap = {
                    statusFont: "",
                    cls: ""
                };
                if (utilService.isNotEmpty(s)) {
                    s = s.toString();
                }
                switch (s) {
                    case "0":
                        statusMap.statusFont = appUtils.getString("recovery.term.history.runResult.success");
                        statusMap.cls = "icon-success icon";
                        break;
                    case "1":
                        statusMap.statusFont = appUtils.getString("recovery.term.history.runResult.failed");
                        statusMap.cls = "icon-failed icon";
                        break;
                    case "2":
                        statusMap.statusFont = appUtils.getString("recovery.term.history.runResult.someSuccess");
                        statusMap.cls = "icon-danger icon";
                        break;
                    case "3":
                        statusMap.statusFont = appUtils.getString("recovery.term.history.runResult.running");
                        statusMap.cls = "iconbutton-loading icon";
                        break;
                    case "4":
                        statusMap.statusFont = appUtils.getString("recovery.term.history.runResult.paused");
                        statusMap.cls = "iconbutton-pause icon";
                        break;
                    default:
                        statusMap.statusFont = "--";
                        statusMap.cls = "";
                }
                return statusMap;
            };

            /**
             * 保存子节点信息到缓存中
             * @param  {[type]} result 所有的表格数据
             * @return {[type]}        [description]
             */
            this.saveChildrenId = function(result) {

                for (var i = 0; i < result.length; i++) {
                    if (!_.isUndefined(result[i].children) && result[i].children != 0) {
                        this.childrenIdMap.push({id: result[i].detailId, childrenObj: result[i].children});

                        var result1 = result[i].children;
                        for (var j = 0; j < result1.length; j++) {
                            if (!_.isUndefined(result1[j].children) && result1[j].children.length != 0) {
                                this.childrenIdMap.push({id: result1[j].detailId, childrenObj: result1[j].children });

                                var result2 = result1[j].children;
                                for (var k = 0; k < result2.length; k++) {
                                    if (!_.isUndefined(result2[k].children) && result2[k].children.length != 0) {
                                        this.childrenIdMap.push({
                                            id: result2[k].detailId,
                                            childrenObj: result2[k].children
                                        });

                                        var result3 = result2[k].children;
                                        for (var l = 0; l < result3.length; l++) {
                                            if (!_.isUndefined(result3[l].children) && result3[l].children.length != 0) {
                                                this.childrenIdMap.push({
                                                    id: result3[l].detailId,
                                                    childrenObj: result3[l].children
                                                });
                                                var result4 = result3[l].children;
                                                for (var m = 0; m < result4.length; m++) {
                                                    if (!_.isUndefined(result4[m].children) && result4[m].children.length != 0) {
                                                        this.childrenIdMap.push({
                                                            id: result4[m].detailId,
                                                            childrenObj: result4[m].children
                                                        })
                                                    }
                                                };
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return this.childrenIdMap;
            };

            this.showDetails = function(paramId, callback) {
                var that = this;
                $("#recoveryDetailTreeDiv #treeTable").on("click", " .folder", function() {
                    mask.show();
                    var parent = $(this).parent().parent();
                    var parentId = parent.attr("id").replace("suffex", "");
                    var children = _.filter(paramId, function(obj) {
                        return parentId == obj.id
                    });
                    var thisLeft = parseInt($(this).css("padding-left").split("px")[0], 10);
                    var childrenSpanLeft = thisLeft + 25 + "px";
                    var childrenPosition = thisLeft + 5 + "px center";
                    var childrenObj = children[0].childrenObj
                    parent.toggleClass("collapsed");
                    var html = "";
                    if (!parent.hasClass("collapsed")) {
                        for (var j = 0; j < childrenObj.length; j++) {
                            var parentIdSet = " data-tt-parent-id='" + childrenObj[j].parentDetailId + "'";
                            var classStyle = "branch";
                            var spanClass = "";
                            var spanStyle = "padding-left:" + childrenSpanLeft;
                            spanStyle += "; background-position:" + childrenPosition;
                            if (!utilService.isEmpty(childrenObj[j].children)) {
                                spanClass = "folder";
                                classStyle += " collapsed"
                            }

                            if (j % 2) {
                                classStyle += " even'";
                            } else {
                                classStyle += " old'";
                            }
                            var detailId = childrenObj[j].detailId;
                            var processName = "--";
                            if (null == childrenObj[j].processName) {
                                processName = "null";
                            } else {
                                if ("" != childrenObj[j].processName) {
                                    processName = $.encoder.encodeForHTML(childrenObj[j].processName);
                                }
                                var escapedParam = [];
                                if (utilService.isNotEmpty(childrenObj[j].processNameParams)) {
                                    var nameParams = childrenObj[j].processNameParams;
                                    if (nameParams) {
                                        for (var i = 0; i < nameParams.length; i++) {
                                            escapedParam.push($.encoder.encodeForHTML(nameParams[i]));
                                        }
                                    }
                                    processName = appUtils.getString($.encoder.encodeForHTML(childrenObj[j].processName), escapedParam);
                                } else {
                                    processName = appUtils.getString($.encoder.encodeForHTML(childrenObj[j].processName));
                                }
                            }
                            var processStatus = "--",
                                c = "",
                                iconLabel = "";
                            if (utilService.isNotEmpty(childrenObj[j].processStatus)) {
                                processStatus = that.getStatus(childrenObj[j].processStatus).statusFont;
                                c = that.getStatus(childrenObj[j].processStatus).cls;
                                iconLabel = "icon-label";
                            }
                            var startTime = "--";
                            if (utilService.isNotEmpty(childrenObj[j].startTime)) {
                                startTime = $.encoder.encodeForHTML(childrenObj[j].startTime);
                            }
                            var endTime = "--";
                            if (utilService.isNotEmpty(childrenObj[j].endTime)) {
                                endTime = $.encoder.encodeForHTML(childrenObj[j].endTime);
                            }
                            var executeTime = "--";
                            if (utilService.isNotEmpty(childrenObj[j].executeTime)) {
                                executeTime = $.encoder.encodeForHTML(childrenObj[j].executeTime);
                            }
                            var processDetail = "--";
                            if (utilService.isNotEmpty(childrenObj[j].processDetail)) {
                                var escapedDetailParam = [];
                                if (utilService.isNotEmpty(childrenObj[j].processDetailParams)) {
                                    var detailParams = childrenObj[j].processDetailParams;
                                    for (var i = 0; i < detailParams.length; i++) {
                                        if (_.isString(detailParams[i])) {
                                            escapedDetailParam.push($.encoder.encodeForHTML(detailParams[i]));
                                        } else {
                                            that.map = [];
                                            that.val = {};
                                            that._key = "";
                                            var detail = "";
                                            var params = that.toArray(that.parseParamToArray(detailParams[i]));
                                            _.each(params, function(v) {
                                                detail += $.encoder.encodeForHTML(v);
                                            });
                                            escapedDetailParam.push(detail);
                                        }
                                    };
                                    processDetail = appUtils.getString($.encoder.encodeForHTML(childrenObj[j].processDetail), escapedDetailParam);
                                } else {
                                    processDetail = appUtils.getString($.encoder.encodeForHTML(childrenObj[j].processDetail));
                                }
                            }
                            processName = processName.replace(/\'/g, "&#39;").replace(/\"/g, "&quot;");
                            processDetail = processDetail.replace(/\'/g, "&#39;").replace(/\"/g, "&quot;");
                            if (callback && _.isFunction(callback)) {
                                var params = {
                                    processName,
                                    classStyle,
                                    processStatus,
                                    detailId,
                                    parentIdSet,
                                    iconLabel,
                                    startTime,
                                    endTime,
                                    executeTime,
                                    processDetail,
                                    c,
                                    spanClass,
                                    logStatus: childrenObj[j].processStatus
                                }
                                html += callback(params);
                            } else {
                                html += "<tr class='x-grid3-row treeTr " + classStyle + " id='suffex" + detailId + "'" + " value='" + processStatus + "' data-tt-id='" + detailId + "'" + parentIdSet + ">";
                                html += "<td class='x-grid3-table-cell' width='20%' style='text-align:left;' title='" + processName + "'><span class='" + spanClass + "' style='" + spanStyle + "'>" + processName + "</span></td>";
                                html += "<td class='x-grid3-table-cell td-left-align' width='14%' class='refHandle' title='" + processStatus + "'><div><label class='" + c + "'></label><label class='" + iconLabel + "'>" + processStatus + "</label><div></td>";
                                html += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + startTime + "'><label class='maxTime'>" + startTime + "</label></td>";
                                html += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + endTime + "'><label class='maxTime'>" + endTime + "</label></td>";
                                html += "<td class='x-grid3-table-cell td-left-align' width='10%' title='" + executeTime + "'><label class='maxTime'>" + executeTime + "</label></td>";
                                html += "<td class='x-grid3-table-cell td-left-align' width='18%' title='" + processDetail + "'><label class='maxDescContext'>" + processDetail + "</label></td></tr>";
                            }
                        }
                        parent.after(html);
                        mask.hide();

                    } else {
                        var children1 = parent.nextAll().filter(function() {
                            return $(this).attr("data-tt-parent-id") == parentId;
                        });
                        $.each(children1, function(index1, obj1) {
                            var children1Id = $(obj1).attr("id").replace("suffex", "");
                            var children2 = $(obj1).nextAll();
                            children2 = children2.filter(function() {
                                return $(this).attr("data-tt-parent-id") == children1Id;
                            });
                            if (children2.length != 0) {
                                $.each(children2, function(index2, obj2) {
                                    var children2Id = $(obj2).attr("id").replace("suffex", "");
                                    var children3 = $(obj2).nextAll();
                                    children3 = children3.filter(function() {
                                        return $(this).attr("data-tt-parent-id") == children2Id;
                                    });
                                    if (children3.len != 0) {
                                        $.each(children3, function(index3, obj3) {
                                            var children3Id = $(obj3).attr("id").replace("suffex", "");
                                            var children4 = $(obj3).nextAll();
                                            children4 = children4.filter(function() {
                                                return $(this).attr("data-tt-parent-id") == children3Id;
                                            });
                                            if (children4.length != 0) {
                                                children4.remove();
                                            }
                                        })
                                        children3.remove();
                                    }
                                })
                                children2.remove();
                            }
                        })
                        children1.remove();
                        mask.hide();
                    }
                })
            }


            this.initTreeTabelHead = function(treeHead) {
                this.treeTableBuf = "<table class='x-grid3-table tbodytable' id='treeTable' style='margin-top:0px;margin-bottom:0px'><thead><tr class='x-grid3-hd-row'>" + "<th class='cell-spliter' dragabled='true' width='20%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 11px;' class='ellipsis'>" + appUtils.getString("common_term_name_label") + "</div></th>" + "<th class='cell-spliter' dragabled='true' width='14%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_status_label") + "</div></th>" + "<th class='cell-spliter' dragabled='true' width='19%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_begintime_label") + "</div></th>" + "<th class='cell-spliter' dragabled='true' width='19%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_endtime_label") + "</div></th>" + "<th class='cell-spliter' dragabled='true' width='10%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("task_term_executeTime_label") + "</div></th>" + "<th class='cell-spliter' dragabled='true' width='18%'><span onmousedown='' style='cursor:col-resize;width:4;'></span>" + "<div style='*width:99%;*padding-bottom:0; margin-right: 8px;margin-left: 3px;' class='ellipsis'>" + appUtils.getString("common_term_description_column") + "</div></th></tr></thead>";
                if (treeHead) {
                    this.treeTableBuf = treeHead;
                } 
                return this.treeTableBuf;
            };

            this.getTreeAllNodes = function(data) {
                var steps = [];
                if (!data || data.length == 0) {
                    return [];
                }

                for (var i = 0; i < data.length; i++) {
                    steps = steps.concat(data[i]);
                    if (!_.isEmpty(data[i].children)) {
                        steps = steps.concat(this.getTreeAllNodes(data[i].children));
                    }
                }
                return steps;
            }

            this.initTreeTabContent = function(result,flag, callback) {
                if (!result) {
                    return;
                }
                for (var i = 0; i < result.length; i++) {
                    this.initLogDetail(result[i], i, flag, callback);
                    !flag && (this.initTreeTabContent(result[i].children, flag, callback));
                }
            };

            this.bindListenEvent = function() {
                this.initDisplayData();
            };

            this.initEmptyTr = function() {
                this.treeTableBuf += "<tr class='x-grid3-row'><td class='x-grid3-table-cell' colspan='6' width='100%'>" + window.tinyLanguage.language.emptyTable + "</td></tr>";
            }

            this.initTableFinalTag = function(domId) {
                var html = this.treeTableBuf + "</table>";
                if (!_.isUndefined(domId)) {
                    $("#" + domId).html(html);
                    return;
                }

                if($("#excuteDetailDiv #recoveryDetailTreeDiv").length != 0){
                    $("#excuteDetailDiv #recoveryDetailTreeDiv").html(html);
                    return;
                }
                $("#recoveryDetailTreeDiv").html(html);
            };

            this.parseParamToArray = function(obj) {
                for (var field in obj) {
                    var temp = obj[field];
                    if (angular.isObject(temp) && !angular.isArray(temp)) {
                        var key = field.replace(/.(2[5][0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})/g, "");
                        if (key == field) {
                            //随机生产1-10的ip
                            var randomIP = "." + Math.floor(Math.random() * 10 + 1) + "." + Math.floor(Math.random() * 10 + 1) + "." + Math.floor(Math.random() * 10 + 1) + "." + Math.floor(Math.random() * 10 + 1);
                            field += randomIP;
                        }
                        this.map.push(field);
                        this.parseParamToArray(temp);
                    }
                    if (angular.isString(temp) && temp === field) {
                        this.map.push(field);
                    }

                    if (angular.isArray(temp)) {
                        this.map.push(appUtils.getString(field, temp));
                    }
                }
                return this.map;
            }

            this.endWith = function(str, endStr) {
                var d = str.length - endStr.length;
                return (d >= 0 && str.lastIndexOf(endStr) == d)
            };

            this.toArray = function(params) {
                var values = [];
                for (var i in params) {
                    var t = params[i].toString();

                    var ipAddress = t.match(/(2[5][0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})/g);
                    var key = "";
                    if (null != ipAddress && this.endWith(t, ipAddress[0])) {
                        key = t.replace(/.(2[5][0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})\.(25[0-5]|2[0-4]\d|1\d{2}|\d{1,2})/g, "");
                    } else {
                        key = t;
                    }
                    if ((key != t && "" != key) || (i == 0 && null == ipAddress)) {
                        var ip = t.slice(key.length + 1)

                        this._key = ip;
                        this.val[this._key] = {
                            key: key,
                            values: []
                        };
                        continue;
                    }

                    if (this._key == "") {
                        this.val[key] = key;
                        continue;
                    }
                    this.val[this._key]["values"].push(t);
                }

                for (var f in this.val) {
                    var obj = this.val[f];
                    if (f == obj) {
                        values.push(obj);
                        continue;
                    }
                    values.push(appUtils.getString(obj.key, obj.values));
                }
                return values;
            }

            this.initLogDetail = function(rpdetail, i, flag, callback) {
                if (!rpdetail) {
                    return;
                }
                var parentIdSet = " data-tt-parent-id='" + rpdetail.parentDetailId + "'";
                var classStyle = " leaf";
                var spanClass = "";
                if (utilService.isEmpty(rpdetail.parentDetailId)) {
                    parentIdSet = " ";
                    classStyle = " branch";
                }
                if (!utilService.isEmpty(rpdetail.children)){
                    spanClass = "folder";
                    flag && (classStyle += " collapsed")
                }

                if (i % 2) {
                    classStyle += " even'";
                } else {
                    classStyle += " old'";
                }
                var detailId = rpdetail.detailId;
                var processName = "--";
                if (null == rpdetail.processName) {
                    processName = "null";
                } else {
                    if ("" != rpdetail.processName) {
                        //如果是对象，当前必然是MySql的解决方案步骤
                        if (_.isObject(rpdetail.processName)) {
                            var i18nKey = rpdetail.processName["i18nKey"];
                            if (!_.isEmpty(i18nKey)) {
                                rpdetail.processName = appUtils.getString(i18nKey);
                            } else {
                                rpdetail.processName = rpdetail.processName["i18n"][cookieService.get("language")];
                            }
                        }
                        processName = $.encoder.encodeForHTML(rpdetail.processName);
                    }
                    var escapedParam = [];
                    if (utilService.isNotEmpty(rpdetail.processNameParams)) {
                        var nameParams = rpdetail.processNameParams;
                        if (nameParams) {
                            for (var i = 0; i < nameParams.length; i++) {
                                escapedParam.push($.encoder.encodeForHTML(nameParams[i]));
                            }
                        }
                        processName = appUtils.getString($.encoder.encodeForHTML(rpdetail.processName), escapedParam);
                    } else {
                        processName = appUtils.getString($.encoder.encodeForHTML(rpdetail.processName));
                    }
                }
                var processStatus = "--",
                    c = "",
                    iconLabel = "";
                if (utilService.isNotEmpty(rpdetail.processStatus)) {
                    processStatus = this.getStatus(rpdetail.processStatus).statusFont;
                    c = this.getStatus(rpdetail.processStatus).cls;
                    iconLabel = "icon-label";
                }
                var startTime = "--";
                if (utilService.isNotEmpty(rpdetail.startTime)) {
                    startTime = $.encoder.encodeForHTML(rpdetail.startTime);
                }
                var endTime = "--";
                if (utilService.isNotEmpty(rpdetail.endTime)) {
                    endTime = $.encoder.encodeForHTML(rpdetail.endTime);
                }
                var executeTime = "--";
                if (utilService.isNotEmpty(rpdetail.executeTime)) {
                    executeTime = $.encoder.encodeForHTML(rpdetail.executeTime);
                }
                var processDetail = "--";
                if (utilService.isNotEmpty(rpdetail.processDetail)) {
                    var escapedDetailParam = [];
                    if (utilService.isNotEmpty(rpdetail.processDetailParams)) {
                        var detailParams = rpdetail.processDetailParams;
                        for (var i = 0; i < detailParams.length; i++) {
                            if (_.isString(detailParams[i])) {
                                escapedDetailParam.push($.encoder.encodeForHTML(detailParams[i]));
                            } else {
                                this.map = [];
                                this.val = {};
                                this._key = "";
                                var detail = "";
                                var params = this.toArray(this.parseParamToArray(detailParams[i]));
                                _.each(params, function(v) {
                                    detail += $.encoder.encodeForHTML(v);
                                });
                                escapedDetailParam.push(detail);
                            }
                        };
                        processDetail = appUtils.getString($.encoder.encodeForHTML(rpdetail.processDetail), escapedDetailParam);
                    } else {
                        processDetail = appUtils.getString($.encoder.encodeForHTML(rpdetail.processDetail));
                    }
                }
                processName = processName.replace(/\'/g, "&#39;").replace(/\"/g, "&quot;");
                processDetail = processDetail.replace(/\'/g, "&#39;").replace(/\"/g, "&quot;");
                if (callback && _.isFunction(callback)) {
                    var params = {
                        processName,
                        classStyle,
                        processStatus,
                        detailId,
                        parentIdSet,
                        iconLabel,
                        startTime,
                        endTime,
                        executeTime,
                        processDetail,
                        c,
                        spanClass,
                        logStatus: rpdetail.processStatus
                    }
                    this.treeTableBuf += callback(params)
                } else {
                    this.treeTableBuf += "<tr class='x-grid3-row treeTr " + classStyle + " id='suffex" + detailId + "'" + " value='" + processStatus + "' data-tt-id='" + detailId + "'" + parentIdSet + ">";
                    this.treeTableBuf += "<td class='x-grid3-table-cell' width='20%' style='text-align:left;' title='" + processName + "'><span class='"+ spanClass +"'>" + processName + "</span></td>";
                    this.treeTableBuf += "<td class='x-grid3-table-cell td-left-align' width='14%' class='refHandle' title='" + processStatus + "'><div><label class='" + c + "'></label><label class='" + iconLabel + "'>" + processStatus + "</label><div></td>";
                    this.treeTableBuf += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + startTime + "'><label class='maxTime'>" + startTime + "</label></td>";
                    this.treeTableBuf += "<td class='x-grid3-table-cell td-left-align' width='19%' title='" + endTime + "'><label class='maxTime'>" + endTime + "</label></td>";
                    this.treeTableBuf += "<td class='x-grid3-table-cell td-left-align' width='10%' title='" + executeTime + "'><label class='maxTime'>" + executeTime + "</label></td>";
                    this.treeTableBuf += "<td class='x-grid3-table-cell td-left-align' width='18%' title='" + processDetail + "'><label class='maxDescContext'>" + processDetail + "</label></td></tr>";
                }
                return this.treeTableBuf;
            };

            this.initDisplayData = function() {
                this.refInitDisplayData();
                $("#recoveryProcessTreeDiv #treeTable .folder").on("click", function() {
                    var parent = $(this).parent().parent();
                    var nexts = parent.nextAll();
                    var filteredNext = nexts.filter(function() {
                        return $(this).attr("data-tt-parent-id") == parent.attr("id").replace("suffex", "");
                    });
                    parent.toggleClass("collapsed");
                    if (parent.hasClass("collapsed")) {
                        filteredNext.hide();
                        filteredNext.each(function() {
                            var childrenParentId = $(this).attr("id").replace("suffex", "")
                            if ($(this).find("td span:last-child").hasClass("folder")) {
                                $(this).addClass("collapsed");
                                $.each($(this).nextAll(), function(index, obj) {
                                    var nextParentId = $(obj).attr("data-tt-parent-id");
                                    if (childrenParentId == nextParentId) {
                                        $(obj).hide();
                                        if ($(this).find("td span:last-child").hasClass("folder")) {
                                            $(this).addClass("collapsed")
                                            var newxChildDataId = $(obj).attr("data-tt-id")
                                            $.each($(obj).nextAll(), function(index, child) {
                                                if (newxChildDataId == $(child).attr("data-tt-parent-id")) {
                                                    $(child).hide();
                                                    if ($(this).find("td span:last-child").hasClass("folder")) {
                                                        $(this).addClass("collapsed")
                                                        var c_id = $(child).attr("data-tt-id");
                                                        $.each($(child).nextAll(), function(index, o) {
                                                            if (c_id == $(o).attr("data-tt-parent-id")) {
                                                                $(o).hide();
                                                            }
                                                        });
                                                    };
                                                }
                                            });
                                        };
                                    }
                                });
                            }
                        })

                    } else {
                        filteredNext.show();
                        filteredNext.each(function() {
                            var childrenParentId = $(this).attr("id").replace("suffex", "")
                            if ($(this).find("td span:last-child").hasClass("folder")) {
                                $(this).removeClass("collapsed");
                                $.each($(this).nextAll(), function(index, obj) {
                                    var nextParentId = $(obj).attr("data-tt-parent-id");
                                    if (childrenParentId == nextParentId) {
                                        $(obj).show();
                                        if ($(this).find("td span:last-child").hasClass("folder")) {
                                            $(this).removeClass("collapsed")
                                            var newxChildDataId = $(obj).attr("data-tt-id")
                                            $.each($(obj).nextAll(), function(index, child) {
                                                if (newxChildDataId == $(child).attr("data-tt-parent-id")) {
                                                    $(child).show();
                                                    if ($(this).find("td span:last-child").hasClass("folder")) {
                                                        $(this).removeClass("collapsed")
                                                        var c_id = $(child).attr("data-tt-id");
                                                        $.each($(child).nextAll(), function(index, o) {
                                                            if (c_id == $(o).attr("data-tt-parent-id")) {
                                                                $(o).show();
                                                            }
                                                        });
                                                    };
                                                }
                                            });
                                        };
                                    }
                                });
                            }

                        })
                    }
                })
            };
            this.refInitDisplayData = function() {
                $("#recoveryProcessTreeDiv #treeTable tr td").each(function() {
                    if ($(this).find("label").text() == "--") {
                        $(this).addClass("left-align");
                    }
                });
                //选择
                $("#recoveryProcessTreeDiv #treeTable tbody").on("mousedown", "tr", function() {
                    $(".row-selected").not(this).removeClass("row-selected");
                    var thisCss = $(this).attr("class");
                    if (thisCss.indexOf("row-selected") != -1) {
                        return false;
                    }
                    $(this).toggleClass("row-selected");
                });

                //悬浮
                $("#recoveryProcessTreeDiv #treeTable tbody").on("mouseover", "tr", function() {
                    $(this).toggleClass("row-over");
                });

                $("#recoveryProcessTreeDiv #treeTable tbody").on("mouseout", "tr", function() {
                    $(this).toggleClass("row-over");
                });

                $("#recoveryProcessTreeDiv #treeTable .folder").each(function(){
                    var parentTr = $(this).parent().parent();
                    var id = parentTr.attr("id") ? parentTr.attr("id").replace("suffex", "") : "";
                    var thisChilds = parentTr.nextAll("tr").filter(function(){return $(this).attr("data-tt-parent-id") == id})
                    var thisSpan = parentTr.find("td span:last-child");
                    var thisLeft = parseInt(thisSpan.css("padding-left").split("px")[0],10);
                    thisChilds.each(function(){
                        $(this).find('td span:last-child').css({
                            "padding-left": (thisLeft + 35) + "px",
                            "background-position": (thisLeft + 15) + "px center"
                        })
                    })
                });

                $("#excuteDetailDiv #recoveryDetailTreeDiv").resizableColumns({
                    store: window.store
                });
            };
            this.historyBindEvent = function(){
                $("#treeTable tbody").on("mousedown", "tr", function() {
                    $(".row-selected").not(this).removeClass("row-selected");
                    var thisCss = $(this).attr("class");
                    if (thisCss.indexOf("row-selected") != -1) {
                        return false;
                    }
                    $(this).toggleClass("row-selected");
                });
                $("#excuteDetailDiv #recoveryDetailTreeDiv").resizableColumns({
                    store: window.store
                });
            }
        };
        service.$injector = ["constsService", "communicationService", "utilService", "exception", "mask", "infoTransferredService", "statusEnumService", "appUtils", "cookieService"];
        return service;
    });
