define(["tiny-lib/angular", "tiny-lib/underscore", "tiny-lib/Class"],function(angular, _, Class){
	var service = ["constsService", "appUtils", function(constsService, appUtils){
		var _thisService = this;

		var WidgetTemplate = Class.extend({});

        /*
        表格模板,1.封装了Table的公共逻辑  2.增强了几个API

        1.分页和排序, 排序默认跳转第一页
          当queryCondition配置有查询函数,且queryCondition.$serverSide为真(表示后台分页),增加分页和排序公共逻辑;
          若传入callback和sortCallback,则先调用传入的逻辑再调用分页和排序

        2.opAreaConfig 操作状态封装,原始API上增加或者修改以下配置
        opAreaConfig : {
            authKey string 操作权限
            classConfig array [可用样式,不可用样式]
            clickActive fn 点击事件(1不可用时不会触发 2默认传入当前行表格数据)
            mouseActive fn 控制按钮是否可用(返回true可用,false不可用)
        }

        3.checkbox 封装
        checkbox: true,
        rowId: 行的唯一标示,如"uuid",则会以表格数据cell.uuid为唯一标示
        checkedItems: 初始化选中的项
        增加的API:
        updateCheckedItems 刷新选中项,当选中项有改变时,调用此方法
        getCheckedItems 获取选中项

        */

        this.tableTempalte = WidgetTemplate.extend({
			init: function(config){
                var widgetThis = this;

				var defaultConfig = {
					displayLength: constsService.TABLE_COUNT_PER_PAGE,
					totalRecords: 0,
                    enablePagination: false
            	};

                /*--------------分页和排序----------------------*/
        		//分页
        		var callback = config.callback;
    			config.callback = function(oPage){
                	if( _.isFunction(callback) ){
                		callback.call(this, oPage);
                	}

                    var queryCondition = widgetThis.queryCondition;

                    if( queryCondition ){
                        queryCondition.startPage = oPage.currentPage - 1;

                        if( queryCondition.$fn && queryCondition.$serverSide ){
                            var queryFn = queryCondition.$fn.query;
                            _.isFunction(queryFn) && queryFn();
                        }
                    }
    			}

    			//排序
    			var sortCallback = config.sortCallback;
    			config.sortCallback = function(nNode, sortArr){
    				if( _.isFunction(sortCallback) ){
                		sortCallback.call(this, nNode, sortArr);
                	}

                    var queryCondition = widgetThis.queryCondition;

                    if( queryCondition ){

                        queryCondition.orderBy = config.id == "pgTable" ? config.columns[sortArr[0][0] - 1].mData : config.columns[sortArr[0][0]].mData;
                        queryCondition.orderType = sortArr[0][1];

                        //后台分页排序时跳转第一页
                        if( queryCondition.$fn && queryCondition.$serverSide ){
                            queryCondition.startPage = 0;
                            var queryFn = queryCondition.$fn.query;
                             _.isFunction(queryFn) && queryFn();
                        }
                    }
    			}

                /*--------------表格操作----------------------*/
                if( _.isArray(config.opAreaConfig) ){
                    config.opAreaConfig = _thisService.createTableOpAreaConfig(config.id, config.opAreaConfig);

                    var hoverActive = config.hoverActive;
                    config.hoverActive = function(event, oData){
                        _.isFunction(hoverActive) && hoverActive.apply(this,arguments);
                        //hoverActive时调用mouseActive
                        _.each(config.opAreaConfig, function(op) {
                            _.isFunction(op.mouseActive) && op.mouseActive.call(this,oData);
                        });
                    }
                }

                /*--------------checkbox----------------------*/
                if( config.checkbox && config.rowId ){
                    config.checkedItems = config.checkedItems || [];

                    //点击行,更新checkedItems
                    var cellClickActive = config.cellClickActive;
                    config.cellClickActive = function(event, cell){
                        _.isFunction(cellClickActive) && cellClickActive.apply(this, arguments);
                        widgetThis.updateCheckedItems();
                    }

                    //点击全选,更新checkedItems
                    var tHeadCheckboxFn = config.tHeadCheckboxFn;
                    config.tHeadCheckboxFn = function(){
                        _.isFunction(tHeadCheckboxFn) && tHeadCheckboxFn.apply(this, arguments);
                        widgetThis.updateCheckedItems();
                    }

                    //drawCallback时,选中checkbox
                    var drawCallback = config.drawCallback;
                    config.drawCallback = function(oSetting){
                        _.isFunction(drawCallback) && drawCallback.apply(this, arguments);

                        if (!oSetting.aoData.length) return;

                        var trs = $("#" + config.id + " .tinyTable.dataTable tbody tr");
                        trs.each(function() {
                            $(this).removeClass("clickTrColor").find("div.table_checkbox_select").removeClass("table_checkbox_select");
                        });

                        var tableWidget = $("#"+widgetThis.id).widget();
                        _.each(widgetThis.checkedItems, function(item){
                            tableWidget.setSelectedRow(config.rowId, item[config.rowId]);
                        });
                    }

                    //更新checkedItems
                    config.updateCheckedItems = function(){
                        var widgetThis = this;
                        var rowId = config.rowId;
                        var tableWidget = $("#"+widgetThis.id).widget();

                        var items = tableWidget.getTableCheckedItems();
                        if( _.isArray(items) ){
                            widgetThis.checkedItems = appUtils.union(widgetThis.checkedItems, items, rowId);
                        }

                        //删除当前页未选中的项
                        var trs = $("#" + widgetThis.id + " .tinyTable.dataTable tbody tr:not('.clickTrColor')");
                        trs.each(function() {
                            var trData = tableWidget.getTableData(this);
                            appUtils.removeItemFromArray(widgetThis.checkedItems, rowId, trData[rowId]);
                        });
                    }

                    //获取checkedItems(返回副本)
                    config.getCheckedItems = function(){
                        return _.clone(widgetThis.checkedItems);
                    }

                    //清空选中项
                    config.clearCheckedItems = function(){
                        widgetThis.checkedItems = [];
                    }
                }

            	_.extend(this, defaultConfig, config);
			}
		});

        /*
        表格操作按钮的封装,影响配置项说明
        {
        authKey string 操作权限
        classConfig array [可用样式,不可用样式]
        clickActive fn 点击事件(1不可用时不会触发 2默认传入当前行表格数据)
        mouseActive fn 控制按钮是否可用(返回true可用,false不可用)
        }
        */
        this.createTableOpAreaConfig = function(tableId, config){
            if( !_.isArray(config) ) return;

            //权限过滤
            var opAreaConfig = appUtils.flilterOperRight(_.clone(config));

            _.each(opAreaConfig, function(conf){
                var clickActive = conf.clickActive;
                conf.clickActive = function(){
                    if( $("#"+conf.id).find("div").hasClass(conf.classConfig[1]) ) return;

                    var hoverData = $("#" + tableId).widget().getHoverData()[0];
                    _.isFunction(clickActive) && clickActive(hoverData);
                }

                var mouseActive = conf.mouseActive;
                conf.mouseActive = function(){
                    var hoverData = arguments[0];

                    var isAvaliable = _.isFunction(mouseActive) && mouseActive(hoverData);
                    if( isAvaliable ){
                        $("#"+conf.id).find("div").removeClass(conf.classConfig[1]).addClass(conf.classConfig[0]);
                    }
                    else{
                        $("#"+conf.id).find("div").removeClass(conf.classConfig[0]).addClass(conf.classConfig[1]);
                    }
                }
            });

            return opAreaConfig;
        }

        /*
        生成更新表格的回调
            table 表格数据模型
            scope 作用域
            cb    数据返回时的回调
            afterApplyCb 调用scope.apply后的回调
        */
        this.createUpdateTableFn = function(table, scope, cb, afterApplyCb) {
            return function(data, restConf) {
                if( data && data.totalCount && data.records ){
                    var totalCount = data.totalCount;
                    var records = data.records;

                    table.data = _thisService.encodeForTable(table, records);
                    table.totalRecords = totalCount;
                    table.enablePagination = totalCount > 10;
                }
                else{
                    if( _.isEmpty(data) ) {
                        table.data = [];
                        table.totalRecords = 0;
                        table.enablePagination = false;
                    }
                    else{
                        table.data = _thisService.encodeForTable(table, data);
                        table.totalRecords = data.length;
                        table.enablePagination = data.length > 10;
                    }
                }

                /*----------------兼容TableFixer----------------*/
                if( _.isObject(table.tableFixer) ){
                    //分页和搜索不清除选中项
                    if (table.tableFixer.pageQuery === true) {
                        table.tableFixer.pageQuery = false;
                    } else if (table.tableFixer.search === true) {
                        table.tableFixer.search = false;
                    } else {
                        table.tableFixer.clear();
                    }
                }
                /*-----------------------------------------------*/

                var queryCondition = table.queryCondition;
                if( (queryCondition && queryCondition.startPage == 0) || table.enablePagination == false ){
                    table.curPage = {"pageIndex": 1};
                }


                _.isFunction(cb) && cb(data);
                scope && scope.$apply();
                _.isFunction(afterApplyCb) && afterApplyCb(data);

                //非第一页数据为空自动跳转到第一页
                var queryFn = queryCondition && queryCondition.$fn.query;
                if( queryCondition && _.isFunction(queryFn) && queryCondition.$serverSide ){
                    if( _thisService.checkPageForward(queryCondition.startPage, data) ){
                        queryCondition.startPage = 0;
                        table.curPage = { "pageIndex": 1 };
                        queryFn(restConf);
                    }
                }
            };
        };

        /* 为表格数据作html编码 */
        this.encodeForTable = function(table, records) {
            if( _.isArray(table.columns) && _.isArray(records) ){
                var keys = [];

                table.columns.forEach(function(col) {
                    if (col.bVisible !== false && col.mData) {
                        keys.push(col.mData);
                    }
                });

                keys.length > 0 && records.forEach(function(record) {
                    keys.forEach(function(key) {
                        var item = record;
                        var key = key.split(".");
                        var len = key.length;

                        //处理props.key这种情况
                        for (var i = 0; i < len - 1; i++) {
                            item = item[key[i]];
                        }

                        var v = item[key[i]];

                        if ( _.isString(v) ) {
                            item[key[i]] = $.encoder.encodeForHTML(v);
                        }
                        else if( _.isNull(v) ){
                            item[key[i]] = "null";
                        }

                    });
                });
            }

            return records;
        };


        /*
        分页查询时,当页码不为第一页且返回的response未空时,返回true
        */
        this.checkPageForward = function(pageNum, response){
            if( angular.isUndefined(pageNum) || pageNum == 0 ) return false;

            if( _.isEmpty(response) || (_.isArray(response) && response.length == 0) ){
                return true;
            }
            else if( _.isObject(response) ){
                return !response.records || response.records.length == 0;
            }
            else{
                return false;
            }
        }

	}];
	return service;
});