define(["tiny-lib/angular", 
        "tiny-lib/jquery",
        "tiny-directives/Directive",
        "ibase/ibase",        
        "app/services/maskService",
        "app/services/msgService",
        "app/services/nodepsAppUtilService",  
        "language/firstLoginLanguage",
        "language/widgetsLanguage",
        "app/services/securityService",
        "firstlogin-root/controllers/firstLoginCtrl"],
    function (angular, $, wcc, ibase, mask, message, noDepsUtil, language, widgetsLang, securityService, firstLoginCtrl) {
        "use strict";

        //注入框架的配置文件
        var dependency = [ "ng", "wcc", "ui.platform" ];

        var dtd = $.Deferred();

        var module = angular.module("firstLogin", dependency);
        var secHolder = new securityService(module);
        $.extend(language, widgetsLang);
        $.when(secHolder.load()).then(function() {
            secHolder.register();
            module.controller("firstLoginCtrl", firstLoginCtrl);
            module.service("mask", mask);
            module.service("i18nService", function() {
                this.get = function (key, defaultVal) {
                    (defaultVal === undefined) && (defaultVal = key);

                    if (!key) {
                        return defaultVal;
                    }

                    return this.resource()[key] || defaultVal;
                };
                this.resource = function() {
                    return language;
                };
            });
            module.service("message", message);
            module.service("noDepsUtil", noDepsUtil);
            dtd.resolve(module);
        }, function() {
            dtd.reject();
        });

        return dtd.promise();
    });

