define(['tiny-lib/jquery',
    "tiny-lib/angular",
    "tiny-common/UnifyValid",
    "tiny-widgets/Window",
    "tiny-directives/FormField",
    "tiny-directives/Textbox",
    "tiny-directives/Button"],
    function ($, angular, UnifyValid ,Window) {
        "use strict";

    var ctrl = function ($scope, mask, communicationService, utilService, securityService, message, noDepsUtil, i18nService, cookieService) {
        var ViewModel = {
            orignalPwd: {
                id: "orignalPwd",
                label: i18nService.resource()["Login_Label_Old_Password"],
                value: "",
                val: function(value) {
                    return $("#orignalPwd").widget().getValue();
                },
                validate: "required;"
            },
            newPwd: {
                id: "newPwd",
                label: i18nService.resource()["Login_Label_New_Password"],
                value: "",
                val: function(value) {
                    return $("#newPwd").widget().getValue();
                },
                validate: "validateNewPwdFn : extend function;",
                validateFn: ["validateNewPwdFn"]
            },
            confirmPwd: {
                id: "confirmPwd",
                label: i18nService.resource()["Login_Label_Confirm_Password"],
                value: "",
                val: function(value) {
                    return $("#confirmPwd").widget().getValue();
                },
                validate: "validateConfirmPwdFn : extend function;",
                validateFn: ["validateConfirmPwdFn"]
            }
        };

        $scope.operations = {
            ok: {
                id: "btnApply",
                label: i18nService.resource()["common_term_yes_button"],
                click: function() {
                    if (!UnifyValid.FormValid($("#firstLoginFrm"), {focusInvalid: true})) {
                        return;
                    }
                    mask.show();
                    var param = {};
                    var url = utilService.getResouceUrl("/users/action/userModifyPassword");
                    param.newPassword = ViewModel.newPwd.val();
                    param.confirmPassword = ViewModel.confirmPwd.val();
                    param.oldPassword = ViewModel.orignalPwd.val();
                    communicationService.put(url, param).promise().always(function (result) {
                        mask.hide();
                        var resJson;
                        try {
                            resJson = JSON.parse(result);
                        } catch (err) {}
                        resJson = resJson || {};
                        if (__checkResponse(result)) {
                            message.success({content: i18nService.resource()["login_first_modify_pwd_successed_msg"], ok: function() {
                                __forwardToLoginPage();
                            }});
                        }
                    });
                }
            },
            cancel: {
                id: "btnCancel",
                label: i18nService.resource()["common_term_no_button"],
                click: function() {
                    __forwardToLoginPage();
                }
            }
        };

        var __forwardToLoginPage = function() {
            var url = utilService.getResouceUrl("/ws/auth/logout");
            communicationService.post(url,{timeOut:false}).promise().always(function(result) {
                var rootPath = utilService.getRootPath();
                window.location.href = rootPath + "/src/login/view/login.html"
            });
        };

        var __checkResponse = function(response, callback) {
            var eventArgs = {
                code: 0,
                param: ""
            };
            if (angular.isObject(response)) {
                if (response['status'] == 401) {
                    message.error({content: i18nService.resource()["user_term_timeout_message"], ok: function() {
                        __forwardToLoginPage();
                    }});
                    return false;
                }

                if (response['status'] == 403) {
                    window.location.href = utilService.getRootPath() + "/pages/error.html";
                    return false;
                }

                if (angular.isDefined(response.responseText) && response.responseText.indexOf('"errorCode":') > -1) {
                    var resJson, code, param, des;
                    try {
                        resJson = JSON.parse(response.responseText);
                    } catch (err) {}
                    resJson = resJson || {errorCode: -1, des: ""};
                    eventArgs = {
                        code: resJson.errorCode,
                        param: resJson.detailPara
                    }
                }
            } else if (response && angular.isString(response)) {
                var resJson;
                try {
                    resJson = JSON.parse(response.responseText);
                } catch (err) {}
                resJson = resJson || {errorCode: -1, des: ""};
                eventArgs = {
                    code: resJson.errorCode,
                    param: resJson.detailPara
                }
            } else {
                if (!response) {
                    eventArgs.error = {
                        code: 0
                    }
                } else {
                    eventArgs.error = {
                        code: -1
                    };
                }
            }

            if (eventArgs.code !== 0) {
                eventArgs.code = "lego.err." + eventArgs.code;
                var msg = i18nService.resource()[eventArgs.code] || eventArgs.code;
                //只建立一个实例
                if ($("body").find("div[id^='messageDialog_main_MessageDialog_']")[0]) {
                    $("body").find("div[id^='messageDialog_main_MessageDialog_']").remove();
                }
                message.error({
                    content: $.encoder.encodeForHTML(msg),
                    ok: function () {
                        if (typeof callback === "function") {
                            (callback)();
                        }
                    }
                });
                return false;
            } else {
                return true;
            }
        };

        var __PRIVATE__ = {
            minLen: 10,
            pwdComplex: 4,
            maxLen: 64
        };

        $scope.model = {
            width: 208,
            password: "password",
            orignalPwd: ViewModel.orignalPwd,
            newPwd: ViewModel.newPwd,
            confirmPwd: ViewModel.confirmPwd
        };

        UnifyValid.validateNewPwdFn = function() {
            var orignalPwd = ViewModel.orignalPwd.val();
            var newPwd = ViewModel.newPwd.val();

            if (!newPwd) {
                return i18nService.resource()["Login_Message_Password_Empty_New"];
            }

            if (orignalPwd == newPwd) {
                return i18nService.resource()["Login_Message_Password_Same"];
            }

            var userName = securityService.getCurrentUser().userName || "";

            var reverseName = userName.split('').reverse();
            reverseName = reverseName.join('');
            var isSameWithName = newPwd == userName || newPwd == reverseName;

            if (!checkUserPwd(newPwd, __PRIVATE__.minLen, __PRIVATE__.pwdComplex, 64) || isSameWithName) {
                var message = noDepsUtil.stringFormat(i18nService.resource()["Login_Message_Password_Complex"], $.trim(__PRIVATE__.minLen), $.trim(__PRIVATE__.maxLen), "");
                if (__PRIVATE__.pwdComplex == 2) {
                    message = noDepsUtil.stringFormat(
                            i18nService.resource()["Login_Message_Password_Complex"],
                            $.trim(__PRIVATE__.minLen),
                            i18nService.resource()["Login_Message_Password_Complex_Special"]);
                }
                return message;
            }

            return "";

        };

        var checkUserPwd = function(pwd, length, complexEnum, maxLen) {
            pwd = $.trim(pwd);
            length = length || 8;
            maxLen = maxLen || 64;
            complexEnum = complexEnum || 2;
            if (!pwd) {
                return false;
            }

            if (pwd.length < length || pwd.length > maxLen) {
                return false;
            }

            var regUpWord = /[A-Z]+/;
            var regDownWord = /[a-z]+/;
            var regNumber = /[0-9]+/;
            var regSpecialWord = /[`~\!@#\$%\^&\*\(\)\-_=+\\[\{\}\]\;:\'\"\,\<\.\>\/\?\u0020]+/;

            var weight = 0;

            //验证密码连续重复字符小于等于2
            if (new RegExp('(.)\\1{2}').test(pwd)) {
                return false;
            }

            if (regNumber.test(pwd)) {
                weight += 1;
            }

            if (regDownWord.test(pwd)) {
                weight += 2;
            }

            if (regUpWord.test(pwd)) {
                weight += 4;
            }

            if (regSpecialWord.test(pwd)) {
                weight += 8;
            }

            if (complexEnum == 2) {
                return weight >= 11;
            }

            if (complexEnum == 4) {
                return weight === 15;
            }

            return false;
        };

        UnifyValid.validateConfirmPwdFn = function() {
            var newPwd = ViewModel.newPwd.val();
            var confirmPwd = ViewModel.confirmPwd.val();

            if (newPwd != confirmPwd) {
                return i18nService.resource()["Login_Message_Password_Different"];
            }

            return "";
        };

        $scope.$on("$destroy", function() {
            delete __PRIVATE__.minLen;
            delete __PRIVATE__.pwdComplex;
            delete UnifyValid.validateNewPwdFn;
            delete UnifyValid.validateConfirmPwdFn;
        });

        // 监听回车事件
        $("#firstLoginFrm").keypress(function(event) {
            var curkey = event.which;
            if(curkey == 13){
                $scope.operations.ok.click();
                return false;
            }
        });

        (function() {
            communicationService.get(utilService.getResouceUrl("/securitypolicy")).promise().always(function (response) {
                if (__checkResponse(response)) {
                    __PRIVATE__.minLen = response.passLenVal;
                    __PRIVATE__.pwdComplex = response.passComplexVal;
                }
                $("#" + ViewModel.orignalPwd.id).find('input').focus();
            });

            })();


            function getDefaultLanguage() {
                var locale = cookieService.get("language");
                if (angular.isUndefined(locale) || locale == null) {
                    if (navigator.appName == "Netscape") {
                        locale = navigator.language.match(/[^-]+/)[0]
                    } else {
                        locale = navigator.browserLanguage.match(/[^-]+/)[0]
                    }
                }
                $(".rightTitle").html(i18nService.resource()["login_message_rightemssage_label"]);
                if (angular.equals(locale, "zh") || angular.equals(locale, "zh_CN")) {
                    return "zh";
                } else {
                    return "en";
                }
            };
            setTimeout(function() {
                if ("en" == getDefaultLanguage()) {
                    var styleDom = $("style:eq(0)");
                    styleDom.html(styleDom.html + "*{font-family: Arial, 'Microsoft Yahei', 'SimSun', Tahoma;}")

                }
            });

        };
        ctrl.$injector = ["$scope", "mask", "communicationService", "utilService", "appUtils", "securityService", "message", "i18nService", "cookieService"];
        return ctrl;
    });
