(function() {
    "use strict";

    var languageDir = (function() {
        var arrStr = document.cookie.split("; ");
        var arrLength = arrStr.length;
        for (var i = 0; i < arrLength; i++) {
            var tempArr = arrStr[i].split("=");
            if (tempArr[0] == "rd_language") {
                var lan = unescape(tempArr[1]);
                if (lan === "zh" || lan === "zh_CN") {
                    return "i18n/zh";
                } else {
                    return "i18n/en";
                }
            }
        }

        return "i18n/zh";
    })();

    require.config({
        "baseUrl": "/",
        "paths": {
            "app": "src/app",
            "ibase": "lib/ibase",
            "firstlogin-root": "src/firstlogin",
            "language": languageDir,
            "bootstrap": "lib/bootstrap2.3.2/js",
            "tiny-lib": "lib/tiny/tiny-lib",
            "tiny-widgets": "lib/tiny/tiny-widgets",
            "tiny-directives": "lib/tiny/tiny-directives",
            "tiny-common": "lib/tiny/tiny-common"
        },
        "shim": {
            "tiny-lib/jquery": {
                exports: "$"
            },
            "tiny-lib/underscore": {
                exports: "_"
            },
            "tiny-lib/angular": {
                deps: ["tiny-lib/jquery"],
                exports: "angular"
            },
            "bootstrap/bootstrap.min": {
                exports: "bootstrap",
                deps: ["tiny-lib/jquery"]
            },
            "jqueryui/jquery.layout-1.3.0": {
                deps: ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/jquery-ui.custom": {
                deps: ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery-ui.custom.min": {
                deps: ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery.dataTables": {
                deps: ["tiny-lib/jquery"]
            },
            "tiny-lib/jqPlot": {
                deps: ["tiny-lib/jquery", "tiny-lib/angular", "tiny-widgets/Tip", "tiny-lib/excanvas.original"]
            },
            "tiny-lib/jquery.ui.dialog": {
                deps: ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/jquery.dialogextend": {
                deps: ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/ColReorderWithResize": {
                deps: ["tiny-lib/jquery.dataTables"]
            },
            "tiny-lib/jquery.caret": {
                deps: ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery.tipsy": {
                deps: ["tiny-lib/jquery"],
                exports: "tipsy"
            },
            "ibase/ibase": {
                deps: ["tiny-lib/jquery", "tiny-lib/angular"]
            }
        },
        priority: ["angular"]
    });
    /**
     * 主启动类，手动给html element绑定module
     */
    require(['tiny-lib/jquery', "tiny-lib/angular", "firstlogin-root/controllers/firstLogin"],
        function ($, angular, app) {
            $.when(app).then(function (module) {
                angular.bootstrap($("html"), [module.name]);
            });
        }
    );
})();
