define(["tiny-lib/angular", 
    "tiny-directives/Directive", 
    "ibase/ibase",        
    "services-root/maskService",
    "services-root/nodepsAppUtilService",
    "services-root/msgService",
    "language/noAuthLanguage",
    "login-root/controllers/loginCtrl"],
    function (angular, wcc, ibase, mask, noDepsUtils, message, widgetLang, loginCtrl) {
        "use strict";

        //注入框架的配置文件
        var dependency = [
            "ng",
            "wcc",
            "ui.platform"
        ];
        var loginModule = angular.module("framework", dependency);
        loginModule.controller("loginCtrl", loginCtrl);        
        loginModule.service("i18nService", function() {
            this.get = function (key, defaultVal) {
                (defaultVal === undefined) && (defaultVal = key);

                if (!key) {
                    return defaultVal;
                }

                return this.resource()[key] || defaultVal;
            };
            this.resource = function() {
                return widgetLang;
            };
        });
        loginModule.service("mask", mask);        
        loginModule.service("message", message);
        loginModule.service("noDepsUtil", noDepsUtils);
        return loginModule;
    }
);
