define([], function() {
        "use strict";
        var ctrl = function($scope, communicationService, utilService, cookieService, message, noDepsUtil, i18nService) {
            //产品自己配置支持的浏览器版本信息，浏览器之间用“;”分隔，版本号之间用“,”分隔，
            //至少配置一个版本号（支持的最低版本号），也可以配置两个（一个最低版本号一个最高版本号）
            var supportAllInfo = "IE:11.0;firefox:65;chrome:72";
            var needCaptcha = cookieService.get("needCaptcha");
            var modifiedCookie = document.cookie.split(";");
            var localStorage = window.localStorage;

            $(document).ready(function() {
                _changeLoginContainerHeight();
                if (false == checkbrower()) {
                    message.prompt({
                        content: i18nService.get("common_brower_info_support"),
                        ok: function() {
                            $("#loginName").widget().option("focused", true);
                        }
                    });
                };

                if(modifiedCookie.length == 2 &&
                    modifiedCookie[0].indexOf("sessionIdleTime") > -1 &&
                    modifiedCookie[1].indexOf("tiny_language") > -1) {
                    localStorage.clear();
                }
            });

            function _changeLoginContainerHeight() {
                if ("true" == $.trim(needCaptcha)) {
                    $('.login_content').height(296);
                    $('.left_panel').height(296);
                    $('.right_panel').height(296);
                } else {
                    $('.login_content').height(258);
                    $('.left_panel').height(258);
                    $('.right_panel').height(258);
                }
            }

            function getBrowserInfo() {
                var Msie = /(msie\s|trident.*rv:)([\w.]+)/;
                var Firefox = /(firefox)\/([\w.]+)/;
                var Chrome = /(chrome)\/([\w.]+)/;
                var Mesign = /(mesignbrowser)\/([\w.]+)/;
                var Opera = /(opera).+version\/([\w.]+)/;
                var Safari = /version\/([\w.]+).*(safari)/;
                var browser;
                var version;
                var agent = navigator.userAgent.toLowerCase();
                var match = Mesign.exec(agent);
                if (null != match) {
                    return {
                        browser: match[1] || "",
                        version: match[2] || "0"
                    };
                }
                var match = Msie.exec(agent);
                if (null != match) {
                    return {
                        browser: "IE",
                        version: match[2] || "0"
                    };
                }
                var match = Firefox.exec(agent);
                if (null != match) {
                    return {
                        browser: match[1] || "",
                        version: match[2] || "0"
                    };
                }
                var match = Chrome.exec(agent);
                if (null != match) {
                    return {
                        browser: match[1] || "",
                        version: match[2] || "0"
                    };
                }
                var match = Opera.exec(agent);
                if (null != match) {
                    return {
                        browser: match[1] || "",
                        version: match[2] || "0"
                    };
                }
                var match = Safari.exec(agent);
                if (null != match) {
                    return {
                        browser: match[2] || "",
                        version: match[1] || "0"
                    };
                }
                return "false";
            }

            function checkbrower() {
                var currentInfo = getBrowserInfo();
                if ("false" == currentInfo) {
                    return false;
                }
                var supportarray = supportAllInfo.toLowerCase().split(';');
                var browser = currentInfo.browser.toLowerCase();
                var version = currentInfo.version;
                var flag = true;
                if (browser === "mesignbrowser") {
                    return true;
                }
                for (var i = 0; i < supportarray.length; i++) {
                    var supportInfo = supportarray[i].split(":"); // supportInfo[0]获取支持浏览器类型,supportInfo[1]获取支持浏览器版本号
                    if (-1 != browser.indexOf(supportInfo[0])) {
                        flag = false; //使用的浏览器是否属于支持的信息标记
                        var ver = supportInfo[1].split(","); // ver[0]为最低版本，ver[1]为最高版本
                        if (ver.length == 2) {
                            if (parseFloat(version) < parseFloat(ver[0]) || parseFloat(version) > parseFloat(ver[1])) {
                                return false;
                            }
                        } else if (ver.length == 1) {
                            if (parseFloat(version) < parseFloat(ver[0])) {
                                return false;
                            }
                        }
                    }
                }
                if (flag) {
                    //flag的值不改变，则使用的浏览器不在支持的范围中
                    return false;
                }
            };

            $scope.copyright = noDepsUtil.stringFormat(i18nService.get("common_term_copyright_label"),  new Date().getFullYear());
            $scope.model = {
                width: 208,
                tbName: {
                    style: "icon-username icon-location",
                    id: "loginName",
                    focused: true,
                    validate: "regularCheck(/^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-.]*$/)",
                    contentChange: function(evt,currentValue) {
                        sessionStorage.setItem("userName",currentValue);
                    }
                },
                tbPass: {
                    style: "icon-password icon-location",
                    type: "password",
                    id: "loginPass",
                    focused: false,
                    validate: "required;"
                },
                cbLang: {
                    style: "icon-language icon-location",
                    id: "cbLanguage",
                    width: 208,
                    values: [{
                        selectId: "zh",
                        label: "简体中文"
                    }, {
                        selectId: "en",
                        label: "English"
                    }],
                    defaultSelectid: getDefaultLanguage(),
                    change: function() {
                        var lang = $("#cbLanguage").widget().getSelectedId();
                        cookieService.put("language", lang);
                        if (lang === "zh") {
                            cookieService.put("language", "zh");
                        } else {
                            cookieService.put("language", "en");
                        }
                        location.reload();
                    }
                },
                tbCheckCode: {
                    style: "icon-verifycode icon-location",
                    id: "loginCheckCode",
                    display: needCaptcha == "true",
                    width: 135,
                    focused: false,
                    maxLength: 4,
                    validate: "required;"
                }
            };
            var logingFlag = false;

            function _successFn(result) {
                needCaptcha = cookieService.get("needCaptcha");
                if (__checkResponse(result, function() {
                        _changeLoginContainerHeight();
                        $("#loginBtn").widget().option("text", i18nService.get("common_term_login_button"));
                        $("#loginPass").widget().option("focused", true);
                        $("#loginPass").widget().option('value', '');
                        $("#loginBtn").find(".tiny-btn-text").removeClass("login-loading");
                    })) {
                    if (result) {
                        if ($.trim(result["expireDay"])) {
                            var expireDay = parseInt(result['expireDay'], 10);
                            expireDay = isNaN(expireDay) ? -1 : expireDay;
                            if (expireDay >= 0 && expireDay <= 3) {
                                message.prompt({
                                    content: noDepsUtil.stringFormat(i18nService.get("login_page_pwd_time_expiring_msg"), expireDay),
                                    ok: function() {
                                        _goToIndexPage();
                                        needCaptcha == "true" && $scope.refreashVildCode();
                                        logingFlag = false;
                                        $("#loginName").widget().option("focused", true);
                                    }
                                });
                            } else if (expireDay < 0) {
                                message.prompt({
                                    content: noDepsUtil.stringFormat(i18nService.get("login_page_pwd_time_expired_msg")),
                                    ok: function() {
                                        _goToIndexPage();
                                        needCaptcha == "true" && $scope.refreashVildCode();
                                        logingFlag = false;
                                        $("#loginName").widget().option("focused", true);
                                    }
                                });
                            }
                            return;
                        } else {
                            _goToIndexPage();
                        }
                    }
                }

                if(needCaptcha == "true") {
                    if (_.isEmpty($("#loginCheckCode").widget())) {
                        $scope.model.tbCheckCode.value = "";
                    } else {
                        $("#loginCheckCode").widget().option('value', '');
                    }
                    $scope.model.tbCheckCode.display = true;
                    $scope.refreashVildCode();
                    $scope.$apply();
                }

                logingFlag = false;
                sessionStorage.removeItem("userName");
                sessionStorage.setItem("loginInCount", 1);
            };

            $scope.loginBtn = {
                label: i18nService.get("common_term_login_button"),
                id: "loginBtn",
                disable: false,
                click: function() {
                    if (!navigator.cookieEnabled) {
                        $(".login_error").text(i18nService.get("user_term_cookie_error_message"));
                        return;
                    }
                    if (logingFlag) {
                        return;
                    }

                    logingFlag = true;
                    var wid = $("#cbLanguage").widget().getSelectedId();
                    var paraObj = {};
                    paraObj.userName = $.trim($("#loginName").widget().getValue());
                    if (!$.trim(paraObj.userName)) {
                        $(".login_error span").text(i18nService.get("login_user_name_empty_msg"));
                        $("#loginName").widget().option("focused", true);
                        logingFlag = false;
                        return;
                    }
                    if (!/^[a-zA-Z_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\w-.]*$/.test(paraObj.userName)) {
                        $(".login_error span").text(i18nService.get("login_user_name_rule_msg"));
                        $("#loginName").widget().option("focused", true);
                        logingFlag = false;
                        return;
                    }

                    paraObj.pwd = $("#loginPass").widget().getValue();
                    if (!$.trim(paraObj.pwd)) {
                        $(".login_error span").text(i18nService.get("login_pwd_empty_msg"));
                        $("#loginPass").widget().option("focused", true);
                        logingFlag = false;
                        return;
                    }
                    paraObj.lang = wid;

                    if ($scope.model.tbCheckCode.display) {
                        paraObj.randomCode = $("#loginCheckCode").widget().getValue();
                        paraObj.randomCode = $.trim(paraObj.randomCode);
                        if (!paraObj.randomCode || paraObj.randomCode.length !== 4) {
                            $(".login_error span").text(i18nService.get("login_verify_code_empty_msg"));
                            logingFlag = false;
                            return;
                        }
                    }

                    $(".login_error span").text("");
                    $("#loginBtn").widget().option("text", "");
                    $("#loginBtn").find(".tiny-btn-text").addClass("login-loading");
                    communicationService.post(utilService.getResouceUrl("/auth/login"), paraObj).promise().always(_successFn);
                }
            };

            $scope.refreashVildCode = function() {
                setTimeout(function() {
                      var createImgUrl = utilService.getResouceUrl("/auth") + "?" + Math.random();
                      var randomIconTitle = i18nService.get("common_term_verifytip_label");
                      var randomIconDiv = "<img id='validationCode' name='validationCode' class='validate_code_img' src='"+createImgUrl+"' title='"+randomIconTitle+"'>";
                      !_.isEmpty(angular.element(".login_validationCode")) && angular.element(".login_validationCode").empty();
                      angular.element(".login_validationCode").html(randomIconDiv);
                      angular.element("#validationCode").bind('click', function(event) {
                            _refreashVildCode();
                      });
                }, 200);
            };

            function _goToIndexPage() {
                if (isSupportedCSS3Brower()) {
                    $(".main_content").addClass("hide").on("animationend webkitAnimationEnd MSAnimationEnd oAnimationEnd", function() {
                        $(".main_container").fadeOut("normal", function() {
                            var rootPath = utilService.getRootPath();
                            var mainUrl = rootPath + "/src/index.html#/home/staticView";
                            window.location.href = mainUrl;
                        });
                    });
                } else {
                    var rootPath = utilService.getRootPath(),
                        mainUrl = rootPath + "/src/index.html";
                    window.location.href = mainUrl;
                }
            }

            function __checkResponse(response, callback) {
                var eventArgs = {
                    code: 0,
                    param: ""
                };
                if (angular.isObject(response)) {
                    if (angular.isDefined(response.responseText) && response.responseText.indexOf('"errorCode":') > -1) {
                        var resJson;
                        try {
                            resJson = JSON.parse(response.responseText);
                        } catch (err) {}
                        resJson = resJson || {
                            errorCode: -1,
                            des: ""
                        };
                        eventArgs = {
                            code: resJson.errorCode,
                            param: resJson.detailPara || resJson.detailParam
                        }
                    }
                } else if (response && angular.isString(response)) {
                    var resJson;
                    try {
                        resJson = JSON.parse(response.responseText);
                    } catch (err) {}
                    resJson = resJson || {
                        errorCode: -1,
                        des: ""
                    };
                    eventArgs = {
                        code: resJson.errorCode,
                        param: resJson.detailPara || resJson.detailParam
                    }
                } else {
                    if (!response) {
                        eventArgs.error = {
                            code: 0
                        }
                    } else {
                        eventArgs.error = {
                            code: -1
                        };
                    }
                }

                if (eventArgs.code !== 0) {
                    eventArgs.code = "lego.err." + eventArgs.code;
                    var msg = i18nService.resource()[eventArgs.code] || eventArgs.code;
                    if(!_.isEmpty(eventArgs.param)){
                        msg = noDepsUtil.stringFormat(i18nService.get(eventArgs.code), eventArgs.param)
                    }
                    //只建立一个实例
                    if ($("body").find("div[id^='messageDialog_main_MessageDialog_']")[0]) {
                        $("body").find("div[id^='messageDialog_main_MessageDialog_']").remove();
                    }

                    $(".login_error span").text($.encoder.encodeForHTML(msg));
                    if (typeof callback === "function") {
                        (callback)();
                    }
                    return false;
                } else {
                    return true;
                }
            };

            function _refreashVildCode() {
                $scope.refreashVildCode();
            }

            angular.element(document).ready(function() {
                needCaptcha == "true" && $scope.refreashVildCode();
                communicationService.get(utilService.getResouceUrl("/auth/isLicenseExpire")).promise().always(function(result) {
                    if (result && result.status == 401) {
                        return;
                    }
                    if (!__checkResponse(result)) {
                        return;
                    }

                    result.expire = $.trim(result.expire).toLowerCase();
                    if (result.expire == "true") {
                        return;
                    }

                    var installTime = result.installTime + (90 * 24 * 60 * 60 * 1000);
                    var curTime = result.curTime;

                    var leftDay = (installTime - curTime) / (24 * 60 * 60 * 1000);
                    leftDay = parseInt(leftDay, 10);
                    leftDay = isNaN(leftDay) ? 0 : Math.floor(leftDay);
                    leftDay = leftDay < 0 ? 0 : leftDay;

                    if (leftDay <= 10) {
                        message.prompt({
                            content: noDepsUtil.stringFormat(i18nService.get("login_page_license_time_expiring_msg"), leftDay),
                            ok: function() {
                                $("#loginName").widget().option("focused", true);
                            }
                        });
                    }
                    $("#loginName").widget().option("value",sessionStorage.getItem("userName"));
                });
                window != top && (top.location.href = window.location.href);
            });
            // 监听回车事件
            $(".main_container").keypress(function(event) {
                var curkey = event.which;
                if (curkey == 13) {
                    $scope.loginBtn.click();
                    return false;
                }
            });


            function getDefaultLanguage() {
                var locale = cookieService.get("language");
                if (angular.isUndefined(locale) || locale == null) {
                    if (navigator.appName == "Netscape") {
                        locale = navigator.language.match(/[^-]+/)[0]
                    } else {
                        locale = navigator.browserLanguage.match(/[^-]+/)[0]
                    }
                }
                $(".rightTitle").html(i18nService.resource()["login_message_rightemssage_label"]);
                if (angular.equals(locale, "zh") || angular.equals(locale, "zh_CN")) {
                    return "zh";
                } else {
                    return "en";
                }
            };

            function isSupportedCSS3Brower() {
                var userAgent = window.navigator.userAgent.toLowerCase();
                var supportFlag = false;
                var version = window.tinyWidget.util.browser.version;
                if (window.tinyWidget.util.browser.msie) {
                    // IE6-IE8
                    if (!$.support.leadingWhitespace) {
                        return false;
                    }
                    // IE9
                    if (window.tinyWidget.util.browser.msie && /msie 9\.0/i.test(userAgent)) {
                        return false;
                    }

                    return true;
                }

                if (window.tinyWidget.util.browser.mozilla || window.tinyWidget.util.browser.chrome || window.tinyWidget.util.browser.opera) {
                    return true;
                }
            }

            setTimeout(function() {
                if ("en" == getDefaultLanguage()) {
                    var styleDom = $("style:eq(0)");
                    styleDom.html(styleDom.html + "*{font-family: Arial, 'Microsoft Yahei', 'SimSun', Tahoma;}")
                }
            });
        };
        ctrl.$injector = ["$scope", "communicationService", "utilService", "cookieService", "message", "noDepsUtil", "i18nService"];
        return ctrl;
    });
