(function() {
    "use strict";
    var languageDir = (function() {
        var arrStr = document.cookie.split("; ");
        var arrLength = arrStr.length;
        var lang = "";
        for (var i = 0; i < arrLength; i++) {
            var tempArr = arrStr[i].split("=");
            if (tempArr[0] == "rd_language") {
                var lan = unescape(tempArr[1]);
                if (lan === "zh" || lan === "zh_CN") {
                    document.cookie = "tiny_language=zh;Secure=true;path=/src/";
                    lang = "zh";
                } else {
                    document.cookie = "tiny_language=en;Secure=true;path=/src/";
                    lang = "en";
                }
            }

        }
        if (lang) {
            return "i18n/" + lang;
        }
        if(navigator.appName == "Netscape") {
            lang = navigator.language.match(/[^-]+/)[0];
        } else {
            lang = navigator.browserLanguage.match(/[^-]+/)[0];
        }
        if (lang === "zh" || lang === "zh_CN") {
            document.cookie = "tiny_language=zh;Secure=true;path=/src/";
            lang = "zh";
        } else {
            document.cookie = "tiny_language=en;Secure=true;path=/src/";
            lang = "en";
        }

        return "i18n/" + lang;
    })();

    require.config({
        "baseUrl": "/",
        "paths": {
            "app": "src/app",
            "ibase": "lib/ibase",
            "login-root": "src/login",
            "services-root": "src/app/services",
            "language": languageDir,
            "bootstrap": "lib/bootstrap2.3.2/js",
            "tiny-lib": "lib/tiny/tiny-lib",
            "tiny-widgets": "lib/tiny/tiny-widgets",
            "tiny-directives": "lib/tiny/tiny-directives",
            "tiny-common": "lib/tiny/tiny-common"
        },
        "shim": {
            "tiny-lib/jquery": {
                "exports": "$"
            },
            "tiny-lib/underscore": {
                "exports": "_"
            },
            "tiny-lib/jquery.placeholder": {
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/angular-toggle-switch": {
                "deps": ["tiny-lib/angular"]
            },
            "tiny-lib/raphael": {
                "exports": "Raphael"
            },
            "bootstrap/bootstrap.min": {
                "exports": "bootstrap",
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/ui-bootstrap-tpls-0.12.1": {
                "deps": ["tiny-lib/angular"]
            },
            "jqueryui/jquery.layout-1.3.0": {
                "deps": ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/angular-dragdrop": {
                deps: ["tiny-lib/angular", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/angular": {
                "deps": ["tiny-lib/jquery"],
                "exports": "angular"
            },
            "tiny-directives/Timeline": {
                "deps": ["tiny-lib/angular"]
            },
            "tiny-directives/Charts": {
                "deps": ["tiny-lib/angular"]
            },
            "tiny-lib/jquery-ui.custom": {
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery-ui.custom.min": {
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery.ztree.all": {
                "deps": ["tiny-lib/jquery"],
                "exports": "zTreeAll"
            },
            "tiny-lib/jquery.ztree.exhide": {
                "deps": ["tiny-lib/jquery", "tiny-lib/jquery.ztree.all"],
                "exports": "zTreeExhide"
            },
            "tiny-lib/jquery.dataTables": {
                deps: ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/jquery.ui.dialog": {
                "deps": ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/jquery.dialogextend": {
                "deps": ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
            },
            "tiny-lib/jquery.slider": {
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery-ui-datepicker": {
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/ColReorderWithResize": {
                deps: ["tiny-lib/jquery.dataTables"]
            },
            "tiny-lib/ColVis": {
                deps: ["tiny-lib/jquery.dataTables"]
            },
            "tiny-lib/jquery.caret": {
                "deps": ["tiny-lib/jquery"]
            },
            "ui-router/angular-ui-router.min": {
                "deps": ["tiny-lib/angular"]
            },
            "tiny-lib/jquery.tipsy": {
                "deps": ["tiny-lib/jquery"],
                "exports": "tipsy"
            },
            "tiny-lib/d3": {
                "exports": "d3"
            },
            "tiny-lib/jquery.flot": {
                "deps": ["tiny-lib/jquery"]
            },
            "tiny-lib/jquery.flot.symbol": {
                deps: ["tiny-lib/jquery.flot"]
            },
            "tiny-lib/jquery.flot.dashes": {
                deps: ["tiny-lib/jquery.flot"]
            },
            "tiny-lib/jquery.flot.time": {
                deps: ["tiny-lib/jquery.flot"]
            },
            "tiny-lib/jquery.flot.spline": {
                deps: ["tiny-lib/jquery.flot"]
            },
            "tiny-lib/jquery.flot.threshold.multiple": {
                deps: ["tiny-lib/jquery.flot"]
            },
            "tiny-lib/jquery.flot.stack": {
                deps: ["tiny-lib/jquery.flot"]
            },
            "tiny-lib/jquery.flot.pie": {
                deps: ["tiny-lib/jquery.flot"]
            },

            /********产品组件*********/
            "ibase/ibase": {
                deps: ["tiny-lib/jquery", "tiny-lib/angular"]
            },
            "src/jquery.fly": {
                deps: ["tiny-lib/jquery"]
            }
        },
        priority: ["angular"]
    });
    /**
     * 主启动类，手动给html element绑定module
     */
    require(['tiny-lib/jquery', "tiny-lib/angular", "login-root/controllers/login"],
        function ($, angular, app) {
            angular.bootstrap($("html"), [app.name]);
        }
    );
})();
