/**
 * 工程的module加载配置文件
 * module的基础路径为"工程名/"
 *
 */
"use strict";

var languageDir = getLanguageDir();

function getLanguageDir() {
    var arrStr = document.cookie.split("; ");
    var arrLength = arrStr.length;
    for (var i = 0;i < arrLength;i++) {
      var tempArr = arrStr[i].split("=");
      if (tempArr[0] == "rd_language") {
        var lan = unescape(tempArr[1]);
        if(lan === "zh" || lan === "zh_CN") {
            return "i18n/zh";
        } else {
            return "i18n/en";
        }
      }
    }
    return "i18n/zh";
}

//全局定位打开后台任务列表
window.showTaskList = function() {
    $.each($('.ui-icon-closethick'), function(index, element) {
        if ($.trim($(element).attr("class")) === "ui-icon ui-icon-closethick") {
            $(element).click();
            return false;
        }
        return true;
    });
    $('#taskButton').click();
}

/**
 * 是否为英文语言
 * @return {Boolean} [description]
 */
window.isEn = function() {
    return getLanguageDir() != "i18n/zh";
}()

/**
 * 判断是否为isUltraVR的唯一标识
 *
 * @return {Boolean} [description]
 */
window.isUltraVR = function() {
    return "OceanStor BCManager eReplication" == "UltraVR";
}()

/**
 * 判断是否为私有云的唯一标识
 *
 * @return {Boolean} [description]
 */
window.isPrivateConsole = function() {
    return "eReplication_Console" == "eReplication_Console";
}()

window.taskUserGuide = function (start, showTaskGuide) {
    var state = angular.element(document).injector().get("$state");
    if (state.$current.name == "protection.pg.list.policy") return;
    var end = $('#taskButton').offset();
    var pic = $('<img class="task-flyer" src="/theme/recoverydirector/images/recovery/task.png"/>');
    //防止点击esc键，导致在body生成图片
    if(_.isUndefined(start.left) && _.isUndefined(start.pageX)){
        window._taskRunningFn();
        return;
    };
    pic.fly({
        speed: 1.5,
        start: {
            left: _.isUndefined(start.left) ? start.pageX : start.left,
            top: _.isUndefined(start.top) ? start.pageY : start.top
        },
        end: {
            left: end.left,
            top: end.top,
            width: 16,
            height: 16
        },
        onEnd: function() {
            this.destory();
            window._taskRunningFn();
        }
    });

}

require.config({
    "baseUrl": "../",
    "paths": {
        "can": "lib/can",
        "app": "src/app",
        "ui-router": "lib/angular-ui/ui-router",
        "tiny-lib": "lib/tiny/tiny-lib",
        "tiny-widgets": "lib/tiny/tiny-widgets",
        "tiny-directives": "lib/tiny/tiny-directives",
        "tiny-common": "lib/tiny/tiny-common",
        "tiny-extra-widgets": "lib/tiny-extra/widgets",
        "tiny-extra-directives": "lib/tiny-extra/directives",
        "tiny-extra-lib": "lib/tiny-extra/lib",
        "bootstrap": "lib/bootstrap2.3.2/js",
        "moment": "lib/moment/moment.min",
        "lazy-load": "lib/lazy-load",
        "language": languageDir,
        "ibase": "lib/ibase"
    },
    "pkgs": {
        //继承tiny，重写需求
       "tiny-widgets/Window" : "lib/tiny-extra/widgets/WindowExt",
       "tiny-widgets-Window": "tiny-widgets/Window",
       "tiny-widgets/Menubutton" : "lib/tiny-extra/widgets/MenubuttonExt",
       "tiny-widgets-Menubutton": "tiny-widgets/Menubutton",
       "tiny-widgets/Table" : "lib/tiny-extra/widgets/TableExt",
       "tiny-widgets-Table": "tiny-widgets/Table",
       "tiny-widgets/CirqueChart" : "lib/tiny-extra/widgets/CirqueChartExt",
       "tiny-widgets-CirqueChart": "tiny-widgets/CirqueChart",
    },
    "shim": {
        "tiny-lib/jquery": {
            "exports": "$"
        },
        "tiny-lib/underscore": {
            "exports": "_"
        },
        "tiny-lib/jquery.placeholder": {
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/angular-toggle-switch": {
            "deps": ["tiny-lib/angular"]
        },
        "tiny-lib/raphael": {
            "exports": "Raphael"
        },
        "bootstrap/bootstrap.min": {
            "exports": "bootstrap",
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/ui-bootstrap-tpls-0.12.1": {
            "deps": ["tiny-lib/angular"]
        },
        "jqueryui/jquery.layout-1.3.0": {
            "deps": ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
        },
        "tiny-lib/angular": {
            "deps": ["tiny-lib/jquery"],
            "exports": "angular"
        },
        "tiny-lib/angular-dragdrop": {
            "deps": ["tiny-lib/angular", "tiny-lib/jquery-ui.custom.min"]
        },
        "tiny-directives/Timeline": {
            "deps": ["tiny-lib/angular"]
        },
        "tiny-directives/Charts": {
            "deps": ["tiny-lib/angular"]
        },
        "tiny-lib/jquery-ui.custom": {
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/jquery-ui.custom.min": {
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/jquery.ztree.all": {
            "deps": ["tiny-lib/jquery"],
            "exports": "zTreeAll"
        },
        "tiny-lib/jquery.ztree.exhide": {
            "deps": ["tiny-lib/jquery", "tiny-lib/jquery.ztree.all"],
            "exports": "zTreeExhide"
        },
        "tiny-lib/jquery.dataTables": {
            "deps" : ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
        },
        "tiny-lib/jquery.ui.dialog": {
            "deps": ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
        },
        "tiny-lib/jquery.dialogextend": {
            "deps": ["tiny-lib/jquery", "tiny-lib/jquery-ui.custom.min"]
        },
        "tiny-lib/jquery.slider": {
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/jquery-ui-datepicker": {
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/ColReorderWithResize": {
            "deps": ["tiny-lib/jquery.dataTables"]
        },
        "tiny-lib/ColVis": {
            "deps": ["tiny-lib/jquery.dataTables"]
        },
        "tiny-lib/jquery.caret": {
            "deps": ["tiny-lib/jquery"]
        },
        "ui-router/angular-ui-router.min": {
            "deps": ["tiny-lib/angular"]
        },
        "tiny-lib/jquery.tipsy": {
            "deps": ["tiny-lib/jquery"],
            "exports": "tipsy"
        },
        "tiny-lib/d3": {
            "exports": "d3"
        },
        "tiny-lib/jquery.flot": {
            "deps": ["tiny-lib/jquery"]
        },
        "tiny-lib/jquery.flot.symbol": {
            "deps": ["tiny-lib/jquery.flot"]
        },
        "tiny-lib/jquery.flot.dashes": {
            "deps": ["tiny-lib/jquery.flot"]
        },
        "tiny-lib/jquery.flot.time": {
            "deps": ["tiny-lib/jquery.flot"]
        },
        "tiny-lib/jquery.flot.spline": {
            "deps": ["tiny-lib/jquery.flot"]
        },
        "tiny-lib/jquery.flot.threshold.multiple": {
            "deps": ["tiny-lib/jquery.flot"]
        },
        "tiny-lib/jquery.flot.stack": {
            "deps": ["tiny-lib/jquery.flot"]
        },
        "tiny-lib/jquery.flot.pie": {
            "deps": ["tiny-lib/jquery.flot"]
        },

        /********产品组件*********/
        "ibase/ibase": {
            "deps": ["tiny-lib/jquery", "tiny-lib/angular"]
        },
        "src/jquery.fly" : {
            "deps": ["tiny-lib/jquery"]
        }
    },
    priority: [
        "angular"
    ]
});

if (typeof define === "function" && define.amd) {
    define("angular", [], function() {
        return window.angular;
    });
}

/**
 * 主启动类，手动给html element绑定module
 */
require(['tiny-lib/jquery', "tiny-lib/angular", "app/framework/framework",
        "app/framework/base/controllers/serviceCtrl",
        "app/framework/base/controllers/menusCtrl",
        "app/framework/base/controllers/quickStartCtrl",
        "lib/utils/requestAnimationFrame",
        "lib/utils/fly",
        "lib/utils/tableColDrag",
        "lib/utils/store",
        ],
    function ($, angular, framework, serviceCtrl, menusCtrl, quickStartCtrl) {
        framework && $.when(framework).then(function(framework) {
            if (!framework) {
                return;
            }
            var appModule = angular.module("rd_system", [framework.name]);
            appModule.run(['$state', function($state) {
                window.myAppErrorLog = [];
                //屏蔽浏览器控制台angular-ui-router.min.js的Transition Rejection报错信息
                $state.defaultErrorHandler(function(error) {
                    window.myAppErrorLog.push(error);
                });
            }])
            appModule.controller("serviceCtrl", serviceCtrl);
            appModule.controller("menusCtrl", menusCtrl);
            appModule.controller("quickStartCtrl", quickStartCtrl);
            angular.bootstrap($("html"), [appModule.name]);
        }, function (err) {
        });
    }
);
