define(["tiny-extra-lib/jquery.base64"], function() {
    "use strict";
    var ctrl = ["$scope", "$sce", "$compile", "constsService", "appUtils", "restService", "message", function($scope, $sce, $compile, constsService, appUtils, restService, message) {

        var tableKey = "moUuid";
        var cacheDrTypeMap = {};
        var selectedVms = [];
        var selectedVmsQuery = "";
        var page = 1;
        var orderBy;
        var orderType;
        var protectGroup;
        var queryCondition;
        var cacheSelectVms = [];
        var vmTableData = [];

        var _avaliableTableFixer = appUtils.tableFixer("avaliableTable", tableKey);
        var _selectedTabelFixer = appUtils.tableFixer("selectedTable", tableKey);
        var _clearTable = function() {
            $scope.model.avaliableVms.data = [];
            $scope.model.selectedVms.data = [];
            $scope.$apply();
        }

        $scope.openstackVirtualInstructions = appUtils.getString("protection_openstack_addVirtual_label");
        var _updateSelectedVms = function(data) {
            data = angular.copy(data);
            !data && (data = []);
            if (selectedVmsQuery != "" && angular.isArray(data)) {
                var key = "name";
                var delCnt = 0;
                for (var i = 0, len = data.length; i < len; i++) {
                    var item = data[i - delCnt];
                    var itemStr = item[key];

                    if (angular.isString(itemStr) && angular.isString(selectedVmsQuery) &&
                        itemStr.toUpperCase().indexOf(selectedVmsQuery.toUpperCase()) == -1) {
                        data.splice(i - delCnt++, 1);
                    }
                }
            }

            var table = $scope.model.selectedVms;
            table.totalRecords = data.length;
            table.data = data;
            table.enablePagination = data.length > table.displayLength;
            if (table.enablePagination == false) {
                table.curPage = {
                    "pageIndex": 1
                };
            }
            $scope.$apply();
        };

        var updateDisableRow = function() {
            var tbWidget = $("#avaliableTable").widget();
            if (!tbWidget) return;

            var tbData = tbWidget.getTableData();
            var selectedData = appUtils.intersection(selectedVms, tbData, tableKey);

            appUtils.enableAllRow("avaliableTable", tbData.length);
            selectedData.forEach(function(item) {
                tbWidget.setSelectedRow(tableKey, item[tableKey]);
                var index = appUtils.getIndexFromArray(tbData, tableKey, item[tableKey]);
                appUtils.disableRow("avaliableTable", index);
            });
        }

        $scope.text = {
            avaliableVms: appUtils.getStringWithColon("resMapping.term.availableVM.tab"),
            selectedVms: appUtils.getStringWithColon("resMapping.term.selectVM.tab"),
        };
        $scope.addProtectObjectsWizard = {
            id: "addProtectObjectsWizard",
            exclude: [],
            preview: false,
            steps: [{
                id: "avaliableVms",
                title: appUtils.getString("rm_term_volumn_step1_object"),
                templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/fusionsphere/protectVirtual.html"
            }, {
                id: "table",
                title: appUtils.getString("rm_term_volumn_step2_manage"),
                templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/fusionsphere/protectVolumn.html"
            }],
            previous: function(param) {},
            load: function(currentStep) {},
            active: function(currentStep) {
                if ($scope.model[currentStep.id].isInit) {
                    $scope.model[currentStep.id].isInit = false;
                    $scope.model[currentStep.id].queryData();
                }

                cacheDrTypeMap = {};
                $("#drVolumnTypeDetail").bind("click", $scope.model.table.linkFn);
            },
            finish: function(param) {
                var isOk = $scope.model.table.checkFinish();
                if (!isOk) {
                    return;
                }

                protectGroup.polist = [];
                restService.addProtectObject(protectGroup.uuid, {
                    data: $scope.model.table.getParam(),
                    success: function() {
                        var winInstance = $("#" + constsService.PG_AD_VIRTUAL_WIN.winId).widget();
                        winInstance.option("data", {close: true});
                        winInstance.destroy();
                    },
                });

            },
            next: function(param) {
                return $scope.model.avaliableVms.checkNext();
            },
            cancel: function(param) {
                var winInstance = $("#" + constsService.PG_AD_VIRTUAL_WIN.winId).widget();
                winInstance.option("data", {
                    close: false
                });
                winInstance.destroy();
            }
        };

        $scope.model = {
            productFusionsphere: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_product_fusionsphere"),
                id: "productFusionsphere",
                disable: true,
                defaultSelectid: "-1",
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "poProviderSN",
                label: "drFusionSphereName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            productRegion: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_product_region"),
                id: "productRegion",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "regionId",
                label: "regionName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            productProject: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_product_project"),
                id: "productProject",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                selectId: "projectId",
                label: "projectName",
                getValue: function() {},
                setValue: function(val) {},
                select: function() {},
                width: constsService.W3,
            },
            productZone: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_product_zone"),
                id: "productZone",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "zoneName",
                label: "zoneName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            drFusionsphere: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_dr_fusionsphere"),
                id: "drFusionsphere",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "drFusionSphereId",
                label: "drFusionSphereName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            drRegion: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_dr_region"),
                id: "drRegion",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "drRegionId",
                label: "drRegionName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            drProject: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_dr_project"),
                id: "drProject",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "drProjectId",
                label: "drProjectName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            drZone: {
                name: appUtils.getStringWithColon("rm_term_openstack_protect_dr_zone"),
                id: "drZone",
                defaultSelectid: "-1",
                disable: true,
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                select: function() {},
                selectId: "drZoneName",
                label: "drZoneName",
                getValue: function() {},
                setValue: function(val) {},
                width: constsService.W3,
            },
            selectBox: {
                "id": "selectBox",
                "left-values": [{
                    "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftTitle.html",
                    "title-type": "url",
                    "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftContent.html",
                    "content-type": "url"
                }],
                "right-values": [{
                    "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightTitle.html",
                    "title-type": "url",
                    "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightContent.html",
                    "content-type": "url",
                    "add": {
                        id: "addBtn",
                        click: function() {
                            var checkedItems = _avaliableTableFixer.getSelectedRow();
                            appUtils.union(selectedVms, checkedItems, tableKey);
                            _updateSelectedVms(selectedVms);
                            updateDisableRow();
                        }
                    },
                    "remove": {
                        id: "removeBtn",
                        click: function() {
                            var removeItems = _selectedTabelFixer.getSelectedRow();
                            appUtils.removeFromArray(selectedVms, removeItems, tableKey);
                            _selectedTabelFixer.remove(removeItems, tableKey);
                            _avaliableTableFixer.remove(removeItems, tableKey);
                            _updateSelectedVms(selectedVms);
                            updateDisableRow();
                            _avaliableTableFixer.selectRow();
                        }
                    }
                }],
                "setting": {
                    "left-width": "400px",
                    "height": "400px",
                    "right-width": "440px"
                }
            },
            avaliableVms: {
                id: "avaliableTable",
                isInit: true,
                columnsDraggable: false,
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                enablePagination: false,
                tableFixer: _avaliableTableFixer,
                data: [],
                checkbox: true,
                columns: [{
                    "bVisible": false,
                    "mData": tableKey
                }, {
                    "sTitle": appUtils.getString("current_alarm_term_name_column"),
                    "mData": "name",
                    "bSortable": false,
                    "sWidth": "320px"
                }],
                tHeadCheckboxFn: function() {
                    _avaliableTableFixer.click();
                },
                click: function(event, cell) {
                    _avaliableTableFixer.click();
                },
                callback: function(oPage) {
                    _avaliableTableFixer.pageQuery = true;
                    page = oPage.currentPage;
                    $scope.model.avaliableVms.queryData();
                },
                drawCallback: function() {
                    _avaliableTableFixer.selectRow();
                    updateDisableRow();
                },
                checkNext: function() {
                    var selectedTableData = $("#selectedTable").widget().getTableData();
                    if (selectedTableData.length == 0) {
                        message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate", appUtils.getString("resMapping.term.availableVM.tab")));
                        return false;
                    }

                    //比较moUuid
                    var array = [];
                    _.each(selectedTableData, function(data) {
                        this.push(data.moUuid);
                    }, array);

                    if (_.difference(array, cacheSelectVms)) {
                        $scope.model.table.isInit = true;
                    } else {
                        $scope.model.table.isInit = false;
                    }
                    cacheSelectVms = array;
                    return true;
                },
                queryData: function() {
                    var deviceSn = $("#productFusionsphere").widget().getSelectedId();
                    var regionId = $("#productRegion").widget().getSelectedId();
                    var zoneName = $("#productZone").widget().getSelectedId();
                    var projectId = $("#productProject").widget().getSelectedId();
                    var oQuery = {
                        poType: 12,
                        deviceSn: deviceSn,
                        _FILTER: queryCondition || "",
                        _PAGE: appUtils.queryFilter(page - 1, 10, orderBy, orderType)
                    };
                    oQuery.deviceSn = $.base64.encode(oQuery.deviceSn);
                    oQuery._FILTER += "&extFilter.regionId=" + regionId + "&extFilter.projectId=" + projectId + "&extFilter.zoneName=" + zoneName;

                    if (deviceSn == "-1") {
                        return;
                    }

                    $scope.maskDualSelectBox = $.Deferred();
                    $scope.$apply();
                    restService.pageQueryAvailableProtectObject(oQuery, {
                        mask: false,
                        success: _updateAvaliableVms,
                        callback: function() {
                            $scope.maskDualSelectBox.resolve();
                        }
                    });
                }
            },
            selectedVms: {
                id: "selectedTable",
                columnsDraggable: false,
                displayLength: constsService.TABLE_COUNT_PER_PAGE,
                enablePagination: false,
                tableFixer: _selectedTabelFixer,
                data: [],
                checkbox: true,
                columns: [{
                    "bVisible": false,
                    "mData": tableKey
                }, {
                    "sTitle": appUtils.getString("current_alarm_term_name_column"),
                    "mData": "name",
                    "bSortable": false,
                    "sWidth": "320px"
                }],
                tHeadCheckboxFn: function() {
                    _selectedTabelFixer.click();
                },
                click: function(event, cell) {
                    _selectedTabelFixer.click();
                },
                drawCallback: function() {
                    _selectedTabelFixer.selectRow();
                }
            },
            leftSearchSelect: {
                id: "leftSearchSelect",
                isHide: true,
                values: [{
                    selectId: "name",
                    label: appUtils.getString("current_alarm_term_name_column")
                }],
                defaultSelectid: "name"
            },
            rightSearchSelect: {
                id: "rightSearchSelect",
                isHide: true,
                values: [{
                    selectId: "name",
                    label: appUtils.getString("current_alarm_term_name_column")
                }],
                defaultSelectid: "name"
            },
            leftSearch: {
                id: "leftSearchBox",
                searchFn: function(query) {
                    query = appUtils.formatSearchVal(query);
                    var key = "name";
                    queryCondition = query ? "extFilter." + key + "=" + query : "";
                    $scope.model.avaliableVms.queryData();
                }
            },
            rightSearch: {
                id: "rightSearchBox",
                searchFn: function(query) {
                    selectedVmsQuery = $.trim(query);
                    _updateSelectedVms(selectedVms);
                }
            },
            search: {
                "id": "vmSearch",
                "values": [{
                    selectId: "0",
                    label: appUtils.getString("rm_term_volumn_column_virtual")
                }],
                "display": true,
                "disable": false,
                "showTip": true,
                "isSearchbox": true,
                "defaultSelectid": "0",
                "width": constsService.W1 + 40,
                "change": function() {},
                "click": function(query) {
                    var inputValue = $.trim($("#vmSearch").widget().getSearchboxValue().inputValue);
                    $scope.model.table.data = _.filter(vmTableData, function(value, key, list) {
                        return value["moName"].indexOf(inputValue) != -1;
                    });
                    $scope.$apply();
                    if (_.size($scope.model.table.data) == 0) {
                        $("#drVolumnTypeDetail").unbind("click");
                        $("#drVolumnTypeDetail").removeClass('btn-link').addClass('btn-link-disable');
                        return;
                    };
                    $("#drVolumnTypeDetail").removeClass('btn-link-disable').addClass('btn-link');
                    $("#drVolumnTypeDetail").bind("click", $scope.model.table.linkFn);
                    $scope.model.table.openNode();
                }
            },
            table: {
                id: "datasVolumesTable",
                data: [],
                isInit: true,
                columns: [{
                    "sTitle": "",
                    "mData": "detail",
                    "bSearchable": false,
                    "bSortable": false,
                    "sWidth": "60px"
                }, {
                    "sTitle": "",
                    "mData": "moUuid",
                    "bSortable": false,
                    "bVisible": false,
                }, {
                    "sTitle": appUtils.getString("common_term_name_label"),
                    "mData": "moName",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_type"),
                    "mData": "volumeType",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_dr_type"),
                    "mData": "drVolumeType",
                    "bSortable": false
                }],
                linkFn: function() {
                    var win = _.clone(constsService.OPENSTACK_DR_VOLUMN_SETTING_WIN);
                    win.helpId = "ADD_PO_WIN";
                    win.title = appUtils.getString(win.title);
                    win.data = $("#datasVolumesTable").widget().getTableData();
                    appUtils.showWindow(win, function() {
                        var options = this.options,
                            closeFlag = true,
                            batchVolumeData = $("#volumesDiffTable").widget().getTableData();

                        $scope.model.table.openNode(function(){
                            $.each(batchVolumeData, function(index, v1) {
                                var v1widget;
                                if(v1.volumeId.indexOf(".") != "-1"){
                                    v1widget = $('#' + v1.volumeId.replace(/\./g,'\\.')).widget();
                                }else{
                                    v1widget = $("#" + v1.volumeId).widget();
                                }

                                if (v1widget.getSelectedId() == "-1") {
                                    closeFlag = false;
                                    message.error(appUtils.getString("rm_term_drVolumn_type_validate"));
                                    return false;
                                }

                                _.each($("#datasVolumesTable").widget().getTableData(), function(v2) {

                                    _.each(_.where(v2.volumes, {"volumeType": v1.volumeType}), function(v3) {

                                        var v3widget = $("#" + appUtils.covertSpecialChar(v3.volumeId) + this).widget(),
                                            label = $.trim(v1widget.getSelectedLabel()),
                                            object = _.findWhere(v3widget.option("values"), {"label": label});

                                        if (!_.isEmpty(object)){
                                            v3widget.opChecked(object.selectId);
                                        } else {
                                            v3widget.opLabel(v3widget.getSelectedId(), label);
                                        }

                                        if (!_.has(cacheDrTypeMap, appUtils.covertSpecialChar(v3.volumeId) + appUtils.covertSpecialChar(v2.moUuid))) {
                                            cacheDrTypeMap[appUtils.covertSpecialChar(v3.volumeId) + appUtils.covertSpecialChar(v2.moUuid)] = {selectId: v1widget.getSelectedId(),label: label};
                                        } else {
                                            _.extend(cacheDrTypeMap[appUtils.covertSpecialChar(v3.volumeId) + appUtils.covertSpecialChar(v2.moUuid)], {selectId: v1widget.getSelectedId(),label: label});
                                        }

                                    }, appUtils.covertSpecialChar(v2.moUuid));
                                });

                            });

                            closeFlag && $("#" + options.winId).widget().destroy();
                        });
                    });
                },
                showDetails: {
                    "colIndex": 0,
                    "domPendType": "nopend",
                    "openClick": function(event, aData) {
                        var createNode = function(volumeId, moUuid) {
                            var select = "<tiny-select id='smodel.id' select='smodel.select()' values='smodel.values' default-selectid='smodel.defaultId' width='smodel.width' auto-open='smodel.autoOpen' close-fn='smodel.closeFn' open-fn='smodel.openFn'></tiny-select>";
                            var selectLink = $compile(select);
                            var selectScope = $scope.$new();
                            selectScope.smodel = {
                                id: volumeId + moUuid,
                                defaultId: "-1",
                                values: [{
                                    "selectId": "-1",
                                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                                }],
                                width: constsService.W2 + 30,
                                select: function() {},
                                autoOpen: function() {},
                                closeFn: function() {
                                    var widget = $("#" + this.id).widget();
                                    var selectedObj = {selectId: widget.getSelectedId(),label: widget.getSelectedLabel()};

                                    if (!_.has(cacheDrTypeMap, volumeId + moUuid)) {
                                        cacheDrTypeMap[volumeId + moUuid] = {selectId: widget.getSelectedId(),label: widget.getSelectedLabel()};
                                    } else {
                                        _.extend(cacheDrTypeMap[volumeId + moUuid], {selectId: widget.getSelectedId(),label: widget.getSelectedLabel()});
                                    }

                                    var len = $('.tiny-select[id*=' + volumeId + ']').length;
                                    for (var index = 0; index < len; index++) {
                                        $('.tiny-select[id*=' + volumeId + ']').eq(index).widget().selected = [widget.getSelectedId()];
                                        $('.tiny-select[id*=' + volumeId + '] .tiny-select-text').eq(index).val(widget.getSelectedLabel());
                                    }
                                },
                                openFn: function(object) {
                                    var params = {
                                        openstackId: $("#productFusionsphere").widget().getSelectedId(),
                                        regionId: $("#drRegion").widget().getSelectedId(),
                                        projectId: $("#drProject").widget().getSelectedId(),
                                        srcRegionId: $("#productRegion").widget().getSelectedId(),
                                        srcProjectId: $("#productProject").widget().getSelectedId(),
                                        srcVolumeTypeName: $.trim($("#volumeType_" + volumeId).text())
                                    };
                                    var context = this;
                                    restService.getOpenStackVolumeType(params, {
                                        success: function(result) {
                                            var vals = [];
                                            _.each(result, function(r) {
                                                vals.push({
                                                    selectId: appUtils.covertSpecialChar(r.volumeTypeId),
                                                    label: r.volumeTypeName
                                                })

                                            });
                                            vals.push({selectId: "-1", label: appUtils.getString("common_term_pleaseSelect_listbox")});
                                            $("#" + context.id).widget().option("values", vals);
                                            object.open();
                                        }
                                    })
                                }
                            }

                            if (_.has(cacheDrTypeMap, volumeId + moUuid)) {
                                selectScope.smodel.values = [cacheDrTypeMap[volumeId + moUuid]];
                                selectScope.smodel.defaultId = cacheDrTypeMap[volumeId + moUuid].selectId;
                            }
                            var selectNode = selectLink(selectScope);
                            selectScope.$evalAsync();
                            $("td[id='drVolumeType_" + volumeId + moUuid + "']").html(selectNode);
                        };

                        var tr = $(event.target).parents("tr")[0];
                        var dsData = $("#datasVolumesTable").widget().getTableData(tr);
                        var child = angular.copy(dsData.volumes);
                        var moUuid = appUtils.covertSpecialChar(dsData.moUuid);
                        var html = "";
                        for (var z = 0; z < child.length; z++) {
                            var volumeName = $.encoder.encodeForHTML(child[z].volumeName);
                            var volumeId = appUtils.covertSpecialChar(child[z].volumeId);
                            var volumeType = child[z].volumeType;
                            html += '<tr class="odd clickTrColor" parentId="' + dsData.moUuid + '">';
                            html += '<td tdname="detail" class="tiny-tdStyle"></td>';
                            html += '<td tdname="volumeName" class="tiny-tdStyle" id="volumeName_' + volumeId + '" style="padding-left:20px">' + volumeName + '</td>';
                            html += '<td tdname="volumeType" class="tiny-tdStyle" id="volumeType_' + volumeId + '">' + volumeType + '</td>';
                            html += '<td tdname="drVolumeType" class="tiny-tdStyle"id="drVolumeType_' + volumeId + moUuid + '"></td></tr>';
                        }

                        $(event.target).parents("tr").eq(0).after(html);
                        _.each(child, function(volume) {
                            createNode(appUtils.covertSpecialChar(volume["volumeId"]), this);
                        }, moUuid);
                    },
                    "closeClick": function(event, aData) {
                        var trObj = $(event.target).parents("tr")[0];
                        trObj = $("#datasVolumesTable").widget().getTableData(trObj);

                        $(event.target).parents("tr").eq(0).nextAll().filter(
                            function() {
                                return $(this).attr("parentId") === $("#datasVolumesTable").widget().getTableData($(event.target).parents("tr")[0]).moUuid;
                            }).unbind().remove();
                    }
                },
                openNode: function(callback) {
                    var switchDiv = $("div.default_show_style");
                    if (switchDiv && switchDiv.length != 0) {
                        switchDiv.click();
                    }
                    setTimeout(function() {
                        _.isFunction(callback) && callback();
                    }, 20);
                },
                "closeClick": function(event, aData) {
                },
                callback: function(evtObj) {
                    $scope.model.table.defaultSelectId = undefined;
                },
                renderRow: function(nRow, aData, iDataIndex) {
                    $("td:eq(0)", nRow).html("<div class='default_show_style btn-link'>&nbsp;</div>");
                },
                cellClickActive: function(e, param, isFind) {},
                drawCallback: function(oSetting) {},
                defaultSelectId: undefined,
                desc: $sce.trustAsHtml(appUtils.getString("rm_term_volumn_table_desc", appUtils.getString("rm_term_volumn_table_desc_param"))),
                checkFinish: function() {
                    var dataTable = $("#datasVolumesTable").widget().getTableData(), valid = true;

                    $.each(dataTable, function(index, data) {
                        var moUuid = appUtils.covertSpecialChar(data["moUuid"]);
                        $.each(data.volumes, function(index, volume) {
                            var volumeId = appUtils.covertSpecialChar(volume.volumeId);
                            var drVolumeTypewidget = $("#" + volumeId + moUuid).widget();

                            //节点关闭，从缓存中获取数据进行判断
                            if (_.isUndefined(drVolumeTypewidget)) {
                                if (!_.has(cacheDrTypeMap, volumeId + moUuid) || cacheDrTypeMap[volumeId + moUuid].label == appUtils.getString("common_term_pleaseSelect_listbox")) {
                                    valid = false;
                                    return false;
                                }
                            } else {
                                if ( drVolumeTypewidget.getSelectedId() == "-1" && drVolumeTypewidget.getSelectedLabel() == appUtils.getString("common_term_pleaseSelect_listbox")) {
                                    valid = false;
                                    return false;
                                }
                            }
                        })

                        if (!valid) return false;
                    });

                    if (!valid) {
                        message.error(appUtils.getString("rm_term_drVolumn_type_validate"));
                        return false;
                    }

                    return true;
                },
                getParam: function() {
                    var polist = [];
                    _.each($("#datasVolumesTable").widget().getTableData(), function(d) {
                        var temp = {},
                            volumeConfig = [];

                        temp["moUuid"] = d.moUuid;
                        _.each(d.volumes, function(v, index) {
                            var volumeId = appUtils.covertSpecialChar(v["volumeId"]);
                            var moUuid = appUtils.covertSpecialChar(temp["moUuid"]);
                            var drVolumeType = "";

                            if (_.isUndefined(cacheDrTypeMap[volumeId + moUuid])) {
                                drVolumeType = $("#" + volumeId + moUuid).widget().getSelectedLabel();
                            } else {
                                drVolumeType = cacheDrTypeMap[volumeId + moUuid].label;
                            }

                            volumeConfig.push({
                                volumeId: v.volumeId,
                                drVolumeType: drVolumeType,
                                volumeType: $.trim($("#volumeType_" + volumeId).text()),
                                volumeName: $.trim($("#volumeName_" + volumeId).text())
                            });
                        });

                        temp["props"] = {"volumeConfig": JSON.stringify(volumeConfig)};

                        polist.push(temp);
                    });

                    return polist;
                },
                queryData: function() {
                    var queryProps = {};
                    var moUuids = [];
                    _.each(selectedVms, function(vm) {
                        moUuids.push(vm.moUuid);
                    });
                    queryProps.regionId = protectGroup['props']['regionId'];
                    queryProps.projectId = protectGroup['props']['projectId'];
                    restService.getOpenStackVolumes(queryProps, {
                        data: moUuids,
                        success: function(result) {
                            var arr = [];
                            _.each(result, function(d) {
                                _.extend(d, {
                                    "detail": {
                                        contentType: "simple",
                                        content: ""
                                    }
                                });

                                var tmo = _.pick(d, "detail", "volumes", "moName", "moUuid");
                                arr.push(tmo);
                            });

                            $scope.model.table.data = appUtils.encodeForHTML(arr);
                            $scope.$apply();
                            $scope.model.table.openNode();
                            vmTableData = _.clone($scope.model.table.data);
                        }
                    });
                }
            }

        }

        var _updateAvaliableVms = appUtils.newUpdateTable($scope.model.avaliableVms, $scope);
        var _init = function() {
            protectGroup = $("#" + constsService.PG_AD_VIRTUAL_WIN.winId).widget().option("data");
            _.each($scope.model, function(model) {
                if (_.isObject(model) && _.isFunction(model.setValue)) {

                    var label = protectGroup.props[model.label];
                    var selectId = protectGroup.props[model.selectId];
                    if ("poProviderSN" == model.selectId) {
                        selectId = protectGroup["poProviderSN"];
                    }

                    if (_.isUndefined(label) && _.isUndefined(selectId)) {
                        selectId = "-1";
                        label = appUtils.getString("common_term_pleaseSelect_listbox");
                    } else if (_.isEmpty(selectId) || _.isEmpty(label)) {
                        _.isEmpty(selectId) && (selectId = "-1");
                        _.isEmpty(label) && (label = appUtils.getString("common_term_pleaseSelect_listbox"));
                    }

                    model.values = [{
                        "selectId": selectId,
                        "label": label,
                        "checked": true
                    }];
                    model.defaultSelectid = selectId;
                    $scope.$apply();
                }
            });
        }

        _init();

    }];

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("addOpenstackVirtualWinCtrl", ctrl);
    return module;
});
