define([], function() {
    var ctrl = ["$scope", "$state", "$timeout", "$injector", "$compile", "message", "appUtils", "constsService", "model", "restService", "exception",
        function($scope, $state, $timeout, $injector, $compile, message, appUtils, constsService, Model, restService, exception) {

            var updateTable;
            var page = 1;
            var orderBy;
            var orderType;
            var tableFixer;
            var _promise;
            //卷管理窗口
            var openManageWin = function(param){
                var win = angular.copy(constsService.VOLUME_MANAGE_WIN);
                win.title = appUtils.getString(param.title);
                win.data = $scope.protectGroup;
                if(param.title == "volume_manage_has_protected"){
                    win.buttons = [{
                        key: "ok",
                        label: appUtils.getString('common_term_close_button'),
                        focused: false,
                        handler: function(event){
                            $("#" + win.winId).widget().destroy();
                        }
                    }];
                }
                win.close = function() {
                    if ($("#" + constsService.VOLUME_MANAGE_WIN.winId).widget().option("data")["close"]) {
                        return;
                    }
                    $scope.model.table.curPage = {
                        "pageIndex": 1
                    };
                    page = 1;
                    pageQuery();
                };
                appUtils.showWindow(win);
            };

            var changeStatus = function(){
                if (!$scope.protectGroup.primary || _.contains([3, 4, 5], $scope.protectGroup.status)){
                    $("#voliume_manage .tiny-menubutton-main-a").css('cursor','default');
                    $scope.model.manage.text = "<span class='iconbutton-setting-disabled' style='float:left;'></span><span class='btn-link-disable'>"+appUtils.getString("rm_term_volumn_manage")+"</span>";
                    $scope.model.manage.content = [];
                    $scope.$apply();
                }else if($scope.protectGroup.props.serviceInstanceType == "replication"){
                    $("#voliume_manage .tiny-menubutton-main-a").css('cursor','pointer');
                    $scope.model.manage.text = "<span class='iconbutton-setting' style='float:left;'></span><span class='btn-link'>"+appUtils.getString("rm_term_volumn_manage")+"</span>";
                    $scope.model.manage.content = [{
                       title: "<span class='menu-item-btn'>"+appUtils.getString("volume_manage_has_protected")+"</span>",
                       click: function(){
                           _.extend($scope.protectGroup,{
                               protectedVolume:true,
                               unProtectedVolume:false,
                               removedVolume:false
                           });
                           openManageWin({title:"volume_manage_has_protected"});
                       }
                    }]
                }else{
                    $("#voliume_manage .tiny-menubutton-main-a").css('cursor','pointer');
                    $scope.model.manage.text = "<span class='iconbutton-setting' style='float:left;'></span><span class='btn-link'>"+appUtils.getString("rm_term_volumn_manage")+"</span>";
                    $scope.model.manage.content = [{
                        title: "<span class='menu-item-btn'>"+appUtils.getString("volume_manage_has_protected")+"</span>",
                        click: function(){
                            _.extend($scope.protectGroup,{
                                protectedVolume:true,
                                unProtectedVolume:false,
                                removedVolume:false
                            });
                            openManageWin({title:"volume_manage_has_protected"});
                        }
                    },{
                        title: "<span class='menu-item-btn'>"+appUtils.getString("volume_manage_un_protected")+"</span>",
                        click: function(){
                            _.extend($scope.protectGroup,{
                                protectedVolume:false,
                                unProtectedVolume:true,
                                removedVolume:false
                            });
                            openManageWin({title:"volume_manage_un_protected"});
                        }
                    },{
                        title: "<span class='menu-item-btn'>"+appUtils.getString("volume_manage_removed_protected")+"</span>",
                        click: function(){
                            _.extend($scope.protectGroup,{
                                protectedVolume:false,
                                unProtectedVolume:false,
                                removedVolume:true
                            });
                            openManageWin({title:"volume_manage_removed_protected"});
                        }
                    }];
                    $scope.$apply();
                }
            };

            $scope.model = {
                maskFlag: true,
                checkRight: appUtils.checkRight,
                refresh: {
                    tooltip: appUtils.getString("common_term_refresh_button"),
                    click: pageQuery
                },
                add: {
                    disable: true,
                    name: appUtils.getString("common_term_add_button"),
                    click: function() {
                        if (this.disable) return;
                        var win = angular.copy(constsService.PG_AD_VIRTUAL_WIN);
                        win.title = appUtils.getString(win.title);
                        win.data = $scope.protectGroup;
                        win.close = function() {
                            if (!$("#" + constsService.PG_AD_VIRTUAL_WIN.winId).widget().option("data")["close"]) {
                                return;
                            }

                            message.prompt({
                                content: appUtils.getString("site_term_refresh_message"),
                                ok: function() {
                                    $scope.model.table.curPage = {
                                        "pageIndex": 1
                                    };
                                    page = 1;
                                    pageQuery();
                                }
                            })
                        };
                        appUtils.showWindow(win);
                    }
                },
                manage: {
                    disable: true,
                    id:"voliume_manage",
                    text:"<span class='iconbutton-setting-disabled' style='float:left;'></span><span class='btn-link-disable'>"+appUtils.getString("rm_term_volumn_manage")+"</span>",
                    content:[]
                },
                del: {
                    name: appUtils.getString("ism.drm.common.action.remove"),
                    disable: true,
                    click: function() {
                        if (this.disable) return;
                        var polist = $("#openStackPgObjectTable").widget().getTableCheckedItems();
                        polist.forEach(function(item) {
                            delete item.props;
                        });
                        var pg = new Model.ProtectGroup({
                            pgId: $scope.protectGroup.pgId,
                            polist: polist,
                            poType: $scope.protectGroup.poType
                        });
                        pg.delProtectObject({
                            "interceptor": function(next) {
                                var msg = appUtils.getString("protectionGroup.task.removevm.opcontent.label") + "<br>" +
                                    appUtils.getString("protectionGroup.task.removevm.opresult.label") + "<br>" +
                                    appUtils.getString("common.task.execute.danger.message");

                                message.warn({
                                    content: msg,
                                    ok: function() {
                                        next();
                                    }
                                });
                            },
                            "success": function() {
                                var msg = appUtils.getString("site_term_refresh_message");
                                message.prompt({
                                    content: msg,
                                    ok: function() {
                                        page = 1;
                                        $scope.model.table.curPage = {
                                            "pageIndex": 1
                                        };
                                        pageQuery();
                                    }
                                });
                            }
                        });
                    }
                },
                table: {
                    id: "openStackPgObjectTable",
                    paginationStyle:"full_numbers",
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    enablePagination: false,
                    checkbox: true,
                    checkedItemNum: 0,
                    tableFixer: tableFixer,
                    columns: [{
                        "bVisible": false,
                        "mData": "moUuid"
                    },{
                        "sTitle": appUtils.getString("common_term_name_label"),
                        "mData": "name"
                    },{
                        "sTitle": appUtils.getString("common_term_openstack_name_column_label"),
                        "mData": "providerName",
                        "bSortable": false
                    },{
                        "sTitle": appUtils.getString("common_term_openstack_region_column_label"),
                        "mData": "props.regionId",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_openstack_project_column_label"),
                        "mData": "props.projectName",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("common_term_openstack_zone_column_label"),
                        "mData": "props.zoneName",
                        "bSortable": false
                    }],
                    tHeadCheckboxFn: function() {
                        tableFixer.click();
                        btnCtrl();
                    },
                    click: function(event, cell) {
                        tableFixer.click();
                        btnCtrl();
                    },
                    renderRow: function(nRow, aData, iDataIndex) {

                    },
                    callback: function(oPage) {
                        page = oPage.currentPage;
                        tableFixer.pageQuery = true;
                        pageQuery();
                        tableFixer.clear();

                    },
                    sortCallback: function(nNode, sortArr) {
                        orderBy = $scope.model.table.columns[sortArr[0][0] - 1].mData;
                        orderType = sortArr[0][1];
                        page = 1;
                        tableFixer.pageQuery = true;
                        pageQuery();
                    },
                    drawCallback: function() {
                        tableFixer && tableFixer.selectRow();
                    }
                }
            }

            //监听选择保护组事件,刷新界面
            $scope.$on(constsService.PG_SELECT_EVENT, function(e, param) {
                $scope.protectGroup = param.protectGroup;
                page = 1;
                orderBy = "";
                orderType = "";
                $scope.model.table.curPage = {"pageIndex": 1};
                pageQuery();
            });

            $scope.isPrivateConsole = window.isPrivateConsole;

            var updatePgListTable = appUtils.newUpdateTable($scope.model.table, $scope),
                tableFixer = appUtils.tableFixer("openStackPgObjectTable", "moUuid");

            function btnCtrl() {

                //openstack云双活屏蔽操作
                if($scope.protectGroup.template.type == 25 || $scope.protectGroup.template.type == 29) {return};

                //openstack云主备屏蔽添加、删除操作
                if($scope.protectGroup.props.serviceInstanceType == "replication"){
                    $scope.model.add.disable = true;
                    $scope.model.del.disable = true;
                    $scope.model.manage.disable = false;
                    $scope.$apply();
                    return;
                }

                //锁定、正在执行、失效
                if (!$scope.protectGroup.primary || _.contains([3, 4, 5], $scope.protectGroup.status)) return;
                if ( $("#openStackPgObjectTable").length == 0 || $("#openStackPgObjectTable").widget().getTableCheckedItems().length == 0) {
                    $scope.model.add.disable = false;
                    $scope.model.del.disable = true;
                    $scope.model.manage.disable = false;
                    $scope.$apply();
                    return;
                }

                $scope.model.add.disable = false;
                $scope.model.del.disable = false;
                $scope.model.manage.disable = false;
                $scope.$apply();
            }

            function pageQuery(flag, isShowMsgBox) {
                var _mask = flag || _.isUndefined(flag)
                var config = {
                    "mask":_mask,
                    "isShowMsgBox": _.isUndefined(isShowMsgBox),
                    "success": function(data) {
                        updatePgListTable(data);
                        btnCtrl();
                        changeStatus();
                        if (appUtils.checkPageForward(page, data)) {
                            page = 1;
                            $scope.model.table.curPage = {
                                "pageIndex": 1
                            };
                            pageQuery();
                        }
                    }
                };

                if(_mask){
                   $scope.maskFlag = false;
                   $scope.maskHandle = $.Deferred();
                   $scope.$apply();
                   config.callback = function() {
                       $scope.maskHandle.resolve();
                       $scope.maskFlag = true;
                       $scope.$apply();
                   };
                }


                restService.queryProtectObjectsByPage({
                    protectgroupId: $scope.protectGroup.pgId,
                    _PAGE: appUtils.queryFilter(page - 1, 10, orderBy, orderType)
                }, config);
            }

            function autoRefresh(){
                if($scope.$$destroyed
                        || _.isEmpty(_.findWhere($("#pgTable").widget().getTableData(), $scope.protectGroup.pgId))){
                    $timeout.cancel(_promise);
                }else{
                    pageQuery(false, false);
                    _promise = $timeout(autoRefresh,3000)
                }
            }

            _promise = $timeout(autoRefresh,3000)

            pageQuery();

        }
    ];
    return ctrl;
});
