define(["tiny-lib/angular"],
function(angular){
	var ctrl = ["$scope","$state","$timeout","$injector","$compile","$controller","message","appUtils","constsService","model","restService","exception", "statusEnumService",
	function($scope,$state,$timeout,$injector,$compile, $controller, message, appUtils,Consts,Model,Rest,exception,statusEnumService){
			if(!$scope.$parent.tabShow) return;
			if (_.contains([21, 22, 25, 29, 34, 37], $scope.protectGroup.template.type)) {
				var html = "app/business/recoverydirector/protection/views/protectiongroup/fusionsphere/openstackProtectionObjectList.html";
				var ctrl = "app/business/recoverydirector/protection/controllers/protectiongroup/fusionsphere/openstackProtectionObjectListCtrl";
				$("#openstackPgObjectList").append($("<div></div>").load(html, function() {
				    require([ctrl], function(ctrl) {
				        var newScope = $scope.$new();
				        newScope[ctrl] = ctrl;
				        newScope.protectGroup = $scope.protectGroup;
				        $controller(ctrl, {$scope: newScope});
				        $compile($("#openstack-pg-container").contents())(newScope);
				        $scope.$apply();
				    });
				}))

				$("#maskHandleDiv").hide();
				return;
			};

			var protectGroup = $scope.protectGroup;
			var isHostRep;
			var updateTable;
			var page = 1, orderBy, orderType;
			var tableFixer;
			var addPopWin = angular.copy(Consts.VM_ADD_PO_WIN);
			var resource = appUtils.resource();
			var promise;
			var isAutoRefresh = false;
			var showSnapLastCreateTime = false;

			$scope.checkRight = appUtils.checkRight;
			$scope.maskFlag = false;
			$scope.refreshText = appUtils.getString("common_term_refresh_button");
			$scope.operShow  = true;
			$scope.extraOperShow = true;
			$scope.hostRepTableShow = true;
			$scope.arrayRepTableShow = true;
			$scope.visTableShow = true;
			$scope.fusionStorageRepShow = true;
			/*容灾状态表(po.props.drStatus)
			 * 删除(0)  一致性校验(1) 差量复制(2) 初始同步(3) 暂停容灾(4) 恢复容灾(5) (1:可操作 0:不能操作)
			 *
			 * */
			var statusMap = {
				0:[1,1,1,1,0,0],
				1:[1,1,0,0,1,0],
				2:[1,1,0,0,1,0],
				3:[1,1,0,0,1,0],
				4:[1,0,0,0,0,0],
				5:[1,1,0,0,1,0],
				6:[1,0,0,0,0,1],
				7:[1,0,0,0,0,0],
				8:[0,0,0,0,0,0],
				9:[0,0,0,0,0,0]
			};

			$scope.btns = {
				add : {
					name : appUtils.getString("common_term_add_button"),
					click : function(){
						//san双活
						if(protectGroup.props.protectType == "HyperMetro"){
							var win = angular.copy(Consts.VM_NAS_PO_MODIFY);
							win.title = appUtils.getString(win.title);
							win.close = function(){
					            appUtils.getWinData() === true && init();
					        };
							appUtils.openWin(win, {protectGroup:protectGroup,type:"add",protectionType:"HyperMetro"});
						}
						else{
							appUtils.openWin(addPopWin , {
				            	protectGroup : protectGroup
				        	});
						}
					}
				},
				del : {
					name : appUtils.getString("ism.drm.common.action.remove"),
					click : function(){
						if(protectGroup.props.protectType == "HyperMetro"){
							var win = angular.copy(Consts.VM_NAS_PO_MODIFY);
							win.title = appUtils.getString("protection_object_task_removeObject_title");
							win.close = function(){
					            appUtils.getWinData() === true && init();
					        };
							appUtils.openWin(win, {protectGroup:protectGroup,type:"del",protectionType:"HyperMetro"});
						}
						else{
							var polist = Model.util.generatePoListFromTable(tableFixer);
							polist.forEach(function(item){
								delete item.props;
							});
							var pg = new Model.ProtectGroup({
								pgId   : protectGroup.pgId,
								polist : polist,
								poType : protectGroup.poType
							});
							pg.delProtectObject({
								"interceptor"  : function(next){
									var msg = resource.get("protectionGroup.task.removevm.opcontent.label") + "<br>" +
											  resource.get("protectionGroup.task.removevm.opresult.label") + "<br>" +
											  resource.get("common.task.execute.danger.message");

				        			message.warn({
				        				content : msg,
				        				ok : function(){
				        					next();
				        				}
				        			});
				        		},
								"success" : function(){
									var msg = appUtils.getString("site_term_refresh_message");
									message.prompt({content:msg,ok:function(){
										page = 1;
										$scope.hostRepTable.curPage   = {"pageIndex": 1};
										$scope.arrayRepTable.curPage  = {"pageIndex": 1};
										$scope.visDoubleTable.curPage = {"pageIndex": 1};
										pageQuery();
									}});
								}
							});
						}
					}
				},
				start : {
					name : appUtils.getString("ism.drm.protect.group.start.label"),
					click : function(){

						var config = angular.copy(Consts.startFusionsphereLink);
						config.title = appUtils.getString(config.title);
						config.close = function(){
				            appUtils.getWinData() === true && $scope.refresh();
				        };

						appUtils.openWin(config , {
							 pgId : protectGroup.pgId,
							 moUuid : getMoUuids(),
							 status : getAvaliableActionInStart()
				        });
					}
				},
				stop : {
					name : appUtils.getString("ism.drm.protect.group.stop.label"),
					click : function(){
						var config = {
							data : {
								pgId : protectGroup.pgId,
								moUuid : getMoUuids(),
								opertionType : 2
							},
							interceptor  : function(next){
								var msg = resource.get("protectionGroup.task.pausevmdr.opcontent.label") + "<br>" +
								  resource.get("protectionGroup.task.pausevmdr.opresult.label") + "<br>" +
								  resource.get("common.task.execute.danger.message");

			        			message.warn({
			        				content : msg,
			        				ok : function(){
			        					next();
			        				}
			        			});
			        		},
							success : function(){
								var msg = appUtils.getString(appUtils.getString("common_term_operation_success_label"));
								message.success({content:msg,ok:function(){
									$scope.refresh();
								}});
							}
						};

						Rest.exeProtectAction("",config);
					}
				},
				recovery : {
					name : appUtils.getString("ism.drm.protect.group.recovery.label"),
					click : function(){
						var config = {
							data : {
								pgId : protectGroup.pgId,
								moUuid : getMoUuids(),
								opertionType : 3
							},
							success : function(){
								var msg = appUtils.getString(appUtils.getString("common_term_operation_success_label"));
								message.success({content:msg,ok:function(){
									$scope.refresh();
								}});
							}
						};

						Rest.exeProtectAction("",config);
					}
				}
			};

			//主机复制
			$scope.hostRepTable = {
				id : "hostRepTable",
				paginationStyle:"full_numbers",
				displayLength : Consts.TABLE_COUNT_PER_PAGE,
	            checkbox : true,
	            tableFixer : tableFixer,
	            columns:[{
						"bVisible" : false,
						"mData" : "moUuid"
					}, {
						"sTitle" : appUtils.getString("common_term_name_label"),
						"mData" : "name"
					}, {
						"sTitle" : "ID",
						"mData" : "props.vmId",
						"bSortable" : false
					},{
						"sTitle" : appUtils.getString("common_term_system_label"),
						"mData" : "props.osType"
					}, {
						"sTitle" : appUtils.getString("recovery.term.colum.process.title"),
						"mData" : "props.drProgress",
						"bSortable" : false
					}, {
						"sTitle" : appUtils.getString("common_term_DRStatus_column"),
						"mData" : "props.drStatus",
						"bSortable" : false
					}, {
						"sTitle" : appUtils.getString("common_term_whetherMeetRPO_column"),
						"mData" : "props.rpoStatus",
						"bSortable" : false
					}, {
						"sTitle" : appUtils.getString("common_term_whetherInitialSync_column"),
						"mData" : "props.initSyncStatus",
						"bSortable" : false
					}
				],
				tHeadCheckboxFn : function(){
					tableFixer.click();
					btnCtrl();
				},
				click : function(event, cell){
					tableFixer.click();
					btnCtrl();
				},
			    renderRow : function(nRow, aData, iDataIndex){
			    	//进度条,只有在初始同步和一致性校验的时候显示(1,4)
			    	if( aData.props.drStatus=="1" || aData.props.drStatus=="4" ){
				    	var progressColumn = "<div class='progressbar'><tiny-progressbar label-position='position' color='color' value='value' width='width' height='height'></tiny-progressbar></div>";
	                    var compiledColumn = $compile(progressColumn);
	                    var scope = $scope.$new();
	                    scope.value = aData.props.drProgress;
	                    scope.position = "right";
	                    scope.width  = "110px";
	                    scope.height = "10px";
	                    scope.color  = Consts.COLOR_GREEN;
	                    var progressNode = compiledColumn(scope);
	                    $("td:eq(4)", nRow).html(progressNode);
                    }else{
                    	 $("td:eq(4)", nRow).html("--");
                    }

                    //dr状态
                    var drStatusMap = {
                     0:resource.get("protectionGroup.term.vm.drstatus.stop.label"),
                     1:resource.get("protectionGroup.term.vm.drstatus.drbegin.label"),
                     2:resource.get("protectionGroup.term.vm.drstatus.blockcopy.label"),
                     3:resource.get("protectionGroup.term.vm.drstatus.continuousIO.label"),
                     4:resource.get("protectionGroup.term.vm.drstatus.consistencycheck.label"),
                     5:resource.get("protectionGroup.term.vm.drstatus.diffsyn.label"),
                     6:resource.get("protectionGroup.term.vm.drstatus.pause.label"),
                     7:resource.get("protectionGroup.term.vm.drstatus.unlinked.label"),
                     8:resource.get("protectionGroup.term.vm.drstatus.exception.label"),
                     9:resource.get("protectionGroup.term.vm.drstatus.unprotected.label")
                    };
                    var drStatusText = drStatusMap[aData.props.drStatus];
                    $("td:eq(5)", nRow).text(drStatusText);

                    var rpoStatus = {
                    	0:"--",
                        1:resource.get("protectionGroup.term.vm.rpostatus.satisfied.label"),
                        2:resource.get("protectionGroup.term.vm.rpostatus.unsatisfied.label")
                     };
                    var rpoStatusText = rpoStatus[aData.props.rpoStatus];
                    $("td:eq(6)", nRow).text(rpoStatusText || "--");

                    var initSyncStatus = {
                        	0:resource.get("protectionGroup_term_vm_initsyncstatus_unfinished_label"),
                            1:resource.get("protectionGroup_term_vm_initsyncstatus_finished_label")
                         };
                    var initSyncStatusText = initSyncStatus[aData.props.initSyncStatus];
                    $("td:eq(7)", nRow).text(initSyncStatusText);

                    if( showSnapLastCreateTime ){
                    	$("td:eq(8)", nRow).text(aData.props.Snap_Last_CreateTime || "--");
                    }
			    },
			    callback : function(oPage){
			    	 page = oPage.currentPage;
			    	 tableFixer.pageQuery = true;
					 pageQuery();
			    },
			    sortCallback: function (nNode, sortArr) {
					orderBy = $scope.hostRepTable.columns[sortArr[0][0]-1].mData;
	                orderType = sortArr[0][1];
	                page = 1;
	                tableFixer.pageQuery = true;
					pageQuery();
                },
			    drawCallback : function(){
			    	tableFixer && tableFixer.selectRow();
			    }
			};

			//阵列复制
			$scope.arrayRepTable = {
				id : "arrayRepTable",
				paginationStyle:"full_numbers",
				displayLength : Consts.TABLE_COUNT_PER_PAGE,
	            columns:[{
						"sTitle" : appUtils.getString("common_term_name_label"),
						"mData" : "name",
						"bSortable" : false
					}, {
						"sTitle" : "ID",
						"mData" : "props.vmId",
						"bSortable" : false
					},
					{
						"sTitle" : appUtils.getString("common.term.cloud.column"),
						"mData" : "providerName",
						"bSortable" : false
					},
					{
						"sTitle" : appUtils.getString("common_term_system_label"),
						"mData" : "props.osType",
						"bSortable" : false
					}
				],
			    callback : function(oPage){
			    	 page = oPage.currentPage;
					 pageQuery();
			    },
			    sortCallback: function (nNode, sortArr) {
					orderBy = $scope.arrayRepTable.columns[sortArr[0][0]].mData;
	                orderType = sortArr[0][1];
	                page = 1;
					pageQuery();
                }
			};

			//vis双活
			$scope.visDoubleTable = {
				id : "visDoubleTable",
				paginationStyle:"full_numbers",
				displayLength : Consts.TABLE_COUNT_PER_PAGE,
				checkbox : true,
				isDraggedRemember: true,
				tableFixer : tableFixer,
	            columns:[{
						"bVisible" : false,
						"mData" : "moUuid"
					},{
						"sTitle" : appUtils.getString("common_term_name_label"),
						"mData" : "name",
						"bSortable" : false
					},{
						"sTitle" : "ID",
						"mData" : "props.vmId",
						"bSortable" : false
					},
					{
						"sTitle" : appUtils.getString("common.term.cloud.column"),
						"mData" : "providerName",
						"bSortable" : false
					},
					{
						"sTitle" : appUtils.getString("common_term_system_label"),
						"mData" : "props.osType",
						"bSortable" : false
					}
				],
				tHeadCheckboxFn : function(){
					tableFixer.click();
					btnCtrl();
				},
				click : function(event, cell){
					tableFixer.click();
					btnCtrl();
				},
				callback : function(oPage){
			    	 page = oPage.currentPage;
			    	 tableFixer.pageQuery = true;
					 pageQuery();
			    },
			    sortCallback: function (nNode, sortArr) {
					orderBy = $scope.visDoubleTable.columns[sortArr[0][0]-1].mData;
	                orderType = sortArr[0][1];
	                page = 1;
	                tableFixer.pageQuery = true;
					pageQuery();
                },
			    drawCallback : function(){
			    	tableFixer && tableFixer.selectRow();
			    }
			};

			//FC+FusionStore虚拟化异步复制
			$scope.fusionStorageRepTable = {
				id : "fusionStorageRepTable",
				paginationStyle:"full_numbers",
				displayLength : Consts.TABLE_COUNT_PER_PAGE,
				checkbox : true,
				isDraggedRemember: true,
				tableFixer : tableFixer,
				columns:[{
						"sTitle" : appUtils.getString("common_term_name_label"),
						"mData" : "name",
						"bSortable" : false
					},{
						"sTitle" : appUtils.getString("common_term_status_column"),
						"mData" : "poStatus",
						"bSortable" : false
					},{
						"sTitle" : "ID",
						"mData" : "props.vmId",
						"bSortable" : false
					},
					{
						"sTitle" : appUtils.getString("common.term.cloud.column"),
						"mData" : "providerName",
						"bSortable" : false
					},
					{
						"sTitle" : appUtils.getString("common_term_system_label"),
						"mData" : "props.osType",
						"bSortable" : false
					}
				],
				tHeadCheckboxFn : function(){
					tableFixer.click();
					$scope.fsBtns.btnDelete.btnStatus();
				},
				click : function(event, cell){
					tableFixer.click();
					$scope.fsBtns.btnDelete.btnStatus();
				},
				callback : function(oPage){
		    	 	page = oPage.currentPage;
		    	 	tableFixer.pageQuery = true;
				 	pageQuery();
			    },
			    sortCallback: function (nNode, sortArr) {
					orderBy = $scope.visDoubleTable.columns[sortArr[0][0]-1].mData;
	                orderType = sortArr[0][1];
	                page = 1;
	                tableFixer.pageQuery = true;
					pageQuery();
                },
                drawCallback : function(){
                	tableFixer && tableFixer.selectRow();
                },
                renderRow: function(nRow, aData, iDataIndex){
                	$("td:eq(2)", nRow).html(statusEnumService.getStatus("PROTECTEDVM_STATUS", aData["poStatus"]));
                }
			};
			$scope.fsBtns = {
				btnAdd: {
					disabled: false,
					click: function(){
						if (this.disabled){
							return;
						};
						var win = angular.copy(Consts.ADD_FUSIONSTORAGE_PO_WIN);
						win.title = appUtils.getString("ism.drm.add.po.batch.title");
						win.data = protectGroup;
						win.close = function() {
						    if (!$("#" + Consts.ADD_FUSIONSTORAGE_PO_WIN.winId).widget().option("data")["close"]) {
						        return;
						    }
						    message.prompt({
						        content: appUtils.getString("site_term_refresh_message"),
						        ok: function() {
						            $scope.fusionStorageRepTable.curPage = {
						                "pageIndex": 1
						            };
						            page = 1;
						            pageQuery();
						        }
						    })
						};
						appUtils.showWindow(win);
					}
				},
				btnDelete: {
					disabled: true,
					btnStatus: function(){
						if(!protectGroup.primary || !tableFixer || protectGroup.status == 3 || protectGroup.status == 4 ) return;
						this.disabled = !_.size(tableFixer.getSelectedRow());
						$scope.$apply();
					},
					click: function(){
						if (this.disabled) {
						    return;
						};
						var polist = Model.util.generatePoListFromTable(tableFixer);
							polist.forEach(function(item){
								delete item.props;
							});
							var pg = new Model.ProtectGroup({
								pgId   : protectGroup.pgId,
								polist : polist,
								poType : protectGroup.poType
							});
							pg.delProtectObject({
								"interceptor"  : function(next){
									//查询是否存在有待更新的卷，如果有，则需要增加提示会随着保护对象的添加一起更新卷
									var msg = resource.get("protectionGroup.task.removevm.opcontent.label") + "<br>" +
											  resource.get("protectionGroup.task.removevm.opresult.label") + "<br>" +
											  resource.get("common.task.execute.danger.message");
									Rest.getProtectedDiskInfo([protectGroup.pgId], function(result){
										var updateVol = _.filter(result, function(val) {
										    return _.contains(["UNPROTECTED", "REMOVED"], val["status"])
										});
										if(!_.isEmpty(updateVol)) {
											msg = resource.get("protectionGroup.task.removevm.opcontent.label") + "<br>" +
											  	resource.get("protectionGroup.task.removevm.opresult.label") + "<br>" +
											  	resource.get("protection_fsb_delete_update_vol_label") + "<br>" +
											  	resource.get("common.task.execute.danger.message");
										};
										message.warn({
											content : msg,
											ok : function(){
												next();
											}
										});
									});
				        		},
								"success" : function(){
									var msg = appUtils.getString("site_term_refresh_message");
									message.prompt({content:msg,ok:function(){
										page = 1;
										$scope.hostRepTable.curPage   = {"pageIndex": 1};
										$scope.arrayRepTable.curPage  = {"pageIndex": 1};
										$scope.visDoubleTable.curPage = {"pageIndex": 1};
										$scope.fusionStorageRepTable.curPage = {"pageIndex": 1};
										pageQuery();
									}});
								}
							});
					}
				},
				volManage: {
					disabled: false,
					text: appUtils.getString("rm_term_volumn_manage"),
					click: function(){
						if (this.disabled) {
						    return;
						};
						var win = angular.copy(Consts.FUSIONSTORAGE_VOLUME_MANAGE_WIN);
						win.title = appUtils.getString("rm_term_volumn_manage");
						win.data = _.extend(protectGroup, {});
						win.close = function() {
						    if ($("#" + Consts.FUSIONSTORAGE_VOLUME_MANAGE_WIN.winId).widget().option("data")["close"]) {
						        return;
						    };
						    $scope.fusionStorageRepTable.curPage = {
						        "pageIndex": 1
						    };
						    page = 1;
						    pageQuery();
						};
						win.buttons = [{
							label: appUtils.getString("common_term_close_button"),
							handler: function() {
							    $("#" + Consts.FUSIONSTORAGE_VOLUME_MANAGE_WIN.winId).widget().destroy();
							}
						}];
						appUtils.showWindow(win);
					}
				}
			};

			var updateHostRepTable  = appUtils.newUpdateTable($scope.hostRepTable,$scope);
			var updateArrayRepTable = appUtils.newUpdateTable($scope.arrayRepTable,$scope);
			var updateVisTable = appUtils.newUpdateTable($scope.visDoubleTable,$scope);
			var updateFusionStorageRepTable = appUtils.newUpdateTable($scope.fusionStorageRepTable,$scope);

			 //分页查询
			function pageQuery(){
				var config = {
					"success":function(data){
						updateTable(data);
						if( appUtils.checkPageForward(page,data) ){
							page = 1;
							$scope.hostRepTable.curPage   = {"pageIndex": 1};
							$scope.arrayRepTable.curPage  = {"pageIndex": 1};
							$scope.visDoubleTable.curPage = {"pageIndex": 1};
							pageQuery();
						}
					},
					"fail" : function(rep){
						exception.checkSessionTimeout(rep,function(){
							$timeout.cancel(promise);
						});
					 }
				};

				config.mask = false;
				if( isAutoRefresh ){
					isAutoRefresh = false;
				}else{
					$scope.maskFlag = false;
					$scope.maskHandle = $.Deferred();
            		$scope.$apply();
					config.callback = function(){
						$scope.maskHandle.resolve();
						$scope.maskFlag = true;
						$scope.$apply();
					}
				}

				Rest.queryProtectObjectsByPage({
	    			 protectgroupId : protectGroup.pgId,
	    			_PAGE : appUtils.queryFilter(page-1,10,orderBy,orderType)
	    		},config);
			}

			function getMoUuids(){
				var rows = tableFixer.getSelectedRow();
			    var moUuids = [];
			    rows.forEach(function(row){
			    	moUuids.push(row.moUuid);
			    });
			    return moUuids;
			}

			/*判断选中虚拟机中启动中可执行的动作
			 *@return array 按基线同步 ,一致性校验 ,差量复制顺序返回 1:可操作 0:不可操作
			 * */

			//一致性校验(1) 差量复制(2) 初始同步(3)

			function getAvaliableActionInStart(){
				var rows = tableFixer.getSelectedRow();
				var ret = [1,1,1];
				var result = true;

				rows.every(function(row){
					var status = row.props.drStatus;
					var opers  = statusMap[status];
					if( angular.isArray(opers) ){
						var temp = opers.slice(1,4);
						for(var i=0;i<3;i++){
							ret[i] = ret[i] & temp[i];
						}
					}else{
						result = false;
						return false;
					}
				});

				if(!result) return [0,0,0];

				var sortRet = [ret[2],ret[0],ret[1]];
				return sortRet;
			}

			//删除,暂停,恢复操作的状态
			function getActionStatus(){
				var rows = tableFixer.getSelectedRow();
				var ret = [1,1,1];
				var result = true;

				rows.every(function(row){
					var status = row.props.drStatus;
					var opers  = statusMap[status];
					if( angular.isArray(opers) ){
						ret[0] = ret[0] & opers[0];
						ret[1] = ret[1] & opers[4];
						ret[2] = ret[2] & opers[5];
					}else{
						result = false;
						return false;
					}
				});

				if(!result) return [0,0,0];
				return ret;
			}


			//按钮控制
			function btnCtrl(){
				if(!protectGroup.primary || !tableFixer || protectGroup.status == 3 || protectGroup.status == 4 ) return;

				if( tableFixer.getSelectedRow().length == 0){
					enableBtn("del",false);
					enableBtn("start",false);
					enableBtn("pause",false);
					enableBtn("resume",false);
				}else{

					if( isHostRep ){
						var start = getAvaliableActionInStart();
						start.indexOf(1) == "-1" ? enableBtn("start",false) : enableBtn("start");

						var pr = getActionStatus();
						pr[0] == 0 ? enableBtn("del",false) : enableBtn("del");
						pr[1] == 0 ? enableBtn("pause",false) : enableBtn("pause");
						pr[2] == 0 ? enableBtn("resume",false) : enableBtn("resume");
					}
					else{
						enableBtn("del");
					}
				}
			}

			var btnsMap = {
				"add"   : ["iconbutton-add",$scope.btns.add.click],
				"del"   : ["iconbutton-delete",$scope.btns.del.click],
				"start" : ["iconbutton-start",$scope.btns.start.click],
				"pause" : ["iconbutton-pause",$scope.btns.stop.click],
				"resume": ["iconbutton-resume",$scope.btns.recovery.click]
			};

			//按钮状态控制
			function enableBtn(id,enable){
				var btn = $("#"+id);
				var cls = btnsMap[id][0];
				var click = btnsMap[id][1];

				if(enable === false){
					cls += "-disabled";
					btn.find("div").attr("class",cls);
					btn.find("span").css("color","#666");
					btn.unbind("click");
				}else{
					btn.find("div").attr("class",cls);
					btn.find("span").css("color","#009ae7");
					btn.unbind("click").click(click);
				}
			}

			$scope.refresh = function(){

				isHostRep = protectGroup.props.protectType == "HostReplication";
				updateTable = isHostRep ? updateHostRepTable : updateArrayRepTable;

				$scope.operShow  = isHostRep;
				$scope.extraOperShow = isHostRep;

				$scope.hostRepTableShow = isHostRep;
				$scope.arrayRepTableShow = !isHostRep;
				$scope.visTableShow = false;
				$scope.fusionStorageRepShow = false;

				if( isHostRep ){
					tableFixer = appUtils.tableFixer("hostRepTable","moUuid");
				}
				//vis双活支持添加移除
				if( protectGroup.props.protectType == "VISDoubleActive" ){
					$scope.arrayRepTableShow = false;
					$scope.visTableShow = true;
					$scope.operShow = true;
					$scope.extraOperShow = false;
					tableFixer = appUtils.tableFixer("visDoubleTable","moUuid");
					updateTable = updateVisTable;
				}
				//fusionStorage小lun异步复制
				if(protectGroup.template.type == 33){
					$scope.fusionStorageRepShow = true;
					$scope.hostRepTableShow = false;
					$scope.arrayRepTableShow = false;
					$scope.visTableShow = false;
					$scope.operShow = false;
					$scope.extraOperShow = false;
					tableFixer = appUtils.tableFixer("fusionStorageRepTable","moUuid");
					updateTable = updateFusionStorageRepTable;
				}

				//灾备端或者保护组状态为失效和锁定则全部灰化
				if( !protectGroup.primary || protectGroup.status == 3 || protectGroup.status == 4 ){
					enableBtn("add",false);
					enableBtn("del",false);
					enableBtn("start",false);
					enableBtn("pause",false);
					enableBtn("resume",false);
					//小lun异步复制
					$scope.fsBtns.btnAdd.disabled = true;
					$scope.fsBtns.volManage.disabled = true;
				}else{
					enableBtn("add");
					enableBtn("del");
					//小lun异步复制
					$scope.fsBtns.btnAdd.disabled = false;
					$scope.fsBtns.volManage.disabled = false;
				}

				btnCtrl();

				//华为虚拟机双活+快照保护组无效时,可以添加移除保护对象
				if( _.isObject(protectGroup.template) && protectGroup.template.type == 19 && protectGroup.status == 3 ){
					enableBtn("add");
					enableBtn("del");
				}

				pageQuery();

			};

			//主机复制需要自动刷新
			function autoRefresh(){
				if( !$state.includes("protection.pg.list.protectobjects_fusionsphere") || $scope.$$destroyed){
					$timeout.cancel(promise);
				}else{
					isAutoRefresh = true;
					$scope.refresh();
					promise = $timeout(autoRefresh,15000);
				}
			}

			//监听选择保护组事件,刷新界面
			$scope.$on(Consts.PG_SELECT_EVENT,function(){
				protectGroup = $scope.protectGroup;
				page = 1;
				orderBy = "";
				orderType = "";
				$scope.hostRepTable.curPage   = {"pageIndex": 1};
				$scope.arrayRepTable.curPage  = {"pageIndex": 1};
				$scope.visDoubleTable.curPage = {"pageIndex": 1};
				$scope.refresh();

				//主机复制需要自动刷新
				$timeout.cancel(promise);
				if(protectGroup.props.protectType == "HostReplication"){
					promise = $timeout(autoRefresh,15000);
					//fc5.1及以上版本需要在增加列"最新恢复时间点"
					var fcVersion = protectGroup.props.FS_VRM_VERSION;
					if( fcVersion && fcVersion != "v5.0" ){
						if(showSnapLastCreateTime) return;

						showSnapLastCreateTime = true;
						$scope.hostRepTable.columns = angular.copy($scope.hostRepTable.columns);
						$scope.hostRepTable.columns.push({
							"sTitle" : appUtils.getString("recovery_term_latestRecoveryTimePoint_column"),
							"mData" : "props.Snap_Last_CreateTime",
							"bSortable" : false
						});
					}
					else{
						if(showSnapLastCreateTime){
							$scope.hostRepTable.columns = angular.copy($scope.hostRepTable.columns);
							$scope.hostRepTable.columns.pop();
							showSnapLastCreateTime = false;
						}
					}
				}
			});

			function init(){

				addPopWin.title = appUtils.getString(addPopWin.title);
				addPopWin.close = function(){
		            appUtils.getWinData("ADD_PO_WIN") === true && $scope.$emit(Consts.TOPIC.PG_LIST_UPDATE);
		        };

		        var jqOper = $("#operDiv");
		        jqOper.find("#add").click($scope.btns.add.click);
		        jqOper.find("#del").click($scope.btns.del.click);

		        $scope.refresh();

		        //主机复制需要自动刷新
		        $timeout.cancel(promise);
		        if(protectGroup.props.protectType == "HostReplication"){
					promise = $timeout(autoRefresh,15000);
					//fc5.1及以上版本需要在增加列"最新恢复时间点"
					var fcVersion = protectGroup.props.FS_VRM_VERSION;
					if( fcVersion && fcVersion != "v5.0"){
						showSnapLastCreateTime = true;
						$scope.hostRepTable.columns.push({
							"sTitle" : appUtils.getString("recovery_term_latestRecoveryTimePoint_column"),
							"mData" : "props.Snap_Last_CreateTime",
							"bSortable" : false
						});
					}
				}
			}

			init();
	}];
	var module = angular.module('recoverydirector.protection.config');
	module.tinyController('protection.pg.protectobjects_fusionsphere.ctrl', ctrl);
	return module;
});
