/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderVolumeTask;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.EndpointUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.AvailableZoneInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ImageMetadataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgUpdateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapshotActiveInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeTypeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeUpdateInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.task.ForkJoinPoolManager;
import com.huawei.lego.core.base.thread.Enhancer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;

public class CinderManager
implements ICinderManager {
    private static Log logger = LogFactory.getInstance(CinderManager.class);

    @Override
    public List<OpenStackVolume> getVolumes(String regionUuid, String tokenId, String projUuid, String volCgId) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        List volumes = (List)Enhancer.timeSupplier((String)("get all volumes for project " + projUuid), () -> this.getAllVolumeInProject(regionUuid, tokenId, projUuid, volCgId)).get();
        return this.translateVolumes(openstackUuid, regionUuid, tokenId, projUuid, volumes);
    }

    private List<VolumeInfo> getAllVolumeInProject(String regionUuid, String tokenId, String projUuid, String volCgId) {
        List<VolumeInfo> volumesList;
        EndpointUtil endpointUtil = EndpointUtil.getInstance();
        String urlStr = endpointUtil.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String url = OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOL_DETAILS.getUri();
        if (!VerifyUtil.isEmpty((String)volCgId)) {
            url = OpenstackEnumDefine.REQUEST_URL.CINDER_BATCHQUERY_VOL_DETAILS_BY_CG.getUri();
        }
        String newUrlStr = urlStr + String.format(url, projId);
        logger.debug((Object)"Get batch volumes request str=%s , volCgId=%s.", new Object[]{newUrlStr, volCgId});
        try {
            volumesList = this.getOpenStackVolumes(newUrlStr, tokenId, volCgId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Get openStackVolumes error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        return volumesList;
    }

    private List<VolumeInfo> getOpenStackVolumes(String strUrl, String tokenId, String volCgId) {
        int limitNum = (int)LegoConfig.getInstance().getNumber("volume.query.parallel.quantity.config", 3L);
        ForkJoinPool cinderForkJoinPool = ForkJoinPoolManager.getInstance().createForkJoinPool(limitNum);
        try {
            CinderVolumeTask openStackVolumesTask = new CinderVolumeTask(strUrl, tokenId, volCgId, -1L);
            ForkJoinTask<List<VolumeInfo>> openStackVolumes = cinderForkJoinPool.submit(openStackVolumesTask);
            List<VolumeInfo> list = openStackVolumes.get(5L, TimeUnit.MINUTES);
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"Query OpenStackVolume error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949735L);
        }
        finally {
            cinderForkJoinPool.shutdown();
        }
    }

    private List<OpenStackVolume> translateVolumes(String openstackUuid, String regionUuid, String tokenId, String projUuid, List<VolumeInfo> volInfolist) {
        ArrayList<OpenStackVolume> list = new ArrayList<OpenStackVolume>();
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vms = novaMgr.getVms(regionUuid, tokenId, projUuid);
        for (VolumeInfo info : volInfolist) {
            OpenStackVolume vol = this.translateVolume(info, openstackUuid, regionUuid, vms);
            list.add(vol);
        }
        return list;
    }

    @Override
    public VolumeInfo queryVolume(String regionUuid, String tokenId, String projUuid, String volumeId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"Query volume,parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOL.getUri(), projId, volumeId);
        logger.debug((Object)("Get volume request str=" + newUrlStr + ", volumeId=" + volumeId));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)("Get volume success.response str=" + respStr + ", volumeId=" + volumeId));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Get volume failed.response string is empty.request str=" + newUrlStr + ".response str=" + respStr + ", volumeId=" + volumeId));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            logger.error((Object)("Get volume failed.jsonNode is null.request str=" + newUrlStr + ".response str=" + respStr + ", volumeId=" + volumeId));
            return null;
        }
        if (jsonNode.path("volume").isMissingNode()) {
            logger.error((Object)("Get volume failed.jsonNode do not contain volume json keyword.request str=" + newUrlStr + ".response str=" + respStr + ", volumeId=" + volumeId));
            throw new LegoCheckedException(0x300001L);
        }
        VolumeInfo info = JsonUtil.jsonToBean(jsonNode.path("volume").toString(), VolumeInfo.class);
        return info;
    }

    @Override
    public AsyncTaskResponse createVolume(VolumeCreateInfo volumeInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volumeInfo)) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_CREATE_VOL.getUri(), projId);
        String volStr = JsonUtil.beanToJson(volumeInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"volume", (Object)volStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqestJson.toString(), tokenId);
        logger.info((Object)("CreateVolume response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948406L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (null == jsonNode || jsonNode.path("volume").isMissingNode()) {
            logger.error((Object)("Bad Request createVolume :" + volumeInfo));
            throw new LegoCheckedException(1073948406L);
        }
        VolumeInfo info = JsonUtil.jsonToBean(jsonNode.path("volume").toString(), VolumeInfo.class);
        if (null == info) {
            logger.error((Object)("Convert to VolumeInfo return null, str=" + jsonNode.path("volume").toString()));
            throw new LegoCheckedException(0x300001L);
        }
        if (this.isVolumeCreateSuccess(info)) {
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolResponse(regionUuid, tokenId, projUuid, info);
    }

    @Override
    public AsyncTaskResponse deleteVolume(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_DELETE_VOL.getUri(), projId, volumeId);
        logger.info((Object)("DeleteVolume request str: " + newUrlStr));
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        logger.info((Object)("DeleteVolume response str: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            logger.info((Object)("DeleteVolume success.volumeId: " + volumeId));
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("DeleteVolume failed. request str: " + newUrlStr + "response str: " + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    @Override
    public AsyncTaskResponse reserveVolume(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"Failed to reserve volume.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeInfo volume = this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
        if (null == volume) {
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (OpenstackEnumDefine.VOLUME_STATUS_E.ATTACHING.getType().equals(volume.getStatus())) {
            response.setSuccess(true);
            return response;
        }
        if (!OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus())) {
            response.setSuccess(false);
            return response;
        }
        String message = "{\"os-reserve\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        logger.debug((Object)("Reserve volume request str: " + newUrlStr));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.info((Object)("Reserve volume response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkReserveVolResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("Failed to reserve volume.itemNotFound :volumeId=" + volumeId + ", request str: " + newUrlStr + ", response: " + respStr));
            response.setErrorCode("2117645");
        } else {
            logger.error((Object)("Failed to reserve volume.bad Request reserveVolume :volumeId=" + volumeId + ", request str: " + newUrlStr + ", response: " + respStr));
            response.setErrorCode("3145729");
        }
        return response;
    }

    @Override
    public AsyncTaskResponse unreserveVolume(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"Unreserve volume failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeInfo volume = this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
        if (null == volume) {
            logger.error((Object)("Unreserve volume volume is null.volumeId=" + volumeId));
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (!OpenstackEnumDefine.VOLUME_STATUS_E.ATTACHING.getType().equals(volume.getStatus())) {
            logger.info((Object)("Unreserve volume volume success.Only attaching status can do unreserving operation.volumeId=" + volumeId + ", volume status=" + volume.getStatus()));
            response.setSuccess(true);
            return response;
        }
        String message = "{\"os-unreserve\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        logger.debug((Object)("ReserveVolume request str: " + newUrlStr));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("ReserveVolume response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkUnreserveVolResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("ReserveVolume failed. itemNotFound :" + volumeId + ", request str=" + newUrlStr + ", reponse str=" + respStr));
            response.setErrorCode("2117645");
        } else {
            logger.error((Object)("ReserveVolume failed.bad Request unreserveVolume :" + volumeId + ", request str=" + newUrlStr + ", reponse str=" + respStr));
            response.setErrorCode("3145729");
        }
        return response;
    }

    @Override
    public AsyncTaskResponse enableVolumeBootable(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"Enable volume bootable failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeInfo volume = this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
        if (null == volume) {
            logger.error((Object)("Enable volume bootable failed, volumeId=" + volumeId + ",volume is null"));
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (volume.isBootable()) {
            logger.info((Object)("Enable volume bootable success, volumeId=" + volumeId + " is bootable"));
            response.setSuccess(true);
            return response;
        }
        if (!OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus())) {
            logger.error((Object)("Enable volume bootable failed, volumeId=" + volumeId + ",queryed volume status is" + volume.getStatus() + ",not available status"));
            response.setSuccess(false);
            return response;
        }
        String message = "{\"os-set_bootable\":{\"bootable\":true}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        logger.debug((Object)("Enable Volume Bootable request str: " + newUrlStr + ", volumeId=" + volumeId));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("Enable Volume Bootable response: " + respStr + ", volumeId=" + volumeId));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkEnableVolBootableResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("Enable Volume Bootable faild, itemNotFound,volumeId=" + volumeId + "request str: " + newUrlStr + "response: " + respStr));
            response.setErrorCode("2117645");
        } else {
            logger.error((Object)("Enable Volume Bootable faild,bad Request enableVolumeBootable,volumeId=" + volumeId + "request str: " + newUrlStr + "response: " + respStr));
            response.setErrorCode("3145729");
        }
        return response;
    }

    @Override
    public void updateVolMetadatas(String regionUuid, String tokenId, String projUuid, String volumeId, Map<String, String> metadataMap) {
        if (VerifyUtil.isEmpty(metadataMap) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)("Update volume metadatas failed.parameter is empty.volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        EndpointUtil util = EndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_CREATE_VOL_METADATA.getUri(), projId, volumeId);
        logger.debug((Object)("Update volume metadatas.volumeId=" + volumeId + ",request str=" + newUrlStr));
        String message = this.makeMetadataStr(metadataMap);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("Update volume metadatas.volumeId=" + volumeId + ",respStr str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr) || !respStr.contains("metadata")) {
            logger.error((Object)("Update volume metadatas failed.respStr is empty or not contain metadata.volumeId=" + volumeId + ",request str=" + newUrlStr + ",respStr str=" + respStr));
            throw new LegoCheckedException(1073948132L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr).getJSONObject("metadata");
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().equalsIgnoreCase((String)json.get(key))) continue;
            logger.error((Object)("Update volume metadatas failed.Query.Query metadata(" + (String)json.get(key) + ") is not equal to updated metadata(" + entry.getValue() + ").volumeId=" + volumeId + ",request str=" + newUrlStr + ",respStr str=" + respStr));
            throw new LegoCheckedException(1073948132L);
        }
    }

    private String makeMetadataStr(Map<String, String> metadataMap) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            json.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        JSONObject retJson = new JSONObject();
        retJson.put((Object)"metadata", (Object)json);
        return retJson.toString();
    }

    @Override
    public void deleteVolMetadatas(String regionUuid, String tokenId, String projUuid, String volumeId, String metadataKey) {
        if (VerifyUtil.isEmpty((String)metadataKey) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"Delete volume metadata failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        EndpointUtil util = EndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_DELETE_VOL_METADATA.getUri(), projId, volumeId, metadataKey);
        logger.debug((Object)("Delete volume metadata.request str=" + newUrlStr + ", volumeID=" + volumeId));
        ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
    }

    @Override
    public List<OpenStackVolumeType> getVolumeTypes(String regionUuid, String tokenId, String projUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"Get volume type failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        EndpointUtil util = EndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOL_TYPES.getUri(), projId);
        logger.debug((Object)("Get volume type.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)("Get volume type success:volume response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Get volume type failed.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"volume_types")) {
            logger.error((Object)("Get volume type failed.bad Request getVolumeTypes.request str=" + newUrlStr + "response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeTypeInfo> volTypeInfoList = JsonUtil.jsonArrayToList(json.getString("volume_types"), VolumeTypeInfo.class);
        ArrayList<OpenStackVolumeType> list = new ArrayList<OpenStackVolumeType>();
        for (VolumeTypeInfo volTypeInfo : volTypeInfoList) {
            OpenStackVolumeType volType = new OpenStackVolumeType();
            volType.setRegionUuid(regionUuid);
            volType.setProjUuid(projUuid);
            volType.setName(volTypeInfo.getName());
            volType.setExtraSpecs(JsonUtil.beanToJson(volTypeInfo.getExtraSpecs()));
            int hashcode = OpenStackCommonUtil.generateHashCode(regionUuid, projUuid, volTypeInfo.getName());
            volType.setUuid(openstackUuid + ":" + hashcode);
            volType.setTopMoUuid(openstackUuid);
            list.add(volType);
        }
        return list;
    }

    @Override
    public List<VolumeTypeInfo> queryVolumeTypes(String regionUuid, String tokenId, String projUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        EndpointUtil util = EndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOL_TYPES.getUri(), projId);
        logger.debug((Object)("Get volume type success.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)("Get volume type success:response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to query volume type.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"volume_types")) {
            logger.error((Object)("Failed to query volume type.bad Request getVolumeTypes.request str=" + newUrlStr + ",response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeTypeInfo> volTypeInfoList = JsonUtil.jsonArrayToList(json.getString("volume_types"), VolumeTypeInfo.class);
        return volTypeInfoList;
    }

    @Override
    public List<OpenStackAvailabilityZone> getAzs(String regionUuid, String tokenId, String projUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"Failed to get AZ list.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        EndpointUtil util = EndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_AZ.getUri(), projId);
        logger.debug((Object)("get AZ list.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)("get AZ list.response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to get AZ list.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"availabilityZoneInfo")) {
            logger.error((Object)("Failed to get AZ list.bad Request getAzs.request str=" + newUrlStr + "response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<AvailableZoneInfo> zoneList = JsonUtil.jsonArrayToList(json.getString("availabilityZoneInfo"), AvailableZoneInfo.class);
        ArrayList<OpenStackAvailabilityZone> list = new ArrayList<OpenStackAvailabilityZone>();
        for (AvailableZoneInfo zone : zoneList) {
            OpenStackAvailabilityZone openZone = new OpenStackAvailabilityZone();
            openZone.setRegionUuid(regionUuid);
            openZone.setProjUuid(projUuid);
            openZone.setZoneAvailable(Boolean.valueOf(zone.getZoneState().isAvailable()));
            openZone.setName(zone.getZoneName());
            openZone.setTopMoUuid(openstackUuid);
            int hashcode = OpenStackCommonUtil.generateHashCode(regionUuid, projUuid, zone.getZoneName());
            openZone.setUuid(openstackUuid + ":" + "AZ_" + hashcode);
            list.add(openZone);
        }
        return list;
    }

    private OpenStackVolume translateVolume(VolumeInfo info, String openstackUuid, String regionUuid, List<OpenStackVM> vms) {
        OpenStackVolume vol = new OpenStackVolume();
        if (info == null) {
            logger.info((Object)"VolumeInfo is null");
            return vol;
        }
        vol.setUuid(openstackUuid + ":" + info.getId());
        vol.setRegionUuid(regionUuid);
        vol.setAz(info.getAvailabilityZone());
        vol.setProjUuid(openstackUuid + ":" + info.getProjectId());
        vol.setName(info.getName());
        vol.setSize(Integer.valueOf(info.getSize()));
        vol.setVolType(info.getVolumeType());
        vol.setSnapShotId(info.getSnapShotId());
        vol.setSourceVol(info.getSourceVol());
        vol.setConsistentGroupId(info.getConsistentcyGroupId());
        vol.setReplicaDriverData(info.getReplicaDriverData());
        vol.setStatus(Integer.valueOf(OpenstackEnumDefine.VOLUME_STATUS_E.getStatus((String)info.getStatus()).getValue()));
        vol.setBootable(Boolean.valueOf(info.isBootable()));
        vol.setShareable(info.getShareable());
        vol.setTopMoUuid(openstackUuid);
        vol.setMetadata(info.getMetadata());
        vol.setMulitattach(info.getMultiattach());
        vol.setVolumeImageMetadata(info.getVolumeImageMetadata());
        if (!VerifyUtil.isEmpty((Map)info.getVolumeDriverMetadata())) {
            JSONObject jasonObject = JSONObject.fromObject((Object)info.getVolumeDriverMetadata());
            vol.setVolumeDriverMetadata((Map)jasonObject);
        } else {
            vol.setVolumeDriverMetadata(null);
        }
        List attachInfoList = info.getAttachments();
        JSONArray attachmentArray = new JSONArray();
        List<OpenStackVM> bmsVms = OpenStackCommonUtil.getBmsVms(vms);
        for (VolumeAttachmentInfo attachInfo : attachInfoList) {
            JSONObject attachmentObj = new JSONObject();
            attachmentObj.put((Object)"vmUuid", (Object)(openstackUuid + ":" + attachInfo.getServerId()));
            if (VerifyUtil.isEmpty((String)attachInfo.getDevice())) {
                String volVmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, attachInfo.getServerId());
                boolean isBmsVolume = OpenStackCommonUtil.isBmsServiceVolume(volVmUuid, bmsVms);
                if (isBmsVolume) {
                    attachmentObj.put((Object)"device", (Object)"NA");
                }
            } else {
                attachmentObj.put((Object)"device", (Object)attachInfo.getDevice());
            }
            attachmentArray.add((Object)attachmentObj);
        }
        vol.setAttachmentStr(attachmentArray.toString());
        return vol;
    }

    private AsyncTaskResponse checkDeleteVolResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    logger.info((Object)("checkDeleteVolResponse succeed ,volume id: " + volumeId));
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLUME_STATUS_E.DELETING.getType().equals(volume.getStatus())) {
                    logger.error((Object)("checkDeleteVolResponse failed.volume status is not excepted, excepted status: deleting, current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                logger.error((Object)("checkDeleteVolResponse failed ,volume.getStatus() is " + volume.getStatus() + ", volume id:" + volumeId));
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkReserveVolResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    logger.error((Object)("check reserveVolume reponse failed. volume is null.volumeId=" + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VOLUME_STATUS_E.ATTACHING.getType().equals(volume.getStatus())) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus())) {
                    logger.error((Object)("volume status is not excepted, excepted status: attaching or available, current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkUnreserveVolResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    logger.error((Object)("check reserveVolume reponse failed. volume is null.volumeId=" + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus())) {
                    logger.info((Object)("check reserveVolume response success. volume is null.volumeId=" + volumeId + ", volume status=" + volume.getStatus()));
                    response.setSuccess(true);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkEnableVolBootableResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    logger.error((Object)("check enable volume bootable failed, volume is null, volumeid=" + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (volume.isBootable()) {
                    logger.error((Object)("check enable volume bootable success, volume bootable status is true , volumeid=" + volumeId));
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus())) {
                    logger.error((Object)("check enable volume bootable failed, volume status is not excepted, excepted status: available, current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVolResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeInfo volumeInfo) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeInfo, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeInfo.getId());
                if (null == volume) {
                    logger.error((Object)("check create volume failed, volume is null, volumeid=" + volumeInfo.getId()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus())) {
                    if (CinderManager.this.isVolumeCreateSuccess(volume)) {
                        response.setSuccess(true);
                        response.setTaskResult(volume);
                        return true;
                    }
                    logger.error((Object)("volume status is available, but driver data is none, current status : " + volume.getStatus() + ", volume id: " + volumeInfo.getId()));
                    return false;
                }
                if (!OpenstackEnumDefine.VOLUME_STATUS_E.CREATING.getType().equals(volume.getStatus())) {
                    logger.error((Object)("volume status is not excepted, excepted status: available or creating, current status : " + volume.getStatus() + ", volume id: " + volumeInfo.getId()));
                    response.setSuccess(false);
                    response.setErrorCode("1073948406");
                    response.setTaskResult(volume);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean isVolumeCreateSuccess(VolumeInfo volume) {
        return OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volume.getStatus()) && !VerifyUtil.isEmpty((String)volume.getReplicaDriverData()) && !volume.getReplicaDriverData().equalsIgnoreCase("{}");
    }

    @Override
    public AsyncTaskResponse createVolCgSnapShot(VolumeCgSnapShotCreateInfo volCgInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volCgInfo)) {
            logger.error((Object)"Failed to create volume cg snapshot.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_CREATE_VOLCGSNAPSHOT.getUri(), projId);
        logger.debug((Object)("create volume cg snapshot.request str: " + newUrlStr));
        String volRepCgStr = JsonUtil.beanToJson(volCgInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"cgsnapshot", (Object)volRepCgStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqestJson.toString(), tokenId);
        logger.info((Object)("createVolCgSnapShot response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to create volume cg snapshot.response string is empty.request str: " + newUrlStr));
            throw new LegoCheckedException(1073948914L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"cgsnapshot")) {
            logger.error((Object)("Failed to create volume cg snapshot.bad Request createVolCgSnapShot :" + volCgInfo + ", request str: " + newUrlStr + ", response: " + respStr));
            throw new LegoCheckedException(1073948914L);
        }
        VolumeCgSnapShotInfo info = JsonUtil.jsonToBean(json.getString("cgsnapshot"), VolumeCgSnapShotInfo.class);
        if (null == info) {
            logger.error((Object)("Failed to create volume cg snapshot.convert to VolumeCgSnapShotInfo return null, str=" + json.getString("cgsnapshot")));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.VOLCGSNAPSHOT_STATUS_E.AVAIABLE.getValue().equals(info.getStatus())) {
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolCgSnapShotResponse(regionUuid, tokenId, projUuid, info);
    }

    private AsyncTaskResponse checkCreateVolCgSnapShotResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeCgSnapShotInfo info) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(info, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgSnapShotInfo volCgSnapShot = CinderManager.this.queryVolCgSnapShot(regionUuid, tokenId, projUuid, info.getId());
                if (null == volCgSnapShot) {
                    logger.error((Object)"Failed to check create volume cg snapshot.volCgSnapShot is null.");
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VOLCGSNAPSHOT_STATUS_E.AVAIABLE.getValue().equals(volCgSnapShot.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(volCgSnapShot);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLCGSNAPSHOT_STATUS_E.CREATING.getValue().equals(volCgSnapShot.getStatus())) {
                    logger.error((Object)("volume status is not excepted, excepted status: available or creating, current status : " + volCgSnapShot.getStatus() + ", volume id: " + info.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(volCgSnapShot);
                    response.setErrorCode("1073948914");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public VolumeCgSnapShotInfo queryVolCgSnapShot(String regionUuid, String tokenId, String projUuid, String volCgSnapShotId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volCgSnapShotId)) {
            logger.error((Object)"Query volume cg snapshot failed. Query parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOLCGSNAPSHOT.getUri(), projId, volCgSnapShotId);
        logger.debug((Object)("Query volume cg snapshot.request str: " + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.info((Object)("queryVolCgSnapShot response str: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to query volume cg snapshot.response string is empty.response str: " + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            return null;
        }
        if (!json.containsKey((Object)"cgsnapshot")) {
            logger.error((Object)("Failed to query volume cg snapshot.bad Request queryVolConsistencyGroup.request str: " + newUrlStr + ", response str: " + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        VolumeCgSnapShotInfo info = JsonUtil.jsonToBean(json.getString("cgsnapshot"), VolumeCgSnapShotInfo.class);
        return info;
    }

    @Override
    public AsyncTaskResponse deleteVolCgSnapShot(String volCgSnapShotId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volCgSnapShotId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_DELETE_VOLCGSNAPSHOT.getUri(), projId, volCgSnapShotId);
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        logger.info((Object)("deleteVolCgSnapShot response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolCgSnapShotResponse(regionUuid, tokenId, projUuid, volCgSnapShotId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("bad Request deleteVolCgSnapShot: " + volCgSnapShotId));
        response.setErrorCode("1073948916");
        return response;
    }

    private AsyncTaskResponse checkDeleteVolCgSnapShotResponse(final String regionUuid, final String tokenId, final String projUuid, final String volCgSnapShotId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volCgSnapShotId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgSnapShotInfo volCgSnapShot = CinderManager.this.queryVolCgSnapShot(regionUuid, tokenId, projUuid, volCgSnapShotId);
                if (null == volCgSnapShot) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLUME_STATUS_E.DELETING.getType().equals(volCgSnapShot.getStatus())) {
                    logger.error((Object)("volCgSnapShot status is not excepted, excepted status: deleting, current status : " + volCgSnapShot.getStatus() + ", volCgSnapShot id: " + volCgSnapShotId));
                    response.setSuccess(false);
                    response.setErrorCode("1073948916");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public List<VolumeSnapShotInfo> queryVolumeSnapShots(String regionUuid, String tokenId, String projectUuid, Map<String, String> filterProp) {
        String cacheKey;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)"Failed query volume snapShots.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<VolumeSnapShotInfo> snapShotsList = new ArrayList<VolumeSnapShotInfo>();
        EndpointUtil endpointUtil = EndpointUtil.getInstance();
        String urlStr = endpointUtil.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        if (VerifyUtil.isEmpty(filterProp)) {
            filterProp = new HashMap<String, String>();
        }
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.OPENSTACK_SNAPSHOT_LIST, cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projectUuid, JsonUtil.beanToJson(filterProp)}))) {
            List snapShotList = (List)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_SNAPSHOT_LIST, cacheKey);
            return new ArrayList<VolumeSnapShotInfo>(snapShotList);
        }
        String newUrlStr = urlStr + this.getDetailUrl(filterProp, projId);
        logger.info((Object)("Query volume snapShots.request str=" + newUrlStr));
        String limit = String.valueOf(1000);
        filterProp.put("limit", limit);
        int offset = 0;
        String respStr = null;
        while (true) {
            filterProp.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr, filterProp, tokenId, new int[0]);
            logger.info((Object)("Query volume snapShots. response str=" + respStr));
            List<VolumeSnapShotInfo> list = this.getSnapShotFromRespStr(respStr);
            snapShotsList.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        OpenstackCache.putCache(OpenstackCache.CacheType.OPENSTACK_SNAPSHOT_LIST, cacheKey, new ArrayList(snapShotsList));
        return snapShotsList;
    }

    private List<VolumeSnapShotInfo> getSnapShotFromRespStr(String respStr) {
        logger.info((Object)("Query volume snapShots. response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to query volume snapShots.response string is empty.request str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"snapshots")) {
            logger.error((Object)("Failed to  query volume snapShots.bad Request getVolumeSnapShots response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeSnapShotInfo> snapShotsList = JsonUtil.jsonArrayToList(json.getString("snapshots"), VolumeSnapShotInfo.class);
        return snapShotsList;
    }

    private String getDetailUrl(Map<String, String> filterProp, String projId) {
        if (VerifyUtil.isEmpty(filterProp)) {
            return String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOLSNAPSHOTLIST.getUri(), projId);
        }
        if (filterProp.containsKey("volume_id")) {
            return String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOLSNAPSHOTS_BY_VOLUME.getUri(), projId);
        }
        return String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_BATCHQUERYQUERY_VOLSNAPSHOTLIST_CG.getUri(), projId);
    }

    @Override
    public VolumeSnapShotInfo queryVolumeSnapShotByUuid(String regionUuid, String tokenId, String projectUuid, String volSnapShotId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)volSnapShotId)) {
            logger.error((Object)"Failed to query volume snapshot detail.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        EndpointUtil endpointUtil = EndpointUtil.getInstance();
        String urlStr = endpointUtil.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(openstackUuid);
        if (null == open) {
            logger.error((Object)"Failed to query volume snapshot detail.openstack is not discovery");
            throw new LegoCheckedException(1073947393L);
        }
        String url = OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOLSNAPSHOT_DETAIL.getUri();
        if (VerifyUtil.isEmpty((String)open.getVersion()) || "6.0".equals(open.getVersion())) {
            url = OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOLSNAPSHOT.getUri();
        }
        String newUrlStr = urlStr + String.format(url, projId, volSnapShotId);
        logger.debug((Object)("Query volume snapshot detail.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.info((Object)("Query volume snapshot detail. success:response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to query volume snapshot detail.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.info((Object)"Query volume snapshot detail. snapshot is null.");
            return null;
        }
        if (!json.containsKey((Object)"snapshot")) {
            logger.error((Object)("Failed to query volume snapshot detail.bad Request queryVolumeSnapShotBySnapId.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        VolumeSnapShotInfo volSnapShot = JsonUtil.jsonToBean(json.getString("snapshot"), VolumeSnapShotInfo.class);
        return volSnapShot;
    }

    @Override
    public AsyncTaskResponse createVolumeConsistenceGroup(VolumeCgCreateInfo volCgCreateInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volCgCreateInfo)) {
            logger.error((Object)"Failed to create volume consistenceGroup.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_CREATE_VOLCG.getUri(), projId);
        String volCgStr = JsonUtil.beanToJson(volCgCreateInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"consistencygroup", (Object)volCgStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqestJson.toString(), tokenId);
        logger.info((Object)("createVolumeConsistencyGroup response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(1073948913L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"consistencygroup")) {
            logger.error((Object)("bad Request createVolumeConsistenceGroup :" + volCgCreateInfo));
            throw new LegoCheckedException(1073948913L);
        }
        logger.debug((Object)("consistencygroup is:" + json.getString("consistencygroup")));
        VolumeCgInfo info = JsonUtil.jsonToBean(json.getString("consistencygroup"), VolumeCgInfo.class);
        if (null == info) {
            logger.error((Object)("convert to VolumeCgInfo return null, Str=" + json.getString("consistencygroup")));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.VOLCG_STATUS_E.AVAIABLE.getValue().equals(info.getStatus())) {
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolCgResponse(regionUuid, tokenId, projUuid, info);
    }

    private AsyncTaskResponse checkCreateVolCgResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeCgInfo info) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(info, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgInfo volCg = CinderManager.this.queryVolConsistencyGroup(regionUuid, tokenId, projUuid, info.getId());
                if (null == volCg) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VOLCG_STATUS_E.AVAIABLE.getValue().equals(volCg.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(volCg);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLCG_STATUS_E.ERROR.getValue().equals(volCg.getStatus())) {
                    logger.error((Object)("volCg status is not excepted, excepted status: available or creating, current status : " + volCg.getStatus() + ", volCg id: " + info.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(volCg);
                    response.setErrorCode("1073948913");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse updateVolumeConsistenceGroup(VolumeCgUpdateInfo volCgUpdateInfo, String regionUuid, String tokenId, String projUuid, String volCgUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volCgUpdateInfo)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_UPDATE_VOLCG.getUri(), projId, volCgUuid);
        String volCgStr = JsonUtil.beanToJson(volCgUpdateInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"consistencygroup", (Object)volCgStr);
        ClientUtil.sendPutRequest(newUrlStr, reqestJson.toString(), tokenId);
        VolumeCgInfo info = new VolumeCgInfo();
        info.setId(volCgUuid);
        return this.checkCreateVolCgResponse(regionUuid, tokenId, projUuid, info);
    }

    @Override
    public VolumeCgInfo queryVolConsistencyGroup(String regionUuid, String tokenId, String projUuid, String voCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)voCgId)) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_QUERY_VOLCG.getUri(), projId, voCgId);
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.info((Object)("QueryVolConsistencyGroup response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            return null;
        }
        if (!json.containsKey((Object)"consistencygroup")) {
            logger.error((Object)"Bad Request queryVolConsistencyGroup");
            throw new LegoCheckedException(0x300001L);
        }
        VolumeCgInfo info = JsonUtil.jsonToBean(json.getString("consistencygroup"), VolumeCgInfo.class);
        return info;
    }

    @Override
    public AsyncTaskResponse deleteVolumeConsistencyGroup(String volCgId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volCgId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_DELETE_VOLCG.getUri(), projId, volCgId);
        JSONObject jsonInfo = new JSONObject();
        jsonInfo.put((Object)"force", (Object)"true");
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"consistencygroup", (Object)jsonInfo.toString());
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, reqestJson.toString(), tokenId);
        logger.info((Object)("deleteVolumeConsistenceGroup response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolCgResponse(regionUuid, tokenId, projUuid, volCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("bad Request deleteVolumeConsistenceGroup: " + volCgId));
        response.setErrorCode("3145729");
        return response;
    }

    private AsyncTaskResponse checkDeleteVolCgResponse(final String regionUuid, final String tokenId, final String projUuid, final String volCgId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgInfo volCg = CinderManager.this.queryVolConsistencyGroup(regionUuid, tokenId, projUuid, volCgId);
                if (null == volCg) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLUME_STATUS_E.DELETING.getType().equals(volCg.getStatus())) {
                    logger.error((Object)("volCg status is not excepted, excepted status: deleting, current status : " + volCg.getStatus() + ", volCg id: " + volCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public ImageMetadataInfo queryImageMetadata(String regionUuid, String tokenId, String projUuid, String volumeId) {
        Map map = this.queryImageMetadataMap(regionUuid, tokenId, projUuid, volumeId);
        ImageMetadataInfo imageMetadataInfo = JsonUtil.jsonToBean(JSONObject.fromObject((Object)map).toString(), ImageMetadataInfo.class);
        return imageMetadataInfo;
    }

    @Override
    public Map queryImageMetadataMap(String regionUuid, String tokenId, String projUuid, String volumeId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"query image metadata failed. parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        volumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        String message = "{\"os-show_image_metadata\": null}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        logger.debug((Object)("query image metadata. volumeId=" + volumeId + ", request str" + newUrlStr));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("query image metadata. volumeId=" + volumeId + ", response str" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("query image metadata failed. volumeId=" + volumeId + ", respStr is null, request str" + newUrlStr + ", response str" + respStr));
            return null;
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("query image metadata failed. volumeId=" + volumeId + ", respStr contain itemNotFound, request str" + newUrlStr + ", response str" + respStr));
            return null;
        }
        return (Map)JSONObject.toBean((JSONObject)json.getJSONObject("metadata"), Map.class);
    }

    @Override
    public void updateImageMetadata(String regionUuid, String tokenId, String projUuid, ImageMetadataInfo metadataInfo, String volumeId) {
        logger.debug((Object)("update image metadata info.volumeId=" + volumeId));
        if (null == metadataInfo || VerifyUtil.isEmpty((String)metadataInfo.getHwDiskBus())) {
            logger.error((Object)("update image metadata, metadataInfo is empty or metadataInfo have no diskbus,volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)("update image metadata, parameter is empty, volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> volumeImageMetadata = new HashMap<String, String>();
        volumeImageMetadata.put("hw_disk_bus", metadataInfo.getHwDiskBus());
        Map map = this.updateImageMetadata(regionUuid, tokenId, projUuid, volumeImageMetadata, volumeId);
        String rtnJson = JSONObject.fromObject((Object)map).toString();
        ImageMetadataInfo imageMetadataInfo = JsonUtil.jsonToBean(rtnJson, ImageMetadataInfo.class);
        if (null == imageMetadataInfo || !metadataInfo.getHwDiskBus().equals(imageMetadataInfo.getHwDiskBus())) {
            logger.error((Object)("update hw disk bus error.Queryed imageMetadataInfo is null or ,Updated metadataInfo(" + metadataInfo.getHwDiskBus() + ") is not equal Query metadataInfo(" + (imageMetadataInfo != null ? imageMetadataInfo.getHwDiskBus() : "") + ".),response str=" + rtnJson + ",volumeId=" + volumeId));
            throw new LegoCheckedException(1073948126L);
        }
    }

    @Override
    public Map updateImageMetadata(String regionUuid, String tokenId, String projUuid, Map<String, String> volumeImageMetadata, String volumeId) {
        logger.debug((Object)("update image metadata map info.volumeId=" + volumeId));
        if (VerifyUtil.isEmpty(volumeImageMetadata)) {
            logger.error((Object)("update image metadata map , metadataInfo is empty,volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)("update image metadata map, parameter is empty, volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        String imageMetaData = JSONObject.fromObject(volumeImageMetadata).toString();
        String message = "{\"os-set_image_metadata\":{\"metadata\":" + imageMetaData + "}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        volumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        logger.debug((Object)("update image metadata map info.request str=" + newUrlStr + ",volumeId=" + volumeId));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("update image metadata map info.response str=" + respStr + ",volumeId=" + volumeId));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("update image metadata map error.request str=" + newUrlStr + ",imageMetaData str=" + imageMetaData + ",response str=" + respStr + ",volumeId=" + volumeId));
            throw new LegoCheckedException(1073948126L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("update image metadata map error.response str=" + json + ",imageMetaData str=" + imageMetaData + ",response str=" + respStr + ",volumeId=" + volumeId));
            throw new LegoCheckedException(1073948126L);
        }
        return JsonUtil.jsonToBean(json.getString("metadata"), Map.class);
    }

    @Override
    public AsyncTaskResponse createVolSnapshot(String regionUuid, String projectUuid, String tokenId, CreateVolumeSnapShotInfo info) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((Object)info)) {
            logger.error((Object)"Faild to create volume snapshot.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_CREATE_VOLSNAPSHOT.getUri(), projId);
        JSONObject msg = new JSONObject();
        msg.put((Object)"snapshot", (Object)JsonUtil.beanToJson(info));
        logger.debug((Object)("create volume snapshot.request str:" + msg + ", newUrlStr" + newUrlStr));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, msg.toString(), tokenId);
        logger.debug((Object)("create volume snapshot. response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Faild to create volume snapshot.response string is empty.request str:" + msg + ", newUrlStr" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (!json.containsKey((Object)"snapshot")) {
            logger.error((Object)("Faild to create volume snapshot.bad Request createSnapshot :" + info.getVolumeId() + ", request str:" + msg + ", newUrlStr" + newUrlStr + ", response: " + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        VolumeSnapShotInfo snapShotInfo = JsonUtil.jsonToBean(json.getString("snapshot"), VolumeSnapShotInfo.class);
        return this.checkCreateVolSnapShot(regionUuid, tokenId, projectUuid, snapShotInfo);
    }

    @Override
    public void activeVolSnapShot(String regionUuid, String projectUuid, String tokenId, VolumeSnapshotActiveInfo snapshotInfo) {
        logger.error((Object)"Failed to active volume snapShot,does not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private AsyncTaskResponse checkCreateVolSnapShot(final String regionUuid, final String tokenId, final String projectUuid, final VolumeSnapShotInfo snapShotInfo) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(snapShotInfo, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                String volSnapShotId = snapShotInfo.getId();
                logger.debug((Object)("Check snapshot (" + volSnapShotId + ") create snapshot"));
                VolumeSnapShotInfo snapInfo = CinderManager.this.queryVolumeSnapShotByUuid(regionUuid, tokenId, projectUuid, volSnapShotId);
                if (null == snapInfo) {
                    logger.error((Object)("Check create snapshot failed.snapshot is null. SnapShotId=" + volSnapShotId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VOLCGSNAPSHOT_STATUS_E.AVAIABLE.getValue().equals(snapInfo.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(snapInfo);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLSNAPSHOT_STATUS_E.CREATING.getValue().equals(snapInfo.getStatus())) {
                    logger.error((Object)("Check create snapshot failed.snapShot status is not excepted, excepted status: available, current status : " + snapInfo.getStatus() + ", snapShot id: " + snapInfo.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(snapInfo);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse deleteVolSnapShotById(String regionUuid, String projUuid, String tokenId, String snapShotId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)snapShotId)) {
            logger.error((Object)"Failed to delete volume snaphost.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_DELETE_VOLSNAPSHOT.getUri(), projId, snapShotId);
        logger.debug((Object)("Delete volume snaphost.request str=" + newUrlStr));
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        logger.debug((Object)("DeleteSnapShot response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolSnapshotResponse(regionUuid, tokenId, projUuid, snapShotId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("Failed to delete volume snaphost.bad Request deleteSnapShot.request str=" + newUrlStr + ", response: " + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private AsyncTaskResponse checkDeleteVolSnapshotResponse(final String regionUuid, final String tokenId, final String projUuid, final String snapShotId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(snapShotId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeSnapShotInfo info = CinderManager.this.queryVolumeSnapShotByUuid(regionUuid, tokenId, projUuid, snapShotId);
                if (null == info) {
                    logger.error((Object)("Failed to check delete volume snaphost. snapshot is null and snapShotId=" + snapShotId));
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VOLSNAPSHOT_STATUS_E.DELETING.getValue().equals(info.getStatus())) {
                    logger.error((Object)("Failed to check delete volume snaphost.snapShot status is not excepted, excepted status: deleting, current status : " + info.getStatus() + ", snapShotId id: " + snapShotId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public void updateVolume(String regionUuid, String tokenId, String projUuid, String volumeId, VolumeUpdateInfo volInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId) || null == volInfo) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)volInfo.getName()) && VerifyUtil.isEmpty((String)volInfo.getDescription())) {
            logger.error((Object)"Name and description is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String volId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.CINDER_UPDATE_VOL.getUri(), projId, volId);
        String volStr = JsonUtil.beanToJson(volInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"volume", (Object)volStr);
        String respStr = ClientUtil.sendPutRequest(newUrlStr, reqestJson.toString(), tokenId);
        logger.info((Object)("UpdateVolume response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948132L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("volume").isMissingNode()) {
            logger.error((Object)("Bad Request updateVolume :" + volInfo));
            throw new LegoCheckedException(1073948132L);
        }
    }

    @Override
    public OpenStackVolume getVolumeForOpenstackVolume(String regionUuid, String tokenId, String projUuid, String uuidVolume) {
        VolumeInfo volumeInfo = this.queryVolume(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(uuidVolume));
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        OpenStackVolume vol = this.translateVolume(volumeInfo, openstackUuid, regionUuid, new ArrayList<OpenStackVM>());
        return vol;
    }
}

