/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.sdk.msg.EndpointInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ProjectInfo;
import com.huawei.ism.drm.openstack.sdk.msg.RegionInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ServiceInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IAMManager
implements IKeystoreManager {
    private static Log logger = LogFactory.getInstance(IAMManager.class);
    private static final String SERVICE_PREFIX = "bcm-";

    @Override
    public List<OpenStackRegion> getRegions(OpenstackInfo open, String tokenId) {
        return IAMManager.getRegions(open, tokenId, OpenstackEnumDefine.REQUEST_URL.IAM_REGIONS.getUri());
    }

    public static List<OpenStackRegion> getRegions(OpenstackInfo open, String tokenId, String uri) {
        if (VerifyUtil.isEmpty((Object)open) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"param error");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = "https://" + open.getIp() + ":" + open.getPort() + uri;
        String respStr = ClientUtil.sendGetRequest(urlStr, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        List<RegionInfo> regions = JsonUtil.jsonArrayToList(json.getString("regions"), RegionInfo.class);
        ArrayList<OpenStackRegion> list = new ArrayList<OpenStackRegion>();
        for (RegionInfo region : regions) {
            OpenStackRegion openRegion = new OpenStackRegion();
            openRegion.setName(region.getId());
            openRegion.setDescription(region.getDescription());
            openRegion.setUuid(open.getUuid() + ":" + region.getId());
            openRegion.setTopMoUuid(open.getUuid());
            list.add(openRegion);
        }
        return list;
    }

    @Override
    public List<OpenStackProject> getProjects(OpenstackInfo open, String tokenId) {
        if (VerifyUtil.isEmpty((Object)open) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"param error");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = "https://" + open.getIp() + ":" + open.getPort() + OpenstackEnumDefine.REQUEST_URL.IAM_PROJECTS.getUri();
        String respStr = ClientUtil.sendGetRequest(urlStr, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        List<ProjectInfo> list = JsonUtil.jsonArrayToList(json.getString("projects"), ProjectInfo.class);
        ArrayList<OpenStackProject> openstackList = new ArrayList<OpenStackProject>();
        for (ProjectInfo proj : list) {
            OpenStackProject openProject = new OpenStackProject();
            openProject.setEnabled(Boolean.valueOf(proj.isEnabled()));
            openProject.setDomainId(proj.getDomainId());
            openProject.setName(proj.getName());
            openProject.setUuid(open.getUuid() + ":" + proj.getId());
            openProject.setIsDomain(Boolean.valueOf(proj.isDomainFlag()));
            openProject.setParentProjectId(proj.getParentId());
            openProject.setTopMoUuid(open.getUuid());
            openstackList.add(openProject);
        }
        return openstackList;
    }

    @Override
    public List<OpenStackServiceEndPoint> getOpenstackEndpoints(OpenstackInfo open, String tokenId) {
        List<EndpointInfo> endpointInfoList = this.getEndpoints(open, tokenId);
        List<ServiceInfo> serviceList = this.getServices(open, tokenId);
        HashMap<String, ServiceInfo> serviceMap = new HashMap<String, ServiceInfo>();
        ArrayList<OpenStackServiceEndPoint> openEndpointList = new ArrayList<OpenStackServiceEndPoint>();
        for (ServiceInfo service : serviceList) {
            if (open.isUseIAM()) {
                String serviceType = service.getType();
                if (VerifyUtil.isEmpty((String)serviceType) || !serviceType.startsWith(SERVICE_PREFIX)) continue;
                serviceType = serviceType.replace(SERVICE_PREFIX, "");
                service.setType(serviceType);
                serviceMap.put(service.getId(), service);
                continue;
            }
            serviceMap.put(service.getId(), service);
        }
        for (EndpointInfo endpointInfo : endpointInfoList) {
            String interfaceType = endpointInfo.getType();
            if (!"public".equals(interfaceType)) continue;
            OpenStackServiceEndPoint openEndpoint = new OpenStackServiceEndPoint();
            openEndpoint.setInterfaceType("public");
            String serviceId = endpointInfo.getServiceId();
            ServiceInfo service = (ServiceInfo)serviceMap.get(serviceId);
            if (null == service) continue;
            openEndpoint.setServiceId(serviceId);
            openEndpoint.setServiceName(service.getName());
            openEndpoint.setServiceType(service.getType());
            openEndpoint.setServiceUrl(IAMManager.getValidUrl(endpointInfo.getUrl()));
            openEndpoint.setUuid(open.getUuid() + ":" + endpointInfo.getId());
            String regionUuid = open.getUuid() + ":" + endpointInfo.getRegionId();
            openEndpoint.setRegionUuid(regionUuid);
            openEndpoint.setTopMoUuid(open.getUuid());
            openEndpointList.add(openEndpoint);
        }
        return openEndpointList;
    }

    public static String getValidUrl(String url) {
        if (url.contains("$(tenant_id)s")) {
            int index = url.indexOf("$(tenant_id)s");
            url = url.substring(0, index);
        }
        if (!url.endsWith("/")) {
            url = url.concat("/");
        }
        return url;
    }

    private List<ServiceInfo> getServices(OpenstackInfo open, String tokenId) {
        if (VerifyUtil.isEmpty((Object)open) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"param error");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = "https://" + open.getIp() + ":" + open.getPort() + OpenstackEnumDefine.REQUEST_URL.IAM_SERVICE.getUri();
        String respStr = ClientUtil.sendGetRequest(urlStr, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        return JsonUtil.jsonArrayToList(json.getString("services"), ServiceInfo.class);
    }

    private List<EndpointInfo> getEndpoints(OpenstackInfo open, String tokenId) {
        if (VerifyUtil.isEmpty((Object)open) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"param error");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = "https://" + open.getIp() + ":" + open.getPort() + OpenstackEnumDefine.REQUEST_URL.IAM_ENDPOINTS.getUri();
        String respStr = ClientUtil.sendGetRequest(urlStr, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        return JsonUtil.jsonArrayToList(json.getString("endpoints"), EndpointInfo.class);
    }
}

