/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.MigrationParam;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.EndpointUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.constants.ReleaseActionEnum;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolAttachInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NovaManagerMitaka
extends NovaManager {
    private static Log logger = LogFactory.getInstance(NovaManagerMitaka.class);
    private static final long MIGRATION_VM_RETRY_TIMES = 60480L;
    private static final long REBUILD_PHVM_RETRY_TIMES = 60L;
    private static final long HOT_MIGRATION_DEFAULT_RETRY_TIMES = 5L;
    private static final long HOT_MIGRATION_DEFAULT_RETRY_INTERVAL = 120L;
    private static final Set<String> HOT_MIGRATION_NEED_RETRY_MESSAGE_SET = new HashSet<String>(Arrays.asList("No valid host was found. There are not enough hosts available", "too many VMs are migrating from source host"));

    @Override
    public void forceDetachPortFromVM(String portUuid, String vmUuid, String projectUuid, String regionUuid, String tokenId, boolean isClearBackData) {
        if (VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)portUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)regionUuid)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
        String portId = OpenStackCommonUtil.getIdFromUuid(portUuid);
        for (int i = 1; i <= 3; ++i) {
            if (i > 1 && isClearBackData) {
                return;
            }
            List<VMInterface> srcVmPortList = this.getVmInterfaces(regionUuid, tokenId, projectUuid, serverId);
            boolean hasPort = false;
            for (VMInterface vMInterface : srcVmPortList) {
                if (!portId.equals(vMInterface.getPortId())) continue;
                hasPort = true;
                break;
            }
            if (!hasPort && !isClearBackData) {
                logger.debug((Object)"port : %s is not in the vm: %s", new Object[]{portId, serverId});
                return;
            }
            if (i > 1) {
                logger.info((Object)"force deatach Interface failed!, need retry, portid : %s, retry times : %d", new Object[]{portId, i});
                CommonUtil.sleep((long)30000L);
            }
            String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_PORT_DETACH_6_1.getUri(), projId, serverId);
            String message = "{\"forceDetachInterface\":{\"port_id\":\"" + portId + "\",\"backdate\":" + isClearBackData + "}}";
            String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
            logger.info((Object)"deletePortFromVM response is: %s", new Object[]{respStr});
        }
        throw new LegoCheckedException(1073948912L);
    }

    @Override
    public void reattachAndCheckVolume(ReattchParam reattchParam, String vmUuid, ReconnectVolumeInfo reconnVolumeInfo) {
        this.reattachVolume(reattchParam, vmUuid, reconnVolumeInfo);
        Boolean isNeedCheck = LegoConfig.getInstance().getBoolean("check.reattachVolume.config", Boolean.valueOf(false));
        if (isNeedCheck.booleanValue()) {
            this.checkReattachVolumeResult(vmUuid, reattchParam.getRegionUuid(), reattchParam.getTokenId(), reconnVolumeInfo.getVolumeId());
        }
    }

    private void checkReattachVolumeResult(final String srcVmUuid, final String regionUuid, final String tokenId, final String volumeId) {
        long inputRetryTimes = 30L;
        AsyncTaskResponse asyncTaskResponse = AsyncTaskResponse.queryTaskResponseTimeout(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolAttachInfo attachInfo = NovaManagerMitaka.this.getVolumeAttachInfo(srcVmUuid, regionUuid, tokenId, volumeId);
                logger.debug((Object)"Reattach volume has HyperMetro Path, srcVmUuid: %s, volumeId: %s", new Object[]{srcVmUuid, volumeId});
                if (OpenStackCommonUtil.checkHyperMetroVolPath(attachInfo)) {
                    response.setSuccess(true);
                    response.setTaskResult(volumeId);
                    return true;
                }
                return false;
            }
        }, inputRetryTimes);
        if (!asyncTaskResponse.isSuccess()) {
            logger.error((Object)"Reattach volume has hyperMetro path error, srcVmUuid: %s, volumeId: %s", new Object[]{srcVmUuid, volumeId});
            throw new LegoCheckedException(1073948106L, "Reattach volume error.");
        }
    }

    @Override
    public void reattachVolume(ReattchParam reattchParam, String vmUuid, ReconnectVolumeInfo reconnVolumeInfo) {
        OpenStackVM vm;
        if (VerifyUtil.isEmpty((String)reattchParam.getProjectUuid()) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)reattchParam.getRegionUuid()) || VerifyUtil.isEmpty((String)reattchParam.getTokenId()) || VerifyUtil.isEmpty((Object)reconnVolumeInfo)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if ((VerifyUtil.isEmpty((Object)reconnVolumeInfo.getIsHyperMetro()) || !reconnVolumeInfo.getIsHyperMetro().booleanValue()) && null == (vm = this.getVm(reattchParam.getRegionUuid(), reattchParam.getTokenId(), reattchParam.getProjectUuid(), vmUuid, new int[0]))) {
            logger.info((Object)("the vm is not exist,will not reconnect volume,vmUuid=" + vmUuid));
            return;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(reattchParam.getProjectUuid());
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(reattchParam.getRegionUuid(), "compute-ext");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_VOLUMES_REATTACH.getUri(), projId, serverId);
        JSONObject msg = new JSONObject();
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("is_hypermetro");
        msg.put((Object)"reconnectVolume", (Object)JSONObject.fromObject((Object)reconnVolumeInfo, null == reconnVolumeInfo.getIsHyperMetro() ? ignoreSet : null));
        logger.info((Object)("reattachVolume msg is:" + msg));
        ClientUtil.sendPostRequest(newUrlStr, msg.toString(), reattchParam.getTokenId());
    }

    @Override
    public VolAttachInfo getVolumeAttachInfo(String vmUuid, String regionUuid, String tokenId, String volId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)volId) || VerifyUtil.isEmpty((String)vmUuid)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String volumeId = OpenStackCommonUtil.getIdFromUuid(volId);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_HYPERMETRO_VOL_PATH.getUri(), serverId, volumeId);
        HashMap<String, String> realInfo = new HashMap<String, String>();
        realInfo.put("need_csd", "true");
        String respStr = ClientUtil.sendGetRequest(newUrlStr, realInfo, tokenId, new int[0]);
        logger.info((Object)("get VolumeAttachInfo success:VolumeAttachInfo=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"volumeAttachment")) {
            logger.error((Object)"bad Request getVolumeAttachInfo");
            throw new LegoCheckedException(0x300001L);
        }
        VolAttachInfo attachInfo = JsonUtil.jsonToBean(json.getString("volumeAttachment"), VolAttachInfo.class);
        return attachInfo;
    }

    @Override
    public List<HypervisorInfo> getHypervisorInfoByAz(String regionUuid, String projectUuid, String tokenId, String azName) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)azName)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        String url = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_HYPERVISORS_DETAILS_BY_AZ.getUri(), projId);
        uriVariables.put("availability_zone", azName);
        String respStr = ClientUtil.sendGetRequest(url, uriVariables, tokenId, new int[0]);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"hypervisors")) {
            logger.error((Object)("bad Request get os-hypervisors:" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        String arrayStr = json.getString("hypervisors");
        List<HypervisorInfo> hypervisorList = JsonUtil.jsonArrayToList(arrayStr, HypervisorInfo.class);
        return hypervisorList;
    }

    @Override
    public String getVmAddressMap(String regionUuid, String tokenId, String projectUuid, String vmUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid)) {
            logger.error((Object)"Failed to get vm addressMap.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_QUERY_VMADDRESS.getUri(), projId);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        HashMap<String, String> filterProp = new HashMap<String, String>();
        filterProp.put("server_id", serverId);
        String respStr = ClientUtil.sendGetRequest(newUrlStr, filterProp, tokenId, new int[0]);
        Map<String, String> serverIdToAddress = this.getVmsAddressMapFromRespStr(respStr, regionUuid);
        String addressMap = serverIdToAddress.get(vmUuid);
        return addressMap;
    }

    @Override
    public Map<String, String> getVmsAddressMap(String regionUuid, String projectUuid, List<String> uuids) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)"Failed to get vms addressMap.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        StringBuilder newUrlStr = new StringBuilder(OpenStackCommonUtil.getRequestUrl(regionUuid, projId, "compute-ext", OpenstackEnumDefine.REQUEST_URL.NOVA_QUERY_VMSADDRESS.getUri()));
        HashMap<String, String> filterProp = new HashMap<String, String>();
        String limit = String.valueOf(1000);
        filterProp.put("limit", limit);
        int offset = 1;
        HashMap<String, String> serverIdToAddresses = new HashMap<String, String>();
        String respStr = null;
        if (!VerifyUtil.isEmpty(uuids)) {
            StringBuilder serverIds = new StringBuilder();
            for (String uuid : uuids) {
                serverIds.append("&").append("server_id=").append(uuid);
            }
            if (serverIds.length() < 7168) {
                newUrlStr.append((CharSequence)serverIds);
            }
        }
        while (true) {
            filterProp.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr.toString(), filterProp, tokenId, new int[0]);
            Map<String, String> serverIdToAddress = this.getVmsAddressMapFromRespStr(respStr, regionUuid);
            serverIdToAddresses.putAll(serverIdToAddress);
            if (serverIdToAddress.size() < 1000) break;
            ++offset;
        }
        return serverIdToAddresses;
    }

    private Map<String, String> getVmsAddressMapFromRespStr(String respStr, String regionUuid) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to get vms addressMap.response string is empty.request str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        JSONObject respjson = JSONObject.fromObject((Object)respStr);
        if (!respjson.containsKey((Object)"servers")) {
            logger.error((Object)("Failed to get vms address_map .bad Request getServers.request response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        HashMap<String, String> serverIdToAddress = new HashMap<String, String>();
        JSONArray serversArray = respjson.getJSONArray("servers");
        int size = serversArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject server = serversArray.getJSONObject(i);
            if (!server.containsKey((Object)"address_map")) continue;
            String serverId = server.getString("id");
            JSONObject addressMapJson = server.getJSONObject("address_map");
            addressMapJson.put((Object)"reallocate_address", (Object)"True");
            serverIdToAddress.put(openstackUuid + ":" + serverId, addressMapJson.toString());
        }
        return serverIdToAddress;
    }

    @Override
    public void refreshVMAddressMap(String regionUuid, String projectUuid, String vmUuid, String addressMap, String tokenId) {
        logger.info((Object)"reattachVMAddressMap.vmUuid:%s, VMAddressMap :%s", new Object[]{vmUuid, addressMap});
        if (VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)addressMap) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"Failed to refresh Vm AddressMap.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_EXT_SERVER_ACTION.getUri(), projId, serverId);
        JSONObject addressMapJson = new JSONObject();
        addressMapJson.put((Object)"addressMap", (Object)addressMap);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, addressMapJson.toString(), tokenId);
        logger.info((Object)"reattachVMAddressMap for vmUuid:%s, post respStr is: %s", new Object[]{vmUuid, respStr});
    }

    @Override
    public AsyncTaskResponse migration(MigrationParam migrationParam) {
        if (VerifyUtil.isEmpty((Object)migrationParam)) {
            logger.error((Object)"Failed to hotMigration Vm.migrationParam is empty");
            throw new LegoCheckedException(1073947393L);
        }
        migrationParam.check();
        OpenStackVM vm = this.getVm(migrationParam.getRegionUuid(), migrationParam.getTokenId(), migrationParam.getProjectUuid(), migrationParam.getVmUuid(), new int[0]);
        if (null == vm) {
            logger.error((Object)"can not find vm:%s", new Object[]{migrationParam.getVmUuid()});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        migrationParam.setVmName(vm.getName());
        if (Integer.valueOf(OpenstackEnumDefine.VM_STATUS_E.ERROR.getValue()).equals(vm.getStatus())) {
            logger.error((Object)"vm:%s status:%s error", new Object[]{vm.getName(), vm.getStatus()});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode(String.valueOf(migrationParam.isProduct() ? 1073949696L : 1073949705L));
            response.setErrorParameter(new String[]{vm.getName(), ""});
            return response;
        }
        if (migrationParam.getMigrationAz().equals(vm.getAzName())) {
            logger.error((Object)"vm:%s already in az:%s", new Object[]{vm.getName(), migrationParam.getMigrationAz()});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            response.setTaskResult(vm);
            return response;
        }
        OpenstackEnumDefine.VM_STATUS_E migratingStatus = migrationParam.isProduct() ? OpenstackEnumDefine.VM_STATUS_E.MIGRATING : OpenstackEnumDefine.VM_STATUS_E.REBUILD;
        if (!Integer.valueOf(migratingStatus.getValue()).equals(vm.getStatus())) {
            this.doMigration(migrationParam);
        }
        return this.checkMigrationResponse(migrationParam, migratingStatus);
    }

    private void doMigration(MigrationParam migrationParam) {
        String projId = OpenStackCommonUtil.getIdFromUuid(migrationParam.getProjectUuid());
        String serverId = OpenStackCommonUtil.getIdFromUuid(migrationParam.getVmUuid());
        if (migrationParam.isProduct()) {
            String urlStr = EndpointUtil.getInstance().getBaseUrl(migrationParam.getRegionUuid(), "compute-ext");
            String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_EXT_SERVER_ACTION.getUri(), projId, serverId);
            JSONObject migrateLiveJson = new JSONObject();
            migrateLiveJson.put((Object)"block_migration", (Object)"auto");
            migrateLiveJson.put((Object)"type", (Object)"crossAZ_HyperMetro");
            migrateLiveJson.put((Object)"availability_zone", (Object)migrationParam.getMigrationAz());
            migrateLiveJson.put((Object)"target_volume_mapping", migrationParam.getVolumeMap());
            JSONObject requestJson = new JSONObject();
            requestJson.put((Object)"os-migrateLive", (Object)migrateLiveJson);
            logger.info((Object)("hotMigration msg is:" + requestJson.toString()));
            int retryTimes = (int)LegoConfig.getInstance().getNumber("hot.migration.retry.times", 5L);
            long retryInterval = LegoConfig.getInstance().getNumber("hot.migration.retry.interval", 120L);
            if (migrationParam.getPoSize() > retryTimes) {
                retryTimes = migrationParam.getPoSize();
            }
            logger.info((Object)"migration retryTimes:%s, retryInterval:%s", new Object[]{String.valueOf(retryTimes), String.valueOf(retryInterval)});
            this.retryMigrationVm(migrationParam, newUrlStr, requestJson, retryTimes, retryInterval);
        } else {
            String urlStr = EndpointUtil.getInstance().getBaseUrl(migrationParam.getRegionUuid(), "compute");
            String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_RESET_SERVER_STATE.getUri(), projId, serverId);
            JSONObject rescheduleJson = new JSONObject();
            rescheduleJson.put((Object)"skipPolicyCheck", (Object)"True");
            rescheduleJson.put((Object)"availability_zone", (Object)migrationParam.getMigrationAz());
            JSONObject requestJson = new JSONObject();
            requestJson.put((Object)"reschedule", (Object)rescheduleJson);
            logger.info((Object)("reschedule msg is:" + requestJson.toString()));
            ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), migrationParam.getTokenId());
        }
    }

    private void retryMigrationVm(MigrationParam migrationParam, String newUrlStr, JSONObject requestJson, int retryTimes, long retryInterval) {
        try {
            ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), migrationParam.getTokenId());
        }
        catch (LegoCheckedException e) {
            String[] errParam;
            logger.error((Object)"do vm:%s migration error.", (Throwable)e, new Object[]{migrationParam.getVmUuid()});
            boolean retry = false;
            String errMsg = e.getMessage();
            if (e.getErrorCode() == 0x300001L && null != (errParam = e.getParameters()) && errParam.length >= 2) {
                String errStatusCode = errParam[0];
                errMsg = errParam[1];
                if (null != errMsg && String.valueOf(400).equals(errStatusCode) && this.containAny(errMsg, HOT_MIGRATION_NEED_RETRY_MESSAGE_SET)) {
                    retry = true;
                }
            }
            if (retry && --retryTimes > 0) {
                CommonUtil.sleep((long)retryInterval, (TimeUnit)TimeUnit.SECONDS);
                this.retryMigrationVm(migrationParam, newUrlStr, requestJson, retryTimes, retryInterval);
            }
            logger.error((Object)"do vm:%s migration error, errMsg:%s", new Object[]{migrationParam.getVmUuid(), errMsg});
            errMsg = this.getErrMessage(errMsg);
            throw new LegoCheckedException(migrationParam.isProduct() ? 1073949696L : 1073949705L, new String[]{migrationParam.getVmName(), errMsg});
        }
    }

    private String getErrMessage(String errMsg) {
        JSONObject badRequestObj;
        if (VerifyUtil.isEmpty((String)errMsg)) {
            return "";
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)errMsg);
        if (jsonObject.containsKey((Object)"badRequest") && (badRequestObj = jsonObject.getJSONObject("badRequest")).containsKey((Object)"message")) {
            return " error message:" + badRequestObj.getString("message");
        }
        return "";
    }

    private boolean containAny(String message, Set<String> strSet) {
        for (String str : strSet) {
            if (!message.contains(str)) continue;
            return true;
        }
        return false;
    }

    private AsyncTaskResponse checkMigrationResponse(MigrationParam migrationParam, OpenstackEnumDefine.VM_STATUS_E migratingStatus) {
        long errorCode;
        Long inputRetryTimes;
        if (migrationParam.isProduct()) {
            inputRetryTimes = 60480L;
            errorCode = 1073949696L;
        } else {
            inputRetryTimes = 60L;
            errorCode = 1073949705L;
        }
        return AsyncTaskResponse.queryTaskResponseTimeout(migrationParam.getVmUuid(), response -> {
            OpenStackVM vm = this.getVm(migrationParam.getRegionUuid(), migrationParam.getTokenId(), migrationParam.getProjectUuid(), migrationParam.getVmUuid(), new int[0]);
            if (null == vm) {
                response.setSuccess(false);
                response.setErrorCode("2117645");
                return true;
            }
            if (!Integer.valueOf(migratingStatus.getValue()).equals(vm.getStatus())) {
                if (Integer.valueOf(OpenstackEnumDefine.VM_STATUS_E.ERROR.getValue()).equals(vm.getStatus())) {
                    logger.error((Object)"vm:%s status error", new Object[]{vm.getName()});
                    response.setSuccess(false);
                    response.setErrorCode(String.valueOf(errorCode));
                    response.setErrorParameter(new String[]{vm.getName(), ""});
                } else if (migrationParam.getMigrationAz().equals(vm.getAzName())) {
                    response.setSuccess(true);
                    response.setTaskResult(vm);
                } else {
                    logger.error((Object)"vm:%s az not right", new Object[]{vm.getName()});
                    response.setSuccess(false);
                    response.setErrorCode(String.valueOf(errorCode));
                    response.setErrorParameter(new String[]{vm.getName(), ""});
                }
                return true;
            }
            return false;
        }, inputRetryTimes);
    }

    @Override
    public void releaseOrRecapturePhVmResource(String projectUuid, String regionUuid, String tokenId, String vmUuid, ReleaseActionEnum releaseAction) {
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{projectUuid, regionUuid, tokenId, vmUuid, releaseAction})) {
            logger.error((Object)"parameter is empty.projectUuid=%s,regionUuid=%s,vmUuid=%s,releaseAction=%s", new Object[]{projectUuid, regionUuid, vmUuid, releaseAction});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        String urlStr = EndpointUtil.getInstance().getBaseUrl(regionUuid, "compute-ext");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NOVA_EXT_SERVER_ACTION.getUri(), projId, serverId);
        JSONObject releaseActionJson = new JSONObject();
        releaseActionJson.put((Object)"seconds_delay", (Object)0);
        releaseActionJson.put((Object)"action", (Object)releaseAction.getAction());
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"release-stopped-resource", (Object)releaseActionJson);
        logger.info((Object)("releaseOrRecapturePhVmResource msg is:" + requestJson.toString()));
        ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), tokenId);
    }
}

