/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EndpointUtil {
    private static Log logger = LogFactory.getInstance(EndpointUtil.class);
    private static EndpointUtil instance = new EndpointUtil();
    private Map<String, String> serviceTypeName = new HashMap<String, String>();
    private Map<String, Map<String, String>> endpointMap = new ConcurrentHashMap<String, Map<String, String>>();

    private EndpointUtil() {
        this.initializeEndpointMap();
        this.initServiceTypeName();
    }

    public static EndpointUtil getInstance() {
        return instance;
    }

    public String getBaseUrl(String regionUuid, String serviceType) {
        String baseUrl = "";
        Map<String, String> urlMap = this.endpointMap.get(regionUuid);
        if (!VerifyUtil.isEmpty(urlMap)) {
            baseUrl = urlMap.get(serviceType);
        }
        if (VerifyUtil.isEmpty((String)baseUrl)) {
            logger.error((Object)("can not get base url, regionUuid:" + regionUuid + ", serviceType:" + serviceType));
            throw new LegoCheckedException(1073947853L, new String[]{OpenStackCommonUtil.getIdFromUuid(regionUuid), this.getServiceTypeName(serviceType)});
        }
        return baseUrl;
    }

    public void refreshEndpointMap(Map<String, Map<String, String>> regionEndpointMap) {
        for (Map.Entry<String, Map<String, String>> entry : regionEndpointMap.entrySet()) {
            String regionUuid = entry.getKey();
            this.endpointMap.put(regionUuid, entry.getValue());
        }
    }

    private void initializeEndpointMap() {
        logger.info((Object)"initialize endpointMap start...");
        List endpointList = CommonDAOLocator.getMoDao().getAllMo(OpenStackServiceEndPoint.class);
        for (OpenStackServiceEndPoint endPoint : endpointList) {
            if (!this.endpointMap.containsKey(endPoint.getRegionUuid())) {
                HashMap urlMap = new HashMap();
                this.endpointMap.put(endPoint.getRegionUuid(), urlMap);
            }
            this.endpointMap.get(endPoint.getRegionUuid()).put(endPoint.getServiceType(), endPoint.getServiceUrl());
        }
        logger.info((Object)"initialize endpointMap success.");
    }

    private void initServiceTypeName() {
        this.serviceTypeName.put("compute", "Nova");
        this.serviceTypeName.put("network", "Neutron");
        this.serviceTypeName.put("volume", "Cinder");
        this.serviceTypeName.put("agent", "DrExtend");
        this.serviceTypeName.put("compute-ext", "Nova-Ext");
        this.serviceTypeName.put("metering", "CeiloMeter");
        this.serviceTypeName.put("image", "Image");
        this.serviceTypeName.put("apicom", "CombinedApi");
    }

    private String getServiceTypeName(String serviceType) {
        String s = this.serviceTypeName.get(serviceType);
        if (null == s || s.isEmpty()) {
            return serviceType;
        }
        return s;
    }
}

