/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.handler.OpenStackResponseHandler;
import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.msg.AuthenticateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.DomainInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IAMIdentityInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IAMScopeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IdentityInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IdentityRequestInfo;
import com.huawei.ism.drm.openstack.sdk.msg.IdentityResponseInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.PasswordInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ProjectInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ScopeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.TokenInfo;
import com.huawei.ism.drm.openstack.sdk.msg.UserInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.core5.http.Header;

public class TokenUtil {
    private static Log logger = LogFactory.getInstance(TokenUtil.class);
    private static final String X_SUBJECT_TOKEN_KEY = "X-Subject-Token";
    private static final long EXPIRES_MILLSECONDS = 3600000L;
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'";
    private static final int RESPONSE_TIME_OUT = 60000;
    private static final int UN_AHUTH = 401;
    private static TokenUtil instance = new TokenUtil();
    private Map<String, Object> uuidConnectionLock = new ConcurrentHashMap<String, Object>();
    private Map<String, TokenInfo> tokenMap = new ConcurrentHashMap<String, TokenInfo>();

    public static TokenUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToken(String projectUuid) {
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)"param is empty.");
            return;
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        Object object = this.getProjectTockenLock(projectId);
        synchronized (object) {
            this.tokenMap.remove(projectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenByTokenId(String tokenId) {
        if (VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"param is empty.");
            return;
        }
        String projectId = null;
        for (Map.Entry<String, TokenInfo> entry : this.tokenMap.entrySet()) {
            if (!tokenId.equals(entry.getValue().getId())) continue;
            projectId = entry.getKey();
            break;
        }
        if (VerifyUtil.isEmpty(projectId)) {
            logger.info((Object)"get projectId failed");
            return;
        }
        Object object = this.getProjectTockenLock(projectId);
        synchronized (object) {
            logger.info((Object)("remove project's token:projectId=" + projectId));
            this.tokenMap.remove(projectId);
        }
    }

    public String getTokenId(OpenstackInfo open, String projectUuid) {
        if (VerifyUtil.isEmpty((Object)open)) {
            logger.error((Object)"parmeter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            TokenInfo token = this.getTokenInfo(open, null);
            if (null == token || VerifyUtil.isEmpty((String)token.getId())) {
                logger.error((Object)"get token error.");
                throw new LegoCheckedException(1073947689L);
            }
            return token.getId();
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        TokenInfo token = this.getTokenInfo(open, projectId);
        if (null == token || VerifyUtil.isEmpty((String)token.getId())) {
            logger.error((Object)"get token error.");
            throw new LegoCheckedException(1073947689L);
        }
        return token.getId();
    }

    public String getTokenId(String projectUuid) {
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)"param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projectUuid);
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)("param is empty:projectUuid=" + projectUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = this.getOpenstackInfo(openstackUuid);
        return this.getTokenId(open, projectId);
    }

    private OpenstackInfo getOpenstackInfo(String openstackUuid) {
        FusionSphereOpenStack open = (FusionSphereOpenStack)CommonDAOLocator.getMoDao().getMoByUuid(openstackUuid, Boolean.valueOf(true));
        if (VerifyUtil.isEmpty((Object)open)) {
            logger.error((Object)("cant find openstack mo:openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        long moId = open.getMoId();
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extend = neMgr.findByMoId(Long.valueOf(moId));
        if (VerifyUtil.isEmpty((Object)extend)) {
            logger.error((Object)("cant find openstack ne extend info :openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Map paramMap = extend.getExtendParams();
        String isIam = (String)paramMap.get("authType");
        OpenstackInfo openInfo = new OpenstackInfo();
        openInfo.setIp(open.getIpAddress());
        openInfo.setPort((String)paramMap.get("port"));
        openInfo.setDomainName((String)paramMap.get("domain"));
        openInfo.setUser(extend.getNetworkUserName());
        openInfo.setPasswd(extend.getNetworkPassword());
        openInfo.setUseIAM("IAM".equals(isIam));
        openInfo.setUuid(openstackUuid);
        return openInfo;
    }

    private boolean checkToken(String projectId) {
        SimpleDateFormat formater = new SimpleDateFormat(DATE_PATTERN, Locale.ENGLISH);
        if (this.tokenMap.containsKey(projectId)) {
            TokenInfo token = this.tokenMap.get(projectId);
            if (null == token) {
                return false;
            }
            String expirtAt = token.getExpiresAt();
            try {
                long millseconds = formater.parse(expirtAt).getTime();
                long curMillseconds = Calendar.getInstance().getTimeInMillis();
                if (millseconds - curMillseconds > 3600000L) {
                    return true;
                }
            }
            catch (ParseException e) {
                logger.error((Object)("time format error:DATE=" + expirtAt));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenInfo getTokenInfo(OpenstackInfo open, String projectId) {
        String ip = open.getIp();
        String port = open.getPort();
        if (null == projectId) {
            TokenInfo token = this.getNewToken(open, null, ip, port);
            return token;
        }
        Object object = this.getProjectTockenLock(projectId);
        synchronized (object) {
            if (this.checkToken(projectId)) {
                return this.tokenMap.get(projectId);
            }
            TokenInfo token = this.getNewToken(open, projectId, ip, port);
            if (null != token) {
                this.tokenMap.put(projectId, token);
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenInfo getNewToken(OpenstackInfo open, String projectId, String ip, String port) {
        String url;
        char[] msg;
        RestClient client = new RestClient(ip, NumberUtil.parseInteger((Object)port).intValue(), null, null, (IResponseHandler)new OpenStackResponseHandler(), new String[0]);
        client.setTimeout(60000);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (open.isUseIAM()) {
            msg = this.getTokenReqBodyStrOfIAM(open, projectId);
            url = OpenstackEnumDefine.REQUEST_URL.IAM_TOKEN.getUri();
            if (!VerifyUtil.isEmpty((String)projectId)) {
                TokenInfo token = this.getIAMUnscopeToken(client, this.getTokenReqBodyStrOfIAM(open, null), url);
                if (null == token) {
                    logger.error((Object)"getIAMUnscopeToken return null.");
                    throw new LegoCheckedException(0x300001L);
                }
                requestHeaders.put("X-Auth-Token", token.getId());
            }
        } else {
            msg = this.getTokenReqBodyStrOfKeyStone(open, projectId);
            url = OpenstackEnumDefine.REQUEST_URL.IDENTITY_TOKEN.getUri();
        }
        try {
            ServiceResponse response = client.post(url, String.valueOf(msg), null, requestHeaders);
            TokenInfo tokenInfo = this.responseToTokenInfo(response);
            return tokenInfo;
        }
        catch (LegoCheckedException exception) {
            logger.error((Object)("get token failed." + ExceptionUtil.getErrorMessage((Throwable)exception)));
            if (exception.getErrorCode() == 401L) {
                throw new LegoCheckedException(1073947691L, (Throwable)exception);
            }
            if (exception.getErrorCode() == 1073947691L) {
                throw exception;
            }
        }
        catch (Exception e) {
            logger.error((Object)("get token failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            TokenUtil.fillZero(msg);
        }
        return null;
    }

    private static void fillZero(char[] arr) {
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(arr, '\u0000');
        }
    }

    private TokenInfo getIAMUnscopeToken(RestClient client, char[] msg, String url) {
        HashMap requestHeaders = new HashMap();
        try {
            ServiceResponse response = client.post(url, String.valueOf(msg), null, requestHeaders);
            TokenInfo token = this.responseToTokenInfo(response);
            return token;
        }
        catch (LegoCheckedException exception) {
            if (exception.getErrorCode() == 1073947691L) {
                throw exception;
            }
        }
        catch (Exception e) {
            logger.error((Object)("get token failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    private TokenInfo responseToTokenInfo(ServiceResponse response) {
        Header[] headers = response.getResponseHeaders();
        if (response.getStatusCode() == 401) {
            throw new LegoCheckedException(1073947691L, "openstack get token failed.");
        }
        for (Header header : headers) {
            if (!X_SUBJECT_TOKEN_KEY.equals(header.getName())) continue;
            String tokenId = header.getValue();
            IdentityResponseInfo responseInfo = JsonUtil.jsonToBean(response.getResponseString(), IdentityResponseInfo.class);
            if (null == responseInfo) {
                logger.error((Object)"convert response info return null value");
                continue;
            }
            TokenInfo token = responseInfo.getToken();
            token.setId(tokenId);
            return token;
        }
        return null;
    }

    private synchronized Object getProjectTockenLock(String projectId) {
        if (!this.uuidConnectionLock.containsKey(projectId)) {
            Object obj = new Object();
            this.uuidConnectionLock.put(projectId, obj);
            return obj;
        }
        return this.uuidConnectionLock.get(projectId);
    }

    private char[] getTokenReqBodyStrOfKeyStone(OpenstackInfo open, String projectId) {
        DomainInfo domain = new DomainInfo();
        domain.setName(open.getDomainName());
        UserInfo user = new UserInfo();
        user.setDomain(domain);
        user.setName(open.getUser());
        user.setPassword(open.getPasswd());
        PasswordInfo passInfo = new PasswordInfo();
        passInfo.setUser(user);
        IdentityInfo identity = new IdentityInfo();
        identity.setPassword(passInfo);
        AuthenticateInfo auth = new AuthenticateInfo();
        auth.setIdentity(identity);
        if (!VerifyUtil.isEmpty((String)projectId)) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(projectId);
            ScopeInfo scope = new ScopeInfo();
            scope.setProject(projectInfo);
            auth.setScope(scope);
        }
        IdentityRequestInfo identityReq = new IdentityRequestInfo();
        identityReq.setAuth(auth);
        return JsonUtil.beanToJson(identityReq).toCharArray();
    }

    private char[] getTokenReqBodyStrOfIAM(OpenstackInfo open, String projectId) {
        AuthenticateInfo auth = new AuthenticateInfo();
        if (!VerifyUtil.isEmpty((String)projectId)) {
            IAMIdentityInfo.RestrictInfo restrictInfo = new IAMIdentityInfo.RestrictInfo();
            IAMIdentityInfo.AssumeRoleInfo assumeRoleInfo = new IAMIdentityInfo.AssumeRoleInfo();
            assumeRoleInfo.setRestrict(restrictInfo);
            IAMIdentityInfo identity = new IAMIdentityInfo();
            identity.setAssumeRoleInfo(assumeRoleInfo);
            OpenStackProject project = this.getProjectByPojectId(open, projectId);
            String domainId = project.getDomainId();
            assumeRoleInfo.setDomainId(domainId);
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(projectId);
            ScopeInfo scope = new ScopeInfo();
            scope.setProject(projectInfo);
            auth.setScope(scope);
            auth.setIdentity((IdentityInfo)identity);
        } else {
            DomainInfo domain = new DomainInfo();
            domain.setName(open.getDomainName());
            UserInfo user = new UserInfo();
            user.setDomain(domain);
            user.setName(open.getUser());
            user.setPassword(open.getPasswd());
            PasswordInfo passInfo = new PasswordInfo();
            passInfo.setUser(user);
            IdentityInfo identity = new IdentityInfo();
            identity.setPassword(passInfo);
            auth.setIdentity(identity);
            IAMScopeInfo scope = new IAMScopeInfo();
            scope.setDomain(domain);
            auth.setScope((ScopeInfo)scope);
        }
        IdentityRequestInfo identityReq = new IdentityRequestInfo();
        identityReq.setAuth(auth);
        return JsonUtil.beanToJson(identityReq).toCharArray();
    }

    private OpenStackProject getProjectByPojectId(OpenstackInfo open, String projectId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            logger.error((Object)("param is projectId=" + projectId));
            throw new LegoCheckedException(1073947393L);
        }
        String uuid = open.getUuid() + ":" + projectId;
        List list = CommonDAOLocator.getMoDao().find("from OpenStackProject where uuid = ? ", new Object[]{uuid});
        if (VerifyUtil.isEmpty((Collection)list)) {
            logger.error((Object)("param is projectId=" + projectId));
            String unscopedToken = this.getTokenId(open, null);
            IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
            List<OpenStackProject> openStackProjects = keystoreMgr.getProjects(open, unscopedToken);
            for (OpenStackProject openStackProject : openStackProjects) {
                if (!uuid.equals(openStackProject.getUuid())) continue;
                return openStackProject;
            }
            throw new LegoCheckedException(2117645L);
        }
        return (OpenStackProject)list.get(0);
    }

    public synchronized void clearAllTokenCache() {
        logger.info((Object)"clear all token cache.");
        this.tokenMap.clear();
    }
}

